/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extendcontrols;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.util.ParamHelper;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class KDPromptEditorAssistor
extends JPanel {
    private static final Logger logger = Logger.getLogger(KDPromptEditorAssistor.class);
    private KDTextField parent;
    private KDBizPromptBox parentPromptBox;
    private Popup popup;
    private String recordName = null;
    protected boolean isHistoryRecordEnabled = false;
    protected boolean isMyCommonUseEnabled = true;
    private boolean needRetrieval = true;
    private String[] assistorCache;
    private ArrayList assistorContent = new ArrayList();
    private boolean needRetrievalMyCommonUse = true;
    private String[] myCommonUseCache = null;
    private ArrayList myCommonUseContent = new ArrayList();
    private int assistInfoLimit = 2000;
    private AssistorHandler assistorHandler = new AssistorHandler();
    private KDTable assistorTable = new KDTable();
    private KDTable myCommonUseTable = new KDTable();
    protected KDTabbedPane kdTMain;
    private KDList quickQueryConditionList;
    private boolean isQuickQueryEnable = true;
    private boolean isQuickQueryPanelActived = false;
    protected boolean isDynQueryEnabled = false;
    private KDBizPromptBox.FilterFieldItem[] filterFields;
    private FilterInfo quickQueryFilter = new FilterInfo();
    private EntityViewInfo quickQueryEvi = new EntityViewInfo();
    private ArrayList quickQueryContent;
    private boolean isShowing;
    private int listCellCountPerPage = 5;
    private boolean closeAble = true;
    private static final String TABLE_COLUMN_ID = "id";
    private static final String TABLE_COLUMN_NAME = "name";
    private static final String TABLE_COLUMN_NUMBER = "number";
    private static final int SPAN = 10;
    private static final int BUTTON_WIDTH = 73;
    private static final int BUTTON_HEIGHT = 21;
    private static final int COLUMN_WIDTH = 100;
    private boolean multipleSelect = false;
    private boolean isCapitalSensitiveQuery = false;

    public boolean isQuickQueryPanelActived() {
        return this.isQuickQueryPanelActived;
    }

    public void setQuickQueryPanelActived(boolean isQuickQueryPanelActived) {
        this.isQuickQueryPanelActived = isQuickQueryPanelActived;
    }

    public KDPromptEditorAssistor(KDTextField parent) {
        this.setLayout(new BorderLayout());
        this.parent = parent;
        if (parent.getParent() instanceof KDBizPromptBox) {
            this.parentPromptBox = (KDBizPromptBox)((Object)parent.getParent());
        }
        this.initTabbedPane();
        String capitalSensitiveQuery = ParamHelper.getCapitalSensitiveQuery();
        if (capitalSensitiveQuery != null && capitalSensitiveQuery.equalsIgnoreCase("true")) {
            this.isCapitalSensitiveQuery = true;
        }
        this.initDynQueryEnabled();
    }

    private void initTabbedPane() {
        this.kdTMain = new KDTabbedPane();
        this.kdTMain.setName("kdTMain");
        this.kdTMain.setTabPlacement(3);
        this.kdTMain.setForcedHide(true);
        this.assistorTable.setScrollStateHorizon(1);
        this.assistorTable.setScrollStateVertical(1);
        this.assistorTable.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        this.myCommonUseTable.setScrollStateHorizon(1);
        this.myCommonUseTable.setScrollStateVertical(1);
        this.myCommonUseTable.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        this.assistorTable.setBackground(Color.WHITE);
        this.myCommonUseTable.setBackground(Color.WHITE);
        this.kdTMain.setFocusable(false);
        this.assistorTable.setFocusable(false);
        this.myCommonUseTable.setFocusable(false);
        this.kdTMain.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KDPromptEditorAssistor.this.kdTMain_stateChanged(e);
            }
        });
        this.initHistoryTable();
        this.initHistoryControls();
        this.initMyCommonUseTable();
        this.initMyCommonUseControls();
    }

    private void initQuickQuickPane() {
        this.quickQueryConditionList = new KDList();
        this.quickQueryConditionList.setFocusable(false);
        this.quickQueryConditionList.setSelectionForeground(Color.BLACK);
        this.quickQueryConditionList.setSelectionBackground(this.assistorTable.getSelectManager().getSelectColor());
    }

    private void kdTMain_stateChanged(ChangeEvent e) {
        Component selectedComponent = this.kdTMain.getSelectedComponent();
        if (selectedComponent == null) {
            return;
        }
        if (!selectedComponent.equals(this.assistorTable) && selectedComponent.equals(this.myCommonUseTable)) {
            this.needRetrievalMyCommonUse = true;
        }
    }

    private void initMyCommonUseTable() {
        String[] bindContents = new String[4];
        IColumn col = this.myCommonUseTable.addColumn();
        col.setKey(TABLE_COLUMN_ID);
        bindContents[0] = TABLE_COLUMN_ID;
        col.setWidth(100);
        col.getStyleAttributes().setHided(true);
        col = this.myCommonUseTable.addColumn();
        col.setKey(TABLE_COLUMN_NUMBER);
        bindContents[1] = TABLE_COLUMN_NUMBER;
        col.setWidth(100);
        col = this.myCommonUseTable.addColumn();
        col.setKey(TABLE_COLUMN_NAME);
        bindContents[2] = TABLE_COLUMN_NAME;
        col.setWidth(100);
        this.myCommonUseTable.putBindContents("query", bindContents);
        this.myCommonUseTable.setFormatXml("");
        this.myCommonUseTable.checkParsed(true);
        int x = -82;
        int y = -29;
        int width = 73;
        int height = 21;
        height = y - 20;
        width = -19;
        x = 10;
        y = 10;
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(x, y, width, height);
        cons.anchor = 15;
        this.myCommonUseTable.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        this.myCommonUseTable.getIndexColumn().getStyleAttributes().setHided(true);
        this.myCommonUseTable.setGridLineColor(Color.WHITE);
    }

    private void initMyCommonUseControls() {
        KDTableHelper.releaseEsc((JComponent)this.myCommonUseTable);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.myCommonUseTable, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.myCommonUseTable.getSelectManager().setSelectMode(this.isEnabledMultipleSelect() ? 10 : 2);
        this.myCommonUseTable.getStyleAttributes().setLocked(true);
        this.myCommonUseTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                KDPromptEditorAssistor.this.setQuickQueryPanelActived(false);
                if (e.getClickCount() == 2 && e.getType() == 1) {
                    KDPromptEditorAssistor.this.commitSelection();
                    KDPromptEditorAssistor.this.setShowing(false);
                }
            }
        });
    }

    private void deleteMyCommonUse() {
        KDTSelectManager sm = this.myCommonUseTable.getSelectManager();
        int size = sm.size();
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = sm.get(i);
            int top = 0;
            int bottom = 0;
            if (sb.getMode() == 8) {
                bottom = this.myCommonUseTable.getRowCount3();
            } else {
                top = sb.getTop() >= 0 ? sb.getTop() : 0;
                bottom = sb.getBottom() >= 0 ? sb.getBottom() : 0;
            }
            for (int j = top; j <= bottom; ++j) {
                Object number;
                IRow row = this.myCommonUseTable.getRow(j);
                if (row == null || row.getCell(TABLE_COLUMN_NUMBER) == null || (number = row.getCell(TABLE_COLUMN_NUMBER).getValue()) == null) continue;
                this.deleteFromMyCommonUseCache(number.toString());
            }
        }
        this.saveMyCommonUse();
    }

    private void deleteFromMyCommonUseCache(String number) {
        if (this.myCommonUseCache == null || this.myCommonUseCache.length <= 0) {
            return;
        }
        for (int i = 0; i < this.myCommonUseCache.length; ++i) {
            if (this.myCommonUseCache[i].toUpperCase().indexOf(number.toUpperCase()) < 0) continue;
            this.myCommonUseCache[i] = "";
            break;
        }
        for (Object tempContent : this.myCommonUseContent) {
            if (tempContent.toString().toUpperCase().indexOf(number.toUpperCase()) < 0) continue;
            this.myCommonUseContent.remove(tempContent);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMyCommonUse() {
        String fileName = null;
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (this.parent.getParent() instanceof KDBizPromptBox) {
            this.parentPromptBox = (KDBizPromptBox)((Object)this.parent.getParent());
            fileName = this.parentPromptBox != null && !StringUtils.isEmpty((String)this.parentPromptBox.getRecordName()) ? this.parentPromptBox.getRecordName() : userID + this.parentPromptBox.getName();
        } else {
            return;
        }
        fileName = fileName.replaceAll("\\\\|/|\\:|\\*|\"|>|<|\\|\\.| |-|'|=|(|)|", "");
        if (fileName.length() > 200) {
            fileName = fileName.substring(0, 200);
        }
        fileName = fileName + "MyCommonUse";
        File f = this.getMemorizeFile(fileName);
        FileOutputStream fom = null;
        try {
            String str = "";
            for (int i = 0; i < this.myCommonUseCache.length; ++i) {
                if (this.myCommonUseCache[i] == null || this.myCommonUseCache[i].trim().length() <= 0) continue;
                str = str + this.myCommonUseCache[i] + "\n";
            }
            fom = new FileOutputStream(f);
            fom.write(str.getBytes("UTF-8"));
            fom.write(10);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fom != null) {
                    fom.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void deleteHistoryRecord() {
        KDTSelectManager sm = this.assistorTable.getSelectManager();
        int size = sm.size();
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = sm.get(i);
            int top = 0;
            int bottom = 0;
            if (sb.getMode() == 8) {
                bottom = this.assistorTable.getRowCount3();
            } else {
                top = sb.getTop() >= 0 ? sb.getTop() : 0;
                bottom = sb.getBottom() >= 0 ? sb.getBottom() : 0;
            }
            for (int j = top; j <= bottom; ++j) {
                Object number;
                IRow row = this.assistorTable.getRow(j);
                if (row == null || row.getCell(TABLE_COLUMN_NUMBER) == null || (number = row.getCell(TABLE_COLUMN_NUMBER).getValue()) == null) continue;
                this.deleteFromHistoryRecordCache(number.toString());
            }
        }
        this.saveHistoryRecord();
    }

    private void deleteFromHistoryRecordCache(String number) {
        if (this.assistorCache == null || this.assistorCache.length <= 0) {
            return;
        }
        for (int i = 0; i < this.assistorCache.length; ++i) {
            if (this.assistorCache[i].toUpperCase().indexOf(number.toUpperCase()) < 0) continue;
            this.assistorCache[i] = "";
            break;
        }
        for (Object tempContent : this.assistorContent) {
            if (tempContent.toString().toUpperCase().indexOf(number.toUpperCase()) < 0) continue;
            this.assistorContent.remove(tempContent);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveHistoryRecord() {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String fileName = null;
        if (this.parent.getParent() instanceof KDBizPromptBox) {
            this.parentPromptBox = (KDBizPromptBox)((Object)this.parent.getParent());
            fileName = this.parentPromptBox != null && !StringUtils.isEmpty((String)this.parentPromptBox.getRecordName()) ? this.parentPromptBox.getRecordName() : userID + this.parentPromptBox.getName();
        } else {
            return;
        }
        fileName = fileName.replaceAll("\\\\|/|\\:|\\*|\"|>|<|\\|\\.| |-|'|=|(|)|", "");
        if (fileName.length() > 200) {
            fileName = fileName.substring(0, 200);
        }
        File f = this.getMemorizeFile(fileName);
        FileOutputStream fom = null;
        try {
            String str = "";
            for (int i = 0; i < this.assistorCache.length; ++i) {
                if (this.assistorCache[i] == null || this.assistorCache[i].trim().length() <= 0) continue;
                str = str + this.assistorCache[i] + "\n";
            }
            fom = new FileOutputStream(f);
            fom.write(str.getBytes("UTF-8"));
            fom.write(10);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fom != null) {
                    fom.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void initHistoryTable() {
        String[] bindContents = new String[4];
        IColumn col = this.assistorTable.addColumn();
        col.setKey(TABLE_COLUMN_ID);
        bindContents[0] = TABLE_COLUMN_ID;
        col.setWidth(100);
        col.getStyleAttributes().setHided(true);
        col = this.assistorTable.addColumn();
        col.setKey(TABLE_COLUMN_NUMBER);
        bindContents[1] = TABLE_COLUMN_NUMBER;
        col.setWidth(100);
        col = this.assistorTable.addColumn();
        col.setKey(TABLE_COLUMN_NAME);
        bindContents[2] = TABLE_COLUMN_NAME;
        col.setWidth(100);
        this.assistorTable.putBindContents("query", bindContents);
        this.assistorTable.setFormatXml("");
        this.assistorTable.checkParsed(true);
        int x = -82;
        int y = -29;
        int width = 73;
        int height = 21;
        height = y - 20;
        width = -19;
        x = 10;
        y = 10;
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(x, y, width, height);
        cons.anchor = 15;
        this.assistorTable.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        this.assistorTable.getIndexColumn().getStyleAttributes().setHided(true);
        this.assistorTable.setGridLineColor(Color.WHITE);
    }

    private void initHistoryControls() {
        KDTableHelper.releaseEsc((JComponent)this.assistorTable);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.assistorTable, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.assistorTable.getSelectManager().setSelectMode(this.isEnabledMultipleSelect() ? 10 : 2);
        this.assistorTable.getStyleAttributes().setLocked(true);
        this.assistorTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                KDPromptEditorAssistor.this.setQuickQueryPanelActived(false);
                if (e.getClickCount() == 2 && e.getType() == 1) {
                    KDPromptEditorAssistor.this.commitSelection();
                    KDPromptEditorAssistor.this.setShowing(false);
                }
            }
        });
    }

    public void setRecordName(String name) {
        String n = null;
        if (name != null) {
            n = name.replaceAll("\\\\|/|\\:|\\*|\"|>|<|\\|\\.| |-|'|=|(|)|", "");
        }
        this.recordName = n;
        this.needRetrieval = true;
        this.needRetrievalMyCommonUse = true;
    }

    public void installListeners() {
        this.parent.addMouseListener((MouseListener)this.assistorHandler);
        this.parent.addKeyListener((KeyListener)this.assistorHandler);
        this.parent.addFocusListener((FocusListener)this.assistorHandler);
    }

    public void uninstallListeners() {
        this.parent.removeFocusListener((FocusListener)this.assistorHandler);
        this.parent.removeKeyListener((KeyListener)this.assistorHandler);
        this.parent.removeMouseListener((MouseListener)this.assistorHandler);
    }

    public void setQuickQueryEnable(boolean isQuickQueryEnable) {
        this.isQuickQueryEnable = isQuickQueryEnable;
    }

    public void setAssistorMaximumRowCount(int count) {
        this.listCellCountPerPage = count;
    }

    private File getMemorizeFile(String fileName) {
        String fileSepa = System.getProperty("file.separator");
        File f7cacheDir = new File(System.getProperty("user.dir") + fileSepa + "cache" + fileSepa + "F7Cache");
        if (!f7cacheDir.exists()) {
            f7cacheDir.mkdir();
        }
        File f = new File(System.getProperty("user.dir") + fileSepa + "cache" + fileSepa + "F7Cache" + fileSepa + (fileName == null ? "PublicCookie" : fileName));
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memorizeAssistorInfo() {
        if (this.parent.getText().equals("")) {
            return;
        }
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String fileName = null;
        if (this.parent.getParent() instanceof KDBizPromptBox) {
            this.parentPromptBox = (KDBizPromptBox)((Object)this.parent.getParent());
            fileName = this.parentPromptBox != null && !StringUtils.isEmpty((String)this.parentPromptBox.getRecordName()) ? this.parentPromptBox.getRecordName() : userID + this.parentPromptBox.getName();
        } else {
            return;
        }
        fileName = fileName.replaceAll("\\\\|/|\\:|\\*|\"|>|<|\\|\\.| |-|'|=|(|)|", "");
        if (fileName.length() > 200) {
            fileName = fileName.substring(0, 200);
        }
        File f = this.getMemorizeFile(fileName);
        FileOutputStream fom = null;
        try {
            int i;
            int i2;
            if (!f.exists()) {
                f.createNewFile();
                fom = new FileOutputStream(f);
                fom.write(this.parent.getText().getBytes("UTF-8"));
                fom.write(10);
                this.assistorCache = new String[]{this.parent.getText()};
                return;
            }
            if (this.assistorCache == null) {
                this.assistorCache = new String[0];
            }
            for (i2 = 0; i2 < this.assistorCache.length; ++i2) {
                if (!this.assistorCache[i2].equals(this.parent.getText())) continue;
                return;
            }
            if (this.assistorCache.length == this.assistInfoLimit) {
                for (i2 = 0; i2 < this.assistInfoLimit - 1; ++i2) {
                    this.assistorCache[i2] = this.assistorCache[i2 + 1];
                }
                this.assistorCache[this.assistInfoLimit - 1] = this.parent.getText();
            } else {
                String[] tempAssistorInformation = new String[this.assistorCache.length + 1];
                for (i = 0; i < this.assistorCache.length; ++i) {
                    tempAssistorInformation[i] = this.assistorCache[i];
                }
                tempAssistorInformation[this.assistorCache.length] = this.parent.getText();
                this.assistorCache = tempAssistorInformation;
            }
            String str = "";
            for (i = 0; i < this.assistorCache.length; ++i) {
                str = str + this.assistorCache[i] + "\n";
            }
            fom = new FileOutputStream(f);
            fom.write(str.getBytes("UTF-8"));
            fom.write(10);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fom != null) {
                    fom.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Object[] getAssistorContent() {
        return this.assistorContent.toArray();
    }

    private String getSelectedItem(String mainKey) {
        String selectedItem = null;
        Component selectedComponent = this.kdTMain.getSelectedComponent();
        if (selectedComponent == null) {
            return null;
        }
        if (selectedComponent.equals(this.assistorTable)) {
            selectedItem = this.getSelectedHistoryItem(mainKey);
        } else if (selectedComponent.equals(this.myCommonUseTable)) {
            selectedItem = this.getSelectedCommonUseItem(mainKey);
        }
        return selectedItem;
    }

    private String getSelectedHistoryItem(String mainKey) {
        String selectedItem = null;
        KDTSelectManager sm = this.assistorTable.getSelectManager();
        int size = sm.size();
        if (size <= 0) {
            return null;
        }
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = sm.get(i);
            int top = 0;
            int bottom = 0;
            if (sb.getMode() == 8) {
                bottom = this.assistorTable.getRowCount3();
            } else {
                top = sb.getTop() >= 0 ? sb.getTop() : 0;
                bottom = sb.getBottom() >= 0 ? sb.getBottom() : 0;
            }
            for (int j = top; j <= bottom; ++j) {
                Object v;
                IRow row = this.assistorTable.getRow(j);
                if (row == null || row.getCell(mainKey) == null || (v = row.getCell(mainKey).getValue()) == null) continue;
                selectedItem = v.toString();
                return selectedItem;
            }
        }
        return selectedItem;
    }

    private String getSelectedCommonUseItem(String mainKey) {
        String selectedItem = null;
        KDTSelectManager sm = this.myCommonUseTable.getSelectManager();
        int size = sm.size();
        if (size <= 0) {
            return null;
        }
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = sm.get(i);
            int top = 0;
            int bottom = 0;
            if (sb.getMode() == 8) {
                bottom = this.myCommonUseTable.getRowCount3();
            } else {
                top = sb.getTop() >= 0 ? sb.getTop() : 0;
                bottom = sb.getBottom() >= 0 ? sb.getBottom() : 0;
            }
            for (int j = top; j <= bottom; ++j) {
                Object v;
                IRow row = this.myCommonUseTable.getRow(j);
                if (row == null || row.getCell(mainKey) == null || (v = row.getCell(mainKey).getValue()) == null) continue;
                selectedItem = v.toString();
                return selectedItem;
            }
        }
        return selectedItem;
    }

    public void setShowing(boolean b) {
        if (b) {
            if (!this.isShowing) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (Error e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (this.popup != null) {
                try {
                    this.popup.hide();
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (Error ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            Point parentLocationOnScreen = this.parent.getLocationOnScreen();
            Point p = new Point(parentLocationOnScreen.x, parentLocationOnScreen.y + this.parent.getHeight());
            if (this.parent.getParent() instanceof KDBizPromptBox) {
                this.parentPromptBox = (KDBizPromptBox)((Object)this.parent.getParent());
                this.popup = PopupFactory.getSharedInstance().getPopup((Component)((Object)this.parentPromptBox), this, p.x, p.y);
            } else {
                this.popup = PopupFactory.getSharedInstance().getPopup((Component)this.parent, this, p.x, p.y);
            }
            if (!this.parent.isFocusOwner()) {
                if (this.parent.getParent() instanceof KDBizPromptBox) {
                    this.parentPromptBox = (KDBizPromptBox)((Object)this.parent.getParent());
                    this.parentPromptBox.setHasDownPanel(false);
                    this.parentPromptBox.setHasDownPanelSelected(false);
                }
                try {
                    if (this.parent.getParent() instanceof KDBizPromptBox) {
                        this.parentPromptBox = (KDBizPromptBox)((Object)this.parent.getParent());
                        this.parentPromptBox.setHasDownPanel(false);
                        this.parentPromptBox.setHasDownPanelSelected(false);
                    }
                    this.popup.hide();
                    try {
                        EventQueue ventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                        String methodName = "removePromptEditorAssistor";
                        Class[] parameterTypes = new Class[]{Popup.class};
                        Method removePromptEditorAssistor = ventQueue.getClass().getDeclaredMethod(methodName, parameterTypes);
                        removePromptEditorAssistor.invoke((Object)ventQueue, this.popup);
                    }
                    catch (Exception ventQueue) {
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (Error e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                try {
                    if (this.parent.getParent() instanceof KDBizPromptBox) {
                        this.parentPromptBox = (KDBizPromptBox)((Object)this.parent.getParent());
                        this.parentPromptBox.setHasDownPanel(true);
                    }
                    this.popup.show();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (Error e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                EventQueue ventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                String methodName = "addPromptEditorAssistor";
                Class[] parameterTypes = new Class[]{Popup.class};
                Method addPromptEditorAssistor = null;
                try {
                    addPromptEditorAssistor = ventQueue.getClass().getDeclaredMethod(methodName, parameterTypes);
                    addPromptEditorAssistor.invoke((Object)ventQueue, this.popup);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (Error e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (addPromptEditorAssistor == null) {
                    try {
                        addPromptEditorAssistor = ventQueue.getClass().getSuperclass().getDeclaredMethod(methodName, parameterTypes);
                        addPromptEditorAssistor.invoke((Object)ventQueue, this.popup);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (Error e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        } else if (this.popup != null) {
            try {
                if (this.parent.getParent() instanceof KDBizPromptBox) {
                    this.parentPromptBox = (KDBizPromptBox)((Object)this.parent.getParent());
                    this.parentPromptBox.setHasDownPanel(false);
                    this.parentPromptBox.setHasDownPanelSelected(false);
                }
                this.popup.hide();
                try {
                    EventQueue ventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    String methodName = "removePromptEditorAssistor";
                    Class[] parameterTypes = new Class[]{Popup.class};
                    Method removePromptEditorAssistor = ventQueue.getClass().getDeclaredMethod(methodName, parameterTypes);
                    removePromptEditorAssistor.invoke((Object)ventQueue, this.popup);
                }
                catch (Exception ventQueue) {}
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Error e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.isShowing = b;
    }

    @Override
    public boolean isShowing() {
        return this.isShowing;
    }

    private boolean renewAssistorContent() {
        KDBizPromptBox parentPromptBox;
        boolean renewResult = false;
        if (this.parent.getParent() instanceof KDBizPromptBox && StringUtils.isEmpty((String)(parentPromptBox = (KDBizPromptBox)((Object)this.parent.getParent())).getQueryInfo())) {
            return renewResult;
        }
        boolean renewHistoryResult = this.renewHistoryContent();
        boolean renewMyCommonUseResult = this.renewMyCommonUseContent();
        renewResult = renewHistoryResult || renewMyCommonUseResult;
        return renewResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renewHistoryContent() {
        if (!this.isHistoryRecordEnabled) {
            return false;
        }
        if (this.parent.getParent() instanceof KDBizPromptBox) {
            KDBizPromptBox parentPromptBox = (KDBizPromptBox)((Object)this.parent.getParent());
            if (StringUtils.isEmpty((String)parentPromptBox.getQueryInfo())) {
                return false;
            }
            if (!parentPromptBox.isHRHistoryEnbable()) {
                Container c;
                String uiName = null;
                for (c = parentPromptBox.getParent(); c != null && c.getClass().getName().indexOf("com.kingdee.eas.hr.") < 0; c = c.getParent()) {
                }
                if (c != null) {
                    uiName = c.getClass().getName();
                }
                if (uiName != null && uiName.indexOf("com.kingdee.eas.hr.") >= 0) {
                    return false;
                }
            }
        }
        if (this.parent.getParent() instanceof KDBizPromptBox) {
            this.parentPromptBox = (KDBizPromptBox)((Object)this.parent.getParent());
            this.parentPromptBox.setHasDownPanelSelected(false);
        }
        FileInputStream fim = null;
        try {
            boolean bl;
            if (this.needRetrieval) {
                File f;
                String fileName = null;
                String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                if (this.parent.getParent() instanceof KDBizPromptBox) {
                    KDBizPromptBox parentPromptBox = (KDBizPromptBox)((Object)this.parent.getParent());
                    fileName = parentPromptBox != null && !StringUtils.isEmpty((String)parentPromptBox.getRecordName()) ? parentPromptBox.getRecordName() : userID + parentPromptBox.getName();
                } else {
                    boolean parentPromptBox = false;
                    return parentPromptBox;
                }
                fileName = fileName.replaceAll("\\\\|/|\\:|\\*|\"|>|<|\\|\\.| |-|'|=|(|)|", "");
                if (fileName.length() > 200) {
                    fileName = fileName.substring(0, 200);
                }
                if (!(f = this.getMemorizeFile(fileName)).exists()) {
                    boolean e = false;
                    return e;
                }
                fim = new FileInputStream(f);
                byte[] bytes = new byte[(int)f.length()];
                fim.read(bytes);
                String str = new String(bytes, "UTF-8");
                this.assistorCache = str.split("\n");
                this.needRetrieval = false;
            }
            ArrayList<String> assistorList = new ArrayList<String>();
            String temp2 = null;
            String number1 = null;
            String number2 = null;
            for (int i = 0; i < this.assistorCache.length; ++i) {
                number1 = this.assistorCache[i].indexOf("\t") > 0 ? this.assistorCache[i].substring(0, this.assistorCache[i].indexOf("\t")) : this.assistorCache[i];
                boolean isNew = true;
                for (String temp2 : assistorList) {
                    number2 = temp2.indexOf("\t") > 0 ? temp2.substring(0, temp2.indexOf("\t")) : temp2;
                    if (!number1.equals(number2)) continue;
                    isNew = false;
                }
                if (!isNew) continue;
                assistorList.add(this.assistorCache[i]);
            }
            int assistorSize = assistorList.size();
            this.assistorCache = new String[assistorSize];
            Iterator it = assistorList.iterator();
            int index = 0;
            while (it.hasNext()) {
                this.assistorCache[index] = it.next().toString();
                ++index;
            }
            this.assistorContent.clear();
            int findCount = 0;
            for (int i = 0; i < this.assistorCache.length && findCount < 10; ++i) {
                if (StringUtils.isEmpty((String)this.assistorCache[i]) || this.assistorCache[i].toUpperCase().indexOf(this.parent.getText().toUpperCase()) < 0) continue;
                this.assistorContent.add(this.assistorCache[i]);
                ++findCount;
            }
            if (this.assistorContent.size() == 0) {
                bl = false;
                return bl;
            }
            bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fim != null) {
                    fim.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateAssistorContent() {
        this.add((Component)this.kdTMain, "Center");
        this.fillHistroryTable();
        this.fillMyCommonUseTable();
    }

    private void fillHistroryTable() {
        if (!this.isHistoryRecordEnabled || this.assistorContent == null || this.assistorContent.size() == 0) {
            this.kdTMain.remove((Component)this.assistorTable);
            return;
        }
        this.kdTMain.add((Component)this.assistorTable, (Object)this.getMLS("13_KDPromptEditorAssistor", "13_KDPromptEditorAssistor"));
        this.assistorTable.removeRows();
        Iterator it = this.assistorContent.iterator();
        String content = null;
        String id = " ";
        String number = " ";
        String name = " ";
        IRow row = null;
        String[] contentArray = null;
        while (it != null && it.hasNext()) {
            content = (String)it.next();
            if (content == null || content.trim().length() <= 0) continue;
            if (content.indexOf("\t") >= 0) {
                contentArray = content.split("\t");
                if (contentArray.length == 3) {
                    id = contentArray[0];
                    number = contentArray[1];
                    name = contentArray[2];
                } else if (contentArray.length == 2) {
                    id = " ";
                    number = contentArray[0];
                    name = contentArray[1];
                } else {
                    id = " ";
                    number = contentArray[0];
                    name = " ";
                }
            } else {
                id = " ";
                number = content;
                name = " ";
            }
            if (" ".equals(number) && " ".equals(name)) continue;
            row = this.assistorTable.addRow();
            row.getCell(TABLE_COLUMN_ID).setValue((Object)id);
            row.getCell(TABLE_COLUMN_NUMBER).setValue((Object)number);
            row.getCell(TABLE_COLUMN_NAME).setValue((Object)name);
        }
        if (this.assistorTable.getRow(0) != null) {
            int i;
            if (this.parent.getParent() instanceof KDBizPromptBox) {
                KDBizPromptBox kDBizPromptBox = (KDBizPromptBox)((Object)this.parent.getParent());
            }
            int columnCount = this.assistorTable.getColumnCount();
            for (i = 0; i < columnCount; ++i) {
                KDTableHelper.autoFitColumnWidth((KDTable)this.assistorTable, (int)i);
            }
            for (i = 0; i < columnCount; ++i) {
                int columnWidth = this.assistorTable.getColumn(i).getWidth();
                if (columnWidth >= 100) continue;
                this.assistorTable.getColumn(i).setWidth(100);
            }
        }
    }

    private void fillMyCommonUseTable() {
        if (!this.isMyCommonUseEnabled || this.myCommonUseContent == null || this.myCommonUseContent.size() == 0) {
            this.kdTMain.remove((Component)this.myCommonUseTable);
            return;
        }
        this.kdTMain.add((Component)this.myCommonUseTable, (Object)this.getMLS("1_KDCommonPromptDialog", "1_KDCommonPromptDialog"));
        this.myCommonUseTable.removeRows();
        Iterator it = this.myCommonUseContent.iterator();
        String content = null;
        String id = " ";
        String number = " ";
        String name = " ";
        IRow row = null;
        String[] contentArray = null;
        while (it != null && it.hasNext()) {
            content = (String)it.next();
            if (content == null || content.trim().length() <= 0) continue;
            if (content.indexOf("\t") >= 0) {
                contentArray = content.split("\t");
                if (contentArray.length == 3) {
                    id = contentArray[0];
                    number = contentArray[1];
                    name = contentArray[2];
                } else if (contentArray.length == 2) {
                    id = contentArray[0];
                    number = contentArray[1];
                    name = " ";
                } else {
                    id = contentArray[0];
                    number = " ";
                    name = " ";
                }
            } else {
                number = content;
                name = " ";
            }
            if (" ".equals(number) && " ".equals(name)) continue;
            row = this.myCommonUseTable.addRow();
            row.getCell(TABLE_COLUMN_ID).setValue((Object)id);
            row.getCell(TABLE_COLUMN_NUMBER).setValue((Object)number);
            row.getCell(TABLE_COLUMN_NAME).setValue((Object)name);
        }
        if (this.myCommonUseTable.getRow(0) != null) {
            int i;
            if (this.parent.getParent() instanceof KDBizPromptBox) {
                KDBizPromptBox kDBizPromptBox = (KDBizPromptBox)((Object)this.parent.getParent());
            }
            int columnCount = this.myCommonUseTable.getColumnCount();
            for (i = 0; i < columnCount; ++i) {
                KDTableHelper.autoFitColumnWidth((KDTable)this.myCommonUseTable, (int)i);
            }
            for (i = 0; i < columnCount; ++i) {
                int columnWidth = this.myCommonUseTable.getColumn(i).getWidth();
                if (columnWidth >= 100) continue;
                this.myCommonUseTable.getColumn(i).setWidth(100);
            }
        }
    }

    private void updateAssistor() {
        this.updateAssistorContent();
        this.setShowing(true);
    }

    public void commitSelection() {
        this.setCloseAble(false);
        String selectedValue = this.getSelectedItem(TABLE_COLUMN_ID);
        if (StringUtils.isEmpty((String)selectedValue) || " ".equals(selectedValue)) {
            selectedValue = this.getSelectedItem(TABLE_COLUMN_NUMBER);
        }
        if (selectedValue != null && !selectedValue.equals(this.parent.getText())) {
            this.parent.setText(this.getSelectedItem(TABLE_COLUMN_NUMBER));
            if (this.parent.getParent() instanceof KDBizPromptBox) {
                KDBizPromptBox parentPromptBox = (KDBizPromptBox)((Object)this.parent.getParent());
                Object data = parentPromptBox.stringToValueForHistoryOrMyCommonUse(selectedValue, true);
                if (data == null && parentPromptBox.getCommitParser() instanceof ExtendParser) {
                    data = selectedValue;
                    parentPromptBox.setData(data);
                }
                if (KDPromptBox.DEFAULTVALUE.equals(data) || data instanceof Object[] && ((Object[])data).length == 0) {
                    if (parentPromptBox.getCommitParser() == null || parentPromptBox.getCommitParser() instanceof ExtendParser) {
                        data = selectedValue;
                        parentPromptBox.setData(data);
                    } else {
                        String s;
                        MessageFormat mf;
                        String msg;
                        int result;
                        Component selectedComponent = this.kdTMain.getSelectedComponent();
                        if (selectedComponent == null) {
                            return;
                        }
                        if (selectedComponent.equals(this.assistorTable)) {
                            String s2 = this.getMLS("15_KDPromptEditorAssistor", "15_KDPromptEditorAssistor");
                            MessageFormat mf2 = new MessageFormat(s2);
                            String msg2 = mf2.format(new String[]{selectedValue = this.getSelectedItem(TABLE_COLUMN_NUMBER)});
                            int result2 = MsgBox.showConfirm2((Component)this, (String)msg2);
                            if (result2 == 0) {
                                this.deleteHistoryRecord();
                                this.setShowing(false);
                            }
                            this.parent.setText(null);
                        } else if (selectedComponent.equals(this.myCommonUseTable) && (result = MsgBox.showConfirm2((Component)this, (String)(msg = (mf = new MessageFormat(s = this.getMLS("15_KDPromptEditorAssistor", "15_KDPromptEditorAssistor"))).format(new String[]{selectedValue = this.getSelectedItem(TABLE_COLUMN_NUMBER)})))) == 0) {
                            this.deleteMyCommonUse();
                            this.parent.setText(null);
                            this.setShowing(false);
                        }
                        return;
                    }
                }
            }
        }
        this.setCloseAble(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renewMyCommonUseContent() {
        KDPromptBox parentPromptBox;
        if (!this.isMyCommonUseEnabled) {
            return false;
        }
        if (this.parent.getParent() instanceof KDPromptBox) {
            parentPromptBox = (KDPromptBox)this.parent.getParent();
            parentPromptBox.setHasDownPanelSelected(false);
        }
        if (this.parent.getParent() instanceof KDBizPromptBox) {
            parentPromptBox = (KDBizPromptBox)((Object)this.parent.getParent());
            if (StringUtils.isEmpty((String)parentPromptBox.getQueryInfo())) {
                return false;
            }
            if (!parentPromptBox.isHRCommonUseEnbable()) {
                Container c;
                String uiName = null;
                for (c = parentPromptBox.getParent(); c != null && c.getClass().getName().indexOf("com.kingdee.eas.hr.") < 0; c = c.getParent()) {
                }
                if (c != null) {
                    uiName = c.getClass().getName();
                }
                if (uiName != null && uiName.indexOf("com.kingdee.eas.hr.") >= 0) {
                    return false;
                }
            }
        }
        FileInputStream fim = null;
        try {
            boolean bl;
            if (this.needRetrievalMyCommonUse) {
                File f;
                String fileName = null;
                String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                if (this.parent.getParent() instanceof KDBizPromptBox) {
                    KDBizPromptBox parentPromptBox2 = (KDBizPromptBox)((Object)this.parent.getParent());
                    fileName = parentPromptBox2 != null && !StringUtils.isEmpty((String)parentPromptBox2.getRecordName()) ? parentPromptBox2.getRecordName() : userID + parentPromptBox2.getName();
                } else {
                    boolean parentPromptBox2 = false;
                    return parentPromptBox2;
                }
                fileName = fileName.replaceAll("\\\\|/|\\:|\\*|\"|>|<|\\|\\.| |-|'|=|(|)|", "");
                if (fileName.length() > 200) {
                    fileName = fileName.substring(0, 200);
                }
                if (!(f = this.getMemorizeFile(fileName = fileName + "MyCommonUse")).exists()) {
                    boolean e = false;
                    return e;
                }
                fim = new FileInputStream(f);
                byte[] bytes = new byte[(int)f.length()];
                fim.read(bytes);
                String str = new String(bytes, "UTF-8");
                this.myCommonUseCache = str.split("\n");
            }
            this.myCommonUseContent.clear();
            int findCount = 0;
            for (int i = 0; i < this.myCommonUseCache.length && findCount < 10; ++i) {
                if (StringUtils.isEmpty((String)this.myCommonUseCache[i]) || this.myCommonUseCache[i].toUpperCase().indexOf(this.parent.getText().toUpperCase()) < 0) continue;
                this.myCommonUseContent.add(this.myCommonUseCache[i]);
                ++findCount;
            }
            if (this.myCommonUseContent.size() == 0) {
                bl = false;
                return bl;
            }
            bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fim != null) {
                    fim.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isCloseAble() {
        return this.closeAble;
    }

    public void setCloseAble(boolean closeAble) {
        this.closeAble = closeAble;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memorizeAssistorInfo(String editValue) {
        if (editValue.equals("")) {
            return;
        }
        this.renewHistoryContent();
        String fileName = null;
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (this.parent.getParent() instanceof KDBizPromptBox) {
            KDBizPromptBox parentPromptBox = (KDBizPromptBox)((Object)this.parent.getParent());
            fileName = parentPromptBox != null && !StringUtils.isEmpty((String)parentPromptBox.getRecordName()) ? parentPromptBox.getRecordName() : userID + parentPromptBox.getName();
        } else {
            return;
        }
        fileName = fileName.replaceAll("\\\\|/|\\:|\\*|\"|>|<|\\|\\.| |-|'|=|(|)|", "");
        if (fileName.length() > 200) {
            fileName = fileName.substring(0, 200);
        }
        File f = this.getMemorizeFile(fileName);
        FileOutputStream fom = null;
        try {
            int i;
            int i2;
            if (!f.exists()) {
                f.createNewFile();
                fom = new FileOutputStream(f);
                fom.write(editValue.getBytes("UTF-8"));
                fom.write(10);
                this.assistorCache = new String[]{editValue};
                return;
            }
            if (this.assistorCache == null) {
                this.assistorCache = new String[0];
            }
            boolean isFound = false;
            for (i2 = 0; i2 < this.assistorCache.length; ++i2) {
                if (!this.assistorCache[i2].equals(editValue)) continue;
                for (int j = i2; j > 0; --j) {
                    this.assistorCache[j] = this.assistorCache[j - 1];
                }
                this.assistorCache[0] = editValue;
                isFound = true;
                break;
            }
            if (!isFound) {
                if (this.assistorCache.length == this.assistInfoLimit) {
                    for (i2 = this.assistInfoLimit - 1; i2 > 0; --i2) {
                        this.assistorCache[i2] = this.assistorCache[i2 - 1];
                    }
                    this.assistorCache[0] = editValue;
                } else {
                    String[] tempAssistorInformation = new String[this.assistorCache.length + 1];
                    for (i = this.assistorCache.length; i > 0; --i) {
                        tempAssistorInformation[i] = this.assistorCache[i - 1];
                    }
                    tempAssistorInformation[0] = editValue;
                    this.assistorCache = tempAssistorInformation;
                }
            }
            String str = "";
            for (i = 0; i < this.assistorCache.length; ++i) {
                str = str + this.assistorCache[i] + "\n";
            }
            fom = new FileOutputStream(f);
            fom.write(str.getBytes("UTF-8"));
            fom.write(10);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fom != null) {
                    fom.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isEnabledMultipleSelect() {
        return this.multipleSelect;
    }

    public void setEnabledMultiSelection(boolean b) {
        this.multipleSelect = b;
        this.assistorTable.getSelectManager().setSelectMode(b ? 10 : 2);
    }

    public void setHistoryRecordEnabled(boolean isHistoryRecordEnabled) {
        this.isHistoryRecordEnabled = isHistoryRecordEnabled;
        if (isHistoryRecordEnabled) {
            this.kdTMain.add((Component)this.assistorTable, (Object)this.getMLS("13_KDPromptEditorAssistor", "13_KDPromptEditorAssistor"));
        } else {
            this.kdTMain.remove((Component)this.assistorTable);
        }
    }

    public void setMyCommonUseEnabled(boolean isMyCommonUseEnabled) {
        this.isMyCommonUseEnabled = isMyCommonUseEnabled;
        if (isMyCommonUseEnabled) {
            this.kdTMain.add((Component)this.myCommonUseTable, (Object)this.getMLS("1_KDCommonPromptDialog", "1_KDCommonPromptDialog"));
        } else {
            this.kdTMain.remove((Component)this.myCommonUseTable);
        }
    }

    private void gennerateQuickQueryCondition() {
        KDBizPromptBox parentPromptBox;
        this.remove((Component)this.quickQueryConditionList);
        this.quickQueryConditionList.removeAllElements();
        if (!this.isQuickQueryEnable) {
            return;
        }
        if (this.parent.getParent() instanceof KDBizPromptBox && StringUtils.isEmpty((String)(parentPromptBox = (KDBizPromptBox)((Object)this.parent.getParent())).getQueryInfo())) {
            return;
        }
        String inputText = this.parent.getText();
        if (StringUtils.isEmpty((String)inputText)) {
            return;
        }
        if (this.parentPromptBox != null && (this.filterFields == null || this.filterFields.length <= 0)) {
            this.filterFields = this.parentPromptBox.getFilterFields();
        }
        if (this.filterFields == null || this.filterFields.length <= 0) {
            return;
        }
        this.quickQueryContent = new ArrayList();
        int maxQueryFieldCount = 3;
        String s = this.getMLS("11_KDCommonPromptDialog", "11_KDCommonPromptDialog");
        MessageFormat mf = new MessageFormat(s);
        String result = null;
        for (int i = 0; i < this.filterFields.length && i != maxQueryFieldCount; ++i) {
            KDBizPromptBox.FilterFieldItem fiterFieldItem = this.filterFields[i];
            result = mf.format(new String[]{fiterFieldItem.toString(), inputText});
            this.quickQueryContent.add(result);
        }
        this.quickQueryConditionList.setListData(this.quickQueryContent.toArray());
        this.quickQueryConditionList.setSelectedIndex(0);
        this.isQuickQueryPanelActived = false;
        this.setShowing(true);
    }

    private void showQuickQueryPanle() {
        String inputText;
        if (this.popup != null) {
            try {
                this.popup.hide();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Error ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        if (StringUtils.isEmpty((String)(inputText = this.parent.getText()))) {
            return;
        }
        if (this.parentPromptBox != null && this.parentPromptBox.hasDownPanel()) {
            return;
        }
        if (this.quickQueryConditionList == null || this.quickQueryConditionList.getElementCount() <= 0) {
            return;
        }
        Point parentLocationOnScreen = this.parent.getLocationOnScreen();
        Point p = new Point(parentLocationOnScreen.x, parentLocationOnScreen.y + this.parent.getHeight());
        this.popup = PopupFactory.getSharedInstance().getPopup((Component)this.parent, this, p.x, p.y);
        try {
            this.popup.show();
            this.setHasQuickQueryPanel(true);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.setHasQuickQueryPanel(false);
        }
        catch (Error ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.setHasQuickQueryPanel(false);
        }
    }

    public void setHasQuickQueryPanel(boolean hasQuickQueryPanel) {
        this.parentPromptBox.setHasQuickQueryPanel(hasQuickQueryPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQuickQuery() {
        this.parentPromptBox.setDirty(true);
        this.parentPromptBox.setQuickQuery(true);
        String inputText = this.parent.getText();
        if (this.quickQueryConditionList == null || this.quickQueryConditionList.getSelectedValue() == null) {
            this.parentPromptBox.setQuickQuery(false);
            return;
        }
        String selectedValue = this.quickQueryConditionList.getSelectedValue().toString();
        String conditionField = selectedValue.substring(1, selectedValue.indexOf("\u3011"));
        String conditionValue = "%" + inputText.trim() + "%";
        this.quickQueryFilter = new FilterInfo();
        String maskString = "#0";
        StringBuffer newCommitFormat = new StringBuffer();
        for (int i = 0; i < this.filterFields.length; ++i) {
            KDBizPromptBox.FilterFieldItem filterFieldItem = this.filterFields[i];
            if (!filterFieldItem.toString().equalsIgnoreCase(conditionField)) continue;
            String[] fieldArray = filterFieldItem.getName().split("[+]");
            for (int j = 0; j < fieldArray.length; ++j) {
                newCommitFormat.append("$").append(fieldArray[j]).append("$;");
            }
            break;
        }
        this.setShowing(false);
        this.parentPromptBox.setCommitFormat(newCommitFormat.toString());
        EntityViewInfo promptEntityViewInfo = null;
        try {
            promptEntityViewInfo = new EntityViewInfo(this.parentPromptBox.getEntityViewInfo().toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            this.parentPromptBox.commitEdit();
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.parentPromptBox.setEntityViewInfo(promptEntityViewInfo);
            this.quickQueryEvi = null;
            this.quickQueryFilter = null;
            this.parentPromptBox.setQuickQureyEntityViewInfo(null);
        }
        this.parentPromptBox.setQuickQuery(false);
        this.setQuickQueryPanelActived(false);
    }

    protected void initDynQueryEnabled() {
        String dynQueryEnabled = ParamHelper.getDynQueryEnabled();
        this.isDynQueryEnabled = dynQueryEnabled != null && dynQueryEnabled.trim().equalsIgnoreCase("true");
    }

    private String getMLS(String key, String defaultValue) {
        Locale local = Locale.getDefault();
        if (local.toString().toLowerCase().indexOf("l") >= 0) {
            local = this.shortToLong(local);
        }
        return LanguageManager.getLangMessage((String)key, (String)"com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog", (Locale)local, (String)defaultValue);
    }

    private Locale shortToLong(Locale local) {
        if ("l2".equalsIgnoreCase(local.toString())) {
            return Locale.SIMPLIFIED_CHINESE;
        }
        if ("l3".equalsIgnoreCase(local.toString())) {
            return Locale.TRADITIONAL_CHINESE;
        }
        if ("l1".equalsIgnoreCase(local.toString())) {
            return Locale.ENGLISH;
        }
        logger.info((Object)"KDCommonPromptDialog.shortToLong ,illegal Locale!");
        return local;
    }

    private class KingdeeTextFieldAssistorLayout
    implements LayoutManager {
        private int columnHeight = 20;
        private int insets = 4;

        private KingdeeTextFieldAssistorLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int assistorTableWidth = (int)KDPromptEditorAssistor.this.assistorTable.getPreferredSize().getWidth();
            int assistorTableHeight = (int)KDPromptEditorAssistor.this.assistorTable.getPreferredSize().getHeight();
            int myCommonUseTableWidth = (int)KDPromptEditorAssistor.this.myCommonUseTable.getPreferredSize().getWidth();
            int myCommonUseTableHeight = (int)KDPromptEditorAssistor.this.myCommonUseTable.getPreferredSize().getHeight();
            int width = assistorTableWidth > myCommonUseTableWidth ? assistorTableWidth : myCommonUseTableWidth;
            int height = assistorTableHeight > myCommonUseTableHeight ? assistorTableHeight : myCommonUseTableHeight;
            return new Dimension(width, height + 100);
        }

        @Override
        public void layoutContainer(Container parent) {
            int width = (int)KDPromptEditorAssistor.this.kdTMain.getPreferredSize().getWidth();
            int height = (int)KDPromptEditorAssistor.this.kdTMain.getPreferredSize().getHeight();
            KDPromptEditorAssistor.this.kdTMain.setBounds(0, 0, width, height + 100);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }
    }

    private class AssistorHandler
    extends MouseAdapter
    implements KeyListener,
    FocusListener {
        private AssistorHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            String inputText = KDPromptEditorAssistor.this.parent.getText();
            if (!StringUtils.isEmpty((String)inputText) && KDPromptEditorAssistor.this.parentPromptBox != null && !KDPromptEditorAssistor.this.parentPromptBox.isDirty()) {
                return;
            }
            if (KDPromptEditorAssistor.this.parent.getParent() instanceof KDPromptBox) {
                KDPromptBox parentPromptBox = (KDPromptBox)KDPromptEditorAssistor.this.parent.getParent();
                if (!parentPromptBox.isEnabled()) {
                    return;
                }
                if (parentPromptBox.isReadOnly()) {
                    return;
                }
            }
            if (KDPromptEditorAssistor.this.renewAssistorContent()) {
                KDPromptEditorAssistor.this.updateAssistor();
            } else {
                KDPromptEditorAssistor.this.remove((Component)KDPromptEditorAssistor.this.kdTMain);
                KDPromptEditorAssistor.this.setShowing(false);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point location = e.getPoint();
            Rectangle r = new Rectangle();
            KDPromptEditorAssistor.this.quickQueryConditionList.computeVisibleRect(r);
            if (r.contains(location)) {
                KDPromptEditorAssistor.this.quickQueryConditionList.setSelectedIndex(KDPromptEditorAssistor.this.quickQueryConditionList.locationToIndex(location));
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                KDPromptEditorAssistor.this.setShowing(false);
            } else if (e.getKeyCode() == 40) {
                if (!KDPromptEditorAssistor.this.isQuickQueryPanelActived) {
                    Component selectedComponent = KDPromptEditorAssistor.this.kdTMain.getSelectedComponent();
                    if (selectedComponent == null) {
                        return;
                    }
                    if (selectedComponent.equals(KDPromptEditorAssistor.this.assistorTable)) {
                        int selectRowIndex = KDPromptEditorAssistor.this.assistorTable.getSelectManager().getActiveRowIndex();
                        int rowCount = KDPromptEditorAssistor.this.assistorTable.getRowCount();
                        int currentIndex = 0;
                        if (rowCount > 0) {
                            if (selectRowIndex < rowCount - 1) {
                                currentIndex = selectRowIndex + 1;
                                KDPromptEditorAssistor.this.assistorTable.getSelectManager().select(currentIndex, -1);
                                KDPromptEditorAssistor.this.assistorTable.scrollToVisible(currentIndex, -1);
                                if (KDPromptEditorAssistor.this.parent.getParent() instanceof KDPromptBox) {
                                    KDPromptBox parentPromptBox = (KDPromptBox)KDPromptEditorAssistor.this.parent.getParent();
                                    parentPromptBox.setHasDownPanelSelected(true);
                                }
                            } else {
                                currentIndex = 0;
                                KDPromptEditorAssistor.this.assistorTable.getSelectManager().select(currentIndex, -1);
                                KDPromptEditorAssistor.this.assistorTable.scrollToVisible(currentIndex, -1);
                                if (KDPromptEditorAssistor.this.parent.getParent() instanceof KDPromptBox) {
                                    KDPromptBox parentPromptBox = (KDPromptBox)KDPromptEditorAssistor.this.parent.getParent();
                                    parentPromptBox.setHasDownPanelSelected(true);
                                }
                            }
                        }
                    } else if (selectedComponent.equals(KDPromptEditorAssistor.this.myCommonUseTable)) {
                        int selectRowIndex = KDPromptEditorAssistor.this.myCommonUseTable.getSelectManager().getActiveRowIndex();
                        int rowCount = KDPromptEditorAssistor.this.myCommonUseTable.getRowCount();
                        int currentIndex = 0;
                        if (rowCount > 0) {
                            if (selectRowIndex < rowCount - 1) {
                                currentIndex = selectRowIndex + 1;
                                KDPromptEditorAssistor.this.myCommonUseTable.getSelectManager().select(currentIndex, -1);
                                KDPromptEditorAssistor.this.myCommonUseTable.scrollToVisible(currentIndex, -1);
                                if (KDPromptEditorAssistor.this.parent.getParent() instanceof KDPromptBox) {
                                    KDPromptBox parentPromptBox = (KDPromptBox)KDPromptEditorAssistor.this.parent.getParent();
                                    parentPromptBox.setHasDownPanelSelected(true);
                                }
                            } else {
                                currentIndex = 0;
                                KDPromptEditorAssistor.this.myCommonUseTable.getSelectManager().select(currentIndex, -1);
                                KDPromptEditorAssistor.this.myCommonUseTable.scrollToVisible(currentIndex, -1);
                                if (KDPromptEditorAssistor.this.parent.getParent() instanceof KDPromptBox) {
                                    KDPromptBox parentPromptBox = (KDPromptBox)KDPromptEditorAssistor.this.parent.getParent();
                                    parentPromptBox.setHasDownPanelSelected(true);
                                }
                            }
                        }
                    }
                }
            } else if (e.getKeyCode() == 38) {
                if (!KDPromptEditorAssistor.this.isQuickQueryPanelActived) {
                    int selectRowIndex;
                    Component selectedComponent = KDPromptEditorAssistor.this.kdTMain.getSelectedComponent();
                    if (selectedComponent == null) {
                        return;
                    }
                    if (selectedComponent.equals(KDPromptEditorAssistor.this.assistorTable)) {
                        selectRowIndex = KDPromptEditorAssistor.this.assistorTable.getSelectManager().getActiveRowIndex();
                        int rowCount = KDPromptEditorAssistor.this.assistorTable.getRowCount();
                        int currentIndex = 0;
                        if (rowCount > 0) {
                            if (selectRowIndex > 0) {
                                currentIndex = selectRowIndex - 1;
                                KDPromptEditorAssistor.this.assistorTable.getSelectManager().select(currentIndex, -1);
                                KDPromptEditorAssistor.this.assistorTable.scrollToVisible(currentIndex, -1);
                            } else if (selectRowIndex == -1) {
                                currentIndex = rowCount - 1;
                                KDPromptEditorAssistor.this.assistorTable.getSelectManager().select(currentIndex, -1);
                                KDPromptEditorAssistor.this.assistorTable.scrollToVisible(currentIndex, -1);
                            } else {
                                KDPromptEditorAssistor.this.isQuickQueryPanelActived = false;
                                KDPromptEditorAssistor.this.assistorTable.getSelectManager().select(-1, -1);
                                KDPromptEditorAssistor.this.assistorTable.getSelectManager().setSelectMode(0);
                                KDPromptEditorAssistor.this.assistorTable.getSelectManager().setSelectMode(2);
                            }
                        }
                    } else if (selectedComponent.equals(KDPromptEditorAssistor.this.myCommonUseTable)) {
                        selectRowIndex = KDPromptEditorAssistor.this.myCommonUseTable.getSelectManager().getActiveRowIndex();
                        int rowCount = KDPromptEditorAssistor.this.myCommonUseTable.getRowCount();
                        int currentIndex = 0;
                        if (rowCount > 0) {
                            if (selectRowIndex > 0) {
                                currentIndex = selectRowIndex - 1;
                                KDPromptEditorAssistor.this.myCommonUseTable.getSelectManager().select(currentIndex, -1);
                                KDPromptEditorAssistor.this.myCommonUseTable.scrollToVisible(currentIndex, -1);
                            } else if (selectRowIndex == -1) {
                                currentIndex = rowCount - 1;
                                KDPromptEditorAssistor.this.myCommonUseTable.getSelectManager().select(currentIndex, -1);
                                KDPromptEditorAssistor.this.myCommonUseTable.scrollToVisible(currentIndex, -1);
                            } else {
                                KDPromptEditorAssistor.this.isQuickQueryPanelActived = false;
                                KDPromptEditorAssistor.this.myCommonUseTable.getSelectManager().select(-1, -1);
                                KDPromptEditorAssistor.this.myCommonUseTable.getSelectManager().setSelectMode(0);
                                KDPromptEditorAssistor.this.myCommonUseTable.getSelectManager().setSelectMode(2);
                            }
                        }
                    }
                }
                if (KDPromptEditorAssistor.this.isQuickQueryPanelActived) {
                    int selectedIndex = KDPromptEditorAssistor.this.quickQueryConditionList.getSelectedIndex();
                    if (selectedIndex == -1) {
                        int itemCount = KDPromptEditorAssistor.this.quickQueryConditionList.getElementCount();
                        if (itemCount > 0) {
                            selectedIndex = itemCount - 1;
                        }
                    } else if (selectedIndex > 0) {
                        --selectedIndex;
                    }
                    KDPromptEditorAssistor.this.quickQueryConditionList.setSelectedIndex(selectedIndex);
                    KDPromptEditorAssistor.this.quickQueryConditionList.ensureIndexIsVisible(selectedIndex);
                }
            } else if (e.isControlDown() && (e.getKeyCode() == 37 || e.getKeyCode() == 39)) {
                Component selectedComponent;
                if (!KDPromptEditorAssistor.this.isShowing()) {
                    return;
                }
                if (KDPromptEditorAssistor.this.isQuickQueryPanelActived) {
                    KDPromptEditorAssistor.this.isQuickQueryPanelActived = false;
                }
                if ((selectedComponent = KDPromptEditorAssistor.this.kdTMain.getSelectedComponent()) == null) {
                    return;
                }
                if (selectedComponent.equals(KDPromptEditorAssistor.this.assistorTable)) {
                    Component[] components = KDPromptEditorAssistor.this.kdTMain.getComponents();
                    for (int i = 0; i < components.length; ++i) {
                        if (!components[i].equals(KDPromptEditorAssistor.this.myCommonUseTable)) continue;
                        KDPromptEditorAssistor.this.kdTMain.setSelectedComponent((Component)KDPromptEditorAssistor.this.myCommonUseTable);
                    }
                } else if (selectedComponent.equals(KDPromptEditorAssistor.this.myCommonUseTable)) {
                    Component[] components = KDPromptEditorAssistor.this.kdTMain.getComponents();
                    for (int i = 0; i < components.length; ++i) {
                        if (!components[i].equals(KDPromptEditorAssistor.this.assistorTable)) continue;
                        KDPromptEditorAssistor.this.kdTMain.setSelectedComponent((Component)KDPromptEditorAssistor.this.assistorTable);
                    }
                }
            } else if (e.getKeyCode() == 10) {
                if ((StringUtils.isEmpty((String)KDPromptEditorAssistor.this.getSelectedItem(KDPromptEditorAssistor.TABLE_COLUMN_ID)) || !KDPromptEditorAssistor.this.isShowing) && KDPromptEditorAssistor.this.parentPromptBox.isDirty()) {
                    try {
                        KDPromptEditorAssistor.this.parentPromptBox.commitEdit();
                    }
                    catch (ParseException ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                } else if (KDPromptEditorAssistor.this.isQuickQueryPanelActived()) {
                    KDPromptEditorAssistor.this.doQuickQuery();
                } else if (KDPromptEditorAssistor.this.isShowing) {
                    KDPromptEditorAssistor.this.commitSelection();
                    KDPromptEditorAssistor.this.setShowing(false);
                    if (KDPromptEditorAssistor.this.parent.getParent() instanceof KDPromptBox) {
                        KDPromptBox parentPromptBox = (KDPromptBox)KDPromptEditorAssistor.this.parent.getParent();
                        parentPromptBox.setHasDownPanelSelected(false);
                    }
                }
                e.consume();
                if (!KDPromptEditorAssistor.this.parentPromptBox.isDirty()) {
                    if (KDPromptEditorAssistor.this.parentPromptBox.isAutoFocusNextComponent()) {
                        KDPromptEditorAssistor.this.parentPromptBox.requestFocusInWindow();
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    }
                    KDPromptEditorAssistor.this.parentPromptBox.putClientProperty("dirty", Boolean.FALSE);
                    KDPromptEditorAssistor.this.parentPromptBox.NotifyAction();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                return;
            }
            int keyCode = e.getKeyCode();
            if (keyCode == 127 && e.isControlDown()) {
                KDPromptEditorAssistor.this.deleteHistoryRecord();
            }
            if (keyCode >= 48 && keyCode <= 57 || keyCode >= 65 && keyCode <= 90 || keyCode >= 96 && keyCode <= 105 || keyCode == 8 || keyCode == 127 || keyCode == 32) {
                String inputText = KDPromptEditorAssistor.this.parent.getText();
                if (!StringUtils.isEmpty((String)inputText) && KDPromptEditorAssistor.this.parentPromptBox != null && !KDPromptEditorAssistor.this.parentPromptBox.isDirty()) {
                    return;
                }
                if (KDPromptEditorAssistor.this.isDynQueryEnabled) {
                    KDPromptEditorAssistor.this.setShowing(false);
                } else {
                    KDPromptEditorAssistor.this.remove((Component)KDPromptEditorAssistor.this.kdTMain);
                    if (KDPromptEditorAssistor.this.renewAssistorContent()) {
                        KDPromptEditorAssistor.this.updateAssistor();
                    } else {
                        KDPromptEditorAssistor.this.setShowing(false);
                    }
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            String inputText = KDPromptEditorAssistor.this.parent.getText();
            if (!StringUtils.isEmpty((String)inputText) && KDPromptEditorAssistor.this.parentPromptBox != null && !KDPromptEditorAssistor.this.parentPromptBox.isDirty()) {
                return;
            }
            if (KDPromptEditorAssistor.this.renewAssistorContent()) {
                KDPromptEditorAssistor.this.updateAssistor();
            } else {
                KDPromptEditorAssistor.this.setShowing(false);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            KDPromptEditorAssistor.this.setShowing(false);
            KDPromptEditorAssistor.this.parentPromptBox.closeDownPanel();
            KDPromptEditorAssistor.this.parentPromptBox.setHasQuickQueryPanel(false);
        }
    }
}

