/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.myeas.client.AbstractAdminOrgSelectUI;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class AdminOrgSelectUI
extends AbstractAdminOrgSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(AdminOrgSelectUI.class);
    private String orgId = "";
    private String orgName = "";
    private boolean isOK = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.getSelectProIdArray();
        if (StringUtils.isEmpty((String)this.orgId) && !this.ifSelectOrg.isSelected()) {
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("please.select.org"));
            return;
        }
        this.isOK = true;
        this.disposeUIWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isOK = false;
        this.disposeUIWindow();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    private void bindDataToTable() throws BOSException, SQLException {
        try {
            FullOrgUnitCollection orgs = null;
            orgs = PermissionRangeHelper.getUserOrgCol(null, (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (OrgRangeType)OrgRangeType.ADMIN_ORG_TYPE);
            this.orgTable.removeRows();
            this.orgTable.checkParsed();
            if (orgs != null && orgs.size() > 0) {
                IFullOrgUnit orgUnit = FullOrgUnitFactory.getRemoteInstance();
                IRow row = null;
                FullOrgUnitInfo orgInfo = null;
                for (int i = 0; i < orgs.size(); ++i) {
                    orgInfo = orgs.get(i);
                    orgInfo = orgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgInfo.getId()));
                    row = this.orgTable.addRow();
                    row.getCell(0).setValue((Object)orgInfo.getId().toString());
                    row.getCell(1).setValue((Object)orgInfo.getNumber());
                    row.getCell(2).setValue((Object)orgInfo.getName());
                }
            }
            this.orgTable.getSelectManager().setSelectMode(2);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.orgId = "";
        this.orgName = "";
        this.isOK = false;
        this.orgTable.setEditable(false);
        this.bindDataToTable();
    }

    public void getSelectProIdArray() {
        int i;
        KDTSelectBlock sb = null;
        int size = this.orgTable.getSelectManager().size();
        if (size == 0) {
            return;
        }
        int arraySize = 0;
        for (i = 0; i < size; ++i) {
            sb = this.orgTable.getSelectManager().get(i);
            arraySize += sb.size();
        }
        if (arraySize == 0) {
            return;
        }
        for (i = 0; i < size; ++i) {
            sb = this.orgTable.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                this.orgId = this.orgTable.getRow(j).getCell("id").getValue().toString();
                this.orgName = this.orgTable.getRow(j).getCell("name").getValue().toString();
            }
        }
    }

    public String getOrgId() {
        return this.orgId;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public boolean isOK() {
        return this.isOK;
    }
}

