/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.myeas.client.AbstractBatchDelegateUI;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.myeas.client.JobDelegateMainSetUI;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.cp.eip.mc.IJobDelegate;
import com.kingdee.eas.cp.eip.mc.JobDelegateCollection;
import com.kingdee.eas.cp.eip.mc.JobDelegateFactory;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BatchDelegateUI
extends AbstractBatchDelegateUI {
    private static final Logger logger = CoreUIObject.getLogger(BatchDelegateUI.class);
    private String orgID = "";

    public BatchDelegateUI() throws Exception {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("Owner", (Object)this);
        ctx.put("All_Admins", "YES");
        PersonPromptBox pBox = new PersonPromptBox(ctx);
        pBox.showNoPositionPerson(false);
        this.F7User.setHasCUDefaultFilter(false);
        this.F7User.setSelector((KDPromptSelector)pBox);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void bindDataToTable() throws BOSException, SQLException {
        try {
            IJobDelegate delegate = JobDelegateFactory.getRemoteInstance();
            this.proListTable.removeRows();
            this.proListTable.checkParsed();
            String name = this.proNameText.getStringValue();
            IRowSet rowset = delegate.getProcess(this.orgID, name);
            if (rowset != null && rowset.size() > 0) {
                int rowCount = rowset.size();
                IRow row = null;
                int colCount = this.proListTable.getColumnCount();
                for (int i = 0; i < rowCount; ++i) {
                    rowset.next();
                    row = this.proListTable.addRow();
                    for (int j = 0; j < colCount; ++j) {
                        row.getCell(j).setValue((Object)rowset.getString(j + 1));
                    }
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        JobDelegateMainSetUI mainUi = (JobDelegateMainSetUI)this.getUIContext().get("Owner");
        this.orgID = mainUi.orgID;
        this.bindDataToTable();
        this.proListTable.setEditable(false);
        super.onLoad();
        this.F7User.setCommitFormat("$number$");
        this.F7User.setEditFormat("$number$");
        this.F7User.setDisplayFormat("$name$");
        this.F7User.setEditable(false);
    }

    public String[] getSelectProIdArray() {
        KDTSelectBlock sb = null;
        int size = this.proListTable.getSelectManager().size();
        if (size == 0) {
            return null;
        }
        int arraySize = 0;
        for (int i = 0; i < size; ++i) {
            sb = this.proListTable.getSelectManager().get(i);
            arraySize += sb.size();
        }
        if (arraySize == 0) {
            return null;
        }
        String[] array = new String[arraySize];
        int index = 0;
        for (int i = 0; i < size; ++i) {
            sb = this.proListTable.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                array[index++] = this.proListTable.getRow(j).getCell("FID").getValue().toString();
            }
        }
        return array;
    }

    @Override
    protected void btCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    @Override
    protected void btOk_actionPerformed(ActionEvent e) throws Exception {
        IJobDelegate delegate = JobDelegateFactory.getRemoteInstance();
        Timestamp beginTime = this.beginDate.getTimestamp();
        Timestamp endTime = this.endDate.getTimestamp();
        beginTime = Timestamp.valueOf(beginTime.toString().substring(0, 10) + " 00:00:00");
        endTime = Timestamp.valueOf(endTime.toString().substring(0, 10) + " 00:00:00");
        PersonInfo pInfo = (PersonInfo)this.F7User.getData();
        if (pInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("SelectToUser"));
            return;
        }
        IUser user = UserFactory.getRemoteInstance();
        UserCollection users = user.getUserCollection(" where person ='" + pInfo.getId().toString() + "'");
        if (users == null || users.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)InitUIForModel.getResource("no.user.match.this.persion"));
            return;
        }
        UserInfo userTo = users.get(0);
        String[] array = this.getSelectProIdArray();
        if (array == null || array.length < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("PlLEASECHOOSEITEM"));
            return;
        }
        if (this.checkDateAndUser(userTo, this.beginDate, this.endDate)) {
            delegate.batchDelegateSave(beginTime, endTime, userTo, array, this.orgID);
            ((JobDelegateMainSetUI)this.getUIContext().get("Owner")).initUIData();
            this.disposeUIWindow();
        }
    }

    @Override
    protected void kDWorkButton1_actionPerformed(ActionEvent e) throws Exception {
        this.bindDataToTable();
    }

    @Override
    protected void proNameText_keyPressed(KeyEvent e) throws Exception {
        if (e.getKeyCode() == 13) {
            this.bindDataToTable();
        }
    }

    private boolean checkDateAndUser(UserInfo toUser, KDDatePicker dateBegin, KDDatePicker dateEnd) {
        try {
            UserInfo userInfo = InitUIForModel.getUserInfo();
            if (userInfo.getPerson() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("can.not.deledate"));
                return false;
            }
            if (toUser == null) {
                MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("SelectToUser"));
                return false;
            }
            if (toUser != null && toUser.getId().toString().equals(userInfo.getId().toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("SameUser"));
                return false;
            }
            Timestamp beginDate = dateBegin.getTimestamp();
            Timestamp endDate = dateEnd.getTimestamp();
            beginDate = Timestamp.valueOf(beginDate.toString().substring(0, 10) + " 00:00:00");
            endDate = Timestamp.valueOf(endDate.toString().substring(0, 10) + " 00:00:00");
            if (dateBegin.getValue() == null || dateEnd.getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("EndDateBeginDate"));
                return false;
            }
            Date utilDate = new Date();
            Timestamp sqlDate = new Timestamp(utilDate.getTime());
            if (beginDate.compareTo(sqlDate = Timestamp.valueOf(sqlDate.toString().substring(0, 10) + " 00:00:00")) < 0 && !beginDate.toString().equals(sqlDate.toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("BeginDateThanNow"));
                return false;
            }
            if (beginDate.compareTo(endDate) > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("EndDateBeginDate"));
                return false;
            }
            String fromUserId = userInfo.getId().toString();
            String toUserId = toUser.getId().toString();
            if (userInfo.getPerson() == null || toUser.getPerson() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("UserToPerson"));
                return false;
            }
            if (userInfo.getPerson().getId().toString().equals(toUser.getPerson().getId().toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("PersonNotEqu"));
                return false;
            }
            if (!this.checkDelegate(fromUserId, toUserId, dateBegin, dateEnd)) {
                MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("CloseCycleDelegate"));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.handUIException(e);
            return false;
        }
    }

    private boolean checkDelegate(String sourceUserId, String toUserId, KDDatePicker dateBegin, KDDatePicker dateEnd) throws Exception {
        Date beginDate = (Date)this.beginDate.getValue();
        Date endDate = (Date)this.endDate.getValue();
        String closeUserId = "";
        DateFormat dateFormat = BOSLocaleUtil.getDateFormat();
        String strBeginDate = dateFormat.format(beginDate);
        String strEndDate = dateFormat.format(endDate);
        String oql = "select * where (((effectDate>='" + strBeginDate + "' and effectDate<='" + strEndDate + "') or (invalidDate > '" + strBeginDate + "' and invalidDate < '" + strEndDate + "'))  ) and creator = '" + toUserId + "' ";
        IJobDelegate delegate = JobDelegateFactory.getRemoteInstance();
        JobDelegateCollection myJobColl = delegate.getJobDelegateCollection(oql);
        int size = myJobColl.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                if (myJobColl.get(i).getConsignor() == null) continue;
                closeUserId = myJobColl.get(i).getConsignor().getId().toString();
                if (!closeUserId.equals(sourceUserId)) {
                    this.checkDelegate(sourceUserId, closeUserId, dateBegin, dateEnd);
                    continue;
                }
                if (myJobColl.get(i).getEffectDate().equals(myJobColl.get(i).getInvalidDate())) continue;
                return false;
            }
        }
        return true;
    }
}

