/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.myeas.DefaultOpenMenuCollection;
import com.kingdee.eas.base.myeas.DefaultOpenMenuFactory;
import com.kingdee.eas.base.myeas.DefaultOpenMenuInfo;
import com.kingdee.eas.base.myeas.IDefaultOpenMenu;
import com.kingdee.eas.base.myeas.IOpenModel;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.myeas.OpenModelFactory;
import com.kingdee.eas.base.myeas.OpenModelInfo;
import com.kingdee.eas.base.myeas.client.AbstractDefaultOpenUI;
import com.kingdee.eas.base.myeas.client.IMySettingUI;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.permission.MainMenuItemCollection;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.MenuVisitorHelper;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.base.uiframe.client.UIFrameContext;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class DefaultOpenUI
extends AbstractDefaultOpenUI
implements IMySettingUI {
    private UserInfo userInfo = null;
    private IDefaultOpenMenu iDefaultOpen = null;
    private OpenModelInfo usedOpenModelInfo = null;
    private IOpenModel iOpenModel = null;
    private DefaultOpenMenuCollection oldDefaultOpenColl = null;
    private HashMap openMenuMap = new HashMap();
    private boolean isModify = false;
    private JComponent component = null;

    public DefaultOpenUI() throws Exception {
        this.setBackground(new Color(228, 228, 223));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.iDefaultOpen = DefaultOpenMenuFactory.getRemoteInstance();
        this.userInfo = InitUIForModel.getUserInfo();
        this.txtTip.setEnabled(false);
        this.butAdd.setIcon(MyEasResource.getCommonIcon("imgTbtn_move_right"));
        this.butDel.setIcon(MyEasResource.getCommonIcon("imgTbtn_move_left"));
        this.initUiData();
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DefaultOpenUI.this.doubleClickTreeOpen(e);
            }
        };
        this.treeOpen.addMouseListener((MouseListener)ml);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void addMenu() throws Exception {
        DefaultKingdeeTreeNode menuNode = (DefaultKingdeeTreeNode)this.treeMenu.getLastSelectedPathComponent();
        if (menuNode == null || menuNode.getUserObject() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("PlsSelectMenu"));
            return;
        }
        if (!this.checkStyleAddmenu()) {
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("DefMenulMoreOpenMod"));
            return;
        }
        Object info = menuNode.getUserObject();
        MainMenuItemInfo selectMenuInfo = null;
        if (info instanceof MainMenuItemInfo) {
            selectMenuInfo = (MainMenuItemInfo)info;
            if (this.openMenuMap.get(selectMenuInfo.getId().toString()) != null) {
                return;
            }
            if (!selectMenuInfo.isIsLeaf()) {
                return;
            }
            DefaultKingdeeTreeNode top = (DefaultKingdeeTreeNode)this.treeOpen.getModel().getRoot();
            KingdeeTreeModel model = (KingdeeTreeModel)this.treeOpen.getModel();
            DefaultKingdeeTreeNode node11 = new DefaultKingdeeTreeNode();
            node11.setUserObject(menuNode.getUserObject());
            model.insertNodeInto((MutableTreeNode)node11, (MutableTreeNode)top, top.getChildCount());
            this.treeOpen.expandAllNodes(true, (TreeNode)top);
            this.openMenuMap.put(selectMenuInfo.getId().toString(), "a");
            this.enableComponent(true);
            this.setModified(true);
        }
        this.treeViewOpen.repaint();
        this.repaint();
    }

    private void delMenu() {
        DefaultKingdeeTreeNode menuNode = (DefaultKingdeeTreeNode)this.treeOpen.getLastSelectedPathComponent();
        if (menuNode == null || menuNode.getUserObject() == null) {
            return;
        }
        Object info = menuNode.getUserObject();
        MainMenuItemInfo selectMenuInfo = null;
        if (info instanceof MainMenuItemInfo) {
            selectMenuInfo = (MainMenuItemInfo)info;
            this.treeOpen.removeNodeFromParent((MutableTreeNode)menuNode);
            this.openMenuMap.remove(selectMenuInfo.getId().toString());
            this.enableComponent(true);
            this.setModified(true);
        }
    }

    @Override
    protected void butAdd_actionPerformed(ActionEvent e) throws Exception {
        super.butAdd_actionPerformed(e);
        this.addMenu();
    }

    @Override
    protected void butDel_actionPerformed(ActionEvent e) throws Exception {
        super.butDel_actionPerformed(e);
        this.delMenu();
    }

    private void initUiData() {
        try {
            this.initMenuTree();
            this.initOpenMenu();
            this.initOpenStyle();
        }
        catch (Exception es) {
            this.handUIException(es);
        }
    }

    private void initMenuTree() throws Exception {
        MenuVisitorHelper.buildMenuTree((KDTree)this.treeMenu);
        this.treeViewOpen.setShowButton(false);
        this.treeViewMenu.setShowButton(false);
        this.treeViewOpen.setTitle(InitUIForModel.getResource("DefaultOpenMenu"));
        this.treeViewMenu.setTitle(InitUIForModel.getResource("menu"));
    }

    private void initOpenMenu() throws Exception {
        DefaultOpenMenuInfo defaultMenuInfo = null;
        MainMenuItemInfo mainMenuInfo = null;
        DefaultKingdeeTreeNode top = new DefaultKingdeeTreeNode((Object)"");
        DefaultKingdeeTreeNode child = null;
        this.getUserOpenMenu();
        if (this.oldDefaultOpenColl.size() > 0) {
            for (int i = 0; i < this.oldDefaultOpenColl.size(); ++i) {
                defaultMenuInfo = this.oldDefaultOpenColl.get(i);
                mainMenuInfo = defaultMenuInfo.getMainMenu();
                child = new DefaultKingdeeTreeNode((Object)mainMenuInfo.getName());
                child.setUserObject((Object)mainMenuInfo);
                top.add((MutableTreeNode)child);
                this.openMenuMap.put(mainMenuInfo.getId().toString(), "a");
            }
        }
        this.treeOpen = new KDTree((ITreeNode)top);
        this.treeViewOpen.setTree(this.treeOpen);
        this.treeOpen.setShowCheckBox(false);
        this.treeOpen.expandAllNodes(true, (TreeNode)top);
        this.treeOpen.setRootVisible(false);
    }

    private void getUserOpenMenu() throws Exception {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("user", (Object)this.userInfo.getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("mainMenu.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("mainMenu.name"));
        this.oldDefaultOpenColl = this.iDefaultOpen.getDefaultOpenMenuCollection(viewInfo);
    }

    public void initOpenStyle() throws Exception {
        this.usedOpenModelInfo = (OpenModelInfo)UIFrameContext.getInstance().getProperty((Object)"OpenModel");
        if (this.usedOpenModelInfo == null) {
            if (this.iOpenModel == null) {
                this.iOpenModel = OpenModelFactory.getRemoteInstance();
            }
            this.usedOpenModelInfo = this.iOpenModel.getUsedOpenStyle(this.userInfo.getId().toString());
            if (this.usedOpenModelInfo == null) {
                return;
            }
        }
        if (this.usedOpenModelInfo.isIsOpenInFour()) {
            this.txtTip.setText(InitUIForModel.getResource("OpenInFoueTab"));
        } else if (this.usedOpenModelInfo.isIsOpenInNewTab()) {
            String openTabNum = "";
            if (this.usedOpenModelInfo.isIsLimitOpenTab()) {
                openTabNum = InitUIForModel.getResource("OpenTabNum") + this.usedOpenModelInfo.getOpenTabNum();
            }
            this.txtTip.setText(InitUIForModel.getResource("OpenInNewTab") + "\uff1b" + openTabNum);
        } else if (this.usedOpenModelInfo.isIsOpenInWindow()) {
            this.txtTip.setText(InitUIForModel.getResource("OpenInWindow"));
        }
    }

    private boolean checkStyleAddmenu() throws Exception {
        boolean isOK = true;
        if (this.usedOpenModelInfo == null) {
            this.usedOpenModelInfo = (OpenModelInfo)UIFrameContext.getInstance().getProperty((Object)"OpenModel");
            if (this.usedOpenModelInfo == null) {
                if (this.iOpenModel == null) {
                    this.iOpenModel = OpenModelFactory.getRemoteInstance();
                }
                this.usedOpenModelInfo = this.iOpenModel.getUsedOpenStyle(this.userInfo.getId().toString());
                if (this.usedOpenModelInfo == null) {
                    return true;
                }
            }
        }
        DefaultKingdeeTreeNode top = (DefaultKingdeeTreeNode)this.treeOpen.getModel().getRoot();
        int childCount = top.getChildCount();
        int openTabNum = 0;
        isOK = this.usedOpenModelInfo.isIsLimitOpenTab() ? (openTabNum = this.usedOpenModelInfo.getOpenTabNum()) > childCount : true;
        return isOK;
    }

    @Override
    public void saveData() throws Exception {
        DefaultKingdeeTreeNode top = (DefaultKingdeeTreeNode)this.treeOpen.getModel().getRoot();
        DefaultKingdeeTreeNode child = null;
        MainMenuItemCollection selectMenuColl = new MainMenuItemCollection();
        MainMenuItemInfo selectMenuInfo = null;
        DefaultOpenMenuInfo oldOpenInfo = null;
        DefaultOpenMenuCollection defaultOpenColl = new DefaultOpenMenuCollection();
        ObjectUuidPK pk = null;
        for (int i = 0; i < top.getChildCount(); ++i) {
            child = (DefaultKingdeeTreeNode)top.getChildAt(i);
            selectMenuInfo = (MainMenuItemInfo)child.getUserObject();
            selectMenuColl.add(selectMenuInfo);
            oldOpenInfo = new DefaultOpenMenuInfo();
            oldOpenInfo.setMainMenu(selectMenuInfo);
            defaultOpenColl.add(oldOpenInfo);
        }
        this.iDefaultOpen.betchDelete(this.userInfo.getId().toString());
        pk = new ObjectUuidPK(this.userInfo.getId());
        this.iDefaultOpen.batchAddNew((IObjectPK)pk, selectMenuColl);
        UIFrameContext.getInstance().setProperty((Object)"DefOpenMenu", (Object)defaultOpenColl);
        if (UIConfig.isLocalStorePersonalizedSetting()) {
            UIFrameContext.witeCacheData();
        }
        MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("LayModelSaveTip"));
        this.enableComponent(false);
        this.setModified(false);
    }

    @Override
    protected void treeMenu_mouseClicked(MouseEvent e) throws Exception {
        super.treeMenu_mouseClicked(e);
        if (e.getClickCount() == 2) {
            if (e.getButton() == 1) {
                this.addMenu();
            }
        }
    }

    private void doubleClickTreeOpen(MouseEvent e) {
        if (e.getClickCount() == 2) {
            if (e.getButton() == 1) {
                this.delMenu();
            }
        }
    }

    @Override
    public boolean isModified() {
        return this.isModify;
    }

    @Override
    public void setControlComponent(JComponent component) {
        this.component = component;
    }

    @Override
    public void setModified(boolean bFlag) {
        this.isModify = bFlag;
    }

    @Override
    public void enableComponent(boolean bFlag) {
        if (this.component != null) {
            this.component.setEnabled(bFlag);
        }
    }
}

