/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.myeas.ILayoutModel;
import com.kingdee.eas.base.myeas.LayoutModelCollection;
import com.kingdee.eas.base.myeas.LayoutModelFactory;
import com.kingdee.eas.base.myeas.LayoutModelInfo;
import com.kingdee.eas.base.myeas.client.AbstractInputLayModelNameUI;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class InputLayModelNameUI
extends AbstractInputLayModelNameUI {
    private UserInfo userInfo = null;
    private boolean isOK = false;
    private ILayoutModel iModel = null;
    private String operaAction = "";
    private LayoutModelInfo editModelInfo = null;

    public InputLayModelNameUI() throws Exception {
        InitUIForModel initMainUI = new InitUIForModel();
        this.userInfo = initMainUI.getUserInfo();
        this.setUITitle(InitUIForModel.getResource("InfoInputUITitle"));
        this.iModel = LayoutModelFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.operaAction = this.getOprtState();
        if (this.operaAction.equals(OprtState.EDIT)) {
            this.editModelInfo = (LayoutModelInfo)this.getDataObject("model");
            this.initCtrlData();
        }
    }

    private void initCtrlData() {
        if (this.editModelInfo.getName() != null) {
            this.txtName.setText(this.editModelInfo.getName().toString());
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        if (this.txtName.getText().trim().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("NameNotEmpty"));
            this.txtName.requestFocus(true);
            return;
        }
        if (this.txtName.getText().trim().length() > 80) {
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("DataTooLong"));
            this.txtName.requestFocus(true);
            return;
        }
        if (!this.operaAction.equals(OprtState.EDIT) && !this.checkName()) {
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("NameExist"));
            this.txtName.requestFocus(true);
            return;
        }
        this.isOK = true;
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
        this.isOK = false;
    }

    private boolean checkName() throws BOSException {
        boolean isData = true;
        LayoutModelCollection modelColl = null;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("user", (Object)this.userInfo.getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        FilterItemInfo filter2 = new FilterItemInfo("name", (Object)this.txtName.getText().trim(), CompareType.EQUALS);
        filter.getFilterItems().add(filter2);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        modelColl = this.iModel.getLayoutModelCollection(viewInfo);
        if (modelColl.size() > 0) {
            isData = false;
        }
        return isData;
    }

    public String setName() {
        return this.txtName.getText().trim();
    }

    public boolean isIsOK() {
        return this.isOK;
    }
}

