/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client;

import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextAreaCtrl;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.myeas.ILayoutModel;
import com.kingdee.eas.base.myeas.IMyLayoutModel;
import com.kingdee.eas.base.myeas.LayoutModelCollection;
import com.kingdee.eas.base.myeas.LayoutModelFactory;
import com.kingdee.eas.base.myeas.LayoutModelInfo;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.myeas.MyLayoutModelCollection;
import com.kingdee.eas.base.myeas.MyLayoutModelFactory;
import com.kingdee.eas.base.myeas.MyLayoutModelInfo;
import com.kingdee.eas.base.myeas.client.AbstractLayOutModelSelectUI;
import com.kingdee.eas.base.myeas.client.IMySettingUI;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.myeas.client.LayOutModelEditUI;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.CompoundBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LayOutModelSelectUI
extends AbstractLayOutModelSelectUI
implements IMySettingUI {
    private KDPanel mainPanel = new KDPanel();
    private KDContainer container = new KDContainer();
    private KDTreeView treeView = new KDTreeView();
    private KDPanel rightPanel = new KDPanel();
    private KDPanel contentPanel = new KDPanel();
    private KDPanel reaCommentPanel = new KDPanel();
    private KDPanel commentPanel = new KDPanel();
    private KDPanel blankPanel = new KDPanel();
    private KDPanel blankTxtPanel = new KDPanel();
    private KDTextAreaCtrl txtComment = new KDTextAreaCtrl();
    private KDLabel lalComment = new KDLabel();
    private KDPanel tempPanel = new KDPanel();
    private KDTree wdTree = new KDTree();
    private KDWorkButton butAdd = null;
    private KDWorkButton butEdit = null;
    private KDWorkButton butDel = null;
    private ILayoutModel iModel = LayoutModelFactory.getRemoteInstance();
    private UserInfo userInfo = null;
    private LayoutModelInfo oldUsedModelInfo = null;
    private LayoutModelInfo selectModelInfo = null;
    private DefaultKingdeeTreeNode selectNode = null;
    private IMyLayoutModel iMyModel = null;
    private int doNum = 0;
    private boolean isModify = false;
    private JComponent component = null;
    private LayoutModelCollection systemModelColl = null;

    public LayOutModelSelectUI() throws Exception {
        this.setBorder(InitUIForModel.MYSETTING_BORDER);
        this.setBackground(new Color(228, 228, 223));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setName("SelectUI");
        this.tempPanel.setName("Select UI tempPanel");
        this.userInfo = InitUIForModel.getUserInfo();
        this.initUI();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.responseTreeEvent(this.selectNode);
    }

    public void doLayout() {
        super.doLayout();
        this.responseTreeEvent(this.selectNode);
    }

    private void initUI() {
        try {
            this.initTreeView(true);
        }
        catch (Exception es) {
            this.handUIException(es);
        }
        this.initContainer();
        this.mainPanel.setLayout((LayoutManager)new BorderLayout());
        this.rightPanel.setLayout((LayoutManager)new BorderLayout());
        this.contentPanel.setLayout((LayoutManager)new BorderLayout());
        this.commentPanel.setLayout((LayoutManager)new BorderLayout());
        this.reaCommentPanel.setLayout((LayoutManager)new BorderLayout());
        this.tempPanel.setLayout((LayoutManager)new BorderLayout());
        this.mainPanel.setBackground(InitUIForModel.MYSETTING_COLOR);
        this.contentPanel.setBackground(InitUIForModel.MYSETTING_COLOR);
        this.rightPanel.setBackground(InitUIForModel.MYSETTING_COLOR);
        this.commentPanel.setBackground(InitUIForModel.MYSETTING_COLOR);
        this.reaCommentPanel.setBackground(InitUIForModel.MYSETTING_COLOR);
        this.blankPanel.setBackground(InitUIForModel.MYSETTING_COLOR);
        this.blankTxtPanel.setBackground(InitUIForModel.MYSETTING_COLOR);
        this.wdTree.setRowHeight(20);
        this.mainPanel.add((Component)this.container, (Object)"Center");
        this.tempPanel.add((Component)this.treeView, (Object)"West");
        this.tempPanel.add((Component)this.rightPanel, (Object)"Center");
        this.container.getContentPane().setLayout((LayoutManager)new KDLayout());
        this.container.setPreferredSize(new Dimension(500, 500));
        this.container.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 100, 100));
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(8, 8, 84, 84);
        cons.anchor = 15;
        this.tempPanel.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        this.container.getContentPane().add((Component)this.tempPanel, null);
        this.treeView.setSize(new Dimension(200, 600));
        this.treeView.setPreferredSize(new Dimension(200, 600));
        this.treeView.setMaximumSize(new Dimension(200, 600));
        CompoundBorder panelBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(InitUIForModel.getResource("CommentPanelTitle")), BorderFactory.createEmptyBorder(0, 0, 3, 3));
        this.rightPanel.add((Component)this.contentPanel, (Object)"Center");
        this.commentPanel.setPreferredSize(new Dimension(300, 100));
        this.rightPanel.add((Component)this.reaCommentPanel, (Object)"South");
        this.rightPanel.add((Component)this.blankPanel, (Object)"West");
        this.reaCommentPanel.add((Component)this.commentPanel, (Object)"Center");
        this.reaCommentPanel.add((Component)this.blankTxtPanel, (Object)"West");
        this.commentPanel.add((Component)this.txtComment, (Object)"Center");
        this.txtComment.setEnabled(false);
        this.txtComment.setBackground(this.commentPanel.getBackground());
        this.lalComment.setText(EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"27_LayOutModelSelectUI"));
        this.commentPanel.add((Component)this.lalComment, (Object)"North");
        this.mainPanel.setPreferredSize(new Dimension(600, 600));
        this.mainPanel.setMinimumSize(new Dimension(600, 600));
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
    }

    private void initContainer() {
        this.container.setEnableActive(false);
        this.container.setTitle(InitUIForModel.getResource("LayOutModelSelectName"));
    }

    private void butEditAction(String operEdit) {
        try {
            String factoryName = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
            IUIFactory uiFactory = UIFactory.createUIFactory((String)factoryName);
            HashMap<String, LayOutModelSelectUI> mapContext = new HashMap<String, LayOutModelSelectUI>();
            HashMap<String, LayoutModelInfo> mapData = new HashMap<String, LayoutModelInfo>();
            mapContext.put("Owner", this);
            if (operEdit.equals(OprtState.EDIT)) {
                if (this.selectModelInfo == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("SelectModel"));
                    return;
                }
                mapData.put("model", this.selectModelInfo);
            }
            IUIWindow window = uiFactory.create(LayOutModelEditUI.class.getName(), mapContext, mapData, operEdit);
            window.show();
            this.initTreeView(false);
        }
        catch (Exception es) {
            this.handUIException(es);
        }
    }

    private void butDelAction() {
        try {
            int s;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.wdTree.getLastSelectedPathComponent();
            if (node == null) {
                if (this.selectNode == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("SelectModel"));
                    return;
                }
                node = this.selectNode;
            }
            if ((s = MsgBox.showConfirm2((Component)((Object)this), (String)InitUIForModel.getResource("ConfirmDelLayModel"))) == 1 || s == 2) {
                return;
            }
            Object info = node.getUserObject();
            if (info instanceof LayoutModelInfo) {
                LayoutModelInfo delModelInfo = (LayoutModelInfo)info;
                if (delModelInfo.isIsSystem()) {
                    MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("DeleteSystem"));
                    return;
                }
                if (delModelInfo.getId().toString().equals(this.oldUsedModelInfo.getId().toString())) {
                    MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("DeleteUsedLayModel"));
                    return;
                }
                ObjectUuidPK pk = new ObjectUuidPK(delModelInfo.getId());
                this.iModel.delete((IObjectPK)pk);
                this.wdTree.removeNodeFromParent((MutableTreeNode)node);
            }
        }
        catch (Exception es) {
            this.handUIException(es);
        }
    }

    private void butRefreshAction() {
        try {
            this.initTreeView(false);
        }
        catch (Exception es) {
            this.handUIException(es);
        }
    }

    private DefaultKingdeeTreeNode addModelToTree(LayoutModelCollection aModelColl, DefaultKingdeeTreeNode top) {
        DefaultKingdeeTreeNode newTop = top;
        DefaultKingdeeTreeNode childNode = null;
        LayoutModelInfo modelInfo = null;
        int size = aModelColl.size();
        for (int i = 0; i < size; ++i) {
            modelInfo = aModelColl.get(i);
            if (modelInfo.getId().equals((Object)this.oldUsedModelInfo.getId())) {
                this.selectNode = childNode = new DefaultKingdeeTreeNode((Object)(modelInfo.getName().toString() + EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"28_LayOutModelSelectUI")));
            } else {
                childNode = new DefaultKingdeeTreeNode((Object)modelInfo);
            }
            childNode.setUserObject((Object)modelInfo);
            childNode.setCustomIcon(MyEasResource.getCommonIcon("imgTree_layoutproject"));
            newTop.add((MutableTreeNode)childNode);
        }
        return newTop;
    }

    private void initWDTree(boolean isRefresh) throws Exception {
        if (!isRefresh) {
            if (this.systemModelColl == null || this.systemModelColl.size() <= 0) {
                this.systemModelColl = this.iModel.getSystemModelList();
            }
        } else {
            this.systemModelColl = this.iModel.getSystemModelList();
        }
        if (this.oldUsedModelInfo == null) {
            MyLayoutModelInfo myModelInfo = this.getMyModelInfo();
            if (myModelInfo != null) {
                ObjectUuidPK pk = new ObjectUuidPK(myModelInfo.getModel().getId());
                this.oldUsedModelInfo = this.iModel.getLayoutModelInfo((IObjectPK)pk);
            } else {
                this.oldUsedModelInfo = this.iModel.getUsedLayoutModel(this.userInfo.getId().toString());
            }
        }
        LayoutModelCollection userModelColl = this.iModel.getUserModelList(this.userInfo.getId().toString());
        DefaultKingdeeTreeNode top = new DefaultKingdeeTreeNode((Object)"");
        top = this.addModelToTree(this.systemModelColl, top);
        top = this.addModelToTree(userModelColl, top);
        this.wdTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)top));
        this.wdTree.setShowCheckBox(false);
        this.wdTree.setRootVisible(false);
        if (this.selectNode != null) {
            this.wdTree.setSelectionNode(this.selectNode);
        }
        this.wdTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                LayOutModelSelectUI.this.treeMousePress(e);
            }
        });
    }

    private void treeMousePress(TreeSelectionEvent e) {
        TreePath selectPath = e.getNewLeadSelectionPath();
        if (e.getNewLeadSelectionPath() == null || selectPath.getLastPathComponent() == null) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)selectPath.getLastPathComponent();
        if (node == null) {
            return;
        }
        this.selectNode = node;
        this.responseTreeEvent(this.selectNode);
    }

    private void responseTreeEvent(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return;
        }
        this.setCursor(new Cursor(3));
        Object info = node.getUserObject();
        if (info instanceof LayoutModelInfo) {
            this.selectModelInfo = (LayoutModelInfo)info;
            if (this.selectModelInfo.isIsSystem()) {
                this.butEdit.setEnabled(false);
                this.butDel.setEnabled(false);
            } else {
                this.butEdit.setEnabled(true);
                this.butDel.setEnabled(true);
            }
            this.rightPanel.remove((Component)this.contentPanel);
            this.rightPanel.validate();
            if (this.selectModelInfo.getDescription() != null) {
                this.txtComment.setText(this.selectModelInfo.getDescription().toString());
            }
            KDPanel testPanel = new KDPanel();
            if (testPanel.getSize().height <= 0) {
                testPanel.setPreferredSize(new Dimension(400, 270));
            }
            try {
                this.rightPanel.add((Component)testPanel, (Object)"Center");
                this.rightPanel.validate();
                int width = this.getPreferredSize().width * 3 / 4;
                int height = this.getPreferredSize().height / 4;
                Dimension dimenPanel = new Dimension(width, height);
                Dimension parentDimen = new Dimension(testPanel.getPreferredSize().width, testPanel.getPreferredSize().height);
                CompoundBorder panelBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(InitUIForModel.getResource("LayModelPreView")), BorderFactory.createEmptyBorder(5, 5, 5, 5));
                InitUIForModel initUIModel = new InitUIForModel(panelBorder, false);
                initUIModel.setLayModel(this.selectModelInfo);
                initUIModel.initWDMap();
                initUIModel.setDimension(dimenPanel, parentDimen);
                this.contentPanel = initUIModel.returnPanel();
                this.contentPanel.setBackground(InitUIForModel.MYSETTING_COLOR);
                initUIModel = null;
            }
            catch (Exception es) {
                this.handUIException(es);
                this.setCursor(new Cursor(0));
            }
            this.rightPanel.remove((Component)testPanel);
            this.rightPanel.validate();
            this.rightPanel.add((Component)this.contentPanel, (Object)"Center");
            this.rightPanel.validate();
            this.setCursor(new Cursor(0));
        }
    }

    private void initTreeView(boolean isAddButton) throws Exception {
        if (this.treeView != null) {
            this.tempPanel.remove((Component)this.treeView);
        }
        if (isAddButton) {
            this.addButtonToTreeView();
        }
        this.initWDTree(false);
        this.treeView.setTree(this.wdTree);
        this.treeView.setTitle(InitUIForModel.getResource("LayModelList"));
        this.treeView.setShowButton(false);
        this.tempPanel.add((Component)this.treeView, (Object)"West");
    }

    private void addButtonToTreeView() {
        AbstractAction actNew = new AbstractAction("", MyEasResource.getCommonIcon("imgTbtn_new")){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayOutModelSelectUI.this.butEditAction(OprtState.ADDNEW);
            }
        };
        AbstractAction actEdit = new AbstractAction("", MyEasResource.getCommonIcon("imgTbtn_edit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayOutModelSelectUI.this.butEditAction(OprtState.EDIT);
            }
        };
        AbstractAction actDel = new AbstractAction("", MyEasResource.getCommonIcon("imgTbtn_delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayOutModelSelectUI.this.butDelAction();
            }
        };
        this.butAdd = new KDWorkButton(actNew){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 0);
            }
        };
        this.butEdit = new KDWorkButton(actEdit){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 0);
            }
        };
        this.butDel = new KDWorkButton(actDel){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 0);
            }
        };
        this.treeView.getControlPane().add((Component)this.butAdd);
        this.treeView.getControlPane().add((Component)this.butEdit);
        this.treeView.getControlPane().add((Component)this.butDel);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void saveData() {
        try {
            MyLayoutModelInfo myModelInfo;
            if (this.iMyModel == null) {
                this.iMyModel = MyLayoutModelFactory.getRemoteInstance();
            }
            if ((myModelInfo = this.getMyModelInfo()) == null) {
                myModelInfo = new MyLayoutModelInfo();
                myModelInfo.setUser(this.userInfo);
                myModelInfo.setModel(this.selectModelInfo);
                IObjectPK iObjectPK = this.iMyModel.addnew(myModelInfo);
            } else {
                myModelInfo.setUser(this.userInfo);
                myModelInfo.setModel(this.selectModelInfo);
                ObjectUuidPK pk = new ObjectUuidPK(myModelInfo.getId());
                this.iMyModel.update((IObjectPK)pk, myModelInfo);
            }
            this.oldUsedModelInfo = this.selectModelInfo;
            this.initWDTree(false);
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("LayModelSaveTip"));
        }
        catch (Exception es) {
            this.handUIException(es);
        }
    }

    private MyLayoutModelInfo getMyModelInfo() throws Exception {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("user", (Object)this.userInfo.getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        if (this.iMyModel == null) {
            this.iMyModel = MyLayoutModelFactory.getRemoteInstance();
        }
        MyLayoutModelInfo myModelInfo = null;
        MyLayoutModelCollection myModelColl = this.iMyModel.getMyLayoutModelCollection(viewInfo);
        if (myModelColl.size() > 0) {
            myModelInfo = myModelColl.get(0);
        }
        return myModelInfo;
    }

    @Override
    public boolean isModified() {
        return this.isModify;
    }

    @Override
    public void setControlComponent(JComponent component) {
        this.component = component;
    }

    @Override
    public void setModified(boolean bFlag) {
        this.isModify = bFlag;
    }

    @Override
    public void enableComponent(boolean bFlag) {
        if (this.component != null) {
            this.component.setEnabled(bFlag);
        }
    }
}

