/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.myeas.IMyNews;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.myeas.MyNewsFactory;
import com.kingdee.eas.base.myeas.MyNewsInfo;
import com.kingdee.eas.base.myeas.client.AbstractMyNewsEditUI;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JButton;

public class MyNewsEditUI
extends AbstractMyNewsEditUI {
    private String operate = "";
    private UserInfo userInfo = InitUIForModel.getUserInfo();
    private MyNewsInfo editNewsInfo = null;

    public MyNewsEditUI() throws Exception {
        this.setUITitle(InitUIForModel.getResource("newsEditUITitle"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.operate = this.getOprtState();
        this.editNewsInfo = (MyNewsInfo)this.getDataObject("news");
        this.initEditData();
    }

    public JButton getDefaultButton() {
        return this.butOK;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initEditData() {
        if (this.operate.equals(OprtState.VIEW) && this.editNewsInfo != null) {
            this.txtName.setText(this.editNewsInfo.getName());
            this.txtUrl.setText(this.editNewsInfo.getUrl());
            this.txtName.setEditable(false);
        }
    }

    private void editNews() throws Exception {
        if (this.editNewsInfo == null) {
            return;
        }
        this.editNewsInfo.setUrl(this.txtUrl.getText().trim());
        ObjectUuidPK pk = new ObjectUuidPK(this.editNewsInfo.getId());
        IMyNews iMyNews = MyNewsFactory.getRemoteInstance();
        iMyNews.update((IObjectPK)pk, this.editNewsInfo);
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        if (this.operate.equals(OprtState.VIEW)) {
            this.editNews();
            this.getUIWindow().close();
            return;
        }
        if (this.txtName.getText().trim().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("NameNotEmpty"));
            this.txtName.requestFocus(true);
            return;
        }
        if (this.txtUrl.getText().trim().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("ContNotEmpty"));
            this.txtUrl.requestFocus(true);
            return;
        }
        if (this.txtName.getText().trim().length() > 80) {
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("DataTooLong"));
            this.txtName.requestFocus(true);
            return;
        }
        if (this.txtUrl.getText().trim().length() > 500) {
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("DataTooLong"));
            this.txtUrl.requestFocus(true);
            return;
        }
        IMyNews iMyNews = MyNewsFactory.getRemoteInstance();
        MyNewsInfo myNewsInfo = new MyNewsInfo();
        myNewsInfo.setName(this.txtName.getText().trim());
        myNewsInfo.setUrl(this.txtUrl.getText().trim());
        myNewsInfo.setUser(this.userInfo);
        myNewsInfo.setId(BOSUuid.create((BOSObjectType)myNewsInfo.getBOSType()));
        iMyNews.addnew(myNewsInfo);
        MsgBox.showInfo((Component)((Object)this), (String)MyEasResource.getCommonString("saveSuccessed"));
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }
}

