/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;

public class MySettingDropPanel
extends KDPanel {
    private KDPanel topPanel = null;
    private KDPanel bottomPanel = null;
    private KDPanel centerPanel = null;
    private short buttonCount = 0;
    private Hashtable indexOidHash = null;
    private Hashtable indexButtonHash = null;
    private int topButtonCount = 0;
    private int currentSelected = -1;
    private static final String CardDes = "Center";

    public MySettingDropPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.createTopPanel();
        this.createCenterPanel();
        this.createBottomPanel();
        this.add((Component)this.getTopPanel(), "North");
        this.add((Component)this.getCenterPanel(), CardDes);
        this.add((Component)this.getBottomPanel(), "South");
    }

    public int getTopButtonCount() {
        return this.topButtonCount;
    }

    protected void setTopButtonCount(int topButtonCount) {
        this.topButtonCount = topButtonCount;
    }

    public int getBottomButtonCount() {
        return this.buttonCount - this.topButtonCount;
    }

    protected void createTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new KDPanel();
        }
    }

    public KDPanel getTopPanel() {
        return this.topPanel;
    }

    protected void createBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new KDPanel();
        }
    }

    public KDPanel getBottomPanel() {
        return this.bottomPanel;
    }

    protected void createCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new KDPanel();
            this.centerPanel.setLayout((LayoutManager)new CardLayout());
        }
    }

    public KDPanel getCenterPanel() {
        return this.centerPanel;
    }

    public void refresh() {
        int size = this.getTopButtonCount();
        if (size > 0) {
            this.getTopPanel().removeAll();
            this.getTopPanel().setLayout((LayoutManager)new GridLayout(size, 1, 1, 1));
            for (int i = 0; i < size; ++i) {
                this.getTopPanel().add((Component)((JButton)this.getIndexButtonHash().get(new Integer(i))));
            }
        }
        ((CardLayout)this.getCenterPanel().getLayout()).show((Container)this.getCenterPanel(), CardDes + String.valueOf(this.getCurrentSelected()));
        int bottomSize = this.getBottomButtonCount();
        if (bottomSize > 0) {
            this.getBottomPanel().removeAll();
            this.getBottomPanel().setLayout((LayoutManager)new GridLayout(bottomSize, 1, 1, 1));
            for (int j = size; j < size + bottomSize; ++j) {
                this.getBottomPanel().add((Component)((JButton)this.getIndexButtonHash().get(new Integer(j))));
            }
        }
        this.invalidate();
    }

    public void addDropComponent(String oid, String name, ActionListener action, KDPanel contentPanel) {
        this.createDropButton(oid, name, action, contentPanel);
    }

    protected JButton createDropButton(String oid, String name, ActionListener action, KDPanel contentPanel) {
        if (name == null) {
            name = "";
        }
        if (oid == null || oid.length() <= 0 || this.getOidIndexHash().containsKey(oid)) {
            throw new IllegalArgumentException("ID can not is null or ID repeating!");
        }
        DropButton tDropbu = new DropButton(oid, this.buttonCount);
        tDropbu.setBorder(KingdeeBorders.getToolBarBorder());
        tDropbu.putClientProperty("NeedChangeUI", new Boolean(false));
        tDropbu.setPreferredSize(new Dimension(20, 21));
        tDropbu.setText(name);
        tDropbu.setActionCommand(oid);
        tDropbu.addActionListener(new ButtonActionListener(action, oid, this.buttonCount));
        if (contentPanel == null) {
            contentPanel = new KDPanel((LayoutManager)new BorderLayout());
            contentPanel.add((Component)new JLabel("No Item!"), (Object)CardDes);
        }
        this.getCenterPanel().add((Component)contentPanel, (Object)(CardDes + String.valueOf(this.buttonCount)));
        Integer inte = new Integer(this.buttonCount);
        this.getOidIndexHash().put(oid, inte);
        this.getIndexButtonHash().put(inte, tDropbu);
        this.buttonCount = (short)(this.buttonCount + 1);
        this.setCurrentSelected(this.buttonCount - 1);
        this.topButtonCount = this.buttonCount;
        return tDropbu;
    }

    public JButton getDropButton(String oid) {
        if (oid == null) {
            return null;
        }
        return (JButton)this.getIndexButtonHash().get(this.getOidIndexHash().get(oid));
    }

    public void setExpandingIndex(int index) {
        if (index != this.getCurrentSelected()) {
            this.setCurrentSelected(index);
            this.setTopButtonCount(index + 1);
            this.refresh();
        }
    }

    public void setCurrentSelected(int selectedIndex) {
        this.currentSelected = selectedIndex;
    }

    public int getCurrentSelected() {
        return this.currentSelected;
    }

    private Hashtable getOidIndexHash() {
        if (this.indexOidHash == null) {
            this.indexOidHash = new Hashtable();
        }
        return this.indexOidHash;
    }

    private Hashtable getIndexButtonHash() {
        if (this.indexButtonHash == null) {
            this.indexButtonHash = new Hashtable();
        }
        return this.indexButtonHash;
    }

    protected boolean dropButtonAction(ActionEvent e, String oid, int index) {
        if (oid == null || index == -1 || index == this.getCurrentSelected()) {
            return false;
        }
        this.setCurrentSelected(index);
        this.setTopButtonCount(index + 1);
        this.refresh();
        return true;
    }

    class DropButton
    extends JButton {
        private String oid = null;
        private int index = 0;

        public DropButton(String tOid, int tIndex) {
            this.oid = tOid;
            this.index = tIndex;
        }

        public String getOid() {
            return this.oid;
        }

        public int getIndex() {
            return this.index;
        }
    }

    class ButtonActionListener
    implements ActionListener {
        ActionListener buAction = null;
        String oid = null;
        int index = -1;

        public ButtonActionListener(ActionListener action, String tOid, int tIndex) {
            this.buAction = action;
            this.oid = tOid;
            this.index = tIndex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MySettingDropPanel.this.dropButtonAction(e, this.oid, this.index) && this.buAction != null) {
                this.buAction.actionPerformed(e);
            }
        }
    }
}

