/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;

public class MySettingImageButtonUI
extends BasicButtonUI {
    protected static BasicButtonListener listener;
    private String str = null;
    private ImageIcon buttonIcon = null;
    private int maxStrCount = 100;

    public void setMaxStrCount(int count) {
        if (count > 0) {
            this.maxStrCount = count;
        }
    }

    @Override
    public void installUI(JComponent c) {
        AbstractButton button = (AbstractButton)c;
        Border border = button.getBorder();
        this.buttonIcon = (ImageIcon)button.getIcon();
        if (this.buttonIcon != null) {
            int iconW = this.buttonIcon.getIconWidth();
            int iconH = this.buttonIcon.getIconHeight();
            Image scaled = this.buttonIcon.getImage().getScaledInstance(iconW + iconW / 7, iconH + iconH / 7, 4);
            button.setRolloverIcon(new ImageIcon(scaled));
        }
        c.putClientProperty(" oldBorder", border);
        c.setBorder(null);
        this.str = button.getText();
        this.installListeners(button);
    }

    @Override
    public void uninstallUI(JComponent c) {
        Border border = (Border)c.getClientProperty(" oldBorder");
        c.putClientProperty(" oldBorder", null);
        c.setBorder(border);
        this.uninstallListeners((AbstractButton)c);
    }

    public boolean containse(JComponent c, int x, int y) {
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        Icon icon = this.getIcon(button, model);
        Rectangle iconBounds = new Rectangle(0, 0, icon.getIconWidth() + 1, icon.getIconHeight() + 1);
        return iconBounds.contains(x, y);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        Icon icon = this.getIcon(button, model);
        Insets insets = c.getInsets();
        this.drawButtonIcon(g, c, icon);
        Color oldColor = g.getColor();
        if (this.str != null && this.str.length() > 0) {
            this.drawString(g, this.str, insets, icon);
        }
    }

    private void drawButtonIcon(Graphics g, JComponent c, Icon icon) {
        int cw = c.getWidth();
        int iw = icon.getIconWidth();
        Insets insets = c.getInsets();
        icon.paintIcon(c, g, insets.left, insets.top);
    }

    private void drawString(Graphics g, String s, Insets insets, Icon icon) {
        FontMetrics fm = g.getFontMetrics();
        if (this.str != null && this.str.length() > this.maxStrCount) {
            int c = this.str.length() / this.maxStrCount + 1;
            g.drawString(this.str.substring(0, this.maxStrCount), insets.left, icon.getIconHeight() + insets.top + 4 + fm.getHeight());
            if (c > 2) {
                g.drawString(this.str.substring(this.maxStrCount, this.maxStrCount + this.maxStrCount), insets.left, icon.getIconHeight() + insets.top + 18 + fm.getHeight());
                g.drawString(this.str.substring(this.maxStrCount + this.maxStrCount), insets.left, icon.getIconHeight() + insets.top + 29 + fm.getHeight());
            } else {
                g.drawString(this.str.substring(this.maxStrCount), insets.left, icon.getIconHeight() + insets.top + 18 + fm.getHeight());
            }
        } else {
            g.drawString(this.str, icon.getIconWidth() + insets.left + 4, (icon.getIconHeight() + insets.top + fm.getHeight()) / 2);
        }
    }

    private Icon getIcon(AbstractButton b, ButtonModel m) {
        return m.isRollover() && !m.isPressed() ? b.getRolloverIcon() : b.getIcon();
    }
}

