/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.myeas.IMyFavorite;
import com.kingdee.eas.base.myeas.IMyUrlFolder;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.myeas.MyFavoriteCollection;
import com.kingdee.eas.base.myeas.MyFavoriteFactory;
import com.kingdee.eas.base.myeas.MyFavoriteInfo;
import com.kingdee.eas.base.myeas.MyUrlFolderCollection;
import com.kingdee.eas.base.myeas.MyUrlFolderFactory;
import com.kingdee.eas.base.myeas.MyUrlFolderInfo;
import com.kingdee.eas.base.myeas.client.AbstractMyUrlEditUI;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.DefaultComboBoxModel;

public class MyUrlEditUI
extends AbstractMyUrlEditUI {
    private IMyFavorite iMyFovor = MyFavoriteFactory.getRemoteInstance();
    private IMyUrlFolder iMyFolder = MyUrlFolderFactory.getRemoteInstance();
    private UserInfo userInfo = InitUIForModel.getUserInfo();
    private String userID = "";
    private String operate = "";
    private MyFavoriteInfo myEditFavInfo = null;

    public MyUrlEditUI() throws Exception {
        this.setUITitle(InitUIForModel.getResource("MyUrlEditUITitle"));
    }

    public void onLoad() {
        try {
            this.userInfo = InitUIForModel.getUserInfo();
            this.operate = this.getOprtState();
            if (this.operate.equals(OprtState.EDIT)) {
                this.myEditFavInfo = (MyFavoriteInfo)this.getDataObject("favorite");
                this.initUIData();
            }
        }
        catch (Exception es) {
            this.handUIException(es);
        }
    }

    private void initUIData() {
        if (this.myEditFavInfo == null) {
            return;
        }
        this.txtUrl.setText(this.myEditFavInfo.getUrl().toString());
        this.txtName.setText(this.myEditFavInfo.getName().toString());
    }

    private void initComboxFolder() throws BOSException {
        DefaultComboBoxModel<MyUrlFolderInfo> cboModelFolder = new DefaultComboBoxModel<MyUrlFolderInfo>();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("user", (Object)this.userInfo.getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        MyUrlFolderCollection myFolderColl = this.iMyFolder.getMyUrlFolderCollection(viewInfo);
        int selectIndex = 0;
        if (myFolderColl != null) {
            int size = myFolderColl.size();
            for (int i = 0; i < size; ++i) {
                cboModelFolder.addElement(myFolderColl.get(i));
                if (this.myEditFavInfo == null || !myFolderColl.get(i).equals(this.myEditFavInfo)) continue;
                selectIndex = i;
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        if (!this.checkName() || !this.checkData()) {
            return;
        }
        Object selectFolderInfo = null;
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            MyFavoriteInfo myFavorInfo = new MyFavoriteInfo();
            myFavorInfo.setUrl(this.txtUrl.getText().trim());
            myFavorInfo.setName(this.txtName.getText().trim());
            myFavorInfo.setUser(this.userInfo);
            BOSUuid favorID = BOSUuid.create((BOSObjectType)myFavorInfo.getBOSType());
            myFavorInfo.setId(favorID);
            this.iMyFovor.addnew((CoreBaseInfo)myFavorInfo);
        } else {
            this.myEditFavInfo.setUrl(this.txtUrl.getText().trim());
            this.myEditFavInfo.setName(this.txtName.getText().trim());
            this.myEditFavInfo.setUser(this.userInfo);
            ObjectUuidPK pk = new ObjectUuidPK(this.myEditFavInfo.getId());
            this.iMyFovor.update((IObjectPK)pk, (CoreBaseInfo)this.myEditFavInfo);
        }
        MsgBox.showInfo((Component)((Object)this), (String)MyEasResource.getCommonString("saveSuccessed"));
        this.getUIWindow().close();
    }

    private boolean checkData() throws BOSException {
        boolean isOk = true;
        String siteName = this.txtName.getText().trim();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterUser = new FilterItemInfo("user", (Object)this.userID, CompareType.EQUALS);
        filter.getFilterItems().add(filterUser);
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)siteName, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        MyFavoriteCollection myFavorColl = this.iMyFovor.getMyFavoriteCollection(viewInfo);
        if (myFavorColl != null && myFavorColl.size() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("NameExist"));
            isOk = false;
        }
        return isOk;
    }

    private boolean checkName() {
        boolean isOk = true;
        if (this.txtName.getText().trim().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("NameNotEmpty"));
            this.txtName.requestFocus(true);
            return false;
        }
        if (this.txtUrl.getText().trim().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("ContNotEmpty"));
            this.txtUrl.requestFocus(true);
            return false;
        }
        if (this.txtName.getText().trim().length() > 80) {
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("DataTooLong"));
            this.txtName.requestFocus(true);
            return false;
        }
        if (this.txtUrl.getText().trim().length() > 80) {
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("DataTooLong"));
            this.txtUrl.requestFocus(true);
            return false;
        }
        return isOk;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }
}

