/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDInfoTip;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.myeas.IMyEasInvokeEntry;
import com.kingdee.eas.base.myeas.MyEasInvokeEntryFactory;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.myeas.client.AbstractPasswordSetUI;
import com.kingdee.eas.base.myeas.client.IMySettingUI;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.permission.SecurityFactory;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.SecurityValidator;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;

public class PasswordSetUI
extends AbstractPasswordSetUI
implements IMySettingUI {
    private KDContainer container = null;
    private boolean isCanUpdatePassWord = true;
    private boolean isModify = false;
    private JComponent component = null;
    KeyListener keyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            PasswordSetUI.this.setModified(true);
            PasswordSetUI.this.enableComponent(true);
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    };
    KDInfoTip pdTip = null;

    public KDContainer getPaneWithContainer() {
        return this.getContainer();
    }

    public KDContainer getContainer() {
        if (this.container == null) {
            this.container = new KDContainer();
            this.container.getContentPane().setBorder(null);
            this.container.setBorder(InitUIForModel.MYSETTING_BORDER);
            this.initContainer();
        }
        return this.container;
    }

    private void isCanUpdatePass() throws Exception {
    }

    protected void initContainer() {
        this.container.setEnableActive(false);
        this.container.getContentPane().setLayout(new BorderLayout());
        this.container.getContentPane().add((Component)((Object)this));
        this.container.setTitle(this.getString("PasswordSetUI.title"));
    }

    private void initialize() {
        this.txtUser.setEnabled(false);
    }

    @Override
    public void saveData() throws EASBizException, BOSException, Exception {
        if (!this.isCanUpdatePassWord) {
            return;
        }
        if (!this.verifyInput()) {
            return;
        }
        IMyEasInvokeEntry iMyEasInvokeEntry = MyEasInvokeEntryFactory.getRemoteInstance();
        ObjectUuidPK iObjectPK = new ObjectUuidPK(this.getCurrUserInfo().getId());
        char[] oldPwd = this.pwdOld.getPassword();
        char[] newPwd = this.pwdNew.getPassword();
        String strOldPwd = new String(oldPwd);
        String strNewPwd = new String(newPwd);
        UserInfo userInfo = this.getCurrUserInfo();
        strOldPwd = CryptoTean.encrypt((String)userInfo.getNumber(), (String)strOldPwd);
        strNewPwd = CryptoTean.encrypt((String)userInfo.getNumber(), (String)strNewPwd);
        iMyEasInvokeEntry.updatePassword((IObjectPK)iObjectPK, strOldPwd, strNewPwd);
        this.setModified(false);
        this.enableComponent(false);
        MsgBox.showInfo((Component)((Object)this), (String)MyEasResource.getCommonString("saveSuccessed"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initialize();
        this.setBackground(InitUIForModel.MYSETTING_COLOR);
        this.pnlPwd.setBackground(InitUIForModel.MYSETTING_COLOR);
        UserInfo user = this.getCurrUserInfo();
        if (user != null) {
            this.txtUser.setText(user.getNumber());
        }
        this.isCanUpdatePass();
        if (!this.isCanUpdatePassWord) {
            this.pwdNew.setEnabled(false);
            this.pwdNewAgain.setEnabled(false);
            this.pwdOld.setEnabled(false);
        } else {
            this.pwdNew.setEnabled(true);
            this.pwdNewAgain.setEnabled(true);
            this.pwdOld.setEnabled(true);
        }
        this.pwdOld.addKeyListener(this.keyListener);
        this.pwdNew.addKeyListener(this.keyListener);
        this.pwdNewAgain.addKeyListener(this.keyListener);
    }

    protected UserInfo getCurrUserInfo() {
        return (UserInfo)SysContext.getSysContext().getCurrentUser();
    }

    protected boolean verifyInput() {
        char[] newPwd = this.pwdNew.getPassword();
        char[] newPwdAgain = this.pwdNewAgain.getPassword();
        String strNewPwd = new String(newPwd);
        String strNewPwdAgain = new String(newPwdAgain);
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]|[\ufe30-\uffa0]");
        Matcher m = p.matcher(strNewPwd);
        if (strNewPwd.indexOf("'") >= 0 || strNewPwd.indexOf("(") >= 0 || strNewPwd.indexOf("%27") >= 0 || m.find()) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("PasswordSetUI.containIllChar"));
            this.pwdNew.requestFocus();
            this.pwdNew.selectAll();
            return false;
        }
        if (!StringUtils.equals((String)strNewPwd, (String)strNewPwdAgain)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("PasswordSetUI.verifyPwd"));
            this.pwdNew.requestFocus();
            this.pwdNew.selectAll();
            return false;
        }
        return true;
    }

    private String getString(String strKey) {
        return MyEasResource.getString(strKey);
    }

    @Override
    public boolean isModified() {
        return this.isModify;
    }

    @Override
    public void setControlComponent(JComponent component) {
        this.component = component;
    }

    @Override
    public void setModified(boolean bFlag) {
        this.isModify = bFlag;
    }

    @Override
    public void enableComponent(boolean bFlag) {
        if (this.component != null) {
            this.component.setEnabled(bFlag);
        }
    }

    @Override
    protected void pwdNew_focusGained(FocusEvent e) throws Exception {
        if (this.pdTip != null) {
            this.pdTip.setShowing(true);
            return;
        }
        UserInfo userInfo = this.getCurrUserInfo();
        SecurityInfo security = SecurityFactory.getRemoteInstance().getSecurityInfo("where id='" + userInfo.getSecurity().getId().toString() + "'");
        userInfo.setSecurity(security);
        SecurityValidator securityValidator = new SecurityValidator(userInfo);
        String securityPolicy = securityValidator.getSecurityPolicy();
        if (!StringUtils.isEmpty((String)securityPolicy)) {
            this.pdTip = new KDInfoTip((JComponent)this.pwdNew, securityPolicy);
            this.pdTip.setMaxRenderWidth(250.0f);
            this.pdTip.setShowing(true);
        }
    }

    @Override
    protected void pwdNew_focusLost(FocusEvent e) throws Exception {
        if (this.pdTip != null) {
            this.pdTip.setShowing(false);
        }
    }
}

