/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.myeas.IMyEasInvokeEntry;
import com.kingdee.eas.base.myeas.MyEasInvokeEntryFactory;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.myeas.client.AbstractPersonalParSettingUI;
import com.kingdee.eas.base.myeas.client.IMySettingUI;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;

public class PersonalParSettingUI
extends AbstractPersonalParSettingUI
implements IMySettingUI {
    protected KDBizPromptBox kBlobalRoaming;
    protected KDTextField txtNCell;
    private KDContainer container = null;
    private UserInfo currUserInfo = null;
    private PersonInfo currPersonInfo = null;
    private boolean isModify = false;
    private JComponent component = null;
    KeyListener keyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
            PersonalParSettingUI.this.setModified(true);
            PersonalParSettingUI.this.enableComponent(true);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            PersonalParSettingUI.this.setModified(true);
            PersonalParSettingUI.this.enableComponent(true);
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    };

    public PersonalParSettingUI() throws Exception {
        this.txtMail.setMaxLength(50);
        this.txtBakMail.setMaxLength(50);
        this.txtOfficePhone.setMaxLength(50);
        this.txtHomePhone.setMaxLength(50);
        this.txtBakMobile.setMaxLength(50);
        String strFormat = "([0-9])+";
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kBlobalRoaming = new KDBizPromptBox();
        this.kBlobalRoaming.setName("kBlobalRoaming");
        this.txtNCell = new KDTextField();
        this.txtNCell.setName("txtNCell");
        this.txtNCell.setMaxLength(50);
        this.lblMobile.setBoundEditor((JComponent)this.kBlobalRoaming);
        this.lblMobile.setBounds(new Rectangle(10, 98, 200, 19));
        this.txtNCell.setBounds(new Rectangle(218, 98, 149, 19));
        this.add((Component)this.txtNCell, null);
        this.kBlobalRoaming.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7GlobalRoamingQuery");
        this.kBlobalRoaming.setCommitFormat("$areaCode$");
        this.kBlobalRoaming.setDisplayFormat("$areaCode$");
        this.kBlobalRoaming.setEditFormat("$areaCode$");
        this.kBlobalRoaming.setEditable(false);
    }

    private UserInfo getCurrUserInfo() {
        if (this.currUserInfo == null) {
            this.currUserInfo = (UserInfo)SysContext.getSysContext().getCurrentUser();
        }
        return this.currUserInfo;
    }

    private PersonInfo getCurrPersonInfo() {
        if (this.currPersonInfo == null) {
            try {
                if (this.getCurrUserInfo().getPersonId() != null) {
                    IMyEasInvokeEntry iMyEasInvokeEntry = MyEasInvokeEntryFactory.getRemoteInstance();
                    ObjectUuidPK iObjectPK = new ObjectUuidPK(this.getCurrUserInfo().getPersonId().getId());
                    this.currPersonInfo = iMyEasInvokeEntry.getCurrPerson((IObjectPK)iObjectPK);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return this.currPersonInfo;
    }

    private boolean verifyInput() {
        String mail = this.txtMail.getText();
        if (!this.checkMail(mail)) {
            this.txtMail.requestFocus();
            this.txtMail.selectAll();
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("PersonalParSettingUI.checkEMail"));
            return false;
        }
        String secondMail = this.txtBakMail.getText();
        if (!this.checkMail(secondMail)) {
            this.txtBakMail.requestFocus();
            this.txtBakMail.selectAll();
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("PersonalParSettingUI.checkEMail"));
            return false;
        }
        String mobileNum = this.txtNCell.getText();
        if (!this.checkMobile(mobileNum)) {
            this.txtNCell.requestFocus();
            this.txtNCell.selectAll();
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("PersonalParSettingUI.checkMobile"));
            return false;
        }
        String bakMobileNum = this.txtBakMobile.getText();
        if (!this.checkMobile(bakMobileNum)) {
            this.txtBakMobile.requestFocus();
            this.txtBakMobile.selectAll();
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("PersonalParSettingUI.checkMobile"));
            return false;
        }
        return true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setBackground(InitUIForModel.MYSETTING_COLOR);
        this.kDPanelMail.setBackground(InitUIForModel.MYSETTING_COLOR);
        if (this.getCurrPersonInfo() != null) {
            DataBaseInfo info;
            this.txtMail.setText(this.getCurrPersonInfo().getEmail());
            this.txtBakMail.setText(this.getCurrPersonInfo().getBackupEMail());
            this.txtHomePhone.setText(this.getCurrPersonInfo().getHomePhone());
            this.txtOfficePhone.setText(this.getCurrPersonInfo().getOfficePhone());
            this.txtNCell.setText(this.getCurrPersonInfo().getNCell());
            this.txtBakMobile.setText(this.getCurrPersonInfo().getBackupCell());
            if (!StringUtils.isEmpty((String)this.getCurrPersonInfo().getGlobalRoaming()) && (info = UserFactory.getRemoteInstance().getGlobalRoaming(this.getCurrPersonInfo().getGlobalRoaming())) != null) {
                this.kBlobalRoaming.setData((Object)info);
            }
        } else {
            this.txtMail.setEnabled(false);
            this.txtBakMail.setEnabled(false);
            this.txtHomePhone.setEnabled(false);
            this.txtOfficePhone.setEnabled(false);
            this.txtMobile.setEnabled(false);
            this.kBlobalRoaming.setEnabled(false);
            this.txtNCell.setEnabled(false);
            this.txtBakMobile.setEnabled(false);
        }
        this.txtMail.addKeyListener(this.keyListener);
        this.txtBakMail.addKeyListener(this.keyListener);
        this.txtHomePhone.addKeyListener(this.keyListener);
        this.txtHomePhone.addKeyListener(this.keyListener);
        this.txtOfficePhone.addKeyListener(this.keyListener);
        this.txtNCell.addKeyListener(this.keyListener);
        this.txtBakMobile.addKeyListener(this.keyListener);
    }

    private String getString(String strKey) {
        return MyEasResource.getString(strKey);
    }

    public KDContainer getContainer() {
        if (this.container == null) {
            this.container = new KDContainer();
            this.container.getContentPane().setBorder(null);
            this.initContainer();
        }
        return this.container;
    }

    protected void initContainer() {
        AbstractAction actSave = new AbstractAction(null, MyEasResource.getCommonIcon("imgTbtn_save")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PersonalParSettingUI.this.saveData();
                }
                catch (Exception es) {
                    PersonalParSettingUI.this.handUIException(es);
                }
            }
        };
        actSave.putValue("ShortDescription", InitUIForModel.getResource("ButSaveText"));
        this.container.add((Action)actSave);
        if (this.getCurrPersonInfo() == null) {
            actSave.setEnabled(false);
        }
        this.container.setEnableActive(false);
        this.container.getContentPane().setLayout(new BorderLayout());
        this.container.getContentPane().add((Component)((Object)this));
        this.container.setBorder(InitUIForModel.MYSETTING_BORDER);
        this.container.setTitle(this.getString("PersonalParSettingUI.title"));
    }

    public KDContainer getPaneWithContainer() {
        return this.getContainer();
    }

    @Override
    public void saveData() throws EASBizException, BOSException {
        if (!this.verifyInput()) {
            return;
        }
        this.getCurrPersonInfo().setHomePhone(this.txtHomePhone.getText());
        this.getCurrPersonInfo().setOfficePhone(this.txtOfficePhone.getText());
        String areaCode = this.getAreaCodeBySelect(this.kBlobalRoaming.getData());
        String cell = "";
        if (!StringUtils.isEmpty((String)areaCode) && !StringUtils.isEmpty((String)this.txtNCell.getText())) {
            this.getCurrPersonInfo().setGlobalRoaming(areaCode);
            this.getCurrPersonInfo().setNCell(this.txtNCell.getText());
            cell = areaCode + "-" + this.txtNCell.getText();
        }
        this.getCurrPersonInfo().setCell(cell);
        this.getCurrPersonInfo().setBackupCell(this.txtBakMobile.getText());
        this.getCurrPersonInfo().setEmail(this.txtMail.getText());
        this.getCurrPersonInfo().setBackupEMail(this.txtBakMail.getText());
        IMyEasInvokeEntry iMyEasInvokeEntry = MyEasInvokeEntryFactory.getRemoteInstance();
        ObjectUuidPK iObjectPK = new ObjectUuidPK(this.getCurrPersonInfo().getId());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("email"));
        selector.add(new SelectorItemInfo("backupEMail"));
        selector.add(new SelectorItemInfo("officePhone"));
        selector.add(new SelectorItemInfo("homePhone"));
        selector.add(new SelectorItemInfo("cell"));
        selector.add(new SelectorItemInfo("backupCell"));
        selector.add(new SelectorItemInfo("ncell"));
        selector.add(new SelectorItemInfo("globalRoaming"));
        iMyEasInvokeEntry.updatePersonalContact((IObjectPK)iObjectPK, this.getCurrPersonInfo(), selector);
        this.setModified(false);
        this.enableComponent(false);
        MsgBox.showInfo((Component)((Object)this), (String)MyEasResource.getCommonString("saveSuccessed"));
    }

    private boolean checkMail(String mail) {
        if (mail == null || mail.length() == 0) {
            return true;
        }
        char[] ones = mail.toCharArray();
        int signCount = 0;
        for (int i = 0; i < ones.length; ++i) {
            if (ones[i] == '@') {
                if (signCount != 0) break;
                ++signCount;
                continue;
            }
            if (ones[i] != '.' || signCount != 1) continue;
            ++signCount;
        }
        return signCount == 2;
    }

    private boolean checkMobile(String num) {
        if (num == null || num.length() == 0) {
            return true;
        }
        char[] ones = num.toCharArray();
        for (int i = 0; i < ones.length; ++i) {
            if (Character.isDigit(ones[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isModified() {
        return this.isModify;
    }

    @Override
    public void setControlComponent(JComponent component) {
        this.component = component;
    }

    @Override
    public void setModified(boolean bFlag) {
        this.isModify = bFlag;
    }

    @Override
    public void enableComponent(boolean bFlag) {
        if (this.component != null) {
            this.component.setEnabled(bFlag);
        }
    }

    private String getAreaCodeBySelect(Object obj) {
        obj = this.kBlobalRoaming.getData();
        String areaCode = "";
        if (obj != null && obj instanceof DataBaseInfo) {
            DataBaseInfo info = (DataBaseInfo)obj;
            areaCode = info.get("areaCode").toString();
        }
        return areaCode;
    }
}

