/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client;

import com.kingdee.bos.ctrl.extendcontrols.util.ParamHelper;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.myeas.F7MatchEnum;
import com.kingdee.eas.base.myeas.IPersonalParam;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.myeas.PersonalParamCollection;
import com.kingdee.eas.base.myeas.PersonalParamFactory;
import com.kingdee.eas.base.myeas.client.AbstractPersonalParamUI;
import com.kingdee.eas.base.myeas.client.IMySettingUI;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PersonalParamUI
extends AbstractPersonalParamUI
implements IMySettingUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonalParamUI.class);
    private KDContainer container = null;
    private boolean isModify = false;
    private JComponent component = null;
    private static final String f7MatchTypeName = "f7MatchType";
    private static final String F7_CAPITAL_SENSITIVE_QUERY_PARAM_NAME = "f7CapitalSensitiveQuery";
    private static final String F7_RETURN_ONLY_RECORD = "returnOlnyRecord";
    private static final String F7_HISTORY_RECORD_ENABLED = "historyRecordEnabled";
    private static final String F7_FULL_TEXT_INDEX_ENABLED = "fullTextIndexEnabled";
    private static final String F7_FUZZY_SEARCH_ENABLED = "f7fuzzySearchEnabled";
    private static final String F7_DYN_QUERY_ENABLED = "f7DynQuery";
    private F7MatchEnum matchType = null;
    private boolean isCapitalSensitiveQuery = false;
    private boolean isf7fuzzySearchEnabled = false;
    private boolean isReturnOnlyRecord = false;
    private boolean isHistoryRecordEnabled = false;
    private boolean isUseFullTextIndex = false;
    private boolean isDynQueryEnabled = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initMatchType();
        this.initCapitalSensitiveQuery();
        this.initReturnOnlyRecord();
        this.initHistoryRecordEnabled();
        this.initF7fuzzySearch();
        this.initIsUseFullTextIndex();
        this.initDynQueryEnabled();
        this.setModified(false);
        this.chkF7fuzzySearchEnabled.setEnabled(false);
        this.chkF7fuzzySearchEnabled.setVisible(false);
    }

    private void initMatchType() {
        this.comboF7MatchType.addItem((Object)F7MatchEnum.LEFTMATCH);
        this.comboF7MatchType.addItem((Object)F7MatchEnum.RIGHTMATCH);
        this.comboF7MatchType.addItem((Object)F7MatchEnum.ALLMATCH);
        String type = this.getUserMatchType();
        this.matchType = type != null && !type.equals("") ? F7MatchEnum.getEnum(type) : F7MatchEnum.ALLMATCH;
        this.comboF7MatchType.setSelectedItem((Object)this.matchType);
        this.comboF7MatchType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (arg0.getStateChange() == 1) {
                    PersonalParamUI.this.isModify = PersonalParamUI.this.checkModify();
                }
            }
        });
    }

    private void initCapitalSensitiveQuery() {
        String capitalSensitiveQuery = this.getPersonalParam(F7_CAPITAL_SENSITIVE_QUERY_PARAM_NAME);
        this.isCapitalSensitiveQuery = capitalSensitiveQuery != null && capitalSensitiveQuery.trim().equalsIgnoreCase("true");
        this.chkCapitalSensitiveQuery.setSelected(this.isCapitalSensitiveQuery);
    }

    private void initF7fuzzySearch() {
        String f7fuzzySearch = this.getPersonalParam(F7_FUZZY_SEARCH_ENABLED);
        this.isf7fuzzySearchEnabled = f7fuzzySearch != null && f7fuzzySearch.trim().equalsIgnoreCase("true");
        this.chkF7fuzzySearchEnabled.setSelected(this.isf7fuzzySearchEnabled);
    }

    private void initReturnOnlyRecord() {
        String returnOnlyRecord = this.getPersonalParam(F7_RETURN_ONLY_RECORD);
        this.isReturnOnlyRecord = returnOnlyRecord != null && returnOnlyRecord.trim().equalsIgnoreCase("true");
        this.chkReturnOnlyRecord.setSelected(this.isReturnOnlyRecord);
    }

    private void initHistoryRecordEnabled() {
        block5: {
            String historyRecordEnabled = this.getPersonalParam(F7_HISTORY_RECORD_ENABLED);
            if (StringUtils.isEmpty((String)historyRecordEnabled)) {
                Object ctx = null;
                String paramNumber = "F7_HISTORY_RECORD_ENABLED";
                IObjectPK orgUnitId = null;
                boolean setReference = true;
                try {
                    historyRecordEnabled = ParamManager.getParamValueIgnoreGroupControl(null, (String)paramNumber, orgUnitId, (boolean)setReference);
                    if (historyRecordEnabled != null && "true".equalsIgnoreCase(historyRecordEnabled.trim())) {
                        this.isHistoryRecordEnabled = true;
                        break block5;
                    }
                    this.isHistoryRecordEnabled = false;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    this.isHistoryRecordEnabled = true;
                }
            } else {
                this.isHistoryRecordEnabled = historyRecordEnabled != null && "true".equalsIgnoreCase(historyRecordEnabled.trim());
            }
        }
        this.chkHistoryRecordEnabled.setSelected(this.isHistoryRecordEnabled);
    }

    private void initDynQueryEnabled() {
        block5: {
            String dynQueryEnabled = this.getPersonalParam(F7_DYN_QUERY_ENABLED);
            if (StringUtils.isEmpty((String)dynQueryEnabled)) {
                Object ctx = null;
                String paramNumber = "F7_DYN_QUERY_ENABLED";
                IObjectPK orgUnitId = null;
                boolean setReference = true;
                try {
                    dynQueryEnabled = ParamManager.getParamValueIgnoreGroupControl(null, (String)paramNumber, orgUnitId, (boolean)setReference);
                    if (dynQueryEnabled != null && "true".equalsIgnoreCase(dynQueryEnabled.trim())) {
                        this.isHistoryRecordEnabled = true;
                        break block5;
                    }
                    this.isHistoryRecordEnabled = false;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    this.isHistoryRecordEnabled = true;
                }
            } else {
                this.isDynQueryEnabled = dynQueryEnabled != null && "true".equalsIgnoreCase(dynQueryEnabled.trim());
            }
        }
        this.chkDynQuery.setSelected(this.isDynQueryEnabled);
    }

    private String getUserMatchType() {
        try {
            IPersonalParam pp = PersonalParamFactory.getRemoteInstance();
            PersonalParamCollection coll = pp.getPersonalParamCollection("where user.id='" + SysContext.getSysContext().getCurrentUserInfo().getId().toString() + "' and paramName='f7MatchType'");
            if (coll != null && coll.size() > 0) {
                return coll.get(0) == null ? "" : coll.get(0).getParamValue();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return "";
    }

    private String getCapitalSensitiveQuery() {
        try {
            IPersonalParam pp = PersonalParamFactory.getRemoteInstance();
            PersonalParamCollection coll = pp.getPersonalParamCollection("where user.id='" + SysContext.getSysContext().getCurrentUserInfo().getId().toString() + "' paramName='" + F7_CAPITAL_SENSITIVE_QUERY_PARAM_NAME + "'");
            if (coll != null && coll.size() > 0) {
                return coll.get(0) == null ? "" : coll.get(0).getParamValue();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return "";
    }

    private String getPersonalParam(String paramName) {
        try {
            IPersonalParam pp = PersonalParamFactory.getRemoteInstance();
            PersonalParamCollection coll = pp.getPersonalParamCollection("where user.id='" + SysContext.getSysContext().getCurrentUserInfo().getId().toString() + "' and paramName='" + paramName + "'");
            if (coll != null && coll.size() > 0) {
                return coll.get(0) == null ? "" : coll.get(0).getParamValue();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return "";
    }

    public KDContainer getPaneWithContainer() {
        return this.getContainer();
    }

    public KDContainer getContainer() {
        if (this.container == null) {
            this.container = new KDContainer();
            this.container.getContentPane().setBorder(null);
            this.initContainer();
        }
        return this.container;
    }

    protected void initContainer() {
        this.container.setEnableActive(false);
        this.container.getContentPane().setLayout(new BorderLayout());
        this.container.getContentPane().add((Component)((Object)this));
        this.container.setBorder(InitUIForModel.MYSETTING_BORDER);
        this.container.setTitle(this.getString("personalParam"));
    }

    private String getString(String strKey) {
        return MyEasResource.getString(strKey);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void saveData() throws Exception {
        String paramValue = ((F7MatchEnum)((Object)this.comboF7MatchType.getSelectedItem())).getValue();
        IPersonalParam pp = PersonalParamFactory.getRemoteInstance();
        pp.updatePersonalParam(f7MatchTypeName, paramValue);
        ParamHelper.setUserMatchType((String)paramValue);
        this.matchType = (F7MatchEnum)((Object)this.comboF7MatchType.getSelectedItem());
        paramValue = this.chkCapitalSensitiveQuery.isSelected() ? "true" : "false";
        pp.updatePersonalParam(F7_CAPITAL_SENSITIVE_QUERY_PARAM_NAME, paramValue);
        ParamHelper.setCapitalSensitiveQuery((String)paramValue);
        this.isCapitalSensitiveQuery = this.chkCapitalSensitiveQuery.isSelected();
        paramValue = this.chkF7fuzzySearchEnabled.isSelected() ? "true" : "false";
        pp.updatePersonalParam(F7_FUZZY_SEARCH_ENABLED, paramValue);
        ParamHelper.setFuzzySearchEnabled((String)paramValue);
        this.isf7fuzzySearchEnabled = this.chkF7fuzzySearchEnabled.isSelected();
        paramValue = this.chkReturnOnlyRecord.isSelected() ? "true" : "false";
        pp.updatePersonalParam(F7_RETURN_ONLY_RECORD, paramValue);
        ParamHelper.setReturnOnlyRecord((String)paramValue);
        this.isReturnOnlyRecord = this.chkReturnOnlyRecord.isSelected();
        paramValue = this.chkHistoryRecordEnabled.isSelected() ? "true" : "false";
        pp.updatePersonalParam(F7_HISTORY_RECORD_ENABLED, paramValue);
        ParamHelper.setHistoryRecordEnabled((String)paramValue);
        this.isHistoryRecordEnabled = this.chkHistoryRecordEnabled.isSelected();
        paramValue = this.chkDynQuery.isSelected() ? "true" : "false";
        pp.updatePersonalParam(F7_DYN_QUERY_ENABLED, paramValue);
        ParamHelper.setDynQueryEnabled((String)paramValue);
        this.isDynQueryEnabled = this.chkDynQuery.isSelected();
        paramValue = this.chkFullTextIndex.isSelected() ? "true" : "false";
        pp.updatePersonalParam(F7_FULL_TEXT_INDEX_ENABLED, paramValue);
        ParamHelper.setFullTextIndexEnabled((String)paramValue);
        this.isUseFullTextIndex = this.chkFullTextIndex.isSelected();
        this.isModify = false;
        MsgBox.showInfo((Component)((Object)this), (String)MyEasResource.getCommonString("saveSuccessed"));
    }

    @Override
    public boolean isModified() {
        return this.isModify;
    }

    @Override
    public void setControlComponent(JComponent component) {
        this.component = component;
    }

    @Override
    public void setModified(boolean bFlag) {
        this.isModify = bFlag;
    }

    @Override
    public void enableComponent(boolean bFlag) {
        if (this.component != null) {
            this.component.setEnabled(bFlag);
        }
    }

    @Override
    protected void chkF7fuzzySearchEnabled_itemStateChanged(ItemEvent e) throws Exception {
        this.isModify = this.checkModify();
    }

    @Override
    protected void chkCapitalSensitiveQuery_itemStateChanged(ItemEvent e) throws Exception {
        this.isModify = this.checkModify();
    }

    @Override
    protected void chkReturnOnlyRecord_itemStateChanged(ItemEvent e) throws Exception {
        this.isModify = this.checkModify();
    }

    @Override
    protected void chkHistoryRecordEnabled_itemStateChanged(ItemEvent e) throws Exception {
        this.isModify = this.checkModify();
    }

    @Override
    protected void chkDynQuery_itemStateChanged(ItemEvent e) throws Exception {
        this.isModify = this.checkModify();
    }

    private boolean checkModify() {
        boolean modified = false;
        if (!this.comboF7MatchType.getSelectedItem().equals((Object)this.matchType)) {
            modified = true;
            return modified;
        }
        if (!this.chkCapitalSensitiveQuery.isSelected() && this.isCapitalSensitiveQuery || this.chkCapitalSensitiveQuery.isSelected() && !this.isCapitalSensitiveQuery) {
            modified = true;
            return modified;
        }
        if (!this.chkF7fuzzySearchEnabled.isSelected() && this.isf7fuzzySearchEnabled || this.chkF7fuzzySearchEnabled.isSelected() && !this.isf7fuzzySearchEnabled) {
            modified = true;
            return modified;
        }
        if (!this.chkReturnOnlyRecord.isSelected() && this.isReturnOnlyRecord || this.chkReturnOnlyRecord.isSelected() && !this.isReturnOnlyRecord) {
            modified = true;
            return modified;
        }
        if (!this.chkHistoryRecordEnabled.isSelected() && this.isHistoryRecordEnabled || this.chkHistoryRecordEnabled.isSelected() && !this.isHistoryRecordEnabled) {
            modified = true;
            return modified;
        }
        if (!this.chkFullTextIndex.isSelected() && this.isUseFullTextIndex || this.chkFullTextIndex.isSelected() && !this.isUseFullTextIndex) {
            modified = true;
            return modified;
        }
        if (!this.chkDynQuery.isSelected() && this.isDynQueryEnabled || this.chkDynQuery.isSelected() && !this.isDynQueryEnabled) {
            modified = true;
            return modified;
        }
        return modified;
    }

    @Override
    protected void isUseFullTextIndex_itemStateChanged(ItemEvent e) throws Exception {
        this.isModify = this.checkModify();
    }

    private void initIsUseFullTextIndex() {
        this.isUseFullTextIndex = Boolean.parseBoolean(this.getPersonalParam(F7_FULL_TEXT_INDEX_ENABLED));
        this.chkFullTextIndex.setSelected(this.isUseFullTextIndex);
    }
}

