/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.myeas.client.AbstractPortalParameterUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.portal.IPortalParamSetting;
import com.kingdee.eas.portal.PortalParamSettingCollection;
import com.kingdee.eas.portal.PortalParamSettingFactory;
import com.kingdee.eas.portal.PortalParamSettingInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class PortalParameterUI
extends AbstractPortalParameterUI {
    private static final Logger logger = CoreUIObject.getLogger(PortalParameterUI.class);
    private final String myEasResource = "com.kingdee.eas.base.myeas.MyEasResource";
    private File flashFile = null;
    private File logoFile = null;
    private AttachmentClientManager attachmentManager = new AttachmentClientManager();
    private PortalParamSettingInfo portalParamSettingInfo = null;

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            IPortalParamSetting portalFactory = PortalParamSettingFactory.getRemoteInstance();
            PortalParamSettingCollection collection = portalFactory.getPortalParamSettingCollection();
            if (collection != null && collection.size() > 0) {
                this.portalParamSettingInfo = (PortalParamSettingInfo)collection.getObject(0);
            }
            if (this.portalParamSettingInfo != null) {
                this.kdtfLogo.setText(this.portalParamSettingInfo.getLogoName());
                String imagePath = null;
                if (this.portalParamSettingInfo.getLogoAttachID() != null) {
                    imagePath = this.attachmentManager.downloadAttachment(this.portalParamSettingInfo.getLogoAttachID());
                }
                if (imagePath != null) {
                    this.lblLogoImage.setIcon((Icon)new ImageIcon(new URL("file:/" + imagePath)));
                }
                this.kdtfFlash.setText(this.portalParamSettingInfo.getFlashName());
                imagePath = null;
                if (this.portalParamSettingInfo.getFlashAttachID() != null) {
                    imagePath = this.attachmentManager.downloadAttachment(this.portalParamSettingInfo.getFlashAttachID());
                }
                if (imagePath != null) {
                    this.lblFlashImage.setIcon((Icon)new ImageIcon(new URL("file:/" + imagePath)));
                }
                this.txtGreeting.setText(this.portalParamSettingInfo.getWellCome());
                this.txtBrowserState.setText(this.portalParamSettingInfo.getIeStateInfo());
                this.txtBrowserTitle.setText(this.portalParamSettingInfo.getIeTitle());
                this.txtCompanyName.setText(this.portalParamSettingInfo.getCompanyName());
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionCancel.setEnabled(true);
        this.actionUpdate.setEnabled(true);
        this.actionLogo.setEnabled(true);
        this.actionFlash.setEnabled(true);
        this.kDContainer1.setEnableActive(false);
        this.loadFields();
    }

    @Override
    public void actionFlash_actionPerformed(ActionEvent e) throws Exception {
        super.actionFlash_actionPerformed(e);
        this.flashFile = this.attachmentManager.chooseFileByDialog((Component)((Object)this));
        if (this.flashFile != null) {
            this.kdtfFlash.setText(this.flashFile.getName());
            this.lblFlashImage.setIcon((Icon)new ImageIcon(this.flashFile.toURL()));
        }
    }

    @Override
    public void actionLogo_actionPerformed(ActionEvent e) throws Exception {
        super.actionLogo_actionPerformed(e);
        this.logoFile = this.attachmentManager.chooseFileByDialog((Component)((Object)this));
        if (this.logoFile != null) {
            this.kdtfLogo.setText(this.logoFile.getName());
            this.lblLogoImage.setIcon((Icon)new ImageIcon(this.logoFile.toURL()));
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionUpdate_actionPerformed(ActionEvent e) throws Exception {
        super.actionUpdate_actionPerformed(e);
        if (this.kdtfLogo.getText() == null || this.kdtfLogo.getText().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.myeas.MyEasResource", (String)"LOGONAME_NOT_NULL"));
            return;
        }
        if (this.kdtfFlash.getText() == null || this.kdtfFlash.getText().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.myeas.MyEasResource", (String)"FLASHNAME_NOT_NULL"));
            return;
        }
        if (this.txtGreeting.getText() == null || this.txtGreeting.getText().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.myeas.MyEasResource", (String)"WELLCOME_NOT_NULL"));
            return;
        }
        if (this.txtBrowserTitle.getText() == null || this.txtBrowserTitle.getText().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.myeas.MyEasResource", (String)"IETITLE_NOT_NULL"));
            return;
        }
        if (this.txtBrowserState.getText() == null || this.txtBrowserState.getText().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.myeas.MyEasResource", (String)"IESTATE_NOT_NULL"));
            return;
        }
        if (this.txtCompanyName.getText() == null || this.txtCompanyName.getText().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.myeas.MyEasResource", (String)"COMPANYNAME_NOT_NULL"));
            return;
        }
        String portalParamSettingID = null;
        String loID = null;
        String flID = null;
        String logoID = null;
        String flashID = null;
        portalParamSettingID = this.portalParamSettingInfo != null && this.portalParamSettingInfo.getId() != null ? this.portalParamSettingInfo.getId().toString() : BOSUuid.create((String)"288FEB39").toString();
        loID = BOSUuid.create((String)"288FEB39").toString();
        flID = BOSUuid.create((String)"288FEB39").toString();
        PortalParamSettingInfo portalInfo = new PortalParamSettingInfo();
        portalInfo.setId(BOSUuid.read((String)portalParamSettingID));
        portalInfo.setWellCome(this.txtGreeting.getText());
        portalInfo.setCompanyName(this.txtCompanyName.getText());
        portalInfo.setIeStateInfo(this.txtBrowserState.getText());
        portalInfo.setIeTitle(this.txtBrowserTitle.getText());
        IPortalParamSetting portalFactory = PortalParamSettingFactory.getRemoteInstance();
        portalFactory.submit((CoreBaseInfo)portalInfo);
        try {
            if (this.logoFile != null) {
                logoID = this.attachmentManager.addNewAttachment(loID, this.logoFile);
                if (this.portalParamSettingInfo != null && this.portalParamSettingInfo.getLogoID() != null) {
                    this.attachmentManager.deleteOneAssociation(this.portalParamSettingInfo.getLogoID(), this.portalParamSettingInfo.getLogoAttachID());
                }
            } else {
                logoID = this.portalParamSettingInfo.getLogoAttachID();
                loID = this.portalParamSettingInfo.getLogoID();
            }
            portalInfo.setLogoID(loID);
            portalInfo.setLogoName(this.kdtfLogo.getText());
            portalInfo.setLogoAttachID(logoID);
            portalFactory.submit((CoreBaseInfo)portalInfo);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return;
        }
        try {
            if (this.flashFile != null) {
                flashID = this.attachmentManager.addNewAttachment(logoID, this.flashFile);
                if (this.portalParamSettingInfo != null) {
                    this.attachmentManager.deleteOneAssociation(this.portalParamSettingInfo.getFlashID(), this.portalParamSettingInfo.getFlashAttachID());
                }
            } else {
                flashID = this.portalParamSettingInfo.getFlashAttachID();
                flID = this.portalParamSettingInfo.getFlashID();
            }
            portalInfo.setFlashID(flID);
            portalInfo.setFlashName(this.kdtfFlash.getText());
            portalInfo.setFlashAttachID(flashID);
            portalFactory.submit((CoreBaseInfo)portalInfo);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return;
        }
        IPortalParamSetting setting = PortalParamSettingFactory.getRemoteInstance();
        setting.refleshPortalParam();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.myeas.MyEasResource", (String)"PERSONALSETTING_SUCCESS"));
        this.actionExitCurrent_actionPerformed(e);
    }
}

