/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.myeas.IMyEasInvokeEntry;
import com.kingdee.eas.base.myeas.MyEasInvokeEntryFactory;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.myeas.client.AbstractRealTimeNumberSetUI;
import com.kingdee.eas.base.myeas.client.IMySettingUI;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.myeas.client.MyEasNumberDocument;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.text.Document;
import org.apache.log4j.Logger;

public class RealTimeNumberSetUI
extends AbstractRealTimeNumberSetUI
implements IMySettingUI {
    private static final Logger logger = Logger.getLogger(RealTimeNumberSetUI.class);
    private UserInfo currUserInfo = null;
    private PersonInfo currPersonInfo = null;
    private KDContainer container = null;
    private boolean isModify = false;
    private JComponent component = null;

    public RealTimeNumberSetUI() throws Exception {
        this.txtRTX.setMaxLength(50);
        String strFormat = "([0-9])+";
        this.txtRTX.setDocument((Document)new MyEasNumberDocument(strFormat));
    }

    private PersonInfo getCurrPersonInfo() {
        if (this.currPersonInfo == null) {
            try {
                if (this.getCurrUserInfo().getPerson() != null) {
                    IMyEasInvokeEntry iMyEasInvokeEntry = MyEasInvokeEntryFactory.getRemoteInstance();
                    ObjectUuidPK iObjectPK = new ObjectUuidPK(this.getCurrUserInfo().getPerson().getId());
                    this.currPersonInfo = iMyEasInvokeEntry.getCurrPerson((IObjectPK)iObjectPK);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.currPersonInfo;
    }

    private UserInfo getCurrUserInfo() {
        if (this.currUserInfo == null) {
            this.currUserInfo = (UserInfo)SysContext.getSysContext().getCurrentUser();
        }
        return this.currUserInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setBackground(InitUIForModel.MYSETTING_COLOR);
        this.kDPanel1.setBackground(InitUIForModel.MYSETTING_COLOR);
        PersonInfo personInfo = this.getCurrPersonInfo();
        if (personInfo != null) {
            this.txtRTX.setText(personInfo.getRtx());
        } else {
            this.txtRTX.setEnabled(false);
        }
        this.txtRTX.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                RealTimeNumberSetUI.this.setModified(true);
                RealTimeNumberSetUI.this.enableComponent(true);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                RealTimeNumberSetUI.this.setModified(true);
                RealTimeNumberSetUI.this.enableComponent(true);
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public KDContainer getContainer() {
        if (this.container == null) {
            this.container = new KDContainer();
            this.container.getContentPane().setBorder(null);
            this.initContainer();
        }
        return this.container;
    }

    protected void initContainer() {
        this.container.setEnableActive(false);
        this.container.getContentPane().setLayout(new BorderLayout());
        this.container.getContentPane().add((Component)((Object)this));
        this.container.setBorder(InitUIForModel.MYSETTING_BORDER);
        this.container.setTitle(this.getString("RealTimeNumberSetUI.title"));
    }

    private String getString(String strKey) {
        return MyEasResource.getString(strKey);
    }

    @Override
    public void saveData() throws EASBizException, BOSException {
        if (!this.verifyInput()) {
            return;
        }
        this.getCurrPersonInfo().setRtx(this.txtRTX.getText());
        IMyEasInvokeEntry iMyEasInvokeEntry = MyEasInvokeEntryFactory.getRemoteInstance();
        ObjectUuidPK iObjectPK = new ObjectUuidPK(this.getCurrPersonInfo().getId());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("rtx"));
        iMyEasInvokeEntry.updatePersonalPar((IObjectPK)iObjectPK, this.getCurrPersonInfo(), selector);
        this.setModified(true);
        this.enableComponent(true);
        MsgBox.showInfo((Component)((Object)this), (String)MyEasResource.getCommonString("saveSuccessed"));
        this.setModified(false);
    }

    public KDContainer getPaneWithContainer() {
        return this.getContainer();
    }

    private boolean verifyInput() {
        String rtx = this.txtRTX.getText();
        boolean isOK = true;
        if (rtx == null || rtx.length() == 0) {
            isOK = false;
        }
        return isOK;
    }

    @Override
    public boolean isModified() {
        return this.isModify;
    }

    @Override
    public void setControlComponent(JComponent component) {
        this.component = component;
    }

    @Override
    public void setModified(boolean bFlag) {
        this.isModify = bFlag;
    }

    @Override
    public void enableComponent(boolean bFlag) {
        if (this.component != null) {
            this.component.setEnabled(bFlag);
        }
    }
}

