/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client;

import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.model.KingdeeListModel;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.eas.base.myeas.ComMenuFunctionCollection;
import com.kingdee.eas.base.myeas.ComMenuFunctionFactory;
import com.kingdee.eas.base.myeas.MyEasInvokeEntryFactory;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.IMainFunctionMenu;
import com.kingdee.eas.base.uiframe.MainFunctionMenuFactory;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.BeautifulKDList;
import com.kingdee.eas.base.uiframe.client.MainMenuConstants;
import com.kingdee.eas.base.uiframe.client.MenuVisitorHelper;
import com.kingdee.eas.base.uiframe.client.MyComFunctionPanel;
import com.kingdee.eas.base.uiframe.client.NewMenuVisitorHelper;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class ShortCodeSearchUI
extends CoreUI {
    Logger logger = Logger.getLogger(ShortCodeSearchUI.class);
    private KDWorkButton btnSearch = null;
    private KDPanel panelSearch = null;
    private KDTextField textFieldCode = null;
    private KDList queryConditionList;
    private JPopupMenu popup;
    private KDScrollPane queryConditionScrollPane;
    private static final int PREFER_NUMBER = 8;
    private static final int TEXT_WIDTH = 250;
    private static final int SEARCH_PANEL_WIDTH = 280;
    private String inputShortKey = UIFrameResource.getString((String)"inputShortKey");
    public Color SEARCH_INIT_BACKGROUND = UIManager.getColor("eas.infopanel.content.bg");
    public static final Color SEARCH_INIT_FOREGROUND = new Color(0xB2B2B2);
    private boolean needChange = true;
    private static ImageIcon NO_COM = new ImageIcon(MainMenuConstants.GRAY_STAR_IMAGE);
    private static ImageIcon COM = new ImageIcon(MainMenuConstants.BLUE_STAR_IMAGE);

    public ShortCodeSearchUI() throws Exception {
        this.btnSearch = this.getBtnSearch();
        this.init();
    }

    private void init() {
        this.textFieldCode = this.getTextFieldCode();
        this.textFieldCode.setSelectAllOnFocus(false);
        this.queryConditionList = new BeautifulKDList();
        this.queryConditionScrollPane = new KDScrollPane((Component)this.queryConditionList, 20, 31);
        this.queryConditionList.addMouseListener((MouseListener)new ListMouseAdapter());
        this.queryConditionList.addKeyListener((KeyListener)new MenuSearchKeyAdapter());
        this.queryConditionList.setFixedCellWidth(244);
        this.popup = new JPopupMenu();
        this.popup.addKeyListener(new MenuSearchKeyAdapter());
        this.popup.add((Component)this.queryConditionScrollPane);
    }

    public void selectionChanged() {
        Object selectObj = this.queryConditionList.getSelectedValue();
        if (!(selectObj instanceof MenuSearchInfo)) {
            return;
        }
        MenuSearchInfo menuInfo = (MenuSearchInfo)selectObj;
        this.needChange = false;
        this.textFieldCode.setText(menuInfo.toString());
        this.needChange = true;
    }

    public KDPanel getPanelSearch() {
        if (this.panelSearch == null) {
            this.panelSearch = new KDPanel();
            this.panelSearch.setOpaque(true);
            this.panelSearch.setPreferredSize(new Dimension(280, 25));
            ((FlowLayout)this.panelSearch.getLayout()).setHgap(2);
            ((FlowLayout)this.panelSearch.getLayout()).setVgap(2);
            this.panelSearch.add((Component)this.getTextFieldCode());
            this.panelSearch.add((Component)this.getBtnSearch());
        }
        return this.panelSearch;
    }

    public KDTextField getTextFieldCode() {
        if (this.textFieldCode == null) {
            this.textFieldCode = new KDTextField();
            this.textFieldCode.setName("textFieldCode");
            this.textFieldCode.setToolTipText(InitUIForModel.getResource("input.shortcut"));
            this.textFieldCode.setPreferredSize(new Dimension(250, 21));
            Color highColor1 = UIManager.getColor("eas.searchbox.highlight1");
            Color highColor2 = UIManager.getColor("eas.searchbox.highlight2");
            Color shandowColor = new Color(128, 128, 128);
            this.textFieldCode.setBorder(BorderFactory.createBevelBorder(1, highColor1, highColor2, shandowColor, shandowColor));
            this.textFieldCode.setCustomBackgroundColor(this.SEARCH_INIT_BACKGROUND);
            this.textFieldCode.setCustomForegroundColor(SEARCH_INIT_FOREGROUND);
            this.textFieldCode.setOpaque(true);
            this.textFieldCode.addKeyListener((KeyListener)new MenuSearchKeyAdapter());
            this.textFieldCode.addMouseListener((MouseListener)new TextFieldMouseAdapter());
            this.textFieldCode.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    if (ShortCodeSearchUI.this.needChange && !ShortCodeSearchUI.this.textFieldCode.isComposedTextDocumentEvent(e)) {
                        ShortCodeSearchUI.this.showQuickQueryPanle();
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    if (ShortCodeSearchUI.this.needChange && !ShortCodeSearchUI.this.textFieldCode.isComposedTextDocumentEvent(e)) {
                        ShortCodeSearchUI.this.showQuickQueryPanle();
                    }
                }
            });
            CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.textFieldCode, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        }
        return this.textFieldCode;
    }

    public KDWorkButton getBtnSearch() {
        if (this.btnSearch == null) {
            this.btnSearch = new KDWorkButton();
            this.btnSearch.setPreferredSize(new Dimension(20, 19));
            this.btnSearch.setMinimumSize(new Dimension(20, 19));
            this.btnSearch.setBorder(BorderFactory.createEmptyBorder());
            this.btnSearch.setOpaque(false);
            this.btnSearch.setFactType(0);
            this.btnSearch.setContentAreaFilled(false);
            this.btnSearch.setIcon(UIManager.getIcon("eas.searchbox.icon1"));
            this.btnSearch.setRolloverEnabled(true);
            this.btnSearch.setRolloverIcon(UIManager.getIcon("eas.searchbox.icon2"));
            this.btnSearch.setPressedIcon(UIManager.getIcon("eas.searchbox.icon3"));
            this.btnSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ShortCodeSearchUI.this.performSearch();
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Component)((Component)e.getSource()), (Throwable)e1);
                    }
                }
            });
        }
        return this.btnSearch;
    }

    protected void performSearch() throws Exception {
        Object selectedObj = this.queryConditionList.getSelectedValue();
        try {
            if (selectedObj == null || !(selectedObj instanceof MenuSearchInfo)) {
                return;
            }
            this.getBtnSearch().setEnabled(false);
            MainMenuItemInfo menuItem = ((MenuSearchInfo)selectedObj).getMainMenuItemInfo();
            MenuVisitorHelper.showUIbyMenu((Component)this.textFieldCode, (MainMenuItemInfo)menuItem);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            ExceptionHandler.handle((Throwable)e);
        }
        finally {
            this.getBtnSearch().setEnabled(true);
        }
    }

    private void showQuickQueryPanle() {
        String searchText = this.textFieldCode.getText();
        if (StringUtils.isEmpty((String)searchText) || this.inputShortKey.equals(searchText)) {
            this.queryConditionList.removeAll();
            if (this.popup != null) {
                this.popup.setVisible(false);
            }
            return;
        }
        this.fillQueryPanel();
        Point p = new Point(0, this.textFieldCode.getHeight());
        if (!this.popup.isVisible()) {
            this.popup.show((Component)this.textFieldCode, p.x, p.y);
            this.textFieldCode.requestFocus();
        }
    }

    public void fillQueryPanel() {
        this.queryConditionList.removeAllElements();
        MenuSearchInfo[] menus = this.getMenuData(this.textFieldCode.getText());
        if (menus.length > 0) {
            KingdeeListModel model = new KingdeeListModel();
            for (MenuSearchInfo info : menus) {
                model.addElement((Object)info);
            }
            this.queryConditionList.setModel((ListModel)model);
            this.queryConditionList.setSelectedIndex(0);
            for (int i = 0; i < this.queryConditionList.getElementCount(); ++i) {
                if (this.isComFunction(((MenuSearchInfo)this.queryConditionList.getElement(i)).getMainMenuItemInfo().getId().toString())) {
                    this.queryConditionList.setElementIcon((Icon)COM, i);
                    continue;
                }
                this.queryConditionList.setElementIcon((Icon)NO_COM, i);
            }
        } else {
            Object[] noData = new String[]{InitUIForModel.getResource("noData")};
            this.queryConditionList.setListData(noData);
        }
        int count = this.queryConditionList.getElementCount();
        if (count < 8) {
            this.queryConditionList.setVisibleRowCount(count);
        } else {
            this.queryConditionList.setVisibleRowCount(8);
        }
        this.popup.setVisible(false);
    }

    private MenuSearchInfo[] getMenuData(String searchText) {
        searchText = StringUtils.trim((String)searchText);
        List mainMenuItemList = new ArrayList();
        try {
            mainMenuItemList = MyEasInvokeEntryFactory.getRemoteInstance().searchMainMenu(searchText);
            this.sortMainMenuItemList(mainMenuItemList, searchText);
        }
        catch (Exception e1) {
            this.logger.error((Object)"", (Throwable)e1);
            ExceptionHandler.handle((Throwable)e1);
        }
        MenuSearchInfo[] menus = new MenuSearchInfo[mainMenuItemList.size()];
        MenuSearchInfo menuInfo = null;
        int size = mainMenuItemList.size();
        for (int i = 0; i < size; ++i) {
            menuInfo = new MenuSearchInfo();
            menuInfo.setMainMenuItemInfo((MainMenuItemInfo)mainMenuItemList.get(i));
            menus[i] = menuInfo;
        }
        return menus;
    }

    private void sortMainMenuItemList(List mainMenuItemList, final String searchText) {
        Collections.sort(mainMenuItemList, new Comparator(){

            private boolean fullMatch(String searchText2, MainMenuItemInfo menuItem) {
                return StringUtils.equalsIgnoreCase((String)searchText2, (String)menuItem.getShortcutCode()) || StringUtils.equalsIgnoreCase((String)searchText2, (String)menuItem.getName()) || StringUtils.equalsIgnoreCase((String)searchText2, (String)menuItem.getPinYin()) || StringUtils.equalsIgnoreCase((String)searchText2, (String)menuItem.getShortPinYin());
            }

            public int compare(Object o1, Object o2) {
                MainMenuItemInfo menu1 = (MainMenuItemInfo)o1;
                MainMenuItemInfo menu2 = (MainMenuItemInfo)o2;
                if (this.fullMatch(searchText, menu1)) {
                    return -1;
                }
                if (this.fullMatch(searchText, menu2)) {
                    return 1;
                }
                return StringUtils.cnulls((String)menu1.getName()).compareTo(StringUtils.cnulls((String)menu2.getName()));
            }
        });
    }

    public void moveOnList(KDList list, int step) {
        int itemCount = list.getElementCount();
        int selectedIndex = list.getSelectedIndex();
        if ((selectedIndex += step) < 0) {
            selectedIndex = itemCount - 1;
        }
        if (selectedIndex > itemCount - 1) {
            selectedIndex = 0;
        }
        list.setSelectedIndex(selectedIndex);
        list.ensureIndexIsVisible(selectedIndex);
        this.selectionChanged();
    }

    private boolean isComFunction(String menuId) {
        Collection collection = NewMenuVisitorHelper.getComMenuCache().values();
        if (collection == null) {
            return false;
        }
        String id = null;
        for (ComMenuFunctionCollection colls : collection) {
            for (int i = 0; i < colls.size(); ++i) {
                id = colls.get(i).getMenuFunction().getId().toString();
                if (!StringUtils.equals((String)id, (String)menuId)) continue;
                return true;
            }
        }
        return false;
    }

    class MenuSearchInfo {
        MainMenuItemInfo mainMenuItemInfo = null;

        MenuSearchInfo() {
        }

        public MainMenuItemInfo getMainMenuItemInfo() {
            return this.mainMenuItemInfo;
        }

        public void setMainMenuItemInfo(MainMenuItemInfo mainMenuItemInfo) {
            this.mainMenuItemInfo = mainMenuItemInfo;
        }

        public String toString() {
            return this.getMainMenuItemInfo().getName() + "(" + this.getMainMenuItemInfo().getShortcutCode() + ")      ";
        }
    }

    class ListMouseAdapter
    extends MouseAdapter {
        ListMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                if (e.getX() < new ImageIcon(MainMenuConstants.GRAY_STAR_IMAGE).getIconWidth()) {
                    Object selectedObj = ShortCodeSearchUI.this.queryConditionList.getSelectedValue();
                    if (selectedObj == null || !(selectedObj instanceof MenuSearchInfo)) {
                        return;
                    }
                    IMainFunctionMenu ifunction = MainFunctionMenuFactory.getRemoteInstance();
                    MainMenuItemInfo menuItem = ((MenuSearchInfo)selectedObj).getMainMenuItemInfo();
                    if (ShortCodeSearchUI.this.isComFunction(menuItem.getId().toString())) {
                        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                        StringBuffer oql = new StringBuffer("where user.id = '").append(userId).append("' and menuFunction.id = '").append(menuItem.getId().toString()).append("'");
                        ComMenuFunctionFactory.getRemoteInstance().delete(oql.toString());
                        ShortCodeSearchUI.this.queryConditionList.setElementIcon((Icon)NO_COM, ShortCodeSearchUI.this.queryConditionList.getSelectedIndex());
                    } else {
                        ifunction.saveMenuToComFunction(MainMenuItemFactory.getRemoteInstance().getMainMenuItemInfo("where id='" + menuItem.getId() + "'"));
                        ShortCodeSearchUI.this.queryConditionList.setElementIcon((Icon)COM, ShortCodeSearchUI.this.queryConditionList.getSelectedIndex());
                    }
                    NewMenuVisitorHelper.clearComMenuCache();
                    MyComFunctionPanel.reloadAndRepaint();
                } else {
                    ShortCodeSearchUI.this.performSearch();
                    if (ShortCodeSearchUI.this.popup != null) {
                        ShortCodeSearchUI.this.popup.setVisible(false);
                    }
                }
            }
            catch (Exception e1) {
                ShortCodeSearchUI.this.logger.error((Object)"", (Throwable)e1);
                ExceptionHandler.handle((Throwable)e1);
            }
        }
    }

    class TextFieldMouseAdapter
    extends MouseAdapter {
        TextFieldMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            String inputText = ShortCodeSearchUI.this.textFieldCode.getText();
            if (inputText != null && ShortCodeSearchUI.this.inputShortKey.equals(inputText.trim())) {
                ShortCodeSearchUI.this.textFieldCode.setText("");
            }
            if (e.getClickCount() == 2) {
                if (!StringUtils.isEmpty((String)inputText) && ShortCodeSearchUI.this.popup != null) {
                    ShortCodeSearchUI.this.popup.setVisible(true);
                }
                ShortCodeSearchUI.this.textFieldCode.requestFocus();
            }
        }
    }

    class MenuSearchKeyAdapter
    extends KeyAdapter {
        MenuSearchKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                try {
                    ShortCodeSearchUI.this.performSearch();
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Component)((Component)e.getSource()), (Throwable)e1);
                }
            } else if (e.getKeyCode() == 27) {
                if (ShortCodeSearchUI.this.popup != null) {
                    ShortCodeSearchUI.this.popup.setVisible(false);
                }
            } else if (e.getKeyCode() == 40) {
                ShortCodeSearchUI.this.moveOnList(ShortCodeSearchUI.this.queryConditionList, 1);
            } else if (e.getKeyCode() == 38) {
                ShortCodeSearchUI.this.moveOnList(ShortCodeSearchUI.this.queryConditionList, -1);
            }
        }
    }
}

