/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.myeas.FunctionShortCutCollection;
import com.kingdee.eas.base.myeas.FunctionShortCutFactory;
import com.kingdee.eas.base.myeas.FunctionShortCutInfo;
import com.kingdee.eas.base.myeas.IFunctionShortCut;
import com.kingdee.eas.base.myeas.MyEasException;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.myeas.client.AbstractShortCutSetUI;
import com.kingdee.eas.base.myeas.client.IMySettingUI;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.MenuVisitorHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class ShortCutSetUI
extends AbstractShortCutSetUI
implements IMySettingUI {
    private boolean isModify = false;
    private JComponent component = null;
    private int modifyRowIndex = 0;
    private KDContainer container = null;
    private KDTree treeFunMenu = null;
    private KDSplitPane splitPaneMain = null;
    private KDTable tableEdit = null;
    private KDScrollPane scrollPaneLeft = null;

    @Override
    public void saveData() throws Exception {
        block2: {
            try {
                this.saveShortCut(this.modifyRowIndex);
                this.setModified(false);
                this.enableComponent(false);
            }
            catch (Exception e1) {
                this.handUIException(e1);
                if (e1 instanceof MyEasException && ((MyEasException)((Object)e1)).getSubCode().equals(MyEasException.SHORT_CODE_DUP.getCode())) break block2;
                this.handUIException(e1);
            }
        }
    }

    protected void initTree() throws Exception {
        MenuVisitorHelper.buildMenuTree((KDTree)this.getTreeFunMenu());
        this.getTreeFunMenu().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (ShortCutSetUI.this.isPerformSave()) {
                    ShortCutSetUI.this.isModify = false;
                    ShortCutSetUI.this.performNodeSelect();
                }
                ShortCutSetUI.this.enableComponent(false);
            }
        });
    }

    private boolean isPerformSave() {
        int res;
        if (this.isModify && (res = MsgBox.showConfirm3((Component)((Object)this), (String)InitUIForModel.getResource("dataChangedSave"))) == 0) {
            block3: {
                try {
                    this.saveShortCut(this.modifyRowIndex);
                    this.setModified(false);
                    this.enableComponent(false);
                }
                catch (Exception e1) {
                    this.handUIException(e1);
                    if (e1 instanceof MyEasException && ((MyEasException)((Object)e1)).getSubCode().equals(MyEasException.SHORT_CODE_DUP.getCode())) break block3;
                    this.handUIException(e1);
                }
            }
            return true;
        }
        return true;
    }

    public KDContainer getPaneWithContainer() {
        return this.getContainer();
    }

    private void initialize() throws BOSException {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getSplitPaneMain(), "Center");
    }

    protected void performNodeSelect() {
        this.getTableEdit().getEditManager().stopEditing();
        this.getTableEdit().removeRows();
        Vector vecMenuItem = this.getVecMenuItemLeaf(this.getSelectedTreeNode());
        if (vecMenuItem == null || vecMenuItem.size() == 0) {
            return;
        }
        Vector<MenuAndShortCut> vecMenuAndShortCut = new Vector<MenuAndShortCut>(vecMenuItem.size());
        for (int i = 0; i < vecMenuItem.size(); ++i) {
            MainMenuItemInfo menuItemInfo = (MainMenuItemInfo)vecMenuItem.elementAt(i);
            vecMenuAndShortCut.add(new MenuAndShortCut(menuItemInfo, null));
        }
        FunctionShortCutCollection shortCuts = this.fetchShortCut(vecMenuItem);
        if (shortCuts != null && !shortCuts.isEmpty()) {
            Iterator iter = shortCuts.iterator();
            while (iter.hasNext()) {
                FunctionShortCutInfo shortCutInfo = (FunctionShortCutInfo)iter.next();
                for (int i = 0; i < vecMenuAndShortCut.size(); ++i) {
                    MenuAndShortCut menuAndShortCut = (MenuAndShortCut)vecMenuAndShortCut.elementAt(i);
                    if (menuAndShortCut.getShortCutInfo() != null || !StringUtils.equals((String)menuAndShortCut.getMenuItemInfo().getId().toString(), (String)shortCutInfo.getMenuFunction().getId().toString())) continue;
                    menuAndShortCut.setShortCutInfo(shortCutInfo);
                }
            }
        }
        this.showDataAtTable(this.genShowData(vecMenuAndShortCut), this.getTableEdit());
    }

    protected Vector genShowData(Vector vecMenuAndShortCut) {
        if (vecMenuAndShortCut == null || vecMenuAndShortCut.size() == 0) {
            return null;
        }
        Vector result = new Vector(vecMenuAndShortCut.size());
        for (int i = 0; i < vecMenuAndShortCut.size(); ++i) {
            HashMap<String, Object> hmLine = new HashMap<String, Object>();
            MenuAndShortCut currData = (MenuAndShortCut)vecMenuAndShortCut.elementAt(i);
            MainMenuItemInfo menuInfo = currData.getMenuItemInfo();
            FunctionShortCutInfo shortCutInfo = currData.getShortCutInfo();
            if (menuInfo.getName() != null) {
                hmLine.put("MenuName", menuInfo.getName());
            } else {
                hmLine.put("MenuName", "");
            }
            if (menuInfo.getShortcutCode() != null) {
                hmLine.put("SysCode", menuInfo.getShortcutCode());
            } else {
                hmLine.put("SysCode", "");
            }
            if (shortCutInfo != null && shortCutInfo.getShortCutCode() != null) {
                hmLine.put("PerCode", shortCutInfo.getShortCutCode());
            } else {
                hmLine.put("PerCode", "");
            }
            if (shortCutInfo != null) {
                hmLine.put("IsUse", shortCutInfo.isUse());
            } else {
                hmLine.put("IsUse", Boolean.FALSE);
            }
            hmLine.put("FullData", currData);
            result.add(hmLine);
        }
        return result;
    }

    protected void showDataAtTable(Vector vecData, KDTable table) {
        table.removeRows();
        if (vecData == null || vecData.size() == 0) {
            return;
        }
        for (int i = 0; i < vecData.size(); ++i) {
            IRow row = table.addRow();
            HashMap hmLine = (HashMap)vecData.elementAt(i);
            row.getCell("MenuName").setValue(hmLine.get("MenuName"));
            row.getCell("SysCode").setValue(hmLine.get("SysCode"));
            row.getCell("PerCode").setValue(hmLine.get("PerCode"));
            row.getCell("IsUse").setValue(hmLine.get("IsUse"));
            row.getCell("FullData").setValue(hmLine.get("FullData"));
            Boolean isUse = (Boolean)hmLine.get("IsUse");
            if (isUse.booleanValue()) {
                row.getCell("PerCode").getStyleAttributes().setLocked(true);
                continue;
            }
            row.getCell("PerCode").getStyleAttributes().setLocked(false);
        }
    }

    protected FunctionShortCutCollection fetchShortCut(Vector vecMenuItem) {
        if (vecMenuItem == null || vecMenuItem.size() == 0) {
            return null;
        }
        FunctionShortCutCollection result = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < vecMenuItem.size(); ++i) {
            BOSUuid uuid = ((MainMenuItemInfo)vecMenuItem.elementAt(i)).getId();
            set.add(uuid.toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("menuFunction.id", set, CompareType.INCLUDE));
        UserInfo currUser = (UserInfo)SysContext.getSysContext().getCurrentUser();
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)currUser.getId().toString()));
        try {
            IFunctionShortCut iFunctionShortCut = FunctionShortCutFactory.getRemoteInstance();
            result = iFunctionShortCut.getFunctionShortCutCollection(view);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return result;
    }

    public KDContainer getContainer() {
        if (this.container == null) {
            this.container = new KDContainer();
            this.initContainer();
            this.container.setBorder(InitUIForModel.MYSETTING_BORDER);
        }
        return this.container;
    }

    private KDTree getTreeFunMenu() {
        if (this.treeFunMenu == null) {
            this.treeFunMenu = new KDTree();
        }
        return this.treeFunMenu;
    }

    private KDSplitPane getSplitPaneMain() {
        if (this.splitPaneMain == null) {
            this.splitPaneMain = new KDSplitPane();
            this.splitPaneMain.setDividerSize(3);
            this.splitPaneMain.setDividerLocation(200);
            this.splitPaneMain.setHasDividerPointer(false);
            this.splitPaneMain.setPreferredSize(new Dimension(800, 600));
            this.splitPaneMain.add((Component)this.getScrollPaneLeft(), (Object)"left");
            this.splitPaneMain.add((Component)this.getTableEdit(), (Object)"right");
        }
        return this.splitPaneMain;
    }

    private KDScrollPane getScrollPaneLeft() {
        if (this.scrollPaneLeft == null) {
            this.scrollPaneLeft = new KDScrollPane((Component)this.getTreeFunMenu());
        }
        return this.scrollPaneLeft;
    }

    private KDTable getTableEdit() {
        if (this.tableEdit == null) {
            this.tableEdit = new KDTable();
            this.tableEdit.getSelectManager().setSelectMode(1);
            this.initTebleHead(this.tableEdit);
            this.tableEdit.addKDTSelectListener(new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent e) {
                    int curRowIndex;
                    int prevRowIndex;
                    KDTSelectBlock prevBlock = e.getPrevSelectBlock();
                    KDTSelectBlock currBlock = e.getSelectBlock();
                    if (prevBlock != null && currBlock != null && (prevRowIndex = prevBlock.getBeginRow()) != (curRowIndex = currBlock.getBeginRow())) {
                        ShortCutSetUI.this.enableComponent(false);
                    }
                }
            });
            this.tableEdit.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    if (e.getOldValue() != null) {
                        if (e.getOldValue().equals(e.getValue())) {
                            return;
                        }
                        try {
                            ShortCutSetUI.this.performInput(e);
                            ShortCutSetUI.this.modifyRowIndex = e.getRowIndex();
                        }
                        catch (Exception e1) {
                            MsgBox.showInfo((String)e1.getMessage());
                            KDTable tbl = (KDTable)e.getSource();
                            IRow row = tbl.getRow(e.getRowIndex());
                            ICell cellPerCode = row.getCell("PerCode");
                            ICell cellUse = row.getCell("IsUse");
                            cellPerCode.setValue(null);
                            cellUse.setValue((Object)Boolean.FALSE);
                        }
                    }
                }

                public void editStopping(KDTEditEvent e) {
                    IRow row = ShortCutSetUI.this.tableEdit.getRow(e.getRowIndex());
                    ICell cellPerCode = row.getCell("PerCode");
                    ICell cellUse = row.getCell("IsUse");
                    Boolean use = (Boolean)cellUse.getValue();
                    if (use.booleanValue()) {
                        cellPerCode.getStyleAttributes().setLocked(true);
                    } else {
                        cellPerCode.getStyleAttributes().setLocked(false);
                    }
                }

                public void editStarted(KDTEditEvent e) {
                    ShortCutSetUI.this.setModified(true);
                    ShortCutSetUI.this.enableComponent(true);
                }
            });
        }
        return this.tableEdit;
    }

    protected void saveShortCut(int rowIndex) throws Exception {
        FunctionShortCutInfo data = this.getModifiedRowData(rowIndex);
        if (data == null) {
            return;
        }
        if (data.getShortCutCode() != null && data.getShortCutCode().length() > 20) {
            MsgBox.showInfo((Component)((Object)this), (String)ShortCutSetUI.getResource("shortcut.too.long"));
            return;
        }
        IFunctionShortCut iFunctionShortCut = FunctionShortCutFactory.getRemoteInstance();
        if (data.getId() != null) {
            ObjectUuidPK iObjectPK = new ObjectUuidPK(data.getId());
            if (data.getShortCutCode() == null || data.getShortCutCode().length() == 0) {
                iFunctionShortCut.delete((IObjectPK)iObjectPK);
                IRow row = this.getTableEdit().getRow(rowIndex);
                MenuAndShortCut rowData = (MenuAndShortCut)row.getCell("FullData").getValue();
                rowData.setShortCutInfo(null);
            } else {
                iFunctionShortCut.update((IObjectPK)iObjectPK, (CoreBaseInfo)data);
            }
        } else {
            IObjectPK iObjectPK = iFunctionShortCut.addnew((CoreBaseInfo)data);
            data = iFunctionShortCut.getFunctionShortCutInfo(iObjectPK);
            IRow row = this.getTableEdit().getRow(rowIndex);
            MenuAndShortCut rowData = (MenuAndShortCut)row.getCell("FullData").getValue();
            rowData.setShortCutInfo(data);
        }
        MsgBox.showInfo((Component)((Object)this), (String)MyEasResource.getCommonString("saveSuccessed"));
    }

    private FunctionShortCutInfo getModifiedRowData(int rowIndex) throws EASBizException, BOSException {
        FunctionShortCutInfo result = null;
        IRow row = this.getTableEdit().getRow(rowIndex);
        String shortCode = (String)row.getCell("PerCode").getValue();
        this.checkShortCode(shortCode);
        boolean isUse = (Boolean)row.getCell("IsUse").getValue();
        MenuAndShortCut rowData = (MenuAndShortCut)row.getCell("FullData").getValue();
        FunctionShortCutInfo rowShortCodeData = rowData.getShortCutInfo();
        if (rowShortCodeData == null) {
            if (!(shortCode != null && shortCode.length() != 0 || isUse)) {
                return null;
            }
            result = new FunctionShortCutInfo();
            result.setMenuFunction(rowData.getMenuItemInfo());
            result.setShortCutCode(shortCode);
            result.setUse(isUse);
            result.setUser((UserInfo)SysContext.getSysContext().getCurrentUser());
        } else {
            if (StringUtils.equalsIgnoreCase((String)rowShortCodeData.getShortCutCode(), (String)shortCode) && rowShortCodeData.isUse() == isUse) {
                return null;
            }
            result = rowShortCodeData;
            result.setShortCutCode(shortCode);
            result.setUse(isUse);
        }
        return result;
    }

    private void initTebleHead(KDTable currTable) {
        String[] headTitles = new String[]{ShortCutSetUI.getResource("ShortCutTableHead.sysFun"), ShortCutSetUI.getResource("ShortCutTableHead.sysCode"), ShortCutSetUI.getResource("ShortCutTableHead.perCode"), ShortCutSetUI.getResource("use"), ""};
        String[] columnKeys = new String[]{"MenuName", "SysCode", "PerCode", "IsUse", "FullData"};
        int[] columnWidth = new int[]{120, 100, 100, 100, 0};
        for (int i = 0; i < 5; ++i) {
            IColumn column = currTable.addColumn();
            column.setWidth(columnWidth[i]);
            column.setKey(columnKeys[i]);
            if (columnKeys[i] == "MenuName" || columnKeys[i] == "SysCode") {
                column.getStyleAttributes().setLocked(true);
                column.getStyleAttributes().setBackground(new Color(217, 217, 208));
            }
            if (columnKeys[i] == "IsUse") {
                // empty if block
            }
            if (i != 4) continue;
            column.getStyleAttributes().setHided(true);
        }
        IRow row = null;
        row = currTable.addHeadRow();
        for (int i = 0; i < 5; ++i) {
            row.getCell(i).setValue((Object)headTitles[i]);
        }
    }

    private DefaultKingdeeTreeNode getSelectedTreeNode() {
        return (DefaultKingdeeTreeNode)this.getTreeFunMenu().getLastSelectedPathComponent();
    }

    private Vector getVecMenuItemLeaf(DefaultKingdeeTreeNode currNode) {
        if (currNode == null) {
            return null;
        }
        Vector<MainMenuItemInfo> result = new Vector<MainMenuItemInfo>();
        if (currNode.isLeaf()) {
            MainMenuItemInfo mainMenuItemInfo = (MainMenuItemInfo)currNode.getUserObject();
            result.addElement(mainMenuItemInfo);
        } else {
            int childCount = currNode.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                MainMenuItemInfo mainMenuItemInfo;
                DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)currNode.getChildAt(i);
                if (childNode == null || !(mainMenuItemInfo = (MainMenuItemInfo)childNode.getUserObject()).isIsLeaf()) continue;
                result.addElement(mainMenuItemInfo);
            }
        }
        return result;
    }

    protected void performInput(KDTEditEvent e) throws EASBizException, BOSException {
        KDTable tbl = (KDTable)e.getSource();
        if (e.getColIndex() == tbl.getColumnIndex("IsUse")) {
            IRow row = tbl.getRow(e.getRowIndex());
            ICell cellPerCode = row.getCell("PerCode");
            String valuePerCode = (String)cellPerCode.getValue();
            ICell cellUse = row.getCell("IsUse");
            Boolean use = (Boolean)cellUse.getValue();
            if (use.booleanValue() && (valuePerCode == null || valuePerCode.length() == 0)) {
                MsgBox.showInfo((Component)tbl, (String)ShortCutSetUI.getResource("ShortCut.inputCode"));
                cellUse.setValue((Object)Boolean.FALSE);
                use = (Boolean)cellUse.getValue();
            }
            if (use.booleanValue()) {
                cellPerCode.getStyleAttributes().setLocked(true);
            } else {
                cellPerCode.getStyleAttributes().setLocked(false);
            }
        } else if (e.getColIndex() == tbl.getColumnIndex("PerCode")) {
            IRow row = tbl.getRow(e.getRowIndex());
            ICell cellUse = row.getCell("IsUse");
            Boolean use = (Boolean)cellUse.getValue();
            ICell cellPerCode = row.getCell("PerCode");
            String valuePerCode = (String)cellPerCode.getValue();
            if (valuePerCode == null || valuePerCode.length() == 0) {
                if (use.booleanValue()) {
                    cellUse.setValue((Object)Boolean.FALSE);
                }
                return;
            }
            if (!valuePerCode.matches("[a-zA-Z0-9]+")) {
                MsgBox.showInfo((Component)tbl, (String)ShortCutSetUI.getResource("ShortCut.inputCode1"));
                e.setCancel(true);
                cellPerCode.setValue(e.getOldValue());
                return;
            }
            this.checkShortCode(valuePerCode);
        }
    }

    private void checkShortCode(String valuePerCode) throws EASBizException, BOSException {
        IFunctionShortCut iFunctionShortCut = FunctionShortCutFactory.getRemoteInstance();
        iFunctionShortCut.checkShortCodeDup(valuePerCode);
    }

    private static String getResource(String strKey) {
        return MyEasResource.getString(strKey);
    }

    protected void initContainer() {
        this.container.setEnableActive(false);
        this.container.getContentPane().setLayout((LayoutManager)new KDLayout());
        this.container.getContentPane().setLayout((LayoutManager)new KDLayout());
        this.container.setPreferredSize(new Dimension(500, 500));
        this.container.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 100, 100));
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(8, 8, 84, 84);
        cons.anchor = 15;
        this.putClientProperty("KDLayoutConstraints", cons);
        this.container.getContentPane().add((Component)((Object)this), null);
        this.container.setBorder(InitUIForModel.MYSETTING_BORDER);
        this.container.setTitle(ShortCutSetUI.getResource("ShortCutSetUI.title"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initialize();
        this.initTree();
    }

    @Override
    public boolean isModified() {
        return this.isModify;
    }

    @Override
    public void setControlComponent(JComponent component) {
        this.component = component;
    }

    @Override
    public void setModified(boolean bFlag) {
        this.isModify = bFlag;
    }

    @Override
    public void enableComponent(boolean bFlag) {
        if (this.component != null) {
            this.component.setEnabled(bFlag);
        }
    }

    class MenuAndShortCut {
        private MainMenuItemInfo menuItemInfo = null;
        private FunctionShortCutInfo shortCutInfo = null;
        static final int COLUMNCOUNT = 5;
        static final String MENUNAME = "MenuName";
        static final String SYSCODE = "SysCode";
        static final String PERCODE = "PerCode";
        static final String ISUSE = "IsUse";
        static final String FULLDATA = "FullData";

        public MenuAndShortCut(MainMenuItemInfo menuItemInfo, FunctionShortCutInfo shortCutInfo) {
            this.menuItemInfo = menuItemInfo;
            this.shortCutInfo = shortCutInfo;
        }

        public MainMenuItemInfo getMenuItemInfo() {
            return this.menuItemInfo;
        }

        public FunctionShortCutInfo getShortCutInfo() {
            return this.shortCutInfo;
        }

        public void setMenuItemInfo(MainMenuItemInfo info) {
            this.menuItemInfo = info;
        }

        public void setShortCutInfo(FunctionShortCutInfo info) {
            this.shortCutInfo = info;
        }
    }
}

