/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client;

import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.myeas.IToolBarStyle;
import com.kingdee.eas.base.myeas.ToolBarStyleCollection;
import com.kingdee.eas.base.myeas.ToolBarStyleEnum;
import com.kingdee.eas.base.myeas.ToolBarStyleFactory;
import com.kingdee.eas.base.myeas.ToolBarStyleInfo;
import com.kingdee.eas.base.myeas.client.AbstractToolbarStyleSettingUI;
import com.kingdee.eas.base.myeas.client.IMySettingUI;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.base.uiframe.client.UIFrameContext;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ToolbarStyleSettingUI
extends AbstractToolbarStyleSettingUI
implements IMySettingUI {
    private UserInfo userInfo = null;
    private IToolBarStyle iToolBar = null;
    private ToolBarStyleInfo toolInfo = null;
    private boolean isModify = false;
    private JComponent component = null;
    ChangeListener listener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            ToolbarStyleSettingUI.this.enableComponent(true);
            ToolbarStyleSettingUI.this.setModified(true);
        }
    };

    public ToolbarStyleSettingUI() throws Exception {
        this.setUITitle(InitUIForModel.getResource("ToolbarStyle"));
        this.userInfo = InitUIForModel.getUserInfo();
        this.iToolBar = ToolBarStyleFactory.getRemoteInstance();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setAllUserCbx.setVisible(false);
        this.forceCoverCbx.setVisible(false);
        this.initButtonGroup();
        this.initData();
        this.radIcon.addChangeListener(this.listener);
        this.radIconAllText.addChangeListener(this.listener);
        this.radIconText.addChangeListener(this.listener);
        this.radText.addChangeListener(this.listener);
        this.setAllUserCbx.addChangeListener(this.listener);
        this.forceCoverCbx.addChangeListener(this.listener);
    }

    private void initButtonGroup() {
        KDButtonGroup openModelGroup = new KDButtonGroup();
        openModelGroup.add((AbstractButton)this.radIcon);
        openModelGroup.add((AbstractButton)this.radIconAllText);
        openModelGroup.add((AbstractButton)this.radIconText);
        openModelGroup.add((AbstractButton)this.radText);
    }

    private void initData() throws Exception {
        ToolBarStyleEnum toolStyle = null;
        toolStyle = (ToolBarStyleEnum)((Object)UIFrameContext.getInstance().getProperty((Object)"ToolbarStyle"));
        String key = "imgSetting_toolbar_3";
        String tip = "tip_toolbar_3";
        if (toolStyle != null) {
            if (toolStyle.equals((Object)ToolBarStyleEnum.OnlyIcon)) {
                this.radIcon.setSelected(true);
                key = "imgSetting_toolbar_1";
                tip = "tip_toolbar_1";
            } else if (toolStyle.equals((Object)ToolBarStyleEnum.OnlyText)) {
                this.radText.setSelected(true);
                key = "imgSetting_toolbar_4";
                tip = "tip_toolbar_4";
            } else if (toolStyle.equals((Object)ToolBarStyleEnum.IconAllText)) {
                this.radIconAllText.setSelected(true);
                key = "imgSetting_toolbar_2";
                tip = "tip_toolbar_2";
            } else if (toolStyle.equals((Object)ToolBarStyleEnum.IconText)) {
                this.radIconText.setSelected(true);
                key = "imgSetting_toolbar_3";
                tip = "tip_toolbar_3";
            } else {
                this.radIconText.setSelected(true);
                key = "imgSetting_toolbar_3";
                tip = "tip_toolbar_3";
            }
        }
        Image image = UIFrameResource.getCommonImage((String)key);
        String tipText = InitUIForModel.getResource(tip);
        this.lalReview.setHorizontalAlignment(0);
        this.lalReview.setIcon((Icon)new ImageIcon(image));
        this.lalTip.setText(tipText);
    }

    @Override
    public void saveData() throws Exception {
        ToolBarStyleEnum editToolStyle = ToolBarStyleEnum.IconText;
        if (this.radIcon.isSelected()) {
            editToolStyle = ToolBarStyleEnum.OnlyIcon;
        } else if (this.radText.isSelected()) {
            editToolStyle = ToolBarStyleEnum.OnlyText;
        } else if (this.radIconAllText.isSelected()) {
            editToolStyle = ToolBarStyleEnum.IconAllText;
        } else if (this.radIconText.isSelected()) {
            editToolStyle = ToolBarStyleEnum.IconText;
        }
        if (this.setAllUserCbx.isSelected()) {
            this.iToolBar.setStyle(Integer.parseInt(editToolStyle.getValue()), true, this.forceCoverCbx.isSelected());
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("LayModelSaveTip"));
            return;
        }
        String oql = "select id,user,style where user = '" + this.userInfo.getId().toString() + "'";
        ToolBarStyleCollection toolColl = this.iToolBar.getToolBarStyleCollection(oql);
        if (toolColl != null && toolColl.size() > 0) {
            this.toolInfo = toolColl.get(0);
        }
        if (this.toolInfo != null) {
            this.toolInfo.setStyle(editToolStyle);
            ObjectUuidPK pk = new ObjectUuidPK(this.toolInfo.getId());
            this.iToolBar.update((IObjectPK)pk, this.toolInfo);
            UIFrameContext.getInstance().setProperty((Object)"ToolbarStyle", (Object)this.toolInfo.getStyle());
            if (UIConfig.isLocalStorePersonalizedSetting()) {
                UIFrameContext.witeCacheData();
            }
        } else {
            ToolBarStyleInfo newToolInfo = new ToolBarStyleInfo();
            newToolInfo.setUser(this.userInfo);
            newToolInfo.setStyle(editToolStyle);
            newToolInfo.setId(BOSUuid.create((BOSObjectType)newToolInfo.getBOSType()));
            this.iToolBar.addnew(newToolInfo);
            UIFrameContext.getInstance().setProperty((Object)"ToolbarStyle", (Object)newToolInfo.getStyle());
            if (UIConfig.isLocalStorePersonalizedSetting()) {
                UIFrameContext.witeCacheData();
            }
        }
        this.enableComponent(false);
        this.setModified(false);
        MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("LayModelSaveTip"));
    }

    @Override
    protected void radIcon_actionPerformed(ActionEvent e) throws Exception {
        super.radIcon_actionPerformed(e);
        if (this.radIcon.isSelected()) {
            String key = "imgSetting_toolbar_1";
            String tip = "tip_toolbar_1";
            Image image = UIFrameResource.getCommonImage((String)key);
            String tipText = InitUIForModel.getResource(tip);
            this.lalReview.setHorizontalAlignment(0);
            this.lalReview.setIcon((Icon)new ImageIcon(image));
            this.lalTip.setText(tipText);
        }
    }

    @Override
    protected void radIconAllText_actionPerformed(ActionEvent e) throws Exception {
        super.radIconAllText_actionPerformed(e);
        if (this.radIconAllText.isSelected()) {
            String key = "imgSetting_toolbar_2";
            String tip = "tip_toolbar_2";
            Image image = UIFrameResource.getCommonImage((String)key);
            String tipText = InitUIForModel.getResource(tip);
            this.lalReview.setHorizontalAlignment(0);
            this.lalReview.setIcon((Icon)new ImageIcon(image));
            this.lalTip.setText(tipText);
        }
    }

    @Override
    protected void radIconText_actionPerformed(ActionEvent e) throws Exception {
        super.radIconText_actionPerformed(e);
        if (this.radIconText.isSelected()) {
            String key = "imgSetting_toolbar_3";
            String tip = "tip_toolbar_3";
            Image image = UIFrameResource.getCommonImage((String)key);
            String tipText = InitUIForModel.getResource(tip);
            this.lalReview.setHorizontalAlignment(0);
            this.lalReview.setIcon((Icon)new ImageIcon(image));
            this.lalTip.setText(tipText);
        }
    }

    @Override
    protected void radText_actionPerformed(ActionEvent e) throws Exception {
        super.radText_actionPerformed(e);
        if (this.radText.isSelected()) {
            String key = "imgSetting_toolbar_4";
            String tip = "tip_toolbar_4";
            Image image = UIFrameResource.getCommonImage((String)key);
            String tipText = InitUIForModel.getResource(tip);
            this.lalReview.setHorizontalAlignment(0);
            this.lalReview.setIcon((Icon)new ImageIcon(image));
            this.lalTip.setText(tipText);
        }
    }

    @Override
    public boolean isModified() {
        return this.isModify;
    }

    @Override
    public void setControlComponent(JComponent component) {
        this.component = component;
    }

    @Override
    public void setModified(boolean bFlag) {
        this.isModify = bFlag;
    }

    @Override
    public void enableComponent(boolean bFlag) {
        if (this.component != null) {
            this.component.setEnabled(bFlag);
        }
    }

    @Override
    protected void setAllUserCbx_actionPerformed(ActionEvent e) throws Exception {
        super.setAllUserCbx_actionPerformed(e);
        if (this.setAllUserCbx.isSelected()) {
            this.forceCoverCbx.setVisible(true);
        } else {
            this.forceCoverCbx.setVisible(false);
        }
    }
}

