/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.myeas.IMyUrlFolder;
import com.kingdee.eas.base.myeas.MyUrlFolderCollection;
import com.kingdee.eas.base.myeas.MyUrlFolderFactory;
import com.kingdee.eas.base.myeas.MyUrlFolderInfo;
import com.kingdee.eas.base.myeas.client.AbstractUrlFolderEditUI;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class UrlFolderEditUI
extends AbstractUrlFolderEditUI {
    private IMyUrlFolder iUrlFolder = MyUrlFolderFactory.getRemoteInstance();
    private UserInfo userInfo = InitUIForModel.getUserInfo();

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkName()) {
            return;
        }
        MyUrlFolderInfo myFolderInfo = new MyUrlFolderInfo();
        myFolderInfo.setName(this.txtName.getText().trim());
        myFolderInfo.setUser(this.userInfo);
        BOSUuid folderID = BOSUuid.create((BOSObjectType)myFolderInfo.getBOSType());
        myFolderInfo.setId(folderID);
        this.iUrlFolder.addnew((CoreBaseInfo)myFolderInfo);
        this.getUIWindow().close();
    }

    private boolean checkName() {
        boolean isOK = true;
        if (this.txtName.getText().trim().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("NameNotEmpty"));
            isOK = false;
        }
        String name = this.txtName.getText().trim();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterUser = new FilterItemInfo("user", (Object)this.userInfo.getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterUser);
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)name, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        try {
            MyUrlFolderCollection myFolderColl = this.iUrlFolder.getMyUrlFolderCollection(viewInfo);
            if (myFolderColl != null && myFolderColl.size() > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)InitUIForModel.getResource("NameExist"));
                isOK = false;
            }
        }
        catch (Exception es) {
            this.handUIException(es);
        }
        return isOK;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

