/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client.getpanel;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.myeas.ComMenuFunctionInfo;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.myeas.client.getpanel.IMyEasInterPanel;
import com.kingdee.eas.base.permission.IMainMenuItem;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.MainFrame;
import com.kingdee.eas.base.uiframe.client.MainFunctionMenuUI;
import com.kingdee.eas.base.uiframe.client.MenuVisitorHelper;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class GetComFunctionPanel
implements IMyEasInterPanel {
    private KDTreeView treeView = new KDTreeView();
    private KDPanel comFunPanel = new KDPanel();
    private KDTree comFunTree = new KDTree();
    private KDWorkButton butRef = null;
    private KDWorkButton butEdit = null;
    private Action actRefresh = null;
    private Action actEdit = null;
    private Logger logger = Logger.getLogger(GetComFunctionPanel.class);
    private String title = "";
    private IMainMenuItem iMainMenu;

    public GetComFunctionPanel() {
        this.comFunPanel.setLayout((LayoutManager)new BorderLayout());
    }

    @Override
    public void setPanelTitle(String title) {
        this.treeView.setTitle(title);
        this.title = title;
        this.comFunPanel.setName(title);
    }

    @Override
    public boolean isRequestThread() {
        return true;
    }

    @Override
    public void setUserInfo(UserInfo userInfo) {
    }

    @Override
    public KDPanel returnPanel() {
        this.initTreeView();
        this.treeView.setBorder(null);
        this.comFunPanel.add((Component)this.treeView, (Object)"Center");
        return this.comFunPanel;
    }

    private void initTreeView() {
        this.loadingTree();
        this.treeView = new KDTreeView(this.comFunTree);
        this.treeView.setShowButton(false);
        this.treeView.setTitle(this.title);
        this.actRefresh = new AbstractAction("", MyEasResource.getCommonIcon("imgTbtn_refresh")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GetComFunctionPanel.this.initData();
            }
        };
        this.butRef = new KDWorkButton(this.actRefresh){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 0);
            }
        };
        this.actEdit = new AbstractAction("", MyEasResource.getCommonIcon("imgTbtn_edit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GetComFunctionPanel.this.editComFun();
                }
                catch (Exception es) {
                    GetComFunctionPanel.this.logger.error((Object)es.getMessage(), (Throwable)es);
                }
            }
        };
        this.butEdit = new KDWorkButton(this.actEdit){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 0);
            }
        };
        this.butRef.setEnabled(false);
        this.butEdit.setEnabled(false);
        this.treeView.getControlPane().add((Component)this.butRef);
        this.treeView.getControlPane().add((Component)this.butEdit);
    }

    @Override
    public void initData() {
        try {
            this.treeView.remove((Component)this.comFunTree);
            this.treeView.validate();
            try {
                MenuVisitorHelper.buildFavoriteFunTree((KDTree)this.comFunTree);
                MenuVisitorHelper.addFavPopupListener((KDTree)this.comFunTree, (String)"MyEas");
            }
            catch (Exception es) {
                this.logger.error((Object)es.getMessage(), (Throwable)es);
            }
            TreeNode node = (TreeNode)this.comFunTree.getModel().getRoot();
            this.comFunTree.expandAllNodes(true, node);
            this.comFunTree.setShowCheckBox(false);
            this.treeView.setTree(this.comFunTree);
            this.treeView.setShowButton(false);
            this.treeView.setTitle(this.title);
            this.butRef.setEnabled(true);
            this.butEdit.setEnabled(true);
            this.comFunPanel.add((Component)this.treeView, (Object)"Center");
            this.comFunPanel.validate();
            this.initTreeEvent();
            this.comFunTree.setRowHeight(20);
            this.treeView.validate();
        }
        catch (Exception es) {
            this.logger.error((Object)es.getMessage(), (Throwable)es);
        }
    }

    private void editComFun() throws Exception {
        MainFunctionMenuUI msg;
        MainFrame mainFrame = MainFrame.getCurMainFrame((Component)this.treeView);
        IUIObject[] ui = UIFrameUtil.findUIObject((Frame)mainFrame, (String)(msg = new MainFunctionMenuUI()).getClass().getName());
        if (ui != null && ui.length > 0) {
            MainFunctionMenuUI o = (MainFunctionMenuUI)ui[0];
            o.getUIWindow().show();
        }
    }

    private void loadingTree() {
        DefaultKingdeeTreeNode top = new DefaultKingdeeTreeNode((Object)"");
        this.comFunTree = new KDTree((ITreeNode)top);
        this.comFunTree.setShowCheckBox(false);
    }

    private void initTreeEvent() {
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (GetComFunctionPanel.this.comFunTree.getClosestPath(e.getX(), e.getY()) == null || GetComFunctionPanel.this.comFunTree.getPathForLocation(e.getX(), e.getY()) == null) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    if (e.getButton() == 1) {
                        try {
                            GetComFunctionPanel.this.treeMousePress();
                        }
                        catch (Exception es) {
                            GetComFunctionPanel.this.logger.error((Object)es.getMessage(), (Throwable)es);
                        }
                    }
                }
            }
        };
        this.comFunTree.addMouseListener((MouseListener)ml);
        this.comFunTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() != 10) {
                    return;
                }
                try {
                    GetComFunctionPanel.this.treeMousePress();
                }
                catch (Exception es) {
                    GetComFunctionPanel.this.logger.error((Object)es.getMessage(), (Throwable)es);
                }
            }
        });
    }

    private void treeMousePress() throws Exception {
        DefaultKingdeeTreeNode node = null;
        TreePath selPath = this.comFunTree.getSelectionModel().getSelectionPath();
        if (selPath != null) {
            node = (DefaultKingdeeTreeNode)selPath.getLastPathComponent();
        }
        if (node == null) {
            return;
        }
        Object info = node.getUserObject();
        if (info instanceof ComMenuFunctionInfo) {
            ComMenuFunctionInfo selectComFunInfo;
            if (this.iMainMenu == null) {
                this.iMainMenu = MainMenuItemFactory.getRemoteInstance();
            }
            if ((selectComFunInfo = (ComMenuFunctionInfo)info).isDir()) {
                return;
            }
            ObjectUuidPK pk = new ObjectUuidPK(selectComFunInfo.getMenuFunction().getId());
            MainMenuItemInfo selectMenuInfo = this.iMainMenu.getMainMenuItemInfo((IObjectPK)pk);
            MenuVisitorHelper.showUIbyMenu((Component)this.comFunTree, (MainMenuItemInfo)selectMenuInfo);
        }
    }
}

