/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client.getpanel;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeHyperTextCellRenderer;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.myeas.IMyFavorite;
import com.kingdee.eas.base.myeas.IMyUrlFolder;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.myeas.MyFavoriteCollection;
import com.kingdee.eas.base.myeas.MyFavoriteFactory;
import com.kingdee.eas.base.myeas.MyFavoriteInfo;
import com.kingdee.eas.base.myeas.MyUrlFolderCollection;
import com.kingdee.eas.base.myeas.MyUrlFolderFactory;
import com.kingdee.eas.base.myeas.MyUrlFolderInfo;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.myeas.client.MyUrlEditUI;
import com.kingdee.eas.base.myeas.client.getpanel.IMyEasInterPanel;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.MainFrame;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class GetMyFavoritePanel
implements IMyEasInterPanel {
    private UserInfo userInfo = null;
    private String title = "";
    private IMyFavorite iMyFavorite = null;
    private IMyUrlFolder iMyFolder = null;
    private KDPanel mySitePanel = new KDPanel();
    private KDTree siteTree = new KDTree();
    private KDContainer container = new KDContainer();
    private KDTreeView treeView = new KDTreeView();
    private JMenuItem menuitemNew = null;
    private JMenuItem menuitemEdit = null;
    private JMenuItem menuitemDel = null;
    private JPopupMenu mnuOpenMethod1;
    private Icon defaultIcon = null;
    private Icon moveIcon = null;
    private Logger logger = Logger.getLogger(GetMyFavoritePanel.class);

    public GetMyFavoritePanel() {
        this.mySitePanel.setLayout((LayoutManager)new BorderLayout());
        this.container.getContentPane().setLayout((LayoutManager)new KDLayout());
        this.container.setEnableActive(false);
        this.defaultIcon = MyEasResource.getCommonIcon("imgHotspot_1");
        this.moveIcon = MyEasResource.getCommonIcon("imgHotspot_2");
    }

    @Override
    public boolean isRequestThread() {
        return true;
    }

    @Override
    public void setPanelTitle(String title) {
        this.container.setTitle(title);
        this.treeView.setTitle(title);
        this.treeView.setShowControlPanel(false);
        this.mySitePanel.setName(title);
        this.title = title;
    }

    @Override
    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    @Override
    public KDPanel returnPanel() {
        this.loadingTree();
        this.initTreeView();
        this.container.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 100, 100));
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(0, 0, 84, 84);
        cons.anchor = 15;
        this.treeView.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        this.container.getContentPane().add((Component)this.treeView, null);
        this.mySitePanel.add((Component)this.container, (Object)"Center");
        return this.mySitePanel;
    }

    @Override
    public void initData() {
        this.treeView.remove((Component)this.siteTree);
        this.treeView.validate();
        this.setSiteTreeData();
        this.siteTree.setRootVisible(false);
        this.initTreeView();
        this.siteTree.setBackground(new Color(228, 228, 223));
        this.siteTree.setRowHeight(20);
        this.treeView.setBorder(null);
        this.mySitePanel.validate();
    }

    private void initTreeView() {
        this.treeView.setTree(this.siteTree);
        this.treeView.setTitle(this.title);
        this.treeView.setShowButton(false);
    }

    private void setSiteTreeData() {
        DefaultKingdeeTreeNode top = new DefaultKingdeeTreeNode((Object)InitUIForModel.getResource("HotSite"));
        DefaultKingdeeTreeNode folder = null;
        try {
            IMyFavorite iMyfavor = MyFavoriteFactory.getRemoteInstance();
            MyFavoriteCollection myFavorColl = iMyfavor.getMyFavoriteCollection();
            int size = myFavorColl.size();
            MyFavoriteInfo myFavorInfo = null;
            for (int i = 0; i < size; ++i) {
                myFavorInfo = myFavorColl.get(i);
                folder = new DefaultKingdeeTreeNode((Object)myFavorInfo.getName().toString());
                folder.setTextColor(Color.BLUE);
                folder.setUserObject((Object)myFavorInfo);
                folder.setCustomIcon(this.defaultIcon);
                top.add((MutableTreeNode)folder);
            }
            this.siteTree = new KDTree((ITreeNode)top);
            this.siteTree.setShowCheckBox(false);
            MouseAdapter ml = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    GetMyFavoritePanel.this.treeMousePress(e);
                }
            };
            MouseMotionAdapter mmL = new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    DefaultKingdeeTreeNode top = (DefaultKingdeeTreeNode)GetMyFavoritePanel.this.siteTree.getModel().getRoot();
                    if (GetMyFavoritePanel.this.siteTree.getClosestPath(e.getX(), e.getY()) == null || GetMyFavoritePanel.this.siteTree.getPathForLocation(e.getX(), e.getY()) == null) {
                        GetMyFavoritePanel.this.mySitePanel.setCursor(new Cursor(0));
                        return;
                    }
                    TreePath path = GetMyFavoritePanel.this.siteTree.getPathForLocation(e.getX(), e.getY());
                    if (top.getChildCount() > 0) {
                        GetMyFavoritePanel.this.mySitePanel.setCursor(new Cursor(12));
                    } else {
                        GetMyFavoritePanel.this.mySitePanel.setCursor(new Cursor(0));
                    }
                }
            };
            this.siteTree.addMouseListener((MouseListener)ml);
            this.siteTree.addMouseMotionListener((MouseMotionListener)mmL);
            this.initTreePopupMenu();
            this.siteTree.setShowPopMenuDefaultItem(false);
            this.siteTree.setCellRenderer((TreeCellRenderer)new KingdeeTreeHyperTextCellRenderer());
        }
        catch (Exception es) {
            this.logger.error((Object)es.getMessage(), (Throwable)es);
        }
    }

    private void initTreePopupMenu() {
        this.mnuOpenMethod1 = new JPopupMenu();
        this.menuitemNew = new JMenuItem(InitUIForModel.getResource("ButNewName"));
        this.siteTree.getPopupMenu().add(this.menuitemNew);
        this.menuitemNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GetMyFavoritePanel.this.editFavorite(OprtState.ADDNEW);
            }
        });
        this.menuitemEdit = new JMenuItem(InitUIForModel.getResource("ButEditName"));
        this.siteTree.getPopupMenu().add(this.menuitemEdit);
        this.menuitemEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GetMyFavoritePanel.this.editFavorite(OprtState.EDIT);
            }
        });
        this.menuitemDel = new JMenuItem(InitUIForModel.getResource("ButDelName"));
        this.siteTree.getPopupMenu().add(this.menuitemDel);
        this.menuitemDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    GetMyFavoritePanel.this.delFavorite();
                }
                catch (Exception es) {
                    GetMyFavoritePanel.this.logger.error((Object)es.getMessage(), (Throwable)es);
                }
            }
        });
        this.siteTree.addTreePopupMenu(new TreePopupMenuListener(){

            public boolean popMenu(TreePopupMenuEvent e) {
                JPopupMenu menu = e.getMenu();
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)GetMyFavoritePanel.this.siteTree.getLastSelectedPathComponent();
                if (node == null || node.getUserObject() == null) {
                    GetMyFavoritePanel.this.menuitemDel.setEnabled(false);
                    GetMyFavoritePanel.this.menuitemEdit.setEnabled(false);
                } else {
                    GetMyFavoritePanel.this.menuitemDel.setEnabled(true);
                    GetMyFavoritePanel.this.menuitemEdit.setEnabled(true);
                }
                return true;
            }
        });
    }

    private void loadingTree() {
        DefaultKingdeeTreeNode top = new DefaultKingdeeTreeNode((Object)"");
        this.siteTree = new KDTree((ITreeNode)top);
        this.siteTree.setShowCheckBox(false);
        this.siteTree.setBackground(new Color(228, 228, 223));
        this.siteTree.setRootVisible(false);
        this.siteTree.setRowHeight(20);
        this.treeView.setBorder(null);
    }

    private void editFavorite(String oprtState) {
        try {
            String factoryName = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
            IUIFactory uiFactory = UIFactory.createUIFactory((String)factoryName);
            HashMap<String, MainFrame> mapContext = new HashMap<String, MainFrame>();
            HashMap mapData = new HashMap();
            MainFrame mainFrame = MainFrame.getCurMainFrame((Component)this.siteTree);
            mapContext.put("Owner", mainFrame);
            if (oprtState.equals(OprtState.EDIT) && (mapData = this.getHashMapData()).get("favorite") == null) {
                return;
            }
            IUIWindow window = uiFactory.create(MyUrlEditUI.class.getName(), mapContext, (Map)mapData, oprtState);
            window.show();
            this.initData();
        }
        catch (Exception es) {
            this.logger.error((Object)es.getMessage(), (Throwable)es);
        }
    }

    private HashMap getHashMapData() {
        HashMap<String, MyFavoriteInfo> mapData = new HashMap<String, MyFavoriteInfo>();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.siteTree.getLastSelectedPathComponent();
        if (node == null || node.getUserObject() == null) {
            return mapData;
        }
        Object o = node.getUserObject();
        MyFavoriteInfo myFavInfo = null;
        Object myFolderInfo = null;
        if (!(o instanceof MyFavoriteInfo)) {
            return mapData;
        }
        myFavInfo = (MyFavoriteInfo)o;
        mapData.put("favorite", myFavInfo);
        return mapData;
    }

    private void delFavorite() throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.siteTree.getLastSelectedPathComponent();
        if (node == null || node.getUserObject() == null) {
            return;
        }
        Object info = node.getUserObject();
        String strDel = InitUIForModel.getResource("ButDelName");
        String strDelSite = InitUIForModel.getResource("ConfirmDelete");
        String strDelFolder = InitUIForModel.getResource("ConfirmDeleteFolder");
        if (info instanceof MyFavoriteInfo) {
            MyFavoriteInfo delFavInfo = (MyFavoriteInfo)info;
            if (MsgBox.showConfirm3((Component)this.mySitePanel, (String)strDelSite) == 0) {
                this.siteTree.removeNodeFromParent((MutableTreeNode)node);
                ObjectUuidPK pk = new ObjectUuidPK(delFavInfo.getId());
                if (this.iMyFavorite == null) {
                    this.iMyFavorite = MyFavoriteFactory.getRemoteInstance();
                }
                this.iMyFavorite.delete((IObjectPK)pk);
            }
        } else if (info instanceof MyUrlFolderInfo) {
            this.siteTree.removeNodeFromParent((MutableTreeNode)node);
            MyUrlFolderInfo delFolderInfo = (MyUrlFolderInfo)info;
            if (MsgBox.showConfirm2((Component)this.mySitePanel, (String)strDelFolder) == 0) {
                ObjectUuidPK pk = new ObjectUuidPK(delFolderInfo.getId());
                if (this.iMyFolder == null) {
                    this.iMyFolder = MyUrlFolderFactory.getRemoteInstance();
                }
                this.iMyFolder.delete((IObjectPK)pk);
            }
        }
    }

    private void treeMousePress(MouseEvent e) {
        if (this.siteTree.getClosestPath(e.getX(), e.getY()) == null || this.siteTree.getPathForLocation(e.getX(), e.getY()) == null) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.siteTree.getLastSelectedPathComponent();
        MyFavoriteInfo myInfo = null;
        if (node == null) {
            return;
        }
        Object info = node.getUserObject();
        if (!(info instanceof MyFavoriteInfo)) {
            return;
        }
        myInfo = (MyFavoriteInfo)info;
        String strUrl = myInfo.getUrl();
        this.gotoSite(strUrl);
    }

    private void gotoSite(String url) {
        try {
            Runtime.getRuntime().exec("start " + url);
        }
        catch (Exception er) {
            try {
                Runtime.getRuntime().exec("cmd /c start " + url);
            }
            catch (Exception err) {
                try {
                    Runtime.getRuntime().exec("command.com /c start " + url);
                }
                catch (Exception errr) {
                    this.logger.error((Object)errr.getMessage(), (Throwable)errr);
                }
            }
        }
    }

    private MyFavoriteCollection getMyFavoiCollInFolder(MyUrlFolderInfo myFolderInfo) {
        MyFavoriteCollection myFavorColl = null;
        try {
            IMyFavorite iMyfavor = MyFavoriteFactory.getRemoteInstance();
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("user", (Object)this.userInfo.getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            filterItem = new FilterItemInfo("folder", (Object)myFolderInfo.getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            myFavorColl = iMyfavor.getMyFavoriteCollection(viewInfo);
        }
        catch (BOSException es) {
            this.logger.error((Object)es.getMessage(), (Throwable)es);
        }
        return myFavorColl;
    }

    private MyFavoriteCollection getMyFavoiCollInRoot() {
        return null;
    }

    private MyUrlFolderCollection getMyUrlFolderColl() {
        MyUrlFolderCollection myFolderColl = null;
        try {
            IMyUrlFolder iMyFolder = MyUrlFolderFactory.getRemoteInstance();
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("user", (Object)this.userInfo.getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            myFolderColl = iMyFolder.getMyUrlFolderCollection(viewInfo);
        }
        catch (BOSException es) {
            this.logger.error((Object)es.getMessage(), (Throwable)es);
        }
        return myFolderColl;
    }
}

