/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client.getpanel;

import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.myeas.client.getpanel.IMyEasInterPanel;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.IJob;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class GetMyInfoPanel
implements IMyEasInterPanel {
    private KDPanel myInfoPanel = new KDPanel();
    private KDContainer container = new KDContainer();
    private Action actRefresh = null;
    private KDPanel infoPanel = new KDPanel();
    private UserInfo userInfo = null;
    private IPerson iPerson = null;
    private PersonInfo personInfo = null;
    private int labelSize = 7;
    private JPopupMenu mnuOpenMethod1;
    private Logger logger = Logger.getLogger(GetMyInfoPanel.class);
    KDLabel lalName = new KDLabel();
    KDLabel lalGender = new KDLabel();
    KDLabel lalBirth = new KDLabel();
    KDLabel lalEmail = new KDLabel();
    KDLabel lalAddress = new KDLabel();
    KDLabel lalJob = new KDLabel();
    KDLabel lalPosition = new KDLabel();

    public GetMyInfoPanel() {
        this.myInfoPanel.setLayout((LayoutManager)new BorderLayout());
        this.container.setEnableActive(false);
        this.container.getContentPane().setLayout((LayoutManager)new KDLayout());
    }

    @Override
    public void setPanelTitle(String title) {
        this.container.setTitle(title);
        this.myInfoPanel.setName(title);
    }

    @Override
    public boolean isRequestThread() {
        return true;
    }

    @Override
    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    @Override
    public KDPanel returnPanel() {
        this.initPopMenu();
        this.addButtonToContainer();
        this.myInfoPanel.add((Component)this.container, (Object)"Center");
        this.infoPanel.setLayout((LayoutManager)new GridLayout(this.labelSize, 1));
        this.lalName.setText(InitUIForModel.getResource("PersonName"));
        this.lalGender.setText(InitUIForModel.getResource("PersonSex"));
        this.lalBirth.setText(InitUIForModel.getResource("PersonBirDate"));
        this.lalEmail.setText(InitUIForModel.getResource("PersonEmail"));
        this.lalAddress.setText(InitUIForModel.getResource("PersonAddress"));
        this.lalPosition.setText(InitUIForModel.getResource("PersonPosition"));
        this.lalJob.setText(InitUIForModel.getResource("PersonJob"));
        this.infoPanel.add((Component)this.lalName);
        this.infoPanel.add((Component)this.lalGender);
        this.infoPanel.add((Component)this.lalBirth);
        this.infoPanel.add((Component)this.lalEmail);
        this.infoPanel.add((Component)this.lalAddress);
        this.infoPanel.add((Component)this.lalPosition);
        this.infoPanel.add((Component)this.lalJob);
        this.container.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 100, 100));
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(8, 8, 84, 84);
        cons.anchor = 15;
        this.infoPanel.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        this.container.getContentPane().add((Component)this.infoPanel, null);
        return this.myInfoPanel;
    }

    private void addButtonToContainer() {
        this.actRefresh = new AbstractAction("", MyEasResource.getCommonIcon("imgTbtn_refresh")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GetMyInfoPanel.this.initData();
            }
        };
        this.actRefresh.setEnabled(false);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (e.getButton() == 3) {
                        GetMyInfoPanel.this.mnuOpenMethod1.show((Component)e.getSource(), e.getX(), e.getY());
                    }
                }
                catch (Exception es) {
                    GetMyInfoPanel.this.logger.error((Object)es.getMessage(), (Throwable)es);
                }
            }
        };
        this.container.addMouseListener((MouseListener)ml);
    }

    private void initPopMenu() {
        this.mnuOpenMethod1 = new JPopupMenu();
        JMenuItem menuitemRef = new JMenuItem(InitUIForModel.getResource("ButRefreshName"));
        menuitemRef.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GetMyInfoPanel.this.initData();
            }
        });
        this.mnuOpenMethod1.add(menuitemRef);
    }

    @Override
    public void initData() {
        try {
            Date dateB = new Date();
            this.infoPanel.setBackground(new Color(228, 228, 223));
            this.actRefresh.setEnabled(true);
            this.iPerson = PersonFactory.getRemoteInstance();
            if (this.userInfo.getPersonId() == null) {
                return;
            }
            ObjectUuidPK pk = new ObjectUuidPK(this.userInfo.getPersonId().getId());
            this.personInfo = this.iPerson.getPersonInfo((IObjectPK)pk);
            if (this.personInfo != null) {
                if (this.personInfo.getName() != null) {
                    this.lalName.setText(InitUIForModel.getResource("PersonName") + this.personInfo.getName());
                } else {
                    this.lalName.setText(InitUIForModel.getResource("PersonName"));
                }
                if (this.personInfo.getGender() != null) {
                    this.lalGender.setText(InitUIForModel.getResource("PersonSex") + this.personInfo.getGender().toString());
                } else {
                    this.lalGender.setText(InitUIForModel.getResource("PersonSex"));
                }
                if (this.personInfo.getBirthday() != null) {
                    this.lalBirth.setText(InitUIForModel.getResource("PersonBirDate") + this.personInfo.getBirthday().toString());
                } else {
                    this.lalBirth.setText(InitUIForModel.getResource("PersonBirDate"));
                }
                if (this.personInfo.getEmail() != null) {
                    this.lalEmail.setText(InitUIForModel.getResource("PersonEmail") + this.personInfo.getEmail());
                } else {
                    this.lalEmail.setText(InitUIForModel.getResource("PersonEmail"));
                }
                if (this.personInfo.getAddressTX() != null) {
                    this.lalAddress.setText(InitUIForModel.getResource("PersonAddress") + this.personInfo.getAddressTX());
                } else {
                    this.lalAddress.setText(InitUIForModel.getResource("PersonAddress"));
                }
                PositionInfo positionInfo = this.iPerson.getPrimaryPosition(this.personInfo.getId());
                if (positionInfo != null) {
                    this.lalPosition.setText(InitUIForModel.getResource("PersonPosition") + positionInfo.getName());
                    IJob iJob = JobFactory.getRemoteInstance();
                    if (positionInfo.getJob() != null) {
                        pk = new ObjectUuidPK(positionInfo.getJob().getId());
                        JobInfo jobInfo = iJob.getJobInfo((IObjectPK)pk);
                        if (jobInfo != null) {
                            this.lalJob.setText(InitUIForModel.getResource("PersonJob") + jobInfo.getName());
                        }
                    } else {
                        this.lalJob.setText(InitUIForModel.getResource("PersonJob"));
                    }
                } else {
                    this.lalPosition.setText(InitUIForModel.getResource("PersonPosition"));
                }
            }
        }
        catch (Exception es) {
            this.logger.error((Object)es.getMessage(), (Throwable)es);
        }
    }
}

