/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client.getpanel;

import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeHyperTextCellRenderer;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.myeas.IMyNews;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.myeas.MyNewsCollection;
import com.kingdee.eas.base.myeas.MyNewsFactory;
import com.kingdee.eas.base.myeas.MyNewsInfo;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.myeas.client.MyNewsEditUI;
import com.kingdee.eas.base.myeas.client.getpanel.IMyEasInterPanel;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.MainFrame;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.apache.log4j.Logger;

public class GetMyNewsPanel
implements IMyEasInterPanel {
    private UserInfo userInfo = null;
    private KDPanel myNewsPanel = new KDPanel();
    private KDContainer container = new KDContainer();
    private Action actNew = null;
    private Action actDel = null;
    private KDTree newsTree = new KDTree();
    private KDTreeView treeView = new KDTreeView();
    private JPopupMenu mnuOpenMethod1;
    private JMenuItem menuitemNew;
    private JMenuItem menuitemDel;
    private JMenuItem menuitemRef;
    private DefaultKingdeeTreeNode moveNode = null;
    private Logger logger = Logger.getLogger(GetMyNewsPanel.class);
    private IMyNews iMyNews = null;
    private Icon defaultIcon = MyEasResource.getCommonIcon("imgHotspot_1");
    private Icon moveIcon = MyEasResource.getCommonIcon("imgHotspot_2");

    public GetMyNewsPanel() {
        this.myNewsPanel.setLayout((LayoutManager)new BorderLayout());
        this.container.getContentPane().setLayout((LayoutManager)new KDLayout());
        this.treeView.setShowControlPanel(false);
        this.initContainer();
    }

    @Override
    public void setPanelTitle(String title) {
        this.container.setTitle(title);
    }

    @Override
    public boolean isRequestThread() {
        return true;
    }

    @Override
    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    @Override
    public KDPanel returnPanel() {
        this.initTreeView();
        this.myNewsPanel.add((Component)this.container, (Object)"Center");
        return this.myNewsPanel;
    }

    private void loadingTree() {
        DefaultKingdeeTreeNode top = new DefaultKingdeeTreeNode((Object)InitUIForModel.getResource(""));
        this.newsTree = new KDTree((ITreeNode)top);
        this.newsTree.setShowCheckBox(false);
        this.newsTree.setBackground(new Color(228, 228, 223));
        this.newsTree.setRootVisible(false);
        this.newsTree.setRowHeight(20);
        this.treeView.setBorder(null);
    }

    private void initTreeView() {
        this.loadingTree();
        this.treeView.setTree(this.newsTree);
        this.treeView.setShowButton(false);
    }

    private void initTreePopupMenu() {
        this.mnuOpenMethod1 = new JPopupMenu();
        this.menuitemNew = new JMenuItem(InitUIForModel.getResource("ButNewName"));
        this.menuitemNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GetMyNewsPanel.this.addNews();
            }
        });
        this.menuitemDel = new JMenuItem(InitUIForModel.getResource("ButDelName"));
        this.menuitemDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GetMyNewsPanel.this.delNews();
            }
        });
        this.menuitemRef = new JMenuItem(InitUIForModel.getResource("ButRefreshName"));
        this.menuitemRef.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GetMyNewsPanel.this.initData();
            }
        });
        this.mnuOpenMethod1.add(this.menuitemNew);
        this.mnuOpenMethod1.add(this.menuitemDel);
        this.mnuOpenMethod1.add(this.menuitemRef);
    }

    private void addNews() {
        try {
            String factoryName = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
            IUIFactory uiFactory = UIFactory.createUIFactory((String)factoryName);
            HashMap<String, MainFrame> mapContext = new HashMap<String, MainFrame>();
            HashMap mapData = new HashMap();
            MainFrame mainFrame = MainFrame.getCurMainFrame((Component)this.treeView);
            mapContext.put("Owner", mainFrame);
            IUIWindow window = uiFactory.create(MyNewsEditUI.class.getName(), mapContext, mapData, OprtState.ADDNEW);
            window.show();
            this.initData();
        }
        catch (Exception es) {
            this.logger.error((Object)es.getMessage(), (Throwable)es);
        }
    }

    private void delNews() {
        try {
            String strDelSite;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.newsTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object info = node.getUserObject();
            if (info instanceof MyNewsInfo && MsgBox.showConfirm2((Component)this.myNewsPanel, (String)(strDelSite = InitUIForModel.getResource("ConfirmDelete"))) == 0) {
                this.newsTree.removeNodeFromParent((MutableTreeNode)node);
                MyNewsInfo newsInfo = (MyNewsInfo)info;
                ObjectUuidPK pk = new ObjectUuidPK(newsInfo.getId());
                this.iMyNews.delete((IObjectPK)pk);
            }
        }
        catch (Exception es) {
            this.logger.error((Object)es.getMessage(), (Throwable)es);
        }
    }

    private void initContainer() {
        this.container.setEnableActive(false);
        this.container.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 100, 100));
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(0, 0, 92, 92);
        cons.anchor = 15;
        this.treeView.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        this.container.getContentPane().add((Component)this.treeView, null);
    }

    @Override
    public void initData() {
        try {
            this.initTreeData();
            this.newsTree.setBackground(new Color(228, 228, 223));
            this.newsTree.setRowHeight(20);
            this.treeView.setBorder(null);
        }
        catch (Exception es) {
            this.logger.error((Object)es.getMessage(), (Throwable)es);
        }
    }

    private void treeMousePress(MouseEvent e) throws Exception {
        if (this.newsTree.getClosestPath(e.getX(), e.getY()) == null || this.newsTree.getPathForLocation(e.getX(), e.getY()) == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.newsTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object info = node.getUserObject();
        if (info instanceof MyNewsInfo) {
            MyNewsInfo newsInfo = (MyNewsInfo)info;
            String factoryName = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
            IUIFactory uiFactory = UIFactory.createUIFactory((String)factoryName);
            HashMap<String, MainFrame> mapContext = new HashMap<String, MainFrame>();
            HashMap<String, MyNewsInfo> mapData = new HashMap<String, MyNewsInfo>();
            MainFrame mainFrame = MainFrame.getCurMainFrame((Component)this.treeView);
            mapContext.put("Owner", mainFrame);
            mapData.put("news", newsInfo);
            IUIWindow window = uiFactory.create(MyNewsEditUI.class.getName(), mapContext, mapData, OprtState.VIEW);
            window.show();
        }
    }

    private void initTreeData() throws Exception {
        MyNewsCollection myNewsColl = this.getMyNews();
        MyNewsInfo myNewsInfo = null;
        int size = myNewsColl.size();
        DefaultKingdeeTreeNode top = new DefaultKingdeeTreeNode((Object)InitUIForModel.getResource(""));
        DefaultKingdeeTreeNode newsNode = null;
        for (int i = 0; i < size; ++i) {
            myNewsInfo = myNewsColl.get(i);
            if (myNewsInfo.getName() != null) {
                newsNode = new DefaultKingdeeTreeNode((Object)myNewsInfo.getName().toString());
                newsNode.setTextColor(Color.BLUE);
            } else {
                newsNode = new DefaultKingdeeTreeNode((Object)"");
            }
            newsNode.setCustomIcon(this.defaultIcon);
            newsNode.setUserObject((Object)myNewsInfo);
            top.add((MutableTreeNode)newsNode);
        }
        this.newsTree = new KDTree((ITreeNode)top);
        this.newsTree.setRootVisible(false);
        this.newsTree.setShowCheckBox(false);
        this.newsTree.setCellRenderer((TreeCellRenderer)new KingdeeTreeHyperTextCellRenderer());
        this.treeView.setTree(this.newsTree);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (e.getButton() == 1) {
                        GetMyNewsPanel.this.treeMousePress(e);
                    } else if (e.getButton() == 3) {
                        GetMyNewsPanel.this.mnuOpenMethod1.show((Component)e.getSource(), e.getX(), e.getY());
                        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)GetMyNewsPanel.this.newsTree.getLastSelectedPathComponent();
                        GetMyNewsPanel.this.mnuOpenMethod1.show((Component)e.getSource(), e.getX(), e.getY());
                        if (node == null || node.getUserObject() == null) {
                            GetMyNewsPanel.this.menuitemDel.setEnabled(false);
                            GetMyNewsPanel.this.menuitemRef.setEnabled(false);
                        } else {
                            GetMyNewsPanel.this.menuitemDel.setEnabled(true);
                            GetMyNewsPanel.this.menuitemRef.setEnabled(true);
                        }
                    }
                }
                catch (Exception es) {
                    GetMyNewsPanel.this.logger.error((Object)es.getMessage(), (Throwable)es);
                }
            }
        };
        MouseMotionAdapter mmL = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                DefaultKingdeeTreeNode top = (DefaultKingdeeTreeNode)GetMyNewsPanel.this.newsTree.getModel().getRoot();
                if (GetMyNewsPanel.this.newsTree.getClosestPath(e.getX(), e.getY()) == null || GetMyNewsPanel.this.newsTree.getPathForLocation(e.getX(), e.getY()) == null) {
                    GetMyNewsPanel.this.myNewsPanel.setCursor(new Cursor(0));
                    return;
                }
                if (top.getChildCount() > 0) {
                    GetMyNewsPanel.this.myNewsPanel.setCursor(new Cursor(12));
                } else {
                    GetMyNewsPanel.this.myNewsPanel.setCursor(new Cursor(0));
                }
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)GetMyNewsPanel.this.newsTree.getPathForLocation(e.getX(), e.getY()).getLastPathComponent();
            }
        };
        this.newsTree.addMouseListener((MouseListener)ml);
        this.newsTree.addMouseMotionListener((MouseMotionListener)mmL);
        this.initTreePopupMenu();
        this.newsTree.setShowPopMenuDefaultItem(false);
    }

    private MyNewsCollection getMyNews() throws Exception {
        if (this.iMyNews == null) {
            this.iMyNews = MyNewsFactory.getRemoteInstance();
        }
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        MyNewsCollection myNewsColl = this.iMyNews.getMyNewsCollection(viewInfo);
        return myNewsColl;
    }
}

