/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client.getpanel;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.exception.NoOperationRithtException;
import com.kingdee.bos.workflow.exception.NotEnabledException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.myeas.client.getpanel.IMyEasInterPanel;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.MainFrame;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.base.wf.IMyProcess;
import com.kingdee.eas.base.wf.MyProcessCollection;
import com.kingdee.eas.base.wf.MyProcessDef;
import com.kingdee.eas.base.wf.MyProcessFactory;
import com.kingdee.eas.base.wf.client.CustomizeUI;
import com.kingdee.eas.base.wf.client.StartActList;
import com.kingdee.eas.base.wf.client.WFClientUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;

public class GetMyProcessPanel
implements IMyEasInterPanel,
ActionListener {
    private static final Logger logger = Logger.getLogger(GetMyProcessPanel.class);
    private KDPanel myProcessPanel = new KDPanel();
    private KDContainer container = new KDContainer();
    private KDPopupMenu popMenu = null;
    private KDList lstProcess = new KDList();
    private Action actEdit = null;
    private JPopupMenu mnuOpenMethod1;
    private JMenuItem menuitemView;
    private JMenuItem menuitemStart;
    private KDTreeView treeView = new KDTreeView();
    private KDTree treeProcess = new KDTree();
    private UserInfo userInfo = null;
    private ProcessDefInfo[] procDefArray = null;
    private MyProcessCollection myProCollection = null;
    private EASWfServiceClient ormClient = null;
    private IMyProcess iMyProcess = null;

    public GetMyProcessPanel() {
        this.myProcessPanel.setLayout((LayoutManager)new BorderLayout());
        this.container.getContentPane().setLayout((LayoutManager)new KDLayout());
        this.treeView.setShowControlPanel(false);
    }

    private Icon getIcon(String fileName) {
        Icon ico = null;
        String iconResourceName = "";
        if (fileName != null && fileName.length() != 0) {
            iconResourceName = EASResource.getString((String)"com.kingdee.eas.base.wf.client.WfProcessIcoResource", (String)fileName);
            if (iconResourceName.equals("Missing Resource")) {
                iconResourceName = "imgWf_defaultflow";
            }
        } else {
            iconResourceName = "imgWf_defaultflow";
        }
        if (ico == null) {
            ico = EASResource.getIcon((String)"imgWf_defaultflow");
        }
        return ico;
    }

    @Override
    public void setPanelTitle(String title) {
        this.container.setTitle(title);
        this.myProcessPanel.setName(title);
    }

    private void initTree() {
        this.treeProcess.setShowCheckBox(false);
        this.treeProcess.setBackground(new Color(228, 228, 223));
        this.treeProcess.setRowHeight(20);
        this.treeView.setBorder(null);
        this.treeProcess.setShowCheckBox(false);
    }

    private void loadingTree() {
        DefaultKingdeeTreeNode top = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"11_GetMyProcessPanel"));
        this.treeProcess = new KDTree((ITreeNode)top);
        this.initTree();
    }

    @Override
    public KDPanel returnPanel() {
        this.loadingTree();
        this.treeView.setTree(this.treeProcess);
        this.treeView.setShowButton(false);
        this.actEdit = new AbstractAction("", MyEasResource.getCommonIcon("imgTbtn_edit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GetMyProcessPanel.this.transferCustomizeUI(GetMyProcessPanel.this.userInfo);
            }
        };
        this.actEdit.setEnabled(true);
        this.container.add(this.actEdit);
        this.container.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 100, 100));
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(0, 0, 92, 92);
        cons.anchor = 15;
        this.treeView.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        this.container.getContentPane().add((Component)this.treeView, null);
        this.container.setTitleStyle(1);
        this.container.setEnableActive(false);
        this.myProcessPanel.add((Component)this.container, (Object)"Center");
        return this.myProcessPanel;
    }

    public void transferCustomizeUI(UserInfo u) {
        MainFrame mainFrame = MainFrame.getCurMainFrame((Component)this.myProcessPanel);
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("Owner", mainFrame);
            map.put("userInfo", u);
            map.put("procDefArray", this.procDefArray);
            map.put("client", this.ormClient);
            map.put("iMyProcess", this.iMyProcess);
            map.put("myProCollection", this.myProCollection);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CustomizeUI.class.getName(), map, null, null);
            uiWindow.show();
            if (((CustomizeUI)uiWindow.getUIObject()).returnValue) {
                this.setTreeData(((CustomizeUI)uiWindow.getUIObject()).myProCollection);
            }
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)mainFrame, (String)InitUIForModel.getResource("TransferCustomizeFailure"), (Throwable)e);
        }
    }

    private void getProcessOrientData() {
        String url = UIConfig.getUrl();
        try {
            this.ormClient = new EASWfServiceClient();
            this.ormClient.init(url, (String)SysContext.getSysContext().getProperty((Object)"SessionId"));
            this.procDefArray = this.ormClient.getProcDefArrayDistinctByUserID(this.userInfo.getId().toString());
        }
        catch (WfException e1) {
            ExceptionHandler.handle((Component)this.myProcessPanel, (String)EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"12_GetMyProcessPanel"), (Throwable)e1);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)this.myProcessPanel, (String)EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"13_GetMyProcessPanel"), (Throwable)e);
        }
        catch (IllegalArgumentException ex) {
            ExceptionHandler.handle((Component)this.myProcessPanel, (String)EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"14_GetMyProcessPanel"), (Throwable)ex);
        }
        catch (Exception es) {
            ExceptionHandler.handle((Component)this.myProcessPanel, (String)es.toString(), (Throwable)es);
        }
    }

    private void initMyProcessConllection() {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("userID", (Object)this.userInfo.getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        try {
            this.iMyProcess = MyProcessFactory.getRemoteInstance();
            this.myProCollection = this.iMyProcess.getMyProcessCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private MouseListener initPopMenu() {
        this.popMenu = new KDPopupMenu();
        KDMenuItem menuItem = new KDMenuItem(InitUIForModel.getResource("ProcessView"), 1);
        menuItem.addActionListener((ActionListener)this);
        this.popMenu.add((JMenuItem)menuItem);
        menuItem = new KDMenuItem(InitUIForModel.getResource("ProcessStart"), 2);
        menuItem.addActionListener((ActionListener)this);
        this.popMenu.add((JMenuItem)menuItem);
        PopupListener popupListener = new PopupListener(this.popMenu);
        return popupListener;
    }

    @Override
    public void initData() {
        this.initMyProcessConllection();
        this.getProcessOrientData();
        if (this.procDefArray == null) {
            this.setTreeData(null);
        } else {
            this.setTreeData(this.myProCollection);
        }
        this.actEdit.setEnabled(true);
        this.treeProcess.setShowCheckBox(false);
        this.treeProcess.setRootVisible(false);
        this.treeProcess.setBackground(new Color(228, 228, 223));
        this.treeProcess.setRowHeight(20);
        this.treeView.setBorder(null);
    }

    private void setTreeData(MyProcessCollection innerProCollection) {
        DefaultKingdeeTreeNode top = new DefaultKingdeeTreeNode((Object)InitUIForModel.getResource(""));
        DefaultKingdeeTreeNode newsNode = null;
        String fileName = "";
        MyProcessDef mpd = null;
        if (innerProCollection == null || innerProCollection.size() < 1) {
            this.treeProcess = new KDTree((ITreeNode)top);
            this.treeProcess.setRootVisible(false);
            this.initTree();
            this.treeView.setTree(this.treeProcess);
            return;
        }
        int size = innerProCollection.size();
        int length = this.procDefArray.length;
        block0: for (int i = 0; i < size; ++i) {
            String customProcId = innerProCollection.get(i).getProcessID().toString().trim();
            for (int j = 0; j < length; ++j) {
                if (!customProcId.equals(this.procDefArray[j].getProcDefId().trim())) continue;
                mpd = new MyProcessDef(this.procDefArray[j]);
                newsNode = new DefaultKingdeeTreeNode((Object)mpd);
                newsNode.setUserObject((Object)mpd);
                fileName = this.procDefArray[j].getIconName();
                newsNode.setCustomIcon(this.getIcon(fileName));
                top.add((MutableTreeNode)newsNode);
                continue block0;
            }
        }
        this.treeProcess = new KDTree((ITreeNode)top);
        this.treeProcess.setRootVisible(false);
        this.initTree();
        this.treeView.setTree(this.treeProcess);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (e.getButton() == 3) {
                        GetMyProcessPanel.this.mnuOpenMethod1.show((Component)e.getSource(), e.getX(), e.getY());
                        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)GetMyProcessPanel.this.treeProcess.getLastSelectedPathComponent();
                        GetMyProcessPanel.this.mnuOpenMethod1.show((Component)e.getSource(), e.getX(), e.getY());
                        if (node == null || node.getUserObject() == null) {
                            GetMyProcessPanel.this.menuitemStart.setEnabled(false);
                            GetMyProcessPanel.this.menuitemView.setEnabled(false);
                        } else {
                            GetMyProcessPanel.this.menuitemStart.setEnabled(true);
                            GetMyProcessPanel.this.menuitemView.setEnabled(true);
                        }
                    } else if (e.getButton() == 1 && e.getClickCount() == 2) {
                        GetMyProcessPanel.this.startProcess();
                    }
                }
                catch (Exception es) {
                    logger.error((Object)es.getMessage(), (Throwable)es);
                }
            }
        };
        this.treeProcess.addMouseListener((MouseListener)ml);
        this.initTreePopupMenu();
        this.treeProcess.setShowPopMenuDefaultItem(false);
    }

    private void initTreePopupMenu() {
        this.mnuOpenMethod1 = new JPopupMenu();
        this.menuitemView = new JMenuItem(InitUIForModel.getResource("ProcessView"));
        this.menuitemView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GetMyProcessPanel.this.viewProcess();
            }
        });
        this.menuitemStart = new JMenuItem(InitUIForModel.getResource("ProcessStart"));
        this.menuitemStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GetMyProcessPanel.this.startProcess();
            }
        });
        this.mnuOpenMethod1.add(this.menuitemView);
        this.mnuOpenMethod1.add(this.menuitemStart);
    }

    @Override
    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        KDMenuItem item = (KDMenuItem)e.getSource();
        ProcessDefInfo pif = (ProcessDefInfo)((KDPopupMenu)item.getParent()).getUserObject();
        if (item.getMnemonic() == 1 || item.getMnemonic() == 2) {
            // empty if block
        }
    }

    @Override
    public boolean isRequestThread() {
        return true;
    }

    private void startProcess() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeProcess.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object info = node.getUserObject();
        if (info instanceof MyProcessDef) {
            MyProcessDef myPD = (MyProcessDef)info;
            ProcessDefInfo procDefInfo = myPD.getProcessDef();
            MainFrame mainFrame = MainFrame.getCurMainFrame((Component)this.myProcessPanel);
            boolean isStartSuccessful = false;
            if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)mainFrame, (String)InitUIForModel.getResource("ConfirmStartProcess")))) {
                return;
            }
            try {
                ProcessDef procDef = EnactmentServiceFactory.createRemoteEnactService().getProcessDefByDefineHashValue(procDefInfo.getMd5HashValue());
                ActivityCollection actDefCol = procDef.getStartupActivities();
                if (actDefCol.size() == 0) {
                    MsgBox.showError((Component)this.myProcessPanel, (String)InitUIForModel.getResource("NoStartNode"));
                } else if (actDefCol.size() == 1) {
                    ActivityDef actDef = actDefCol.get(0);
                    isStartSuccessful = this.startCommonProcess(procDef, actDef, mainFrame);
                } else {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("actDefCol", actDefCol);
                    map.put("procDefInfo", procDefInfo);
                    map.put("Owner", mainFrame);
                    String factoryName = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)factoryName).create(StartActList.class.getName(), map, null, null);
                    uiWindow.show();
                    if (((StartActList)uiWindow.getUIObject()).selectedActDef != null) {
                        ActivityDef actDef = ((StartActList)uiWindow.getUIObject()).selectedActDef;
                        isStartSuccessful = this.startCommonProcess(procDef, actDef, mainFrame);
                    }
                }
            }
            catch (NotEnabledException ex) {
                ExceptionHandler.handle((Component)mainFrame, (String)EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"9_StartProcessProgressDialog"), (Throwable)ex);
            }
            catch (NoOperationRithtException et) {
                MsgBox.showError((Component)mainFrame, (String)EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"15_GetMyProcessPanel"));
            }
            catch (Exception e) {
                if (!isStartSuccessful) {
                    ExceptionHandler.handle((Component)mainFrame, (String)InitUIForModel.getResource("ProcessStartFailure"), (Throwable)e);
                }
                ExceptionHandler.handle((Component)mainFrame, (String)InitUIForModel.getResource("ProcessRunFailure"), (Throwable)e);
            }
        }
    }

    private boolean startCommonProcess(ProcessDef pDef, ActivityDef aDef, MainFrame mf) throws Exception {
        ProcessInstInfo procInstInfo = this.ormClient.createProcessInst(pDef.getID(), this.userInfo.getId().toString(), this.userInfo.getName());
        if (aDef instanceof ManpowerActivityDef) {
            this.ormClient.startProcessInst(procInstInfo.getProcInstId(), aDef.getID(), this.userInfo.getId().toString());
            AssignmentInfo[] assignInfoArray = this.ormClient.getAssignmentByProcInstAndOwner(procInstInfo.getProcInstId(), this.userInfo.getId().toString());
            if (assignInfoArray.length != 1) {
                MsgBox.showError((Component)mf, (String)InitUIForModel.getResource("ProcessNodeError"));
                return false;
            }
            AssignmentInfo assign = assignInfoArray[0];
            try {
                this.ormClient.invokeUI(new String[]{assign.getAssignmentId()}, (Object)mf, true, true);
                this.ormClient.abortProcessInst(procInstInfo.getProcInstId());
            }
            catch (Exception es) {
                logger.error((Object)es.getMessage(), (Throwable)es);
            }
        } else {
            this.ormClient.startProcessInst(procInstInfo.getProcInstId(), aDef.getID());
        }
        return true;
    }

    private void viewProcess() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeProcess.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object info = node.getUserObject();
        if (info instanceof MyProcessDef) {
            MyProcessDef myPD = (MyProcessDef)info;
            ProcessDefInfo procDefInfo = myPD.getProcessDef();
            MainFrame mainFrame = MainFrame.getCurMainFrame((Component)this.myProcessPanel);
            WFClientUtil cu = new WFClientUtil();
            cu.transferWfDefinePanel((Component)mainFrame, procDefInfo);
        }
    }

    public static ProcessDefInfo[] getProcessOrientData(String userID, Component owner) {
        String url = UIConfig.getUrl();
        ProcessDefInfo[] webProcDefArray = null;
        try {
            EASWfServiceClient ormClient = new EASWfServiceClient();
            ormClient.init(url, (String)SysContext.getSysContext().getProperty((Object)"SessionId"));
            webProcDefArray = ormClient.getProcDefArrayDistinctByUserID(userID);
        }
        catch (WfException e1) {
            ExceptionHandler.handle((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"12_GetMyProcessPanel"), (Throwable)e1);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"13_GetMyProcessPanel"), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception es) {
            ExceptionHandler.handle((Component)owner, (String)es.toString(), (Throwable)es);
        }
        return webProcDefArray;
    }

    public static boolean startProcess(ProcessDefInfo procDefInfo, Component owner, UserInfo thisUserInfo) {
        boolean isOK = false;
        Logger logger = Logger.getLogger(GetMyProcessPanel.class);
        ActivityDef actDef = null;
        ProcessInstInfo procInstInfo = null;
        EASWfServiceClient ormClient = null;
        if (procDefInfo == null) {
            MsgBox.showError((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"16_GetMyProcessPanel"));
            return isOK;
        }
        boolean isStartSuccessful = false;
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)owner, (String)InitUIForModel.getResource("ConfirmStartProcess")))) {
            return isOK;
        }
        try {
            ProcessDef procDef = EnactmentServiceFactory.createRemoteEnactService().getProcessDefByDefineHashValue(procDefInfo.getMd5HashValue());
            ActivityCollection actDefCol = procDef.getStartupActivities();
            if (actDefCol.size() == 0) {
                MsgBox.showError((Component)owner, (String)InitUIForModel.getResource("NoStartNode"));
            } else if (actDefCol.size() == 1) {
                actDef = actDefCol.get(0);
            } else {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("actDefCol", actDefCol);
                map.put("procDefInfo", procDefInfo);
                map.put("Owner", owner);
                String factoryName = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
                IUIWindow uiWindow = UIFactory.createUIFactory((String)factoryName).create(StartActList.class.getName(), map, null, null);
                uiWindow.show();
                if (((StartActList)uiWindow.getUIObject()).selectedActDef != null) {
                    actDef = ((StartActList)uiWindow.getUIObject()).selectedActDef;
                }
            }
            ormClient = new EASWfServiceClient();
            String url = UIConfig.getUrl();
            logger.info((Object)("url:" + url));
            logger.info((Object)("sessionid:" + (String)SysContext.getSysContext().getProperty((Object)"SessionId")));
            ormClient.init(url, (String)SysContext.getSysContext().getProperty((Object)"SessionId"));
            logger.info((Object)("procDef id:" + procDef.getID()));
            logger.info((Object)("user:" + thisUserInfo.getId().toString() + "  ----  " + thisUserInfo.getName()));
            procInstInfo = ormClient.createProcessInst(procDef.getID(), thisUserInfo.getId().toString(), thisUserInfo.getName());
            isStartSuccessful = true;
            if (actDef instanceof ManpowerActivityDef) {
                ormClient.startProcessInst(procInstInfo.getProcInstId(), actDef.getID(), thisUserInfo.getId().toString());
                AssignmentInfo[] assignInfoArray = ormClient.getAssignmentByProcInstAndOwner(procInstInfo.getProcInstId(), thisUserInfo.getId().toString());
                if (assignInfoArray.length != 1) {
                    ormClient.abortProcessInst(procInstInfo.getProcInstId());
                    return isOK;
                }
                AssignmentInfo assign = assignInfoArray[0];
                ormClient.invokeUI(new String[]{assign.getAssignmentId()}, (Object)owner, true, true);
            } else {
                ormClient.startProcessInst(procInstInfo.getProcInstId(), actDef.getID());
            }
            isOK = true;
        }
        catch (NotEnabledException ex) {
            ExceptionHandler.handle((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"9_StartProcessProgressDialog"), (Throwable)ex);
        }
        catch (NoOperationRithtException et) {
            if (isStartSuccessful && procInstInfo != null && ormClient != null) {
                try {
                    ormClient.abortProcessInst(procInstInfo.getProcInstId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            MsgBox.showError((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"17_GetMyProcessPanel"));
        }
        catch (Exception e) {
            if (isStartSuccessful && procInstInfo != null && ormClient != null) {
                try {
                    ormClient.abortProcessInst(procInstInfo.getProcInstId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!isStartSuccessful) {
                ExceptionHandler.handle((Component)owner, (String)InitUIForModel.getResource("ProcessStartFailure"), (Throwable)e);
            }
            ExceptionHandler.handle((Component)owner, (String)InitUIForModel.getResource("ProcessRunFailure"), (Throwable)e);
        }
        return isOK;
    }

    class PopupListener
    extends MouseAdapter {
        KDPopupMenu popup;

        PopupListener(KDPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (GetMyProcessPanel.this.lstProcess.getSelectedIndex() == -1) {
                    return;
                }
                MyProcessDef myPD = (MyProcessDef)GetMyProcessPanel.this.lstProcess.getSelectedValue();
                GetMyProcessPanel.this.popMenu.setUserObject((Object)myPD.getProcessDef());
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                if (GetMyProcessPanel.this.lstProcess.getSelectedIndex() == -1) {
                    return;
                }
                MyProcessDef myPD = (MyProcessDef)GetMyProcessPanel.this.lstProcess.getSelectedValue();
                return;
            }
        }
    }
}

