/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client.getpanel;

import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.myeas.client.getpanel.IMyEasInterPanel;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.MainFrame;
import com.kingdee.eas.common.client.OprtState;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;

public class GetMyReportPanel
implements IMyEasInterPanel {
    private KDPanel myRptPanel = new KDPanel();
    private KDContainer container = new KDContainer();
    private Action actRefresh = null;
    private Action actEdit = null;
    private KDTree rptTree = new KDTree();
    private KDTreeView treeView = new KDTreeView();
    private static Logger logger = Logger.getLogger(GetMyReportPanel.class);

    public GetMyReportPanel() {
        this.myRptPanel.setLayout((LayoutManager)new BorderLayout());
        this.container.getContentPane().setLayout((LayoutManager)new KDLayout());
        this.treeView.setShowControlPanel(false);
        this.initContainer();
    }

    @Override
    public void setPanelTitle(String title) {
        this.container.setTitle(title);
        this.myRptPanel.setName(title);
    }

    @Override
    public void setUserInfo(UserInfo userInfo) {
    }

    @Override
    public boolean isRequestThread() {
        return true;
    }

    @Override
    public KDPanel returnPanel() {
        this.initTreeView();
        this.myRptPanel.add((Component)this.container, (Object)"Center");
        return this.myRptPanel;
    }

    private void loadingTree() {
        DefaultKingdeeTreeNode top = new DefaultKingdeeTreeNode((Object)InitUIForModel.getResource(""));
        this.rptTree = new KDTree((ITreeNode)top);
        this.rptTree.setShowCheckBox(false);
        this.rptTree.setBackground(new Color(228, 228, 223));
        this.rptTree.setRootVisible(false);
        this.rptTree.setRowHeight(20);
        this.treeView.setBorder(null);
    }

    private void initTreeView() {
        this.loadingTree();
        this.treeView.setTree(this.rptTree);
        this.treeView.setShowButton(false);
    }

    @Override
    public void initData() {
        try {
            this.actRefresh.setEnabled(true);
            this.actEdit.setEnabled(true);
            this.setTreeData();
            this.rptTree.setBackground(new Color(228, 228, 223));
            this.rptTree.setRowHeight(26);
            this.treeView.setBorder(null);
        }
        catch (Exception es) {
            logger.error((Object)es.getMessage(), (Throwable)es);
        }
    }

    private void initContainer() {
        this.actRefresh = new AbstractAction("", MyEasResource.getCommonIcon("imgTbtn_refresh")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GetMyReportPanel.this.initData();
            }
        };
        this.actEdit = new AbstractAction("", MyEasResource.getCommonIcon("imgTbtn_edit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GetMyReportPanel.this.showReportUI(null, true);
                }
                catch (Exception es) {
                    logger.error((Object)es.getMessage(), (Throwable)es);
                }
            }
        };
        this.container.add(this.actEdit);
        this.container.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 100, 100));
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(0, 0, 84, 84);
        cons.anchor = 15;
        this.treeView.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        this.container.getContentPane().add((Component)this.treeView, null);
        this.container.setEnableActive(false);
        this.actRefresh.setEnabled(false);
        this.actEdit.setEnabled(false);
    }

    private void initTreePopupMenu() {
        this.rptTree.setShowPopMenuDefaultItem(false);
        JMenuItem menuitemRef = new JMenuItem(InitUIForModel.getResource("ButRefreshName"));
        this.rptTree.getPopupMenu().add(menuitemRef);
        menuitemRef.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GetMyReportPanel.this.initData();
            }
        });
        this.rptTree.addTreePopupMenu(new TreePopupMenuListener(){

            public boolean popMenu(TreePopupMenuEvent e) {
                JPopupMenu menu = e.getMenu();
                return true;
            }
        });
    }

    private void setTreeData() throws Exception {
        IQuerySolutionFacade iQuerySolu = QuerySolutionFacadeFactory.getRemoteInstance();
        QuerySolutionCollection querySoluColl = null;
        QuerySolutionInfo querySoluInfo = null;
        DefaultKingdeeTreeNode top = new DefaultKingdeeTreeNode((Object)InitUIForModel.getResource(""));
        DefaultKingdeeTreeNode rptNode = null;
        String queryName = "com.kingdee.eas.fi.rpt.app.ReportQuery";
        String parentUIName = "com.kingdee.eas.fi.rpt.client.ReportListUI";
        querySoluColl = iQuerySolu.getQuerySolutions(parentUIName, queryName);
        for (int i = 0; i < querySoluColl.size(); ++i) {
            querySoluInfo = querySoluColl.get(i);
            rptNode = new DefaultKingdeeTreeNode((Object)querySoluInfo.getName().toString());
            rptNode.setUserObject((Object)querySoluInfo);
            rptNode.setCustomIcon(MyEasResource.getCommonIcon("imgBill_myreportforms"));
            top.add((MutableTreeNode)rptNode);
        }
        this.rptTree = new KDTree((ITreeNode)top);
        this.rptTree.setRootVisible(false);
        this.rptTree.setShowCheckBox(false);
        this.treeView.setTree(this.rptTree);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (e.getButton() == 1) {
                        GetMyReportPanel.this.treeMousePress(e);
                    }
                }
            }
        };
        this.rptTree.addMouseListener((MouseListener)ml);
        this.initTreePopupMenu();
    }

    private void treeMousePress(MouseEvent e) {
        if (this.rptTree.getClosestPath(e.getX(), e.getY()) == null || this.rptTree.getPathForLocation(e.getX(), e.getY()) == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.rptTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object info = node.getUserObject();
        if (info instanceof QuerySolutionInfo) {
            QuerySolutionInfo queryInfo = (QuerySolutionInfo)info;
            this.showReportUI(queryInfo, false);
        }
    }

    private void showReportUI(QuerySolutionInfo queryInfo, boolean isCommSearch) {
        String soluID = "";
        try {
            String factoryName = "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
            IUIFactory uiFactory = UIFactory.createUIFactory((String)factoryName);
            HashMap<String, Object> mapContext = new HashMap<String, Object>();
            HashMap mapData = new HashMap();
            MainFrame mainFrame = MainFrame.getCurMainFrame((Component)this.treeView);
            if (queryInfo != null) {
                soluID = queryInfo.getId().toString();
                mapContext.put("isCommSearch", isCommSearch);
                mapContext.put("SoluID", soluID);
            }
            mapContext.put("Owner", mainFrame);
            IUIWindow window = uiFactory.create("com.kingdee.eas.fi.rpt.client.ReportListUI", mapContext, mapData, OprtState.ADDNEW);
            window.show();
        }
        catch (UIException es) {
            logger.error((Object)es.getMessage(), (Throwable)es);
        }
    }

    public static QuerySolutionCollection getMyReportColl() throws Exception {
        IQuerySolutionFacade iQuerySolu = QuerySolutionFacadeFactory.getRemoteInstance();
        QuerySolutionCollection querySoluColl = null;
        String queryName = "com.kingdee.eas.fi.rpt.app.ReportQuery";
        String parentUIName = "com.kingdee.eas.fi.rpt.client.ReportListUI";
        querySoluColl = iQuerySolu.getQuerySolutions(parentUIName, queryName);
        return querySoluColl;
    }

    public static void showReportUI(QuerySolutionInfo queryInfo, boolean isCommSearch, Component owner) {
        String soluID = "";
        try {
            String factoryName = "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
            IUIFactory uiFactory = UIFactory.createUIFactory((String)factoryName);
            HashMap<String, Object> mapContext = new HashMap<String, Object>();
            HashMap mapData = new HashMap();
            if (queryInfo != null) {
                soluID = queryInfo.getId().toString();
                mapContext.put("isCommSearch", isCommSearch);
                mapContext.put("SoluID", soluID);
            }
            mapContext.put("Owner", owner);
            IUIWindow window = uiFactory.create("com.kingdee.eas.fi.rpt.client.ReportListUI", mapContext, mapData, OprtState.ADDNEW);
            window.show();
        }
        catch (UIException es) {
            logger.error((Object)es.getMessage(), (Throwable)es);
        }
    }
}

