/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.client.getpanel;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.exception.NoOperationRithtException;
import com.kingdee.bos.workflow.exception.NotEnabledException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.myeas.client.InitUIForModel;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.base.wf.client.StartActList;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IUILifeCycleListener;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.framework.client.workflow.TempBizProcRelationListenter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class StartProcessProgressDialog
extends KDDialog {
    private static final String TITLE = UIFrameResource.getString((String)"invokeFunction");
    private static final Logger logger = Logger.getLogger((String)StartProcessProgressDialog.class.getName());
    private Component parent = null;
    private String procDefId = null;
    private String userId = null;
    private boolean bReturn = false;
    private StartProcessProgressDialog dialog = null;

    public boolean isBReturn() {
        return this.bReturn;
    }

    public void setBReturn(boolean return1) {
        this.bReturn = return1;
    }

    public StartProcessProgressDialog() {
        this.setTitle(TITLE);
    }

    public String getProcDefId() {
        return this.procDefId;
    }

    public void setProcDefId(String procDefId) {
        this.procDefId = procDefId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public StartProcessProgressDialog(Frame frame) {
        super(frame, TITLE, true);
        this.parent = frame;
    }

    public StartProcessProgressDialog(Frame frame, String title) {
        super(frame, title, true);
        this.parent = frame;
    }

    public StartProcessProgressDialog(Dialog dialog) {
        super(dialog, TITLE, true);
        this.parent = dialog;
    }

    public StartProcessProgressDialog(Dialog dialog, String title) {
        super(dialog, title, true);
        this.parent = dialog;
    }

    protected void dialogInit() {
        super.dialogInit();
        this.setResizable(false);
        this.setSize(250, 70);
        this.getContentPane().setLayout(null);
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
        KDProgressBar progressBar = new KDProgressBar();
        progressBar.setStringPainted(false);
        progressBar.setIndeterminate(true);
        this.getContentPane().add((Component)progressBar, null);
        progressBar.setBounds(new Rectangle(10, 10, 222, 19));
    }

    public void show() {
        this.dialog = this;
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                    StartProcessProgressDialog.this.bReturn = StartProcessProgressDialog.this.startProcess(StartProcessProgressDialog.this.procDefId, StartProcessProgressDialog.this.userId, (Component)((Object)StartProcessProgressDialog.this.dialog));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StartProcessProgressDialog.this.dispose();
                        }
                    });
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    StartProcessProgressDialog.this.dispose();
                }
            }
        };
        thread.start();
        super.show();
    }

    private boolean startProcess(String procDefId, String userId, Component owner) {
        UserInfo thisUserInfo;
        ProcessDefInfo procDefInfo;
        IEnactmentService service = null;
        try {
            boolean canStart = false;
            service = EnactmentServiceFactory.createRemoteEnactService();
            canStart = service.canStartProcess(userId, procDefId);
            if (!canStart) {
                MsgBox.showError((Component)owner, (String)MyEasResource.getString("canNotStartProc"));
                SysUtil.abort();
            }
        }
        catch (BOSException e) {
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"6_StartProcessProgressDialog"));
        }
        try {
            EASWfServiceClient ormClient = new EASWfServiceClient();
            ormClient.init(UIConfig.getUrl(), SysContext.getSysContext().getSessionID());
            procDefInfo = ormClient.getProcessDefInfo(procDefId);
            thisUserInfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)userId)));
        }
        catch (Exception e) {
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"7_StartProcessProgressDialog"), (Throwable)e);
            this.dispose();
            ExceptionHandler.handle((Component)owner, (Throwable)e);
            return false;
        }
        boolean isOK = false;
        ActivityDef actDef = null;
        ProcessInstInfo procInstInfo = null;
        EASWfServiceClient ormClient = null;
        if (procDefInfo == null) {
            MsgBox.showError((Component)owner, (String)MyEasResource.getString("noProcessTOStart"));
            return isOK;
        }
        boolean isStartSuccessful = false;
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)owner, (String)InitUIForModel.getResource("ConfirmStartProcess")))) {
            this.dispose();
            return isOK;
        }
        try {
            service = EnactmentServiceFactory.createRemoteEnactService();
            ProcessDef procDef = service.getProcessDefByDefineHashValue(procDefInfo.getMd5HashValue());
            ActivityCollection actDefCol = procDef.getStartupActivities();
            if (actDefCol.size() == 0) {
                this.dispose();
                MsgBox.showError((Component)owner, (String)InitUIForModel.getResource("NoStartNode"));
            } else if (actDefCol.size() == 1) {
                actDef = actDefCol.get(0);
            } else {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("actDefCol", actDefCol);
                map.put("procDefInfo", procDefInfo);
                map.put("Owner", owner);
                map.put("canResize", "true");
                String factoryName = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
                IUIWindow uiWindow = null;
                try {
                    uiWindow = UIFactory.createUIFactory((String)factoryName).create(StartActList.class.getName(), map, null, null);
                }
                catch (UIException uie) {
                    logger.error((Object)EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"8_StartProcessProgressDialog"), (Throwable)uie);
                    ExceptionHandler.handle((Throwable)uie);
                }
                uiWindow.show();
                if (((StartActList)uiWindow.getUIObject()).selectedActDef != null) {
                    actDef = ((StartActList)uiWindow.getUIObject()).selectedActDef;
                } else {
                    this.dispose();
                    return isOK;
                }
            }
            if (actDef instanceof ManpowerActivityDef) {
                String actId = actDef.getID();
                String uiStartClassName = service.getStartupActivityUIClass(procDefId, actId);
                logger.info((Object)("uiStartClassName" + uiStartClassName));
                String uiOprtState = OprtState.ADDNEW;
                UIContext uiContext = new UIContext((Object)this);
                IUIWindow uiWindow = null;
                try {
                    uiContext.put((Object)"ID", null);
                    uiContext.put((Object)"canResize", (Object)"true");
                    String factoryName = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
                    uiWindow = UIFactory.createUIFactory((String)factoryName).create(uiStartClassName, (Map)uiContext, null, uiOprtState);
                }
                catch (UIException uie) {
                    logger.error((Object)EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"8_StartProcessProgressDialog"), (Throwable)uie);
                    ExceptionHandler.handle((Throwable)uie);
                    return false;
                }
                CoreUI coreUI = (CoreUI)uiWindow.getUIObject();
                coreUI.getUILifeCycleHandler().addRuleListener((IUILifeCycleListener)new TempBizProcRelationListenter(procDefId));
                if (coreUI.getDataObject() != null) {
                    coreUI.getDataObject().setExtendedProperty("TBPR_ProcDefID", procDefId);
                }
                if (coreUI instanceof CoreBillEditUI && ((CoreBillEditUI)coreUI).getEditData() != null) {
                    ((CoreBillEditUI)coreUI).getEditData().setExtendedProperty("TBPR_ProcDefID", procDefId);
                }
                uiWindow.show();
            } else {
                ormClient = new EASWfServiceClient();
                String url = UIConfig.getUrl();
                logger.info((Object)("url:" + url));
                ormClient.init(url, (String)SysContext.getSysContext().getProperty((Object)"SessionId"));
                logger.info((Object)("procDef id:" + procDef.getID()));
                logger.info((Object)("user:" + thisUserInfo.getId().toString() + "  ----  " + thisUserInfo.getName()));
                procInstInfo = ormClient.createProcessInst(procDef.getID(), thisUserInfo.getId().toString(), thisUserInfo.getName());
                isStartSuccessful = true;
                ormClient.startProcessInst(procInstInfo.getProcInstId(), actDef.getID());
            }
            isOK = true;
        }
        catch (NotEnabledException ex) {
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"9_StartProcessProgressDialog"), (Throwable)ex);
            this.dispose();
            ExceptionHandler.handle((Component)owner, (String)InitUIForModel.getResource("processhavenotcommit"), (Throwable)ex);
        }
        catch (NoOperationRithtException et) {
            this.dispose();
            if (isStartSuccessful && procInstInfo != null && ormClient != null) {
                try {
                    ormClient.abortProcessInst(procInstInfo.getProcInstId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ExceptionHandler.handle((Component)owner, (String)InitUIForModel.getResource("youhavenotleft"), (Throwable)et);
        }
        catch (Exception e) {
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.base.myeas.MYEASAutoGenerateResource", (String)"10_StartProcessProgressDialog"), (Throwable)e);
            this.dispose();
            if (isStartSuccessful && procInstInfo != null && ormClient != null) {
                try {
                    ormClient.abortProcessInst(procInstInfo.getProcInstId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!isStartSuccessful) {
                ExceptionHandler.handle((Component)owner, (String)InitUIForModel.getResource("ProcessStartFailure"), (Throwable)e);
            }
            ExceptionHandler.handle((Component)owner, (String)InitUIForModel.getResource("ProcessRunFailure"), (Throwable)e);
        }
        return isOK;
    }
}

