/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.util;

import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ClientPersonalSetUtil {
    private static Logger logger = Logger.getLogger(ClientPersonalSetUtil.class);
    public static final String EASROOT = "easclient.root";
    private static final String DEFAULTROOTDIR = "w:\\eas\\deploy\\client";
    private static XMLConfiguration configuration;
    public static final String CONFIGFILE = "clientPersonalSet.xml";
    private static final String CLIENTROOT = "user.dir";
    public static final String loginlogo = "loginlogo";
    public static final String imgKingdeeonline = "imgKingdeeonline";
    public static final String imgLogo_youshang = "imgLogo_youshang";
    public static final String splash = "splash";
    public static final String imgPic_login_logo = "imgPic_login_logo";
    public static final String imgPic_login_youshang = "imgPic_login_youshang";
    public static final String imgPic_login_name = "imgPic_login_name";
    public static final String imgEas_16 = "imgEas_16";
    public static final String imgPic_login_bg = "imgPic_login_bg";
    public static final String imgPic_about = "imgPic_about";
    public static final String welcome = "welcome";
    public static final String servicelimit = "servicelimit";
    public static final String messagecenter_eastitle = "messagecenter_eastitle";
    public static final String login_title = "login_title";
    public static final String AboutDlg_name = "AboutDlg_name";
    public static final String AboutDlg_info = "AboutDlg_info";
    public static final String mainui_logo = "mainui_logo";
    private static boolean isLoadFile;
    public static final String CLIENTLANGUAGE_PROPERTIES = "language.properties";

    public static void loadPersonalSetControlFile() {
        String fileName = System.getProperty(EASROOT) == null ? "w:\\eas\\deploy\\client/clientPersonalSet.xml" : System.getProperty(EASROOT).trim() + "/" + CONFIGFILE;
        File cfgFile = new File(fileName);
        if (cfgFile.exists()) {
            try {
                configuration = XMLConfiguration.getInstance((File)cfgFile);
            }
            catch (Throwable e) {
                configuration = null;
                logger.error((Object)"load file clientPersonalSet.xml  fail");
            }
        } else {
            logger.debug((Object)"cann't find the config file clientPersonalSet.xml!");
        }
    }

    public static void init() {
        if (configuration == null && isLoadFile) {
            ClientPersonalSetUtil.loadPersonalSetControlFile();
            isLoadFile = false;
        }
    }

    public static ConfigurationItem getConfigItem(String name) {
        ClientPersonalSetUtil.init();
        ConfigurationItem configItem = null;
        if (null != configuration) {
            configItem = configuration.getConfigItem(name);
        }
        return configItem;
    }

    public static String getAttributeByLocale(ConfigurationItem cfgitem, String propertyname, Locale locale) {
        ClientPersonalSetUtil.init();
        if (null == cfgitem) {
            return null;
        }
        String visible = cfgitem.getProperty("visible");
        if (visible != null && "false".equals(visible)) {
            return null;
        }
        String localeStr = "";
        if (locale == null) {
            localeStr = "L2";
        } else if (locale.toString().trim().equals("zh_CN") || locale.toString().trim().equalsIgnoreCase("L2")) {
            localeStr = "L2";
        } else if (locale.toString().trim().equals("zh_TW") || locale.toString().trim().equalsIgnoreCase("L3")) {
            localeStr = "L3";
        } else if (locale.toString().trim().equals("en_US") || locale.toString().trim().equalsIgnoreCase("L1")) {
            localeStr = "L1";
        }
        propertyname = propertyname + "_" + localeStr;
        return cfgitem.getProperty(propertyname);
    }

    public static String getTextAttributeByLocale(int rootype, String configname, String propertyname, Locale locale) {
        ClientPersonalSetUtil.init();
        ConfigurationItem cfgitemroot = null;
        if (rootype == 1) {
            cfgitemroot = ClientPersonalSetUtil.getConfigItem("picture");
        } else if (rootype == 2) {
            cfgitemroot = ClientPersonalSetUtil.getConfigItem("text");
        }
        if (null == cfgitemroot) {
            return null;
        }
        ConfigurationItem cfgitem = cfgitemroot.getChild(configname);
        if (null == cfgitem) {
            return null;
        }
        String visible = cfgitem.getProperty("visible");
        if (visible != null && "false".equals(visible)) {
            return null;
        }
        String localeStr = "";
        if (locale == null) {
            localeStr = "L2";
        } else if (locale.toString().trim().equals("zh_CN") || locale.toString().trim().equalsIgnoreCase("L2")) {
            localeStr = "L2";
        } else if (locale.toString().trim().equals("zh_TW") || locale.toString().trim().equalsIgnoreCase("L3")) {
            localeStr = "L3";
        } else if (locale.toString().trim().equals("en_US") || locale.toString().trim().equalsIgnoreCase("L1")) {
            localeStr = "L1";
        }
        propertyname = propertyname + "_" + localeStr;
        return cfgitem.getProperty(propertyname);
    }

    public static boolean isTextVisible(String configname) {
        ClientPersonalSetUtil.init();
        ConfigurationItem cfgitemroot = ClientPersonalSetUtil.getConfigItem("text");
        if (null == cfgitemroot) {
            return true;
        }
        ConfigurationItem cfgitem = cfgitemroot.getChild(configname);
        if (null == cfgitem) {
            return true;
        }
        String visible = cfgitem.getProperty("visible");
        return !"false".equalsIgnoreCase(visible);
    }

    public static String getTextAttributeByLocaleOnlyClient(String configname, Locale locale) {
        ClientPersonalSetUtil.init();
        ConfigurationItem cfgitemroot = ClientPersonalSetUtil.getConfigItem("text");
        if (null == cfgitemroot) {
            return null;
        }
        ConfigurationItem cfgitem = cfgitemroot.getChild(configname);
        if (null == cfgitem) {
            return null;
        }
        String visible = cfgitem.getProperty("visible");
        if (visible != null && "false".equals(visible)) {
            return null;
        }
        String localeStr = "";
        if (locale == null) {
            localeStr = "L2";
        } else if (locale.toString().trim().equals("zh_CN") || locale.toString().trim().equalsIgnoreCase("L2")) {
            localeStr = "L2";
        } else if (locale.toString().trim().equals("zh_TW") || locale.toString().trim().equalsIgnoreCase("L3")) {
            localeStr = "L3";
        } else if (locale.toString().trim().equals("en_US") || locale.toString().trim().equalsIgnoreCase("L1")) {
            localeStr = "L1";
        }
        String textattributekey = "content_" + localeStr;
        return cfgitem.getProperty(textattributekey);
    }

    public static String getLinktipsByLocale(int roodnodetype, String configname, Locale locale) {
        ClientPersonalSetUtil.init();
        ConfigurationItem cfgitemroot = null;
        if (roodnodetype == 1) {
            cfgitemroot = ClientPersonalSetUtil.getConfigItem("picture");
        } else if (roodnodetype == 2) {
            cfgitemroot = ClientPersonalSetUtil.getConfigItem("text");
        }
        if (null == cfgitemroot) {
            return null;
        }
        ConfigurationItem cfgitem = cfgitemroot.getChild(configname);
        if (null == cfgitem) {
            return null;
        }
        String visible = cfgitem.getProperty("visible");
        if (visible != null && "false".equals(visible)) {
            return null;
        }
        String localeStr = "";
        if (locale == null) {
            localeStr = "L2";
        } else if (locale.toString().trim().equals("zh_CN") || locale.toString().trim().equalsIgnoreCase("L2")) {
            localeStr = "L2";
        } else if (locale.toString().trim().equals("zh_TW") || locale.toString().trim().equalsIgnoreCase("L3")) {
            localeStr = "L3";
        } else if (locale.toString().trim().equals("en_US") || locale.toString().trim().equalsIgnoreCase("L1")) {
            localeStr = "L1";
        }
        String propertyname = "linktips_" + localeStr;
        return cfgitem.getProperty(propertyname);
    }

    public static String getColorUiStyle() {
        String colorstr = "01";
        int colorStyle = UIConfig.getUiColorStyle();
        switch (colorStyle) {
            case 5: {
                colorstr = "01";
                break;
            }
            case 2: {
                colorstr = "03";
                break;
            }
            case 0: {
                colorstr = "04";
                break;
            }
            case 4: {
                colorstr = "02";
            }
        }
        return colorstr;
    }

    public static boolean isVisible(String configname) {
        ClientPersonalSetUtil.init();
        ConfigurationItem cfgitemroot = ClientPersonalSetUtil.getConfigItem("picture");
        if (null == cfgitemroot) {
            return true;
        }
        ConfigurationItem cfgitem = cfgitemroot.getChild(configname);
        if (null == cfgitem) {
            return true;
        }
        String visible = cfgitem.getProperty("visible");
        return !"false".equalsIgnoreCase(visible);
    }

    public static String getAtributeForPicPathByconfignameOnlyClient(String configname) {
        File picfile;
        ClientPersonalSetUtil.init();
        ConfigurationItem cfgitemroot = ClientPersonalSetUtil.getConfigItem("picture");
        if (null == cfgitemroot) {
            return null;
        }
        ConfigurationItem cfgitem = cfgitemroot.getChild(configname);
        if (null == cfgitem) {
            return null;
        }
        String visible = cfgitem.getProperty("visible");
        if (visible != null && "false".equals(visible)) {
            return null;
        }
        String propertyname = "color_" + ClientPersonalSetUtil.getColorUiStyle();
        String picname = cfgitem.getProperty(propertyname);
        logger.debug((Object)("picname==client===" + picname));
        String picpath = "";
        picpath = picname != null && !"".equals(picname) ? System.getProperty(CLIENTROOT).trim() + "/deploy/images/clientimage/" + picname : null;
        logger.debug((Object)("picpath==client===" + picpath));
        if (picpath != null && !(picfile = new File(picpath)).exists()) {
            picpath = null;
        }
        return picpath;
    }

    public static String getAtributeByPropertiesForPicPath(String cfgname, String attributekeyname) {
        ClientPersonalSetUtil.init();
        ConfigurationItem cfgitemroot = ClientPersonalSetUtil.getConfigItem("picture");
        if (null == cfgitemroot) {
            return null;
        }
        ConfigurationItem cfgitem = cfgitemroot.getChild(cfgname);
        if (null == cfgitem) {
            return null;
        }
        String visible = cfgitem.getProperty("visible");
        if (visible != null && "false".equals(visible)) {
            return null;
        }
        attributekeyname = attributekeyname + "_" + ClientPersonalSetUtil.getColorUiStyle();
        String picname = cfgitem.getProperty(attributekeyname);
        String picpath = "";
        picpath = picname != null && !"".equals(picname) ? System.getProperty(CLIENTROOT).trim() + "/client/deploy/images/clientimage/" + picname : null;
        return picpath;
    }

    public static String getLink(int roodnodetype, String configname) {
        ClientPersonalSetUtil.init();
        ConfigurationItem cfgitemroot = null;
        if (roodnodetype == 1) {
            cfgitemroot = ClientPersonalSetUtil.getConfigItem("picture");
        } else if (roodnodetype == 2) {
            cfgitemroot = ClientPersonalSetUtil.getConfigItem("text");
        }
        if (null == cfgitemroot) {
            return null;
        }
        ConfigurationItem cfgitem = cfgitemroot.getChild(configname);
        if (null == cfgitem) {
            return null;
        }
        String visible = cfgitem.getProperty("visible");
        if (visible != null && "false".equals(visible)) {
            return null;
        }
        String url = cfgitem.getProperty("linkAddress");
        if (!StringUtils.isEmpty((String)url)) {
            url = url.replaceAll("&", "^&");
        }
        return url;
    }

    public static boolean getIsVisbleTextAttributeByLocaleOnlyClient(String configname, Locale locale) {
        ClientPersonalSetUtil.init();
        boolean isvisble = true;
        ConfigurationItem cfgitemroot = ClientPersonalSetUtil.getConfigItem("text");
        if (null == cfgitemroot) {
            return false;
        }
        ConfigurationItem cfgitem = cfgitemroot.getChild(configname);
        if (null == cfgitem) {
            return false;
        }
        String visible = cfgitem.getProperty("visible");
        if (visible != null && "false".equals(visible)) {
            return false;
        }
        return isvisble;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadlanguagePro() {
        String langpath = System.getProperty(CLIENTROOT).trim() + "/bin/" + CLIENTLANGUAGE_PROPERTIES;
        File proFile = new File(langpath);
        Properties properties = new Properties();
        if (proFile.exists()) {
            try (FileInputStream inputStream = null;){
                File file = proFile;
                synchronized (file) {
                    inputStream = new FileInputStream(proFile);
                }
                properties.load(inputStream);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTolanguagePro(Properties properties) {
        try {
            String langpath = System.getProperty(CLIENTROOT).trim() + "/bin/" + CLIENTLANGUAGE_PROPERTIES;
            File updateFile = new File(langpath);
            if (updateFile.exists()) {
                updateFile.delete();
            }
            updateFile.createNewFile();
            File file = updateFile;
            synchronized (file) {
                try (FileOutputStream fos = null;){
                    fos = new FileOutputStream(updateFile);
                    properties.store(fos, null);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void setloginlanguageInpro(String languagestr) {
        languagestr = ClientPersonalSetUtil.translateToOriginalLocale(languagestr);
        Properties properties = ClientPersonalSetUtil.loadlanguagePro();
        properties.setProperty("loginlanguage", languagestr);
        ClientPersonalSetUtil.saveTolanguagePro(properties);
    }

    private static String translateToOriginalLocale(String languagestr) {
        if ("l2".equalsIgnoreCase(languagestr)) {
            return "zh_CN";
        }
        if ("l3".equalsIgnoreCase(languagestr)) {
            return "zh_TW";
        }
        if ("l1".equalsIgnoreCase(languagestr)) {
            return "en_US";
        }
        return languagestr;
    }

    public static String getloginlanguageInpro() {
        Properties properties = ClientPersonalSetUtil.loadlanguagePro();
        String languagestr = properties.getProperty("loginlanguage");
        languagestr = ClientPersonalSetUtil.translateToOriginalLocale(languagestr);
        return languagestr;
    }

    public static String getDefaultTheme() {
        ClientPersonalSetUtil.init();
        ConfigurationItem cfgitemroot = ClientPersonalSetUtil.getConfigItem("picture");
        if (null == cfgitemroot) {
            return null;
        }
        ConfigurationItem cfgitem = cfgitemroot.getChild("theme");
        if (null == cfgitem) {
            return "dark";
        }
        String style = cfgitem.getProperty("style");
        return style;
    }

    static {
        isLoadFile = true;
    }
}

