/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.netctrl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.netctrl.ObjectUpdateLock;
import com.kingdee.eas.base.netctrl.client.AbstractMutexMainListUI;
import com.kingdee.eas.base.netctrl.client.FilterItem;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.framework.client.FindListEvent;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class MutexMainListUI
extends AbstractMutexMainListUI {
    Logger logger = Logger.getLogger(MutexMainListUI.class);
    String resClass = "com.kingdee.eas.base.netctrl.client.MutexServiceResource.";
    private final int OBJECT_LOCK = 0;
    private final int MUTEX_LOCK = 1;
    private List filterInfo = new ArrayList();
    static final long DELAY_TIME = 100000000L;
    Timer timer;
    long temp = 0L;
    long hour = 0L;
    long min = 0L;
    long sec = 0L;

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName("com.kingdee.eas.base.netctrl.app.MutexMainListUIHandler");
            request.put("dcName", (Object)SysContext.getSysContext().getDcName());
            request.put("locale", (Object)SysContext.getSysContext().getLocale());
            request.setVirtualModel(false);
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public String getUITitle() {
        return EASResource.getString((String)(this.resClass + "MutexService_Main_Title"));
    }

    private String getResource(String key) {
        return EASResource.getString((String)(this.resClass + key));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    private void addSrcFunction() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke("Delete"), "ParamDealCenter");
        this.getActionMap().put("ParamDealCenter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.handlePermissionForItemAction((ItemAction)this.actionOnLoad);
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.setEditable(false);
        this.reLoadTable();
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    MutexMainListUI.this.refresh();
                }
                catch (Exception e) {
                    MutexMainListUI.this.logger.info((Object)"", (Throwable)e);
                }
            }
        }, 100000000L, 100000000L);
        this.addSrcFunction();
    }

    private String getDelayTime(long diff) {
        this.hour = diff / 3600000L;
        this.temp = diff % 3600000L;
        this.min = this.temp / 60000L;
        this.temp %= 60000L;
        this.sec = this.temp / 1000L;
        this.temp %= 1000L;
        return this.hour + ":" + this.min + ":" + this.sec;
    }

    private void initTable() {
        this.btnQuery.setVisible(true);
        this.btnQuery.setEnabled(true);
        this.tblMain.removeHeadRows();
        this.tblMain.removeColumns();
        this.tblMain.setFormatXml("");
        IRow headRow = this.tblMain.addHeadRow();
        int colIndex = 0;
        IColumn column = this.tblMain.addColumn();
        column.setKey("ID");
        column.getStyleAttributes().setHided(true);
        headRow.getCell(colIndex++).setValue((Object)"ID");
        column = this.tblMain.addColumn();
        column.setKey("OrgUnit");
        column.setWidth(150);
        headRow.getCell(colIndex++).setValue((Object)this.getResource("OrgUnit"));
        if (this.lockgroup.getValue() == this.OBJECT_LOCK) {
            this.tblMain.addColumn().setKey("ObjectType");
            headRow.getCell(colIndex++).setValue((Object)this.getResource("ObjectType"));
            column = this.tblMain.addColumn();
            column.setKey("ObjectNumber");
            column.setWidth(150);
            headRow.getCell(colIndex++).setValue((Object)this.getResource("ObjectNumber"));
        } else if (this.lockgroup.getValue() == this.MUTEX_LOCK) {
            this.tblMain.addColumn().setKey("LockType");
            headRow.getCell(colIndex++).setValue((Object)this.getResource("LockType"));
            column = this.tblMain.addColumn();
            column.setKey("Action");
            column.setWidth(120);
            headRow.getCell(colIndex++).setValue((Object)this.getResource("Action"));
        }
        column = this.tblMain.addColumn();
        column.setKey("User");
        column.setWidth(100);
        headRow.getCell(colIndex++).setValue((Object)this.getResource("User"));
        column = this.tblMain.addColumn();
        column.setKey("CreateTime");
        column.setWidth(150);
        column.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateTimeFormatString());
        headRow.getCell(colIndex++).setValue((Object)this.getResource("CreateTime"));
        column = this.tblMain.addColumn();
        column.setKey("DelayTime");
        headRow.getCell(colIndex++).setValue((Object)this.getResource("DelayTime"));
        column = this.tblMain.addColumn();
        column.setKey("ObjectDescription");
        headRow.getCell(colIndex++).setValue((Object)this.getResource("LockDescription"));
        this.tblMain.setAutoscrolls(true);
        KDTSortManager sm = new KDTSortManager(this.tblMain);
        sm.setSortAuto(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        for (int index = 0; index < this.tblMain.getColumnCount(); ++index) {
            this.tblMain.getColumn(index).setSortable(true);
        }
    }

    private boolean objLockFilter(String orgName, String objType, String objNumber, String creator, long createTime, long delayTime) {
        return this.doFilter(orgName, objType, objNumber, "", "", creator, createTime, delayTime);
    }

    private boolean mutexFilter(String orgName, String mutex, String description, String creator, long createTime, long delayTime) {
        return this.doFilter(orgName, "", "", mutex, description, creator, createTime, delayTime);
    }

    private boolean doFilter(String orgName, String objType, String objNumber, String mutex, String description, String creator, long createTime, long delayTime) throws NumberFormatException {
        Iterator it = this.filterInfo.iterator();
        boolean bRet = true;
        String strParam = "";
        long timeParam = 0L;
        while (it.hasNext()) {
            FilterItem fItem = (FilterItem)it.next();
            switch (fItem.getAttrType()) {
                case 0: {
                    strParam = orgName;
                    break;
                }
                case 2: {
                    strParam = objNumber;
                    break;
                }
                case 1: {
                    strParam = objType;
                    break;
                }
                case 6: {
                    strParam = mutex;
                    break;
                }
                case 7: {
                    strParam = description;
                    break;
                }
                case 3: {
                    strParam = creator;
                    break;
                }
                case 4: {
                    timeParam = createTime;
                    break;
                }
                case 5: {
                    timeParam = delayTime;
                }
            }
            if (strParam != null) {
                bRet = fItem.getCompareType() == 0 ? strParam.equals(fItem.getAttrValue()) : strParam.indexOf(fItem.getAttrValue()) != -1;
                strParam = "";
            }
            if (timeParam > 0L) {
                switch (fItem.getCompareType()) {
                    case 0: {
                        bRet = timeParam == Long.parseLong(fItem.getAttrValue());
                        break;
                    }
                    case 1: {
                        bRet = timeParam > Long.parseLong(fItem.getAttrValue());
                        break;
                    }
                    case -1: {
                        bRet = timeParam < Long.parseLong(fItem.getAttrValue());
                    }
                }
                timeParam = 0L;
            }
            if (bRet) continue;
            break;
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadObjLocks() {
        String dcName = SysContext.getSysContext().getDcName();
        IMutexServiceControl iMutexSC = MutexServiceControlFactory.getRemoteInstance();
        Map.Entry entry2 = null;
        String key = null;
        ObjectUpdateLock lock = null;
        IRow row = null;
        HashSet<String> objIds = new HashSet<String>();
        Map strNumbers = new HashMap();
        long time = iMutexSC.getCurrentTime();
        Map updateLocks = Collections.synchronizedMap(iMutexSC.getObjIDForUpdateList());
        if (updateLocks == null) {
            return;
        }
        Map map = updateLocks;
        synchronized (map) {
            for (Map.Entry entry2 : updateLocks.entrySet()) {
                key = (String)entry2.getKey();
                lock = (ObjectUpdateLock)entry2.getValue();
                if (dcName != null && dcName.trim().length() != 0 && (lock.getDcName() == null || lock.toString().length() <= 0 || !lock.getDcName().trim().equals(dcName))) continue;
                objIds.add(key.substring(0, key.length() - dcName.length()));
            }
            this.logger.info((Object)"\u53d6\u6570\u636e\u7f16\u7801....");
            strNumbers = iMutexSC.getObjectNumbers(objIds);
            Iterator iter = updateLocks.entrySet().iterator();
            row = null;
            Locale mylocale = SysContext.getSysContext().getOriginLocale();
            IMetaDataLoader metaLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo meta = null;
            Map orgNameMap = new HashMap();
            try {
                orgNameMap = this.getAllOrgNameMap(updateLocks);
            }
            catch (BOSException be) {
                this.logger.error((Object)"error!", (Throwable)be);
            }
            while (iter.hasNext()) {
                String orgName = "";
                String objType = "";
                String objNumber = "";
                String creator = "";
                long createTime = 0L;
                long delayTime = 0L;
                entry2 = iter.next();
                key = (String)entry2.getKey();
                lock = (ObjectUpdateLock)entry2.getValue();
                if (dcName != null && dcName.trim().length() != 0 && (lock.getDcName() == null || lock.toString().length() <= 0 || !lock.getDcName().trim().equals(dcName))) continue;
                try {
                    orgName = StringUtils.cnulls(orgNameMap.get(lock.getOrgUnitID().toString()));
                }
                catch (Exception e1) {
                    orgName = "";
                }
                if (key.length() > SysContext.getSysContext().getDcName().length()) {
                    String objID = key.substring(0, key.length() - SysContext.getSysContext().getDcName().length());
                    BOSUuid bosUuid = null;
                    try {
                        bosUuid = BOSUuid.read((String)objID);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (bosUuid != null) {
                        try {
                            meta = metaLoader.getEntity(bosUuid.getType());
                            objType = meta.getAlias(mylocale) != null ? meta.getAlias(mylocale) : meta.getName();
                            objNumber = (String)strNumbers.get(objID);
                        }
                        catch (Exception err) {
                            this.logger.info((Object)"get objectType err!");
                        }
                        if (objType == null) {
                            objType = "";
                        }
                        if (objNumber == null) {
                            objNumber = "";
                        }
                    }
                    if (objNumber == null || objNumber.isEmpty()) {
                        objNumber = key;
                    }
                }
                if (BOSUuid.isValidLength((String)(creator = lock.getUserName()))) {
                    try {
                        creator = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(creator)).getName();
                    }
                    catch (Exception e1) {
                        creator = "";
                    }
                }
                createTime = lock.getCreatedTime().getTime();
                delayTime = time - lock.getCreatedTime().getTime();
                if (this.filterInfo.size() != 0 && !this.objLockFilter(orgName, objType, objNumber, creator, createTime, delayTime)) continue;
                row = this.tblMain.addRow();
                row.getCell("ID").setValue((Object)key);
                row.getCell("OrgUnit").setValue((Object)orgName);
                row.getCell("ObjectType").setValue((Object)objType);
                row.getCell("ObjectNumber").setValue((Object)objNumber);
                row.getCell("User").setValue((Object)creator);
                row.getCell("CreateTime").setValue((Object)DateTimeUtils.format((Date)lock.getCreatedTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                row.getCell("DelayTime").setValue((Object)this.getDelayTime(delayTime));
                row.getCell("ObjectDescription").setValue((Object)lock.getObjectDescription());
            }
        }
    }

    private Map getAllOrgNameMap(Map updateLocks) throws BOSException {
        HashMap<String, String> retMap = new HashMap<String, String>();
        Collection col = updateLocks.values();
        if (col == null || col.isEmpty()) {
            return retMap;
        }
        Iterator it = col.iterator();
        ArrayList<String> orgIdStrList = new ArrayList<String>();
        while (it.hasNext()) {
            ObjectUpdateLock lock = (ObjectUpdateLock)it.next();
            orgIdStrList.add(StringUtils.cnulls((Object)lock.getOrgUnitID()));
        }
        if (orgIdStrList.isEmpty()) {
            return retMap;
        }
        String oql = "select id,name where id in (" + ToolUtils.aryToStr(orgIdStrList, (boolean)true) + ")";
        FullOrgUnitCollection orgCol = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(oql);
        for (int i = 0; i < orgCol.size(); ++i) {
            retMap.put(orgCol.get(i).getId().toString(), orgCol.get(i).getName());
        }
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMtxLocks() throws BOSException {
        Map updateLocks;
        String dcName = SysContext.getSysContext().getDcName();
        IMutexServiceControl iMutexSC = MutexServiceControlFactory.getRemoteInstance();
        IUser iUser = UserFactory.getRemoteInstance();
        Map.Entry entry = null;
        Map map = updateLocks = Collections.synchronizedMap(iMutexSC.getMutexList());
        synchronized (map) {
            Iterator iter = updateLocks.entrySet().iterator();
            IRow row = null;
            String key = null;
            MutexParameter value = null;
            long time = MutexServiceControlFactory.getRemoteInstance().getCurrentTime();
            while (iter.hasNext()) {
                String strAction;
                String orgName = "";
                String mutexName = "";
                String mutexDescription = "";
                String creator = "";
                long createTime = 0L;
                long delayTime = 0L;
                entry = iter.next();
                key = (String)entry.getKey();
                value = (MutexParameter)entry.getValue();
                if (dcName == null || dcName.trim().length() == 0 || value.getDcName() != null && value.toString().length() > 0 && value.getDcName().trim().equals(dcName)) {
                    try {
                        orgName = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(value.getOrgUnitID().toString())).getName();
                    }
                    catch (Exception e1) {
                        orgName = "";
                    }
                    mutexName = value.getMutexName();
                    try {
                        creator = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(value.getUserID().toString())).getName();
                    }
                    catch (Exception e1) {
                        creator = "";
                    }
                    createTime = value.getCreateTime().getTime();
                    delayTime = time - value.getCreateTime().getTime();
                    mutexDescription = value.getDescription();
                    strAction = value.getActionName();
                    String string = strAction = strAction == null ? "" : strAction;
                    if (mutexDescription == null || mutexDescription.trim().length() == 0) {
                        mutexDescription = EASResource.getString((String)"com.kingdee.eas.base.netctrl.NETCTRLAutoGenerateResource", (String)"11_MutexMainListUI", (Object[])new Object[]{value.getMutexName(), strAction});
                    }
                    if (!this.mutexFilter(orgName, mutexName, mutexDescription, creator, createTime, delayTime)) continue;
                    row = this.tblMain.addRow();
                    row.getCell("ID").setValue((Object)key);
                    row.getCell("LockType").setValue((Object)value.getMutexLockType());
                    row.getCell("Action").setValue((Object)value.getActionName());
                    row.getCell("User").setValue((Object)creator);
                    row.getCell("OrgUnit").setValue((Object)orgName);
                    row.getCell("CreateTime").setValue((Object)DateTimeUtils.format((Date)value.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    row.getCell("DelayTime").setValue((Object)this.getDelayTime(delayTime));
                    continue;
                }
                mutexName = value.getMutexName();
                try {
                    creator = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(value.getUserID().toString())).getName();
                }
                catch (Exception e1) {
                    creator = "";
                }
                createTime = value.getCreateTime().getTime();
                delayTime = time - value.getCreateTime().getTime();
                mutexDescription = value.getDescription();
                strAction = value.getActionName();
                String string = strAction = strAction == null ? "" : strAction;
                if (mutexDescription == null || mutexDescription.trim().length() == 0) {
                    mutexDescription = EASResource.getString((String)"com.kingdee.eas.base.netctrl.NETCTRLAutoGenerateResource", (String)"11_MutexMainListUI", (Object[])new Object[]{value.getMutexName(), strAction});
                }
                row = this.tblMain.addRow();
                row.getCell("ID").setValue((Object)key);
                row.getCell("LockType").setValue((Object)value.getMutexLockType());
                row.getCell("Action").setValue((Object)value.getActionName());
                row.getCell("User").setValue((Object)creator);
                row.getCell("OrgUnit").setValue((Object)orgName);
                row.getCell("CreateTime").setValue((Object)DateTimeUtils.format((Date)value.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                row.getCell("DelayTime").setValue((Object)this.getDelayTime(delayTime));
            }
        }
    }

    private void reLoadTable() throws Exception {
        this.initTable();
        this.tblMain.removeRows();
        switch (this.lockgroup.getValue()) {
            case 0: {
                this.loadObjLocks();
                break;
            }
            case 1: {
                this.loadMtxLocks();
            }
        }
        this.tblMain.setRefresh(true);
        this.tblMain.updateUI();
        KDTSortManager sm = new KDTSortManager(this.tblMain);
        sm.setSortAuto(true);
        for (int index = 0; index < this.tblMain.getColumnCount(); ++index) {
            this.tblMain.getColumn(index).setSortable(true);
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.reLoadTable();
    }

    protected void refresh() throws Exception {
        this.reLoadTable();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh(e);
    }

    @Override
    protected void RBMtxLock_actionPerformed(ActionEvent e) throws Exception {
        this.reLoadTable();
    }

    @Override
    protected void RBObjLock_actionPerformed(ActionEvent e) throws Exception {
        this.reLoadTable();
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IObjectPK logPK = null;
        if (rowID.length > 0) {
            if (this.confirmRemove()) {
                this.prepareRemoveHandler(rowID);
                try {
                    StringBuffer sb = new StringBuffer();
                    switch (this.lockgroup.getValue()) {
                        case 0: {
                            IRow row;
                            int index;
                            sb.append("[" + EASResource.getString((String)(this.resClass + "ObjectMutex")) + "]");
                            sb.append("|");
                            for (index = 0; index < rowID.length; ++index) {
                                row = this.tblMain.getRow(rowID[index]);
                                String ObjectType = row.getCell("ObjectType").getValue().toString();
                                String ObjectNumber = row.getCell("ObjectNumber").getValue().toString();
                                sb.append(ObjectType).append("+").append(ObjectNumber).append("|");
                            }
                            break;
                        }
                        case 1: {
                            IRow row;
                            int index;
                            sb.append("[" + EASResource.getString((String)(this.resClass + "FunctionMutex")) + "]");
                            for (index = 0; index < rowID.length; ++index) {
                                row = this.tblMain.getRow(rowID[index]);
                                String LockType = row.getCell("LockType").getValue().toString();
                                sb.append(LockType).append("|");
                            }
                            break;
                        }
                    }
                    logPK = LogUtil.beginLog(null, (String)"actionRemove_actionPerformed", (BOSObjectType)BOSObjectType.create((String)"539E75FB"), null, (String)(EASResource.getString((String)(this.resClass + "Mutex_Delete")) + sb.toString()), (String)"manual_default_logitem");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                block12: for (int index = 0; index < rowID.length; ++index) {
                    IRow row = this.tblMain.getRow(rowID[index]);
                    String strID = row.getCell("ID").getValue().toString();
                    IMutexServiceControl iMutexSC = null;
                    switch (this.lockgroup.getValue()) {
                        case 0: {
                            iMutexSC = MutexServiceControlFactory.getRemoteInstance();
                            iMutexSC.delObjIDForUpdate(strID);
                            continue block12;
                        }
                        case 1: {
                            iMutexSC = MutexServiceControlFactory.getRemoteInstance();
                            iMutexSC.delMutex(strID);
                        }
                    }
                }
                this.refresh();
            }
        } else {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "NO_Select_ROW")));
        }
        if (logPK != null) {
            LogUtil.afterLog(null, logPK);
        }
    }

    private void prepareRemoveHandler(int[] rowID) throws Exception {
        String[] strIDs = new String[rowID.length];
        for (int index = 0; index < rowID.length; ++index) {
            IRow row = this.tblMain.getRow(rowID[index]);
            strIDs[index] = row.getCell("ID").getValue().toString();
        }
        IUIActionPostman man = UIActionPostman.getInstance((IUIObject)this);
        RequestContext request = new RequestContext();
        request.put("rowIDs", (Object)strIDs);
        request.put("lockgroup", (Object)new Integer(this.lockgroup.getValue()));
        request.setClassName("com.kingdee.eas.base.netctrl.app.MutexMainListUIHandler");
        request.setMethodName("handleActionRemove");
        man.setRequestContext((Serializable)request);
        man.callHandler();
    }

    @Override
    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK logPK = null;
        IMutexServiceControl iMutexSC = MutexServiceControlFactory.getRemoteInstance();
        switch (this.lockgroup.getValue()) {
            case 0: {
                if (MsgBox.showConfirm2((String)EASResource.getString((String)(this.resClass + "Msg_ClearAllObjMutex"))) != 0) break;
                logPK = LogUtil.beginLog(null, (String)"btnClear_actionPerformed", (BOSObjectType)BOSObjectType.create((String)"539E75FB"), null, (String)(EASResource.getString((String)(this.resClass + "Mutex_Clear")) + "[" + EASResource.getString((String)(this.resClass + "ObjectMutex")) + "]"), (String)"manual_default_logitem");
                iMutexSC.clearAllObjId();
                break;
            }
            case 1: {
                if (MsgBox.showConfirm2((String)EASResource.getString((String)(this.resClass + "Msg_ClearAllFunctionMutex"))) != 0) break;
                logPK = LogUtil.beginLog(null, (String)"btnClear_actionPerformed", (BOSObjectType)BOSObjectType.create((String)"539E75FB"), null, (String)(EASResource.getString((String)(this.resClass + "Mutex_Clear")) + "[" + EASResource.getString((String)(this.resClass + "FunctionMutex")) + "]"), (String)"manual_default_logitem");
            }
        }
        this.refresh();
        if (logPK != null) {
            LogUtil.afterLog(null, logPK);
        }
    }

    protected void disposeUIWindow() {
        super.disposeUIWindow();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnQuery.setVisible(true);
        this.btnQuery.setEnabled(true);
        this.btnLocate.setVisible(true);
        this.btnLocate.setEnabled(true);
        this.actionView.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.actionAddNew.setEnabled(false);
        this.btnClear.setIcon(EASResource.getIcon((String)"imgTbtn_deletemultipart"));
    }

    protected String getKeyFieldName() {
        return "ID";
    }

    private void showFilterWindow() throws Exception {
        UIContext hm = new UIContext((Object)this);
        hm.put("filterInfo", this.filterInfo);
        hm.put("mutexType", new Integer(this.lockgroup.getValue()));
        hm.put("modifyFlag", new Boolean(false));
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.base.netctrl.client.MutexFilterUI", (Map)hm, null, null);
        uiWindow.show();
        this.refresh();
    }

    private void showCommonQueryWindow() throws Exception {
        CommonQueryDialog dialog = null;
        if (!this.isFirstDefaultQuery()) {
            if (dialog == null) {
                dialog = this.initCommonQueryDialog();
                dialog.setShowSorter(false);
                dialog.setQueryObjectPK(this.objectLockQueryPK);
            }
            if (dialog.show()) {
                FilterInfo filterInfo = dialog.getCommonFilter();
                FilterItemCollection itemInfos = filterInfo.getFilterItems();
                String strMsk = filterInfo.getMaskString();
                this.refreshList();
            } else {
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isFirstDefaultQuery()) {
            this.showFilterWindow();
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[2];
        switch (this.lockgroup.getValue()) {
            case 0: {
                locateNames[0] = "ObjectType";
                locateNames[1] = "ObjectNumber";
                break;
            }
            case 1: {
                locateNames[0] = "OrgUnit";
                locateNames[1] = "Action";
            }
        }
        return locateNames;
    }

    protected void locate(FindListEvent e) {
        String strProp = e.getPropertyName();
        if (strProp != null) {
            switch (this.lockgroup.getValue()) {
                case 0: {
                    if (strProp.equalsIgnoreCase("ObjectType") || strProp.equalsIgnoreCase("ObjectNumber")) break;
                    return;
                }
                case 1: {
                    if (strProp.equalsIgnoreCase("OrgUnit") || strProp.equalsIgnoreCase("Action")) break;
                    return;
                }
            }
        }
        super.locate(e);
    }
}

