/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.zxing.BarcodeFormat;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.QRCodeUtils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ControlPolicy;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.file.cloudRegist.CloudRegistUserInfo;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.UserFacadeFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractCloudActiveUI;
import com.kingdee.eas.base.permission.helper.SecurityValidatorHelper;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.common.ContextManagerFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class CloudActiveUI
extends AbstractCloudActiveUI {
    private static final Logger logger = CoreUIObject.getLogger(CloudActiveUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private boolean completed;
    private boolean isCodeTrue;
    private boolean isOnLine;
    private static String CLOUDPHONE = "10691719741876";
    private String uid;
    private String wholePhone;
    private String mixPhone;
    private String email;
    private String prod_inst_code;
    private int reGetTime;
    private boolean isEnSupport;
    private UserInfo currentUser;
    private String authPattern;

    private boolean isEnSupport() {
        Map sortedLangMap = UIConfig.getLanguages();
        for (Map.Entry entry : sortedLangMap.entrySet()) {
            String key = (String)entry.getKey();
            String[] locales = key.split("#");
            if (!"L1".equals(locales[0])) continue;
            return true;
        }
        return false;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setAPIParam();
        String network = (String)this.getUIContext().get("network");
        boolean netFlag = network == null || !"false".equalsIgnoreCase(network);
        String text = "";
        this.kDLabel1.setText(EASResource.getString((String)RESOURCE, (String)"StepOne"));
        this.kDLabelContainer3.getBoundLabel().setText(EASResource.getString((String)RESOURCE, (String)"VerCode"));
        this.btnVerify.setText(EASResource.getString((String)RESOURCE, (String)"Verify"));
        this.kDLabel3.setText(EASResource.getString((String)RESOURCE, (String)"StepTwo"));
        this.kDLabelContainer1.getBoundLabel().setText(EASResource.getString((String)RESOURCE, (String)"LoginCode"));
        this.btnConfirmPwd.getBoundLabel().setText(EASResource.getString((String)RESOURCE, (String)"ConfirmPwd"));
        this.btnUpdatepwd.setText(EASResource.getString((String)RESOURCE, (String)"Updatepwd"));
        this.btnReGetCode.setText(EASResource.getString((String)RESOURCE, (String)"reGetTime"));
        if (!"".equals(this.email)) {
            JSONObject result = this.getActiveCodeFromCloud();
            if (result == null) {
                MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"NeedPhoneMsg"));
                SysUtil.abort();
            }
            if (result.getInteger("errcode") == 0) {
                this.reGetTime = JSONObject.parseObject((String)result.getString("data")).getInteger("resend_in");
                this.isOnLine = true;
                this.startTimer();
                text = EASResource.getString((String)RESOURCE, (String)"emailMessage_online", (Object[])new Object[]{this.email});
            } else {
                String msg = result.getString("description_cn");
                if (msg != null && !"".equals(msg)) {
                    MsgBox.showWarning((String)result.getString("description_cn"));
                } else {
                    MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"NeedPhoneMsg"));
                }
                SysUtil.abort();
            }
        } else {
            JSONObject result = null;
            if (netFlag) {
                result = this.getActiveCodeFromCloud();
            }
            if (result != null && result.getInteger("errcode") == 0) {
                this.reGetTime = JSONObject.parseObject((String)result.getString("data")).getInteger("resend_in");
                this.isOnLine = true;
                this.startTimer();
                text = EASResource.getString((String)RESOURCE, (String)"editMessage_online", (Object[])new Object[]{this.mixPhone});
            } else {
                this.btnReGetCode.setVisible(false);
                String activeCode = this.getActiveCode();
                text = EASResource.getString((String)RESOURCE, (String)"qrcode");
                this.qrcode.setIcon((Icon)this.generateOffineQrcode(activeCode));
            }
        }
        this.txtverifyTip.setBorder(BorderFactory.createEmptyBorder());
        this.txtverifyTip.setText(text);
        this.currentUser = SysContext.getSysContext().getCurrentUserInfo();
        this.btnReGetCode.setEnabled(false);
        this.authPattern = UserFacadeFactory.getRemoteInstance().getAuthPattern();
        if ("BaseDB".equals(this.authPattern) && LoginAuthorWayEnum.NORMAL.getAlias().equals(this.currentUser.getLoginAuthorWay().getAlias()) && this.currentUser.getSecurity().isRequireChgPW() && !this.currentUser.isChangedPW()) {
            this.txtPwd.setEnabled(false);
            this.txtConfirmPwd.setEnabled(false);
            this.btnUpdatepwd.setEnabled(false);
        } else {
            this.kDLabel1.setVisible(false);
            this.kDLabel3.setVisible(false);
            this.kDLabelContainer1.setVisible(false);
            this.btnConfirmPwd.setVisible(false);
            this.pwdTipTxt.setBorder(null);
            this.btnUpdatepwd.setVisible(false);
        }
    }

    private void startTimer() {
        if (!this.isOnLine) {
            this.btnReGetCode.setVisible(false);
            return;
        }
        this.btnReGetCode.setVisible(true);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                        if (CloudActiveUI.this.reGetTime == 0) {
                            CloudActiveUI.this.btnReGetCode.setText(EASResource.getString((String)CloudActiveUI.RESOURCE, (String)"reGet"));
                            CloudActiveUI.this.btnReGetCode.setEnabled(true);
                            continue;
                        }
                        CloudActiveUI.this.reGetTime--;
                        CloudActiveUI.this.btnReGetCode.setText(EASResource.getString((String)CloudActiveUI.RESOURCE, (String)"reGetCodeTime", (Object[])new Object[]{CloudActiveUI.this.reGetTime}));
                        CloudActiveUI.this.btnReGetCode.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return;
                }
            }
        });
        thread.start();
    }

    private void setAPIParam() throws LicenseException {
        SysContext ctx = SysContext.getSysContext();
        CloudRegistUserInfo crui = CloudRegistSrvAgentFactory.getRemoteInstance().getCloudRegistUserInfo(ctx.getUserName());
        this.isEnSupport = this.isEnSupport();
        ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
        LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
        this.uid = crui.getCloudUuId();
        String phoneReg = crui.getPhone();
        String emailReg = crui.getEmail();
        if (!StringUtils.isEmpty((String)phoneReg) && phoneReg.contains("@")) {
            this.email = phoneReg;
            this.wholePhone = "";
            this.mixPhone = "";
        } else if (!StringUtils.isEmpty((String)emailReg)) {
            this.email = emailReg;
            if (StringUtils.isEmpty((String)phoneReg)) {
                this.wholePhone = "";
                this.mixPhone = "";
            } else {
                this.wholePhone = phoneReg;
                this.mixPhone = CloudRegistSrvAgentFactory.getRemoteInstance().getErpTelephone(ctx.getUserName());
            }
        } else {
            this.email = "";
            this.wholePhone = phoneReg;
            this.mixPhone = CloudRegistSrvAgentFactory.getRemoteInstance().getErpTelephone(ctx.getUserName());
        }
        this.prod_inst_code = baseInfo.getProductInstanceID();
    }

    private String getActiveCode() throws LicenseException {
        SysContext ctx = SysContext.getSysContext();
        return CloudRegistSrvAgentFactory.getRemoteInstance().getErpUserActiveCode(ctx.getUserName());
    }

    @Override
    protected void btnReGetCode_actionPerformed(ActionEvent e) throws Exception {
        this.getActiveCodeFromCloud();
    }

    private boolean verifyCode(String code) throws Exception {
        if (this.isOnLine) {
            try {
                String result = UserFacadeFactory.getRemoteInstance().activeCloudOnly(code);
                JSONObject o = JSON.parseObject((String)result);
                return o.getInteger("errcode") == 0;
            }
            catch (Exception e) {
                logger.error((Object)e);
                return false;
            }
        }
        SysContext ctx = SysContext.getSysContext();
        return CloudRegistSrvAgentFactory.getRemoteInstance().checkErpUserSecurityCode(ctx.getUserName(), code);
    }

    private JSONObject getActiveCodeFromCloud() {
        JSONObject o = null;
        try {
            String result = UserFacadeFactory.getRemoteInstance().getActiveCode(this.uid, this.prod_inst_code, this.wholePhone, this.email, "");
            if (StringUtils.isEmpty((String)result)) {
                return null;
            }
            o = JSON.parseObject((String)result);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return o;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    protected void btnVerify_actionPerformed(ActionEvent e) throws Exception {
        String code = this.txtCode.getText().trim();
        this.isCodeTrue = this.verifyCode(code);
        if (!this.isCodeTrue) {
            if (this.isOnLine) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"online_activeCodeError"));
                this.txtCode.setText("");
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"activeCodeError"));
                this.txtCode.setText("");
            }
            return;
        }
        this.btnReGetCode.setVisible(false);
        this.txtCode.setEnabled(false);
        this.btnVerify.setEnabled(false);
        if ("BaseDB".equals(this.authPattern) && LoginAuthorWayEnum.NORMAL.getAlias().equals(this.currentUser.getLoginAuthorWay().getAlias()) && this.currentUser.getSecurity().isRequireChgPW() && !this.currentUser.isChangedPW()) {
            this.txtPwd.setEnabled(true);
            this.txtConfirmPwd.setEnabled(true);
            this.btnUpdatepwd.setEnabled(true);
        } else {
            this.completed = true;
            try {
                if (ControlPolicy.isBySubscriptionRegOnline(null)) {
                    CloudRegistSrvAgentFactory.getRemoteInstance().addActivedErpUser(SysContext.getSysContext().getCurrentUserInfo().getNumber(), this.wholePhone, this.email);
                } else {
                    CloudRegistSrvAgentFactory.getRemoteInstance().addActivedErpUser(SysContext.getSysContext().getCurrentUserInfo().getNumber());
                }
            }
            catch (Exception e1) {
                logger.error((Object)e1);
                throw new BOSException((Throwable)e1);
            }
            HashMap<String, String> ctxMap = new HashMap<String, String>();
            ctxMap.put("cloudUserId", this.uid);
            ContextManagerFactory.getRemoteInstance().setContext(ctxMap);
            this.uiWindow.close();
        }
    }

    @Override
    protected void btnUpdatepwd_actionPerformed(ActionEvent e) throws Exception {
        String pwd = this.txtPwd.getText().trim();
        String confirmPwd = this.txtConfirmPwd.getText().trim();
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]|[\ufe30-\uffa0]");
        Matcher m = p.matcher(pwd);
        if (m.find() || this.checkIllChar(pwd)) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"pwdContainIllChar"));
            this.txtPwd.setText("");
            this.txtConfirmPwd.setText("");
            return;
        }
        if (!StringUtils.equals((String)pwd, (String)confirmPwd)) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"pwdNotSame"));
            this.txtPwd.setText("");
            this.txtConfirmPwd.setText("");
            return;
        }
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        UserFacadeFactory.getRemoteInstance().resetPass(userInfo.getId().toString(), pwd);
        this.completed = true;
        HashMap<String, String> ctxMap = new HashMap<String, String>();
        ctxMap.put("cloudUserId", this.uid);
        ContextManagerFactory.getRemoteInstance().setContext(ctxMap);
        this.uiWindow.close();
    }

    private boolean checkIllChar(String str) {
        return str.indexOf("'") > -1 || str.indexOf("(") > -1 || str.indexOf("%27") > -1 || str.indexOf("<") > -1 || str.indexOf("%3c") > -1;
    }

    @Override
    protected void txtPwd_focusGained(FocusEvent e) throws Exception {
        this.pwdTipTxt.setForeground(Color.gray);
        this.pwdTipTxt.setText(SecurityValidatorHelper.getSecurityPolicy());
    }

    public ImageIcon generateOffineQrcode(String vcode) throws Exception {
        Date date = new Date();
        String time = String.valueOf(date.getTime() / 1000L);
        String signiture = EasCloud.sha1((String)(EasCloud.CLIENT_ID + EasCloud.CLIENT_SECRET + this.prod_inst_code + this.wholePhone + vcode + time));
        StringBuilder sb = new StringBuilder();
        sb.append(EasCloud.OFFLINE_QRCODE_URL).append("?").append("client_id=").append(EasCloud.CLIENT_ID).append("&prod_inst_code=").append(this.prod_inst_code).append("&vcode=").append(vcode).append("&phone=").append(this.wholePhone).append("&timestamp=").append(time).append("&signiture=").append(signiture);
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("barcode", sb.toString());
        config.put("height", "150");
        config.put("width", "150");
        QRCodeUtils.generateBarcodePicture((OutputStream)byteArray, (BarcodeFormat)BarcodeFormat.QR_CODE, config);
        ImageIcon qrcode = new ImageIcon(byteArray.toByteArray());
        return qrcode;
    }
}

