/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.FieldAccessStrategyCollection;
import com.kingdee.eas.base.permission.FieldAccessStrategyFactory;
import com.kingdee.eas.base.permission.FieldAccessStrategyInfo;
import com.kingdee.eas.base.permission.IFieldAccessStrategy;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractFieldAccessStrategyUI;
import com.kingdee.eas.base.permission.client.util.FieldAccessUtil;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewCtrlF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class FieldAccessStrategyUI
extends AbstractFieldAccessStrategyUI {
    private static final int FIELD_NAME_INDEX = 0;
    private static final int ENABLE_FIELD_ACCESS_CONTROL_INDEX = 1;
    private static final Logger logger = CoreUIObject.getLogger(FieldAccessStrategyUI.class);
    private Map loadedData = null;
    private Set lockedFieldNames = null;
    private BOSObjectType currentBOSObjectType = null;
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.selectDefaultCU();
    }

    private void initUI() throws Exception {
        this.initTree();
        this.initOrgF7();
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                try {
                    FieldAccessStrategyUI.this.tblMain_valueChanged(e);
                }
                catch (Exception exc) {
                    FieldAccessStrategyUI.this.handUIException(exc);
                }
            }
        });
    }

    private void initOrgF7() throws Exception {
        boolean isSuperCUAdmin = Administrator.isSuperCUAdmin(this.getCurrentUserPK());
        NewCtrlF7 ctrlF7 = new NewCtrlF7((IUIObject)this);
        if (isSuperCUAdmin) {
            ctrlF7.setIsCUFilter(true, true);
            ctrlF7.setCurrentCUID("00000000-0000-0000-0000-000000000000CCE7AED4");
        } else {
            ctrlF7.setIsCUFilter(true, true);
            ctrlF7.setCurrentCUID(this.getCurrentCU().getId().toString());
        }
        IObjectPK currentUserPK = ToolUtils.getCurrentUserPK();
        String managerCuids = PermissionRangeHelper.getBizUserCUOrgRangeSQL(null, currentUserPK);
        FilterInfo outerFilter = new FilterInfo("unit.id in (" + managerCuids + ")");
        ctrlF7.setOuterFilterInfo(outerFilter);
        StringBuffer extraTreeFilter = new StringBuffer();
        extraTreeFilter.append("\"BASEUNIT\"").append(".FID IN (").append(managerCuids).append(")");
        ctrlF7.setExtraTreeFilters(extraTreeFilter.toString());
        ctrlF7.setMultiSelect(false);
        this.pmtCU.setEditable(false);
        this.pmtCU.setSelector((KDPromptSelector)ctrlF7);
    }

    private void selectDefaultCU() {
        this.pmtCU.setData((Object)this.getCurrentCU());
    }

    private void initTree() {
        DefaultKingdeeTreeNode root = this.createNode();
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        this.treeBizObject.setModel((TreeModel)model);
        UIUtil.addStandardPopupMenu(this.treeBizObject);
    }

    private DefaultKingdeeTreeNode createNode() {
        return SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_fieldpermission")));
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(this.getCurrentUser().getId());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnSubmit);
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.setButtonDefaultStyl(this.btnSelectAll);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.setButtonDefaultStyl(this.btnClearAll);
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.checkOrgIsSelected();
        this.save();
    }

    @Override
    protected void pmtCU_dataChanged(DataChangeEvent e) throws Exception {
        super.pmtCU_dataChanged(e);
        this.alertSave();
        this.refreshList();
    }

    private void checkOrgIsSelected() {
        if (this.getSelectedCUPK() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"orgIsNotSelected"));
            this.abort();
        }
    }

    private void save() throws BOSException, EASBizException {
        if (this.currentBOSObjectType != null) {
            FieldAccessStrategyCollection currentResult = this.getCurrentResult();
            IFieldAccessStrategy iFieldAccessStrategy = FieldAccessStrategyFactory.getRemoteInstance();
            iFieldAccessStrategy.save(currentResult, this.currentBOSObjectType.toString(), this.getAccreditCUPK().toString());
            this.refreshList();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"accreditPermSucceed"));
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        if (this.currentBOSObjectType != null) {
            int size = this.tblMain.getRowCount();
            for (int i = 0; i < size; ++i) {
                this.tblMain.getRow(i).getCell(1).setValue((Object)Boolean.TRUE);
            }
        }
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearAll_actionPerformed(e);
        if (this.currentBOSObjectType != null) {
            int size = this.tblMain.getRowCount();
            for (int i = 0; i < size; ++i) {
                String fieldName = (String)this.tblMain.getRow(i).getCell(0).getUserObject();
                if (this.lockedFieldNames.contains(fieldName)) continue;
                this.tblMain.getRow(i).getCell(1).setValue((Object)Boolean.FALSE);
            }
        }
    }

    @Override
    protected void treeBizObject_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeBizObject_valueChanged(e);
        this.alertSave();
        this.refreshList();
    }

    private void setCurrentEntityType() {
        MetaDataBriefInfo mdbInfo;
        DefaultKingdeeTreeNode node;
        Object userObject;
        Object object = this.treeBizObject.getLastSelectedPathComponent();
        if (object != null && object instanceof DefaultKingdeeTreeNode && (userObject = (node = (DefaultKingdeeTreeNode)object).getUserObject()) instanceof MetaDataBriefInfo && (mdbInfo = (MetaDataBriefInfo)userObject).getMetaDataType().equals((Object)MetaDataTypeList.ENTITY)) {
            this.currentBOSObjectType = mdbInfo.getBOType();
            return;
        }
        this.currentBOSObjectType = null;
    }

    private void alertSave() throws EASBizException, BOSException {
        if (this.currentBOSObjectType != null && this.isModify()) {
            int isYes = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"fieldAccessIsChange"));
            if (MsgBox.isYes((int)isYes)) {
                this.save();
                this.abort();
            } else if (MsgBox.isCancel((int)isYes)) {
                this.abort();
            }
        }
    }

    private boolean isModify() {
        FieldAccessStrategyCollection currentFASCollection = this.getCurrentResult();
        int size = currentFASCollection.size();
        if (currentFASCollection.size() == this.loadedData.keySet().size()) {
            for (int i = 0; i < size; ++i) {
                if (this.loadedData.containsKey(currentFASCollection.get(i).getFieldName())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private FieldAccessStrategyCollection getCurrentResult() {
        CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
        ctrlUnitInfo.setId(BOSUuid.read((String)this.getAccreditCUPK().toString()));
        FieldAccessStrategyCollection result = new FieldAccessStrategyCollection();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            boolean enableFieldAccessControl = (Boolean)row.getCell(1).getValue();
            if (!enableFieldAccessControl) continue;
            String fieldName = (String)row.getCell(0).getUserObject();
            FieldAccessStrategyInfo info = new FieldAccessStrategyInfo();
            info.setBizObjectType(this.currentBOSObjectType.toString());
            info.setFieldName(fieldName);
            info.setEnableAccessControl(true);
            info.setCU(ctrlUnitInfo);
            result.add(info);
        }
        return result;
    }

    private void refreshList() throws BOSException, EASBizException {
        this.setCurrentEntityType();
        if (this.currentBOSObjectType != null) {
            this.loadLockedFieldNames(this.currentBOSObjectType);
            this.loadCurrentFieldAccessStrategy(this.currentBOSObjectType);
            this.loadRowData(this.currentBOSObjectType);
        } else {
            this.lockedFieldNames = null;
            this.loadedData = null;
            this.tblMain.removeRows();
        }
    }

    private IObjectPK getAccreditCUPK() {
        IObjectPK orgPK = this.getSelectedCUPK();
        if (orgPK != null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo entity = loader.getEntity(this.currentBOSObjectType);
            if (OrgType.NONE.equals((Object)PermissionCommonUtil.getMainBizOrgType(entity))) {
                logger.info((Object)("entity mainBizOrg not set ,user SYS_CU_ID ,entity is:" + entity.getName()));
                return new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4");
            }
            return orgPK;
        }
        return null;
    }

    private Map loadCurrentFieldAccessStrategy(BOSObjectType objectType) throws BOSException {
        this.loadedData = new HashMap();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bizObjectType", (Object)objectType.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.getAccreditCUPK().toString()));
        entityViewInfo.setFilter(filterInfo);
        IFieldAccessStrategy iFieldAccessStrategy = FieldAccessStrategyFactory.getRemoteInstance();
        FieldAccessStrategyCollection collection = iFieldAccessStrategy.getFieldAccessStrategyCollection(entityViewInfo);
        if (collection != null) {
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                FieldAccessStrategyInfo info = collection.get(i);
                this.loadedData.put(info.getFieldName(), info);
            }
        }
        return this.loadedData;
    }

    private void loadLockedFieldNames(BOSObjectType objectType) throws BOSException, EASBizException {
        this.lockedFieldNames = new HashSet();
        IFieldAccessStrategy iFieldAccessStrategy = FieldAccessStrategyFactory.getRemoteInstance();
        this.lockedFieldNames = iFieldAccessStrategy.getLockedFieldNames(this.getAccreditCUPK(), objectType);
    }

    private void loadRowData(BOSObjectType objectType) throws BOSException {
        this.tblMain.setRefresh(false);
        this.tblMain.removeRows();
        Set fieldInfos = FieldAccessUtil.getEntityFieldInfos(objectType);
        for (String[] fieldInfo : fieldInfos) {
            IRow row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)fieldInfo[0]);
            row.getCell(0).setUserObject((Object)fieldInfo[1]);
            if (this.loadedData.containsKey(fieldInfo[1])) {
                FieldAccessStrategyInfo info = (FieldAccessStrategyInfo)this.loadedData.get(fieldInfo[1]);
                row.getCell(1).setValue((Object)info.isEnableAccessControl());
            } else {
                row.getCell(1).setValue((Object)Boolean.FALSE);
            }
            if (!this.lockedFieldNames.contains(fieldInfo[1])) continue;
            row.getCell(1).getStyleAttributes().setLocked(true);
            row.getCell(1).getStyleAttributes().setBackground(this.getBackground());
        }
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
    }

    private IObjectPK getSelectedCUPK() {
        if (this.pmtCU.getData() == null) {
            return null;
        }
        CtrlUnitInfo ctrlUnitInfo = (CtrlUnitInfo)this.pmtCU.getData();
        return new ObjectUuidPK(ctrlUnitInfo.getId());
    }

    private CtrlUnitInfo getCurrentCU() {
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private void tblMain_valueChanged(KDTEditEvent e) {
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (colIndex == 1) {
            this.tblMain.getCell(rowIndex, colIndex).setValue(e.getValue());
            if (!((Boolean)e.getValue()).booleanValue()) {
                MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"ENABLEFIELD"));
            }
        }
    }
}

