/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IOrgRangeSolution;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.IUserOrgPerm;
import com.kingdee.eas.base.permission.IUserOrgPermFacade;
import com.kingdee.eas.base.permission.OrgRangeSolutionCollection;
import com.kingdee.eas.base.permission.OrgRangeSolutionEntryCollection;
import com.kingdee.eas.base.permission.OrgRangeSolutionEntryInfo;
import com.kingdee.eas.base.permission.OrgRangeSolutionFactory;
import com.kingdee.eas.base.permission.OrgRangeSolutionInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermFacadeFactory;
import com.kingdee.eas.base.permission.UserOrgPermFactory;
import com.kingdee.eas.base.permission.client.AbstractNewUserBatchUI;
import com.kingdee.eas.base.permission.client.AccreditOrgF7PromptDialog;
import com.kingdee.eas.base.permission.client.OrgRangeSolutionEditUI;
import com.kingdee.eas.base.permission.client.OrgRangeSolutionUtil;
import com.kingdee.eas.base.permission.client.UserListUIHelper;
import com.kingdee.eas.base.permission.client.f7.MultiUserManageF7PromptDialog;
import com.kingdee.eas.base.permission.client.helper.NewUserAccreditTreeHelper;
import com.kingdee.eas.base.permission.client.helper.PermissionUIHelper;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.LogNamesHelper;
import com.kingdee.eas.base.permission.util.LogProxy;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.helper.OrgTableHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LowTimer;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class NewUserBatchUI
extends AbstractNewUserBatchUI {
    private static final Logger logger = CoreUIObject.getLogger(NewUserBatchUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private UserInfo targetUserInfo = null;
    private UserInfo targetUser = null;
    private List targetUsers;
    private UserCollection targetUserCol;
    private int curTabPage = 1;
    private boolean isOnloadFinished = false;
    private NewUserAccreditTreeHelper treeHelper = null;
    private boolean batchSave = true;
    private List selectOrgList = new ArrayList();
    private List selectBizOrgList = new ArrayList();
    private List selectCuOrgList = new ArrayList();
    private boolean selectAllOrg = false;
    private boolean isModified = false;
    private boolean isOnloading = false;
    private KDBizPromptBox f7SltOrgRangeSln = null;
    private OrgRangeSolutionInfo currentSlnInfo = null;
    private Map<String, OrgRangeSolutionCollection> solutionMap = new HashMap<String, OrgRangeSolutionCollection>();

    private FilterInfo getDefaultFilteInfo() {
        FilterInfo myFilterInfo = new FilterInfo();
        String idStr = this.getAccreditOrgIdStr();
        if (StringUtils.isEmpty((String)idStr)) {
            return null;
        }
        myFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INCLUDE));
        return myFilterInfo;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setText(null);
        Icon addIcon = EASResource.getIcon((String)"imgTbtn_move_right");
        this.btnAdd.setIcon(addIcon);
        Icon addAllIcon = EASResource.getIcon((String)"imgTbtn_moveall_right");
        this.btnAddAll.setText(null);
        this.btnAddAll.setIcon(addAllIcon);
        Icon deleteIcon = EASResource.getIcon((String)"imgTbtn_move_left");
        this.btnDelete.setText(null);
        this.btnDelete.setIcon(deleteIcon);
        Icon deleteAllIcon = EASResource.getIcon((String)"imgTbtn_moveall_left");
        this.btnDeleteAll.setText(null);
        this.btnDeleteAll.setIcon(deleteAllIcon);
        this.btnSave.setEnabled(true);
        Icon savePermIcon = EASResource.getIcon((String)"imgTbtn_save");
        this.btnSave.setIcon(savePermIcon);
        Icon deleteAllPermIcon = EASResource.getIcon((String)"imgTbtn_delete");
        this.btnDeleteAllPerm.setIcon(deleteAllPermIcon);
        this.btnDeleteAllPerm.setVisible(false);
        Icon selectOrgIcon = EASResource.getIcon((String)"imgTbtn_selectcompany");
        this.btnSelectOrg.setIcon(selectOrgIcon);
        try {
            this.initTab();
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        this.menuEdit.setVisible(false);
        this.menuView.setVisible(false);
    }

    private void initTab() throws EASBizException, BOSException {
        this.tabAssign.setEnabledAt(0, false);
        if (this.batchSave) {
            if (this.isAllCUAdmin(this.targetUserCol)) {
                this.tabAssign.setEnabledAt(0, true);
            }
        } else if (this.isAllCUAdmin(this.targetUserCol)) {
            this.tabAssign.setEnabledAt(0, true);
        }
        this.tabAssign.setSelectedIndex(1);
    }

    private boolean isAllCUAdmin(UserCollection targetUserCol) {
        Iterator it = targetUserCol.iterator();
        while (it.hasNext()) {
            UserInfo userInfo;
            Object userObj = it.next();
            if (!(userObj instanceof UserInfo) || (userInfo = (UserInfo)userObj).isBizAdmin()) continue;
            return false;
        }
        return true;
    }

    private void setUserInfo() throws EASBizException, BOSException {
        this.targetUser = this.getUserInfo(this.getTargetUserPK());
    }

    private UserInfo getUserInfo(IObjectPK userPK) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bizAdmin"));
        sic.add(new SelectorItemInfo("defOrgUnit.id"));
        sic.add(new SelectorItemInfo("defOrgUnit.number"));
        sic.add(new SelectorItemInfo("defOrgUnit.name"));
        sic.add(new SelectorItemInfo("defOrgUnit.CU.id"));
        sic.add(new SelectorItemInfo("type"));
        IUser iUser = UserFactory.getRemoteInstance();
        return iUser.getUserInfo(userPK, sic);
    }

    private String getAccreditOrgIdStr() {
        if (this.selectOrgList == null || this.selectOrgList.isEmpty()) {
            return null;
        }
        return ToolUtils.aryToStr(this.selectOrgList, false);
    }

    private void initUserF7(UserInfo userInfo) throws EASBizException, BOSException, UuidException, ParserException {
        this.bizUser.setQueryInfo("com.kingdee.eas.base.permission.app.F7UserQuery");
        this.bizUser.setEditFormat("$number$");
        this.bizUser.setCommitFormat("$number$");
        this.bizUser.setDisplayFormat("$number$($name$)");
        this.bizUser.setData((Object)userInfo);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new UserListUIHelper().getCurrentRangeUser();
        if (ToolUtils.getCurrentUser().isBizAdmin()) {
            if (filter == null) {
                filter = new FilterInfo();
            }
            FilterInfo extrafilter = new FilterInfo();
            extrafilter.getFilterItems().add(new FilterItemInfo("bizAdmin", (Object)false, CompareType.EQUALS));
            extrafilter.getFilterItems().add(new FilterItemInfo("type", (Object)10, CompareType.NOTEQUALS));
            filter.mergeFilter(extrafilter, "and");
        }
        evi.setFilter(filter);
        this.bizUser.setEntityViewInfo(evi);
    }

    private void initUserF7(UserCollection userCol) throws EASBizException, BOSException, UuidException, ParserException {
        FilterInfo auUserTypeFilter;
        this.bizUser.setQueryInfo("com.kingdee.eas.base.permission.app.F7UserQuery2");
        this.bizUser.setEditFormat("$number$");
        this.bizUser.setCommitFormat("$number$");
        this.bizUser.setDisplayFormat("$number$($name$)");
        String[] columnKeys = new String[]{"id", "number", "type", "name", "CU.name", "security.alias", "bizAdmin", "effectiveDate", "invalidationDate", "PWEffectiveDate", "isForbidden", "isLocked", "isDelete", "description", "defOrgUnit.name", "CU.id", "cell", "email", "admin.name"};
        this.bizUser.setMergeColumnKeys(columnKeys);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new UserListUIHelper().getCurrentRangeUser();
        if (ToolUtils.getCurrentUser().isBizAdmin()) {
            if (filter == null) {
                filter = new FilterInfo();
            }
            FilterInfo extrafilter = new FilterInfo();
            extrafilter.getFilterItems().add(new FilterItemInfo("bizAdmin", (Object)false, CompareType.EQUALS));
            extrafilter.getFilterItems().add(new FilterItemInfo("type", (Object)10, CompareType.NOTEQUALS));
            filter.mergeFilter(extrafilter, "and");
        }
        if ((auUserTypeFilter = Administrator.getNotAuUserFilter()) != null) {
            filter.mergeFilter(auUserTypeFilter, "and");
        }
        evi.setFilter(filter);
        this.bizUser.setEntityViewInfo(evi);
        this.bizUser.setEnabledMultiSelection(true);
        this.bizUser.setData((Object)userCol.toArray());
    }

    private void clearAllTrees() {
        ((DefaultTreeModel)this.treeSourcePerm.getModel()).setRoot(null);
        ((DefaultTreeModel)this.treeAuthorizedPerm.getModel()).setRoot(null);
        ((DefaultTreeModel)this.treeNormalPerm.getModel()).setRoot(null);
        ((DefaultTreeModel)this.treeForbiddenPerm.getModel()).setRoot(null);
    }

    private void clearTreesByType() {
        ((DefaultTreeModel)this.treeSourcePerm.getModel()).setRoot(null);
        if (this.tabAssign.getSelectedIndex() == 0) {
            ((DefaultTreeModel)this.treeAuthorizedPerm.getModel()).setRoot(null);
        } else {
            ((DefaultTreeModel)this.treeNormalPerm.getModel()).setRoot(null);
            ((DefaultTreeModel)this.treeForbiddenPerm.getModel()).setRoot(null);
        }
    }

    private UserInfo getTargetUserInfo() {
        UserInfo selectedUser = (UserInfo)this.bizUser.getData();
        if (selectedUser != null) {
            return selectedUser;
        }
        this.targetUserInfo = (UserInfo)this.getUIContext().get("targetUser");
        return this.targetUserInfo;
    }

    public void onLoad() throws Exception {
        String disStr;
        this.isOnloading = true;
        this.setUserInfo();
        this.targetUsers = this.getTargetUsers((List)this.getUIContext().get("targetIDs"));
        this.targetUserCol = (UserCollection)((Object)this.getUIContext().get("targetUsers"));
        this.batchSave = Boolean.valueOf(this.getUIContext().get("batchSave").toString());
        if (this.batchSave) {
            disStr = EASResource.getString((String)RESOURCE, (String)"saveAssign");
            this.btnSave.setText(disStr);
            this.btnSave.setToolTipText(disStr);
            this.initUserF7(this.targetUserCol);
        } else {
            disStr = EASResource.getString((String)RESOURCE, (String)"cancelAssign");
            this.btnSave.setText(EASResource.getString((String)RESOURCE, (String)"cancelAssign"));
            this.btnSave.setToolTipText(disStr);
            String titleStr = EASResource.getString((String)RESOURCE, (String)"cancelBatchUITitle");
            this.setUITitle(titleStr);
            this.initUserF7(this.targetUserCol);
        }
        super.onLoad();
        this.initUI();
        this.initTrees();
        for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
            IColumn col = this.tblMain.getColumn(i);
            if (col.getColumnIndex() <= 3) continue;
            col.getStyleAttributes().setHided(true);
        }
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                OrgTableHelper.addTalbeOrgCol((KDTable)NewUserBatchUI.this.tblMain);
                int begin = e.getFirstRow();
                int end = e.getLastRow();
                for (int i = begin; i <= end; ++i) {
                    String orgTypeStr = (String)NewUserBatchUI.this.tblMain.getRow(i).getCell("orgTypeStr").getValue();
                    IRow row = NewUserBatchUI.this.tblMain.getRow(i);
                    OrgTableHelper.setTableRowValue((String)orgTypeStr, (IRow)row);
                }
            }
        });
        this.execQuery();
        this.isOnloading = false;
        this.addFunction();
        this.isOnloadFinished = true;
    }

    private void initUI() {
        Icon selectOrgIcon = EASResource.getIcon((String)"imgTbtn_selectcompany");
        this.btnSaveSolution.setEnabled(false);
        this.btnSaveSolution.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSaveAsSolution.setEnabled(true);
        this.btnSaveAsSolution.setIcon(EASResource.getIcon((String)"imgTbtn_saveas"));
        this.btnEditSolution.setEnabled(true);
        this.btnEditSolution.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnRemoveSolution.setEnabled(true);
        this.btnRemoveSolution.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnSltSolution.setEnabled(true);
        this.btnSltSolution.setIcon(selectOrgIcon);
    }

    private UserCollection getTargetUserCollection() {
        UserCollection userCol = new UserCollection();
        Object userObj = this.bizUser.getData();
        if (userObj == null) {
            return (UserCollection)((Object)this.getUIContext().get("targetUsers"));
        }
        if (userObj instanceof Object[]) {
            Object[] userObjs;
            for (Object userInfo : userObjs = (Object[])userObj) {
                if (!(userInfo instanceof UserInfo)) continue;
                userCol.add((UserInfo)userInfo);
            }
        } else if (userObj instanceof UserInfo) {
            userCol.add((UserInfo)userObj);
        }
        return userCol;
    }

    public List getTargetUsers(List targetUsers) {
        ArrayList<ObjectStringPK> userPKs = new ArrayList<ObjectStringPK>();
        for (Object userPK : targetUsers) {
            userPKs.add(new ObjectStringPK((String)userPK));
        }
        return userPKs;
    }

    private void changeTab(UserInfo user) throws EASBizException, BOSException {
        if (!user.isBizAdmin()) {
            this.tabAssign.setEnabledAt(0, false);
        } else {
            this.tabAssign.setEnabledAt(0, true);
        }
        this.tabAssign.setSelectedIndex(1);
    }

    private void initTrees() throws Exception {
        this.treeHelper = new NewUserAccreditTreeHelper();
        this.initSourceTree();
        this.initTargetTree();
        this.clearAllTrees();
    }

    private void initSourceTree() {
        this.treeSourcePerm.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTreeNode curNode = (KDTreeNode)event.getPath().getLastPathComponent();
                if (curNode == null) {
                    return;
                }
                try {
                    NewUserBatchUI.this.buildLevelSourceTree(curNode);
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        });
    }

    private void initTargetTree() {
        this.treeAuthorizedPerm.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTreeNode curNode = (KDTreeNode)event.getPath().getLastPathComponent();
                if (curNode == null) {
                    return;
                }
                try {
                    NewUserBatchUI.this.buildLevelTargetTree(curNode, 30);
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        });
        this.treeNormalPerm.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTreeNode curNode = (KDTreeNode)event.getPath().getLastPathComponent();
                if (curNode == null) {
                    return;
                }
                try {
                    NewUserBatchUI.this.buildLevelTargetTree(curNode, 10);
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        });
        this.treeForbiddenPerm.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTreeNode curNode = (KDTreeNode)event.getPath().getLastPathComponent();
                if (curNode == null) {
                    return;
                }
                try {
                    NewUserBatchUI.this.buildLevelTargetTree(curNode, 20);
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        });
    }

    private FullOrgUnitCollection getOrgCol() throws Exception {
        FullOrgUnitCollection ret = null;
        List orgList = (List)ObjectUtils.createCopy((Object)this.selectOrgList);
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.aryToStr(orgList, false), CompareType.INCLUDE));
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("id"));
        selectorCol.add(new SelectorItemInfo("cu"));
        selectorCol.add(new SelectorItemInfo("isUnion"));
        selectorCol.add(new SelectorItemInfo("maintainCU"));
        selectorCol.add(new SelectorItemInfo("orgtypestr"));
        entityViewInfo.setSelector(selectorCol);
        entityViewInfo.setFilter(filterInfo);
        ret = iFullOrgUnit.getFullOrgUnitCollection(entityViewInfo);
        return ret;
    }

    private IObjectPK getTargetUserPK() {
        return new ObjectUuidPK((String)this.getUIContext().get("targetID"));
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(this.getCurrentUser().getId());
    }

    private void buildAllTrees() throws Exception {
        this.clearTreesByType();
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        beginTime = lowTimer.msValue();
        this.buildSourceTree();
        endTime = lowTimer.msValue();
        logger.debug((Object)("buildSourceTree()  " + (endTime - beginTime)));
    }

    private void buildSourceTree() throws Exception {
        IUserOrgPermFacade iuopFacade = this.getNewBizInterface();
        IObjectPK sourceUserPK = this.getCurrentUserPK();
        IObjectPK targetUserPK = this.getTargetUserPK();
        UserOrgPermCollection userOrgPerms = iuopFacade.getTopSourceUOPs(sourceUserPK, targetUserPK, this.getOrgCol(), true, this.tabAssign.getSelectedComponent().equals(this.tviewAuthorizedPerm) ? 30 : -1);
        this.treeHelper.buildTopSourceTree(this.treeSourcePerm, (IObjectCollection)userOrgPerms, null);
    }

    private void buildLevelSourceTree(KDTreeNode parent) throws Exception {
        if (parent == null || this.treeHelper.isLeaf(parent) || this.treeHelper.isExpended(parent)) {
            return;
        }
        IUserOrgPermFacade iuopFacade = this.getNewBizInterface();
        IObjectPK sourceUserPK = this.getCurrentUserPK();
        IObjectPK targetUserPK = this.getTargetUserPK();
        PermItemInfo parentPerm = this.treeHelper.getPermItem(parent);
        UserOrgPermCollection userOrgPerms = iuopFacade.getLevelSourceUOPs(sourceUserPK, targetUserPK, this.getOrgCol(), parentPerm, true, this.tabAssign.getSelectedComponent().equals(this.tviewAuthorizedPerm) ? 30 : -1);
        this.treeHelper.buildLevelSourceTree(parent, (IObjectCollection)userOrgPerms, null);
    }

    private void buildLevelTargetTree(KDTreeNode parent, int permType) throws Exception {
        if (parent == null || this.treeHelper.isLeaf(parent) || this.treeHelper.isExpended(parent)) {
            return;
        }
        IUserOrgPermFacade iuopFacade = this.getNewBizInterface();
        IObjectPK sourceUserPK = this.getCurrentUserPK();
        IObjectPK targetUserPK = this.getTargetUserPK();
        PermItemInfo parentPerm = this.treeHelper.getPermItem(parent);
        UserOrgPermCollection userOrgPerms = null;
        boolean sourceFlag = false;
        if (this.treeHelper.isSourceFlag(parent)) {
            userOrgPerms = iuopFacade.getLevelSourceUOPs(sourceUserPK, targetUserPK, this.getOrgCol(), parentPerm, true, this.tabAssign.getSelectedComponent().equals(this.tviewAuthorizedPerm) ? 30 : -1);
            sourceFlag = true;
        } else {
            userOrgPerms = iuopFacade.getLevelTargetUOPs(sourceUserPK, targetUserPK, this.getOrgCol(), parentPerm, permType);
        }
        this.treeHelper.buildLevelTargetTree(parent, (IObjectCollection)userOrgPerms, permType, sourceFlag);
    }

    private void addFunction() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(65, 3), "biz");
        this.getActionMap().put("biz", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    NewUserBatchUI.this.actionSelectOrg_actionPerformed(e);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }
        });
    }

    private void setSortInfo(EntityViewInfo targetQuery) {
        targetQuery.getSorter().clear();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        targetQuery.getSorter().add(sorterItemInfo);
    }

    protected void execQuery() {
        FilterInfo filterInfo = this.getDefaultFilteInfo();
        if (this.mainQuery != null && filterInfo != null) {
            this.mainQuery.setFilter(filterInfo);
            this.setSortInfo(this.mainQuery);
        } else if (this.mainQuery != null && filterInfo == null) {
            try {
                FilterInfo none = new FilterInfo("orgNumber = 1 and orgNumber = -1");
                this.mainQuery.setFilter(none);
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        super.execQuery();
    }

    @Override
    protected void bizUser_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isOnloadFinished) {
            return;
        }
        UserCollection userCol = null;
        Object userInfo = null;
        if (this.batchSave) {
            userCol = this.getTargetUserCollection();
            if (userCol.size() != 0) {
                this.targetUserCol = userCol;
                this.targetUsers = this.getTargetUserIDs(userCol);
            }
        } else {
            userCol = this.getTargetUserCollection();
            if (userCol.size() != 0) {
                this.targetUserCol = userCol;
                this.targetUsers = this.getTargetUserIDs(userCol);
            }
        }
        this.selectOrgList.clear();
        this.selectBizOrgList.clear();
        this.selectCuOrgList.clear();
        if (this.mainQuery != null) {
            FilterInfo filterInfo = new FilterInfo("orgNumber = 1 and orgNumber = -1");
            this.mainQuery.setFilter(filterInfo);
        }
        this.execQuery();
        if (!this.isOnloading) {
            this.clearAllTrees();
        }
        this.initTab();
    }

    protected String getEditUIName() {
        return null;
    }

    protected String getKeyFieldName() {
        return "orgId";
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return new FilterInfo();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    private void treeFilterPermItem() throws Exception {
        try {
            this.filterTree4wait();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
    }

    private void filterTree4wait() {
        LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            @Override
            public Object exec() throws Exception {
                NewUserBatchUI.this.buildAllTrees();
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    private void mayTreeFilter(List oldList, List newList) throws Exception {
        if (!oldList.containsAll(newList) || !newList.containsAll(oldList)) {
            if (!newList.isEmpty()) {
                this.treeFilterPermItem();
            } else {
                ((DefaultTreeModel)this.treeSourcePerm.getModel()).setRoot(null);
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        IUserOrgPerm userOrgPerm = UserOrgPermFactory.getRemoteInstance();
        return userOrgPerm;
    }

    public IUserOrgPermFacade getNewBizInterface() throws BOSException {
        return UserOrgPermFacadeFactory.getRemoteInstance();
    }

    @Override
    protected void tabAssign_stateChanged(ChangeEvent e) throws Exception {
        if (this.curTabPage == 0 && this.tabAssign.getSelectedIndex() != 0) {
            this.solutionStatusChange(this.solutionMap.get("bizSolution"));
            this.selectOrgList = this.selectBizOrgList;
            this.btnSelectOrg.setText(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"selectOrgTypeTip_biz"));
        } else if (this.curTabPage != 0 && this.tabAssign.getSelectedIndex() == 0) {
            this.solutionStatusChange(this.solutionMap.get("managerSolution"));
            this.selectOrgList = this.selectCuOrgList;
            this.btnSelectOrg.setText(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"selectOrgTypeTip"));
        }
        this.curTabPage = this.tabAssign.getSelectedIndex();
        this.execQuery();
        ((DefaultTreeModel)this.treeSourcePerm.getModel()).setRoot(null);
        if (this.selectOrgList.size() > 0) {
            this.buildSourceTree();
        }
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdd_actionPerformed(e);
        TreePath[] treePaths = this.treeSourcePerm.getSelectionPaths();
        if (treePaths != null) {
            int length = treePaths.length;
            KDTreeNode[] treeNodes = new KDTreeNode[length];
            for (int i = 0; i < length; ++i) {
                treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
            }
            Set extendedNodes = this.treeHelper.getExpendedNodes(this.treeSourcePerm);
            if (this.curTabPage == 0) {
                this.treeHelper.addNodes(this.treeAuthorizedPerm, treeNodes, extendedNodes);
                this.treeHelper.setDefaultIcon((KDTreeNode)this.treeAuthorizedPerm.getModel().getRoot());
            } else if (this.curTabPage == 1) {
                this.treeHelper.addNodes(this.treeNormalPerm, treeNodes, extendedNodes);
                this.treeHelper.setDataRuleIcon((KDTreeNode)this.treeNormalPerm.getModel().getRoot());
            } else if (this.curTabPage == 2) {
                this.treeHelper.addNodes(this.treeForbiddenPerm, treeNodes, extendedNodes);
                this.treeHelper.setForbiddenIcon((KDTreeNode)this.treeForbiddenPerm.getModel().getRoot());
            }
        }
        this.isModified = true;
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddAll_actionPerformed(e);
        Object object = this.treeSourcePerm.getModel().getRoot();
        if (object != null && object instanceof KDTreeNode) {
            Set extendedNodes = this.treeHelper.getExpendedNodes(this.treeSourcePerm);
            if (this.curTabPage == 0) {
                this.treeHelper.addNodes(this.treeAuthorizedPerm, new KDTreeNode[]{(KDTreeNode)object}, extendedNodes);
                this.treeHelper.setDefaultIcon((KDTreeNode)this.treeNormalPerm.getModel().getRoot());
            } else if (this.curTabPage == 1) {
                this.treeHelper.addNodes(this.treeNormalPerm, new KDTreeNode[]{(KDTreeNode)object}, extendedNodes);
                this.treeHelper.setDataRuleIcon((KDTreeNode)this.treeNormalPerm.getModel().getRoot());
            } else if (this.curTabPage == 2) {
                this.treeHelper.addNodes(this.treeForbiddenPerm, new KDTreeNode[]{(KDTreeNode)object}, extendedNodes);
                this.treeHelper.setForbiddenIcon((KDTreeNode)this.treeForbiddenPerm.getModel().getRoot());
            }
        }
        this.isModified = true;
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        TreePath[] treePaths = null;
        if (this.curTabPage == 0) {
            treePaths = this.treeAuthorizedPerm.getSelectionPaths();
            if (treePaths != null) {
                int length = treePaths.length;
                KDTreeNode[] treeNodes = new KDTreeNode[length];
                for (int i = 0; i < length; ++i) {
                    treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
                }
                this.treeHelper.removeNodes(this.treeAuthorizedPerm, treeNodes);
            }
        } else if (this.curTabPage == 1) {
            treePaths = this.treeNormalPerm.getSelectionPaths();
            if (treePaths != null) {
                int length = treePaths.length;
                KDTreeNode[] treeNodes = new KDTreeNode[length];
                for (int i = 0; i < length; ++i) {
                    treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
                }
                this.treeHelper.removeNodes(this.treeNormalPerm, treeNodes);
            }
        } else if (this.curTabPage == 2 && (treePaths = this.treeForbiddenPerm.getSelectionPaths()) != null) {
            int length = treePaths.length;
            KDTreeNode[] treeNodes = new KDTreeNode[length];
            for (int i = 0; i < length; ++i) {
                treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
            }
            this.treeHelper.removeNodes(this.treeForbiddenPerm, treeNodes);
        }
        this.isModified = true;
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteAll_actionPerformed(e);
        KDTreeNode object = null;
        if (this.curTabPage == 0) {
            object = (KDTreeNode)this.treeAuthorizedPerm.getModel().getRoot();
            if (object != null) {
                KDTreeNode[] treeNodes = new KDTreeNode[]{object};
                this.treeHelper.removeNodes(this.treeAuthorizedPerm, treeNodes);
            }
        } else if (this.curTabPage == 1) {
            object = (KDTreeNode)this.treeNormalPerm.getModel().getRoot();
            if (object != null) {
                KDTreeNode[] treeNodes = new KDTreeNode[]{object};
                this.treeHelper.removeNodes(this.treeNormalPerm, treeNodes);
            }
        } else if (this.curTabPage == 2 && (object = (KDTreeNode)this.treeForbiddenPerm.getModel().getRoot()) != null) {
            KDTreeNode[] treeNodes = new KDTreeNode[]{object};
            this.treeHelper.removeNodes(this.treeForbiddenPerm, treeNodes);
        }
        this.isModified = true;
    }

    private UserOrgPermCollection[] getUICurrentUOPs() {
        UserOrgPermCollection[] results = new UserOrgPermCollection[3];
        IObjectPK targetUserPK = this.getTargetUserPK();
        UserOrgPermCollection a_userOrgPerms = this.treeHelper.getUserOrgPermFromTree(this.treeAuthorizedPerm, targetUserPK, null, PermType.AUTHORIZATION);
        UserOrgPermCollection n_userOrgPerms = this.treeHelper.getUserOrgPermFromTree(this.treeNormalPerm, targetUserPK, null, PermType.NORMAL);
        UserOrgPermCollection f_userOrgPerms = this.treeHelper.getUserOrgPermFromTree(this.treeForbiddenPerm, targetUserPK, null, PermType.FORBIDDEN);
        results[0] = a_userOrgPerms;
        results[1] = n_userOrgPerms;
        results[2] = f_userOrgPerms;
        return results;
    }

    private void save() throws Exception {
        if (this.targetUser == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"pleaseSelectDataFirst"));
            return;
        }
        FullOrgUnitCollection bizOrgList = UIUtil.getSelectOrgCol(new HashSet<String>(this.selectBizOrgList));
        FullOrgUnitCollection cuOrgList = UIUtil.getSelectOrgCol(new HashSet<String>(this.selectCuOrgList));
        FullOrgUnitCollection log = new FullOrgUnitCollection();
        log.addCollection(bizOrgList);
        log.addCollection(cuOrgList);
        UserOrgPermCollection[] results = this.getUICurrentUOPs();
        if (bizOrgList.isEmpty() && cuOrgList.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"orgIsNotSelected"));
            return;
        }
        if (this.treeHelper.isEmpty(results)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"pleaseSelectDataFirst"));
            return;
        }
        IUserOrgPermFacade userOrgPermFacade = this.getNewBizInterface();
        IObjectPK sourceUserPK = this.getCurrentUserPK();
        ObjectUuidPK targetUserPK = new ObjectUuidPK(this.targetUser.getId());
        if (this.batchSave) {
            LogProxy logProxy = new LogProxy();
            logProxy.beginLog(null, "saveUserOrgPermsBatch", userOrgPermFacade.getType(), null, this.getBatchSaveOrgPermLogDetail(log, results, "save"));
            UserOrgPermCollection tmp = results[0];
            results[0] = new UserOrgPermCollection();
            if (!this.treeHelper.isEmpty(results)) {
                userOrgPermFacade.saveUsersOrgPermsBatch(sourceUserPK, this.targetUsers, ToolUtils.getCurrentCUPK(), bizOrgList, results);
            }
            if (tmp != null && !tmp.isEmpty()) {
                UserOrgPermCollection[] aresult = new UserOrgPermCollection[]{tmp, new UserOrgPermCollection(), new UserOrgPermCollection()};
                userOrgPermFacade.saveUsersOrgPermsBatch(sourceUserPK, this.targetUsers, ToolUtils.getCurrentCUPK(), cuOrgList, aresult);
            }
            logProxy.end();
            UITools.showMsg((CoreUI)this, EASResource.getString((String)RESOURCE, (String)"accreditPermSucceed"), false);
        } else if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"confirmDelete")) == 0) {
            LogProxy logProxy = new LogProxy();
            logProxy.beginLog(null, "deleteUsersOrgPermsBatch", userOrgPermFacade.getType(), null, this.getBatchSaveOrgPermLogDetail(log, results, "delete"));
            UserOrgPermCollection tmp = results[0];
            results[0] = new UserOrgPermCollection();
            if (!this.treeHelper.isEmpty(results)) {
                userOrgPermFacade.deleteUsersOrgPermsBatch(sourceUserPK, this.targetUsers, ToolUtils.getCurrentCUPK(), bizOrgList, results);
            }
            if (tmp != null && !tmp.isEmpty()) {
                UserOrgPermCollection[] aresult = new UserOrgPermCollection[]{tmp, new UserOrgPermCollection(), new UserOrgPermCollection()};
                userOrgPermFacade.deleteUsersOrgPermsBatch(sourceUserPK, this.targetUsers, ToolUtils.getCurrentCUPK(), cuOrgList, aresult);
            }
            logProxy.end();
            UITools.showMsg((CoreUI)this, EASResource.getString((String)RESOURCE, (String)"deleteSucceed"), false);
        }
    }

    private String getBatchSaveOrgPermLogDetail(FullOrgUnitCollection orgList, UserOrgPermCollection[] results, String operStr) {
        Locale locale = SysContext.getSysContext().getLocale();
        StringBuffer sb = new StringBuffer("");
        sb.append(LogNamesHelper.getLogName("operatorType4Log", locale) + " :" + operStr);
        String numberStr = "";
        if (this.targetUser != null) {
            numberStr = this.targetUser.getNumber();
        }
        sb.append("\n ").append(LogNamesHelper.getLogName("userNumber4Log", locale) + ":" + numberStr);
        sb.append(" \n " + LogNamesHelper.getLogName("orgNumber4Log", locale) + " (");
        int size = orgList.size();
        for (int i = 0; i < size; ++i) {
            sb.append(orgList.get(i).getNumber()).append(",");
        }
        sb.append(")");
        sb.append("\n " + LogNamesHelper.getLogName("permName4Log", locale) + " {");
        for (int k = 0; k < results.length; ++k) {
            UserOrgPermCollection perms = results[k];
            int size2 = perms.size();
            for (int i = 0; i < size2; ++i) {
                sb.append("\n [").append(LogNamesHelper.getLogName("permName4Log", locale) + ":").append(perms.get(i).getPermItem().getAlias()).append(",");
                sb.append("," + LogNamesHelper.getLogName("permType4Log", locale) + ":").append(perms.get(i).getPermType().getAlias()).append("]");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean isPrepareActionSave() {
        return true;
    }

    @Override
    public RequestContext prepareActionSave(IItemAction itemAction) throws Exception {
        return super.prepareActionSave(itemAction);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.batchSave) {
            UserOrgPermCollection accResult;
            List<String> accOrgIdList = PermissionHelper.getPkIds((List)ObjectUtils.createCopy((Object)this.selectBizOrgList));
            List<String> grantOrgIdList = PermissionHelper.getPkIds((List)ObjectUtils.createCopy((Object)this.selectCuOrgList));
            UserOrgPermCollection[] results = this.getUICurrentUOPs();
            ArrayList<String> grantPermIds = new ArrayList<String>();
            ArrayList<String> accPermIds = new ArrayList<String>();
            UserOrgPermCollection grantResult = results[0];
            if (grantResult != null) {
                for (int i = 0; i < grantResult.size(); ++i) {
                    if (StringUtils.isEmpty((String)grantResult.get(i).getPermItemId())) continue;
                    grantPermIds.add(grantResult.get(i).getPermItemId());
                }
            }
            if ((accResult = results[1]) != null) {
                for (int i = 0; i < accResult.size(); ++i) {
                    if (StringUtils.isEmpty((String)accResult.get(i).getPermItemId())) continue;
                    accPermIds.add(accResult.get(i).getPermItemId());
                }
            }
            PermissionHelper.alertPermNeedAuthen((Component)((Object)this), accOrgIdList, accPermIds, grantOrgIdList, grantPermIds);
        }
        this.longTimeSave();
    }

    private void longTimeSave() {
        LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
        dialog.setLongTimeTask(new ILongTimeTask(){

            @Override
            public Object exec() throws Exception {
                Thread.sleep(100L);
                NewUserBatchUI.this.save();
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
        this.isModified = false;
    }

    @Override
    public void actionDeletePerm_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeletePerm_actionPerformed(e);
        this.longTimeSave();
    }

    @Override
    public boolean isPrepareActionSelectOrg() {
        return false;
    }

    @Override
    public RequestContext prepareActionSelectOrg(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionSelectOrg(itemAction);
        String targetUserStr = "";
        if (this.targetUser != null) {
            targetUserStr = this.targetUser.getId().toString();
        }
        request.put("getTargetUser", (Object)targetUserStr);
        return request;
    }

    @Override
    public void actionSelectOrg_actionPerformed(ActionEvent e) throws Exception {
        List oldList = (List)ObjectUtils.createCopy((Object)this.selectOrgList);
        super.actionSelectOrg_actionPerformed(e);
        this.selectOrgList();
        this.execQuery();
        this.mayTreeFilter(oldList, this.selectOrgList);
    }

    private void selectOrgList() throws EASBizException, BOSException {
        block7: {
            block8: {
                block5: {
                    block6: {
                        if (!this.batchSave) break block5;
                        if (this.tabAssign.getSelectedComponent().equals(this.tviewAuthorizedPerm)) break block6;
                        AccreditOrgF7PromptDialog orgF7 = new AccreditOrgF7PromptDialog((IUIObject)this, this.getTargetUserCollection().get(0), true);
                        orgF7.setUserCol(this.getTargetUserCollection());
                        orgF7.setShowAssistantOrg(true);
                        orgF7.setContainSealUp(true);
                        HashSet selectedIDs = new HashSet();
                        selectedIDs.addAll(this.selectOrgList);
                        orgF7.setSelectedOrgIds(selectedIDs);
                        orgF7.show();
                        if (orgF7.isCanceled()) break block7;
                        this.selectOrgList.clear();
                        Object obj = orgF7.getData();
                        OrgUnitInfo[] orgUnitInfoAry = (OrgUnitInfo[])obj;
                        for (int i = 0; i < orgUnitInfoAry.length; ++i) {
                            this.selectOrgList.add(orgUnitInfoAry[i].getId().toString());
                        }
                        break block7;
                    }
                    MultiUserManageF7PromptDialog ctrlUnitF7Dialog = new MultiUserManageF7PromptDialog((IUIObject)this, this.targetUserCol);
                    ctrlUnitF7Dialog.setSelectedOrgIds(new HashSet(this.selectOrgList));
                    ctrlUnitF7Dialog.show();
                    if (ctrlUnitF7Dialog.isCanceled()) break block7;
                    this.selectOrgList.clear();
                    Object obj = ctrlUnitF7Dialog.getData();
                    OrgUnitInfo[] orgUnitInfoAry = (OrgUnitInfo[])obj;
                    for (int i = 0; i < orgUnitInfoAry.length; ++i) {
                        this.selectOrgList.add(orgUnitInfoAry[i].getId().toString());
                    }
                    break block7;
                }
                if (this.tabAssign.getSelectedComponent().equals(this.tviewAuthorizedPerm)) break block8;
                AccreditOrgF7PromptDialog orgF7 = new AccreditOrgF7PromptDialog((IUIObject)this, this.getTargetUserCollection().get(0), true);
                orgF7.setUserCol(this.getTargetUserCollection());
                orgF7.setShowAssistantOrg(true);
                orgF7.setContainSealUp(true);
                HashSet selectedIDs = new HashSet();
                selectedIDs.addAll(this.selectOrgList);
                orgF7.setSelectedOrgIds(selectedIDs);
                orgF7.show();
                if (orgF7.isCanceled()) break block7;
                this.selectOrgList.clear();
                Object obj = orgF7.getData();
                OrgUnitInfo[] orgUnitInfoAry = (OrgUnitInfo[])obj;
                for (int i = 0; i < orgUnitInfoAry.length; ++i) {
                    this.selectOrgList.add(orgUnitInfoAry[i].getId().toString());
                }
                break block7;
            }
            MultiUserManageF7PromptDialog ctrlUnitF7Dialog = new MultiUserManageF7PromptDialog((IUIObject)this, this.targetUserCol);
            ctrlUnitF7Dialog.setSelectedOrgIds(new HashSet(this.selectOrgList));
            ctrlUnitF7Dialog.show();
            if (!ctrlUnitF7Dialog.isCanceled()) {
                this.selectOrgList.clear();
                Object obj = ctrlUnitF7Dialog.getData();
                OrgUnitInfo[] orgUnitInfoAry = (OrgUnitInfo[])obj;
                for (int i = 0; i < orgUnitInfoAry.length; ++i) {
                    this.selectOrgList.add(orgUnitInfoAry[i].getId().toString());
                }
            }
        }
    }

    public void setSelectOrgList(List selectOrgList) {
        this.selectOrgList = selectOrgList;
    }

    public boolean isSelectAllOrg() {
        return this.selectAllOrg;
    }

    public void setSelectAllOrg(boolean selectAllOrg) {
        this.selectAllOrg = selectAllOrg;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public boolean destroyWindow() {
        if (this.isModified) {
            try {
                int isYes;
                FullOrgUnitCollection orgList = ToolUtils.filterSameOrg(UIUtil.getSelectOrgCol(this.tblMain, ToolUtils.aryToStr(this.selectOrgList, false)));
                UserOrgPermCollection[] results = this.getUICurrentUOPs();
                if (!orgList.isEmpty() && !this.treeHelper.isEmpty(results) && MsgBox.isYes((int)(isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"alertSave"))))) {
                    this.longTimeSave();
                }
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return super.destroyWindow();
    }

    private List<IObjectPK> getTargetUserIDs(UserCollection userCol) {
        ArrayList<IObjectPK> userIDs = new ArrayList<IObjectPK>();
        Iterator it = userCol.iterator();
        while (it.hasNext()) {
            Object userObj = it.next();
            if (!(userObj instanceof UserInfo)) continue;
            UserInfo userInfo = (UserInfo)userObj;
            userIDs.add((IObjectPK)new ObjectStringPK(userInfo.getId().toString()));
        }
        return userIDs;
    }

    @Override
    public void actionSltSolution_actionPerformed(ActionEvent e) throws Exception {
        OrgRangeSolutionCollection coll;
        this.f7SltOrgRangeSln = this.getOrgRangeF7();
        if (this.currentSlnInfo != null) {
            this.f7SltOrgRangeSln.setData((Object)this.currentSlnInfo);
        }
        if ((coll = OrgRangeSolutionUtil.getOrgRangeSolutionColl(this.f7SltOrgRangeSln)) != null && coll.size() > 0) {
            OrgRangeSolutionUtil.updateOrgTableList(coll, this.tblMain, this.mainQuery, this.targetUsers, this.getSolutionType());
            FullOrgUnitCollection orgCol = UIUtil.getSelectOrgCol(this.tblMain, false);
            if (orgCol.size() > 0) {
                List oldList = (List)ObjectUtils.createCopy((Object)this.selectOrgList);
                if (this.tabAssign.getSelectedIndex() != 0) {
                    this.solutionMap.put("bizSolution", coll);
                    this.selectOrgList = this.selectBizOrgList = ToolUtils.transCol2ListByPeroperty((IObjectCollection)orgCol, new IObjectCol2List(){

                        @Override
                        public String getList(Object obj) {
                            return ((FullOrgUnitInfo)obj).getId().toString();
                        }
                    });
                } else if (this.tabAssign.getSelectedIndex() == 0) {
                    this.solutionMap.put("managerSolution", coll);
                    this.selectOrgList = this.selectCuOrgList = ToolUtils.transCol2ListByPeroperty((IObjectCollection)orgCol, new IObjectCol2List(){

                        @Override
                        public String getList(Object obj) {
                            return ((FullOrgUnitInfo)obj).getId().toString();
                        }
                    });
                }
                this.execQuery();
                this.mayTreeFilter(oldList, this.selectOrgList);
            }
        }
        if (coll != null && coll.size() == 1) {
            this.currentSlnInfo = coll.get(0);
            this.solutionStatusChange(coll);
        }
        if (coll != null && coll.size() > 1) {
            this.solutionStatusChange(coll);
        }
    }

    @Override
    public void actionSaveSolution_actionPerformed(ActionEvent e) throws Exception {
        if (this.currentSlnInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"saveAsSln"));
            return;
        }
        Set orgList = PermissionUIHelper.getSelectedBizDataRanges(this.tblMain, "orgId");
        if (orgList == null || orgList.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"orgNotSelect"));
            return;
        }
        this.currentSlnInfo.getEntries().clear();
        this.currentSlnInfo.getEntries().addCollection(this.getCurrentSltOrgRangeEntry(orgList));
        IOrgRangeSolution orgRangSln = OrgRangeSolutionFactory.getRemoteInstance();
        orgRangSln.update((IObjectPK)new ObjectUuidPK(this.currentSlnInfo.getId().toString()), this.currentSlnInfo);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"savaSlnSuccess"));
    }

    @Override
    public void actionSaveAsSolution_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        Set orgList = PermissionUIHelper.getSelectedBizDataRanges(this.tblMain, "orgId");
        if (orgList == null || orgList.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"orgNotSelect"));
            return;
        }
        uiContext.put((Object)"orgIds", (Object)this.getCurrentSltOrgRangeEntry(orgList));
        uiContext.put((Object)"orgRangeType", (Object)this.getSolutionType());
        uiContext.put((Object)"currentSlnInfo", (Object)this.currentSlnInfo);
        IUIWindow window = this.showDialog(OrgRangeSolutionEditUI.class.getName(), (Map)uiContext, OprtState.ADDNEW);
        OrgRangeSolutionEditUI ui = (OrgRangeSolutionEditUI)window.getUIObject();
        String id = (String)ui.getUIContext().get("ID");
        if (id != null) {
            IOrgRangeSolution orgRangSln = OrgRangeSolutionFactory.getRemoteInstance();
            this.currentSlnInfo = orgRangSln.getOrgRangeSolutionInfo((IObjectPK)new ObjectUuidPK(id));
        }
        if (this.currentSlnInfo != null) {
            this.btnSaveSolution.setEnabled(true);
        }
    }

    @Override
    public void actionEditSolution_actionPerformed(ActionEvent e) throws Exception {
        if (this.currentSlnInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"saveAsSln"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        Set orgList = PermissionUIHelper.getSelectedBizDataRanges(this.tblMain, "orgId");
        if (orgList == null || orgList.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"orgNotSelect"));
            return;
        }
        uiContext.put((Object)"orgIds", (Object)this.getCurrentSltOrgRangeEntry(orgList));
        uiContext.put((Object)"orgRangeType", (Object)this.getSolutionType());
        uiContext.put((Object)"currentSlnInfo", (Object)this.currentSlnInfo);
        uiContext.put((Object)"ID", (Object)this.currentSlnInfo.getId());
        this.showDialog(OrgRangeSolutionEditUI.class.getName(), (Map)uiContext, OprtState.EDIT);
    }

    @Override
    public void actionRemoveSolution_actionPerformed(ActionEvent e) throws Exception {
        if (this.currentSlnInfo != null) {
            if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"confirmDelCurrentSln")) == 0) {
                IOrgRangeSolution orgRangSln = OrgRangeSolutionFactory.getRemoteInstance();
                orgRangSln.delete((IObjectPK)new ObjectUuidPK(this.currentSlnInfo.getId().toString()));
                this.currentSlnInfo = null;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"delSlnSuccess"));
                this.btnSaveSolution.setEnabled(false);
                this.btnSaveAsSolution.setEnabled(true);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"noExistSln"));
        }
    }

    private IUIWindow showDialog(String strUI, Map map, String status) throws Exception {
        map.put("Owner", this);
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curDialog = uiFactory.create(strUI, map, null, status);
            curDialog.show();
            return curDialog;
        }
        catch (UIException ex1) {
            logger.error((Object)ex1.getMessage(), (Throwable)ex1);
            return null;
        }
    }

    private KDBizPromptBox getOrgRangeF7() {
        return OrgRangeSolutionUtil.getOrgRangeF7(this.getSolutionType());
    }

    private OrgRangeSolutionEntryCollection getCurrentSltOrgRangeEntry(Set orgList) {
        OrgRangeSolutionEntryCollection coll = new OrgRangeSolutionEntryCollection();
        List orgIds = ToolUtils.trans2List(orgList);
        int size = orgIds.size();
        for (int i = 0; i < size; ++i) {
            OrgRangeSolutionEntryInfo entryInfo = new OrgRangeSolutionEntryInfo();
            FullOrgUnitInfo fouInfo = new FullOrgUnitInfo();
            fouInfo.setId(BOSUuid.read((String)((String)orgIds.get(i))));
            entryInfo.setOrg(fouInfo);
            coll.add(entryInfo);
        }
        return coll;
    }

    private void solutionStatusChange(OrgRangeSolutionCollection orgSolCol) {
        if (orgSolCol == null || orgSolCol.size() == 0) {
            this.btnSaveSolution.setEnabled(false);
            this.btnEditSolution.setEnabled(true);
            this.btnRemoveSolution.setEnabled(true);
            this.currentSlnInfo = null;
        } else if (orgSolCol.size() == 1) {
            this.btnSaveSolution.setEnabled(true);
            this.btnEditSolution.setEnabled(true);
            this.btnRemoveSolution.setEnabled(true);
            this.currentSlnInfo = orgSolCol.get(0);
        } else {
            this.btnSaveSolution.setEnabled(false);
            this.btnEditSolution.setEnabled(false);
            this.btnRemoveSolution.setEnabled(false);
        }
    }

    private OrgRangeType getSolutionType() {
        return this.tabAssign.getSelectedIndex() == 0 ? OrgRangeType.MANAGE_ORG_TYPE : OrgRangeType.BIZ_ORG_TYPE;
    }
}

