/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.OtherOwnerCollection;
import com.kingdee.eas.base.permission.OtherOwnerInfo;
import com.kingdee.eas.base.permission.SpecialDataPermInfo;
import com.kingdee.eas.base.permission.client.AbstractOtherOwnerF7UI;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class OtherOwnerF7UI
extends AbstractOtherOwnerF7UI
implements KDPromptSelector {
    private static final Logger logger = CoreUIObject.getLogger(OtherOwnerF7UI.class);
    protected IUIWindow currDialog = null;
    private Object parentWindow = null;
    private Map fieldMap = new HashMap();
    private Map aliasMap = new HashMap();
    private static final String PERMINFO = "perminfo";
    private static final String BOSTYPE = "bostype";
    private IMetaDataLoader metaLoader;
    private String otherOwner = "";
    private String botype = null;
    private SpecialDataPermInfo permInfo = null;
    private boolean isCancel = false;

    public void onLoad() throws Exception {
        this.initContext();
    }

    public void initContext() {
        this.botype = (String)this.getUIContext().get(BOSTYPE);
        this.permInfo = (SpecialDataPermInfo)this.getUIContext().get(PERMINFO);
        if (this.permInfo != null && this.permInfo.getOtherOwners() != null) {
            Iterator it = this.permInfo.getOtherOwners().iterator();
            while (it.hasNext()) {
                OtherOwnerInfo ooInfo = (OtherOwnerInfo)it.next();
                this.fieldMap.put(ooInfo.getPropertyName(), ooInfo);
            }
        }
    }

    private void initTable() {
        IColumn isUserCol = this.ownerTable.addColumn();
        isUserCol.getStyleAttributes().setHided(true);
        EntityObjectInfo meta = this.createIMetaDataLoader().getEntity(new BOSObjectType(this.botype));
        PropertyCollection pc = meta.getInheritedDuplicatedProperties();
        for (int i = 0; i < pc.size(); ++i) {
            PropertyInfo childproperty = pc.get(i);
            if (!(childproperty instanceof LinkPropertyInfo)) continue;
            String propName = childproperty.getName();
            String propAlias = childproperty.getAlias();
            Locale[] locals = MultiLangHelper.getDefinedOriginLocales(null);
            int len = locals.length;
            for (int index = 0; index < len; ++index) {
                this.aliasMap.put(MultiLangHelper.getFieldName(propName, locals[index]), childproperty.getAlias(locals[index]));
            }
            boolean isOwner = false;
            boolean isUser = true;
            if (this.fieldMap.get(propName) != null) {
                isOwner = true;
            }
            LinkPropertyInfo lp = (LinkPropertyInfo)childproperty;
            String referenceEntityName = lp.getRelationship().getSupplierObject().getName();
            if (propName.equalsIgnoreCase("creator") || !"User".equalsIgnoreCase(referenceEntityName) && !"Person".equalsIgnoreCase(referenceEntityName)) continue;
            if ("Person".equalsIgnoreCase(referenceEntityName)) {
                isUser = false;
            }
            IRow row = this.ownerTable.addRow();
            row.getCell(0).setValue((Object)isOwner);
            row.getCell(1).setValue((Object)propAlias);
            row.getCell(2).setValue((Object)propName);
            row.getCell(3).setValue((Object)isUser);
        }
        for (int index = this.ownerTable.getRowCount(); index < 11; ++index) {
            this.ownerTable.addRow().getStyleAttributes().setLocked(true);
        }
    }

    public IMetaDataLoader createIMetaDataLoader() {
        if (this.metaLoader == null) {
            this.metaLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        }
        return this.metaLoader;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initTable();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.permInfo != null) {
            OtherOwnerCollection oc = this.permInfo.getOtherOwners();
            oc.clear();
            int size = this.ownerTable.getRowCount();
            for (int index = 0; index < size; ++index) {
                IRow row = this.ownerTable.getRow(index);
                if (!Boolean.TRUE.equals(row.getCell(0).getValue())) continue;
                OtherOwnerInfo ooInfo = new OtherOwnerInfo();
                ooInfo.setPropertyName(row.getCell(2).getValue().toString());
                ooInfo.setPropertyAlias(row.getCell(1).getValue().toString());
                Object isUserObj = row.getCell(3).getValue();
                boolean isUser = true;
                if (isUserObj instanceof Boolean) {
                    isUser = (Boolean)isUserObj;
                }
                ooInfo.setIsOtherOwner(isUser);
                ooInfo.setSpecialDataPerm(this.permInfo);
                ooInfo.setObjectType(this.permInfo.getBizObjectType());
                ooInfo.setCU(this.permInfo.getCU());
                oc.add(ooInfo);
                Locale[] locals = MultiLangHelper.getDefinedOriginLocales(null);
                int len = locals.length;
                for (int lIndex = 0; lIndex < len; ++lIndex) {
                    String otherOwnerAlias = (String)this.aliasMap.get(MultiLangHelper.getFieldName("otherOwner", locals[lIndex]));
                    if (otherOwnerAlias == null) {
                        otherOwnerAlias = "";
                    }
                    if (otherOwnerAlias.length() > 0) {
                        otherOwnerAlias = otherOwnerAlias + ",";
                    }
                    otherOwnerAlias = otherOwnerAlias + (String)this.aliasMap.get(MultiLangHelper.getFieldName(ooInfo.getPropertyName(), locals[lIndex]));
                    this.aliasMap.put(MultiLangHelper.getFieldName("otherOwner", locals[lIndex]), otherOwnerAlias);
                }
            }
            Locale[] locals = MultiLangHelper.getDefinedOriginLocales(null);
            int len = locals.length;
            for (int lIndex = 0; lIndex < len; ++lIndex) {
                this.otherOwner = (String)this.aliasMap.get(MultiLangHelper.getFieldName("otherOwner", locals[lIndex]));
                this.permInfo.setOtherOwner(this.otherOwner, locals[lIndex]);
            }
        }
        super.destroyWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        super.destroyWindow();
    }

    public void show() {
        logger.debug((Object)"show Event!");
        IUIFactory uiFactory = null;
        UIContext hm = new UIContext(this.getParentWindow());
        hm.put(BOSTYPE, this.getBotype());
        hm.put(PERMINFO, this.getPermInfo());
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            this.currDialog = uiFactory.create(((Object)((Object)this)).getClass().getName(), (Map)hm);
            this.currDialog.show();
        }
        catch (UIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private Object getParentWindow() {
        return this.parentWindow;
    }

    public void setParentWindow(Object parentWindow) {
        this.parentWindow = parentWindow;
    }

    public boolean isCanceled() {
        boolean result = true;
        if (this.currDialog != null && (OtherOwnerF7UI)this.currDialog.getUIObject() != null) {
            result = ((OtherOwnerF7UI)this.currDialog.getUIObject()).isCancel;
        }
        return result;
    }

    public Object getData() {
        String result = "";
        if (this.currDialog != null && (OtherOwnerF7UI)this.currDialog.getUIObject() != null) {
            result = ((OtherOwnerF7UI)this.currDialog.getUIObject()).getOtherOwner();
        }
        return result;
    }

    public String getBotype() {
        return this.botype;
    }

    public void setBotype(String btype) {
        this.botype = btype;
    }

    public String getOtherOwner() {
        String otherOwner = (String)this.aliasMap.get(MultiLangHelper.getFieldName("otherOwner", SysContext.getSysContext().getOriginLocale()));
        return otherOwner;
    }

    public Map getFieldMap() {
        return this.fieldMap;
    }

    public void setFieldMap(Map fieldMap) {
        this.fieldMap = fieldMap;
    }

    public SpecialDataPermInfo getPermInfo() {
        return this.permInfo;
    }

    public void setPermInfo(SpecialDataPermInfo spInfo) {
        this.permInfo = spInfo;
    }
}

