/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.ConfigurationInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IRoleMenuFacade;
import com.kingdee.eas.base.permission.IRolePerm;
import com.kingdee.eas.base.permission.MainMenuItemCollection;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RoleMenuFacadeFactory;
import com.kingdee.eas.base.permission.RolePermCollection;
import com.kingdee.eas.base.permission.RolePermFactory;
import com.kingdee.eas.base.permission.RolePermInfo;
import com.kingdee.eas.base.permission.RuleParser;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.base.permission.client.AbstractRoleAccreditUI;
import com.kingdee.eas.base.permission.client.IPopMenuSourceUI;
import com.kingdee.eas.base.permission.client.IRuleAccreditUI;
import com.kingdee.eas.base.permission.client.RoleDiscretePermViewUI;
import com.kingdee.eas.base.permission.client.RoleFieldAccessAccreditUI;
import com.kingdee.eas.base.permission.client.RulePanel;
import com.kingdee.eas.base.permission.client.helper.RoleAccreditLogHelper;
import com.kingdee.eas.base.permission.client.quickperm.PopMenuHelper;
import com.kingdee.eas.base.permission.client.quickperm.PopMenuPerformContext;
import com.kingdee.eas.base.permission.client.tree.IAccreditTreeBuilder;
import com.kingdee.eas.base.permission.client.tree.PermissionTreeBuilderFactory;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.base.permission.util.LogProxy;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.base.uiframe.client.util.MainMenuComparator;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class RoleAccreditUI
extends AbstractRoleAccreditUI
implements IRuleAccreditUI,
IPopMenuSourceUI {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static Logger logger = Logger.getLogger(RoleAccreditUI.class);
    private KDTreeNode branch = null;
    private static final Color disableColor = new Color(102, 102, 102);
    private static final Icon ICON_FOLDER_OPEN = EASResource.getIcon((String)"imgTree_folder_openpick");
    private static final Icon ICON_FOLDER_CLOSE = EASResource.getIcon((String)"imgTree_folder_closepick");
    private static final Icon ICON_LEAF = EASResource.getIcon((String)"imgTree_folder_leafpick");
    private static final Icon ICON_LEAF_ADVICE = EASResource.getIcon((String)"imgTree_folder_leafpick");
    private static final Icon ICON_FOLDER_OPEN_ADVICE = EASResource.getIcon((String)"imgTree_folder_openpick");
    private static final int NORMAL_INDEX = 1;
    private static final int FORBIDDEN_INDEX = 2;
    private static final int AUTHOORIZATION_INDEX = 0;
    private static final int COM_FUNCTION_INDEX = 3;
    private static final int ACCREDIT_INDEX = 0;
    private static final int MENU_INDEX = 1;
    private IAccreditTreeBuilder builder = null;
    private boolean isShowRule = false;
    private RulePanel rulePanel = null;
    private RolePermCollection rpsCopy = null;
    private ConfigurationInfo configurationInfo = null;
    private PopMenuHelper popMenuHelper = null;
    private static String ROOT_NODE = "EAS";

    private void initUI() throws Exception {
        this.rulePanel = new RulePanel();
        this.rulePanel.setStatus(this.getOprtState());
        this.btnShowRule.setVisible(!this.isShowRule);
        this.btnHideRule.setVisible(this.isShowRule);
        this.btnDiscretePerm.setVisible(false);
        this.tHelper.getDisabledTables().add(this.rulePanel.getTable());
        this.tabAssign.removeAll();
        this.tabAssign.add((Component)this.tviewAuthorization, (Object)this.resHelper.getString("tviewAuthorization.constraints"));
        this.tabAssign.add((Component)this.tviewNormalPerm, (Object)this.resHelper.getString("tviewNormalPerm.constraints"));
        this.tabAssign.add((Component)this.tviewForbiddenPerm, (Object)this.resHelper.getString("tviewForbiddenPerm.constraints"));
        this.tabAssign.add((Component)this.tviewComFunction, (Object)this.resHelper.getString("tviewComFunction.constraints"));
        this.tabAssign.setSelectedIndex(1);
        this.menuTipLbl.setVisible(false);
        this.tviewAuthorizedPerm.setShowControlPanel(true);
        this.tviewAuthorizedPerm.setShowButton(true);
        this.tviewAuthorizedPerm.setTitle(EASResource.getString((String)RESOURCE, (String)"QUICK_PANEL"));
        this.tviewNormalPerm.setShowControlPanel(true);
        this.tviewNormalPerm.setShowButton(true);
        this.tviewNormalPerm.setTitle(EASResource.getString((String)RESOURCE, (String)"QUICK_PANEL"));
        this.tviewForbiddenPerm.setShowControlPanel(true);
        this.tviewForbiddenPerm.setShowButton(true);
        this.tviewForbiddenPerm.setTitle(EASResource.getString((String)RESOURCE, (String)"QUICK_PANEL"));
        this.tviewAuthorization.setShowControlPanel(true);
        this.tviewAuthorization.setShowButton(true);
        this.tviewAuthorization.setTitle(EASResource.getString((String)RESOURCE, (String)"QUICK_PANEL"));
        this.tviewMenu.setShowButton(true);
        this.tviewMenu.setTitle(EASResource.getString((String)RESOURCE, (String)"QUICK_PANEL"));
        this.tviewComFunction.setShowButton(true);
        this.tviewComFunction.setTitle("\u5feb\u6377\u9762\u677f");
    }

    private boolean isBizAdmin() {
        return SysContext.getSysContext().getCurrentUserInfo().isBizAdmin();
    }

    @Override
    public boolean isPrepareInit() {
        this.tviewAuthorizedPerm.setTitle(this.resHelper.getString("tviewAuthorizedPerm.title"));
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman hander = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("rolePK", (Object)this.getRolePK());
        hander.setRequestContext((Serializable)request);
        return hander;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.initTrees();
        this.loadConfigurationInfo();
        this.setTitle();
        this.setRulePanelStatus();
    }

    private boolean isMenuTreeInited(KDTree tree) {
        return tree.getModel() != null && tree.getModel().getRoot() != null && ROOT_NODE.equalsIgnoreCase(((DefaultKingdeeTreeNode)tree.getModel().getRoot()).getText());
    }

    private void buildLeftMainMenuTree(KDTree tree) throws EASBizException, BOSException {
        if (this.isMenuTreeInited(tree)) {
            return;
        }
        Set<MainMenuItemInfo> leftMainMenuSet = this.getLeftMainMenuItemCol();
        RoleAccreditUI.buildMenuTree(tree, leftMainMenuSet);
    }

    private void buildRightMainMenuTree(KDTree tree) throws EASBizException, BOSException {
        if (this.isMenuTreeInited(tree)) {
            return;
        }
        Set<MainMenuItemInfo> rightMainMenuSet = this.getRightMainMenuItemCol();
        RoleAccreditUI.buildMenuTree(tree, rightMainMenuSet);
    }

    private Set<MainMenuItemInfo> getLeftMainMenuItemCol() throws EASBizException, BOSException {
        IRoleMenuFacade iRoleMenuFacade = RoleMenuFacadeFactory.getRemoteInstance();
        return iRoleMenuFacade.getMayAccreditMenuColByRoleId(this.getRolePK().toString());
    }

    private Set<MainMenuItemInfo> getRightMainMenuItemCol() throws BOSException, EASBizException {
        HashSet<MainMenuItemInfo> ret = new HashSet<MainMenuItemInfo>();
        IRoleMenuFacade iRoleMenuFacade = RoleMenuFacadeFactory.getRemoteInstance();
        MainMenuItemCollection menuCol = iRoleMenuFacade.getAccreditMenuColByRoleId(this.getRolePK().toString());
        int size = menuCol.size();
        for (int i = 0; i < size; ++i) {
            ret.add(menuCol.get(i));
        }
        return ret;
    }

    private static void buildMenuTree(KDTree tree, Set<MainMenuItemInfo> menuSet) {
        KDTreeNode root = null;
        if (menuSet.size() > 0) {
            Map<String, List<MainMenuItemInfo>> parentMap = RoleAccreditUI.getParentMap(menuSet);
            root = new KDTreeNode((Object)ROOT_NODE);
            RoleAccreditUI.buildRoot(root, parentMap);
        }
        tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
        if (root != null) {
            tree.expandPath(new TreePath(root.getPath()));
            tree.setShowsRootHandles(true);
        }
        tree.repaint();
    }

    private static Map<String, List<MainMenuItemInfo>> getParentMap(Set<MainMenuItemInfo> menuSet) {
        HashMap<String, List<MainMenuItemInfo>> parentMap = new HashMap<String, List<MainMenuItemInfo>>();
        for (MainMenuItemInfo menuItemInfo : menuSet) {
            MainMenuItemInfo parent = menuItemInfo.getParent();
            String parentId = null;
            parentId = parent == null ? ROOT_NODE : StringUtil.cnulls((Object)parent.getId());
            ArrayList<MainMenuItemInfo> children = (ArrayList<MainMenuItemInfo>)parentMap.get(parentId);
            if (children == null) {
                children = new ArrayList<MainMenuItemInfo>();
            }
            children.add(menuItemInfo);
            parentMap.put(parentId, children);
        }
        return parentMap;
    }

    private static void buildRoot(KDTreeNode root, Map<String, List<MainMenuItemInfo>> parentMap) {
        Object userObj = root.getUserObject();
        List<MainMenuItemInfo> children = null;
        if (userObj instanceof MainMenuItemInfo) {
            MainMenuItemInfo parent = (MainMenuItemInfo)userObj;
            String parentId = parent.getId().toString();
            children = parentMap.get(parentId);
            if (children == null) {
                return;
            }
            Collections.sort(children, new MainMenuComparator("longNumber"));
        } else {
            children = parentMap.get(ROOT_NODE);
            Collections.sort(children, new MainMenuComparator("order"));
        }
        for (int i = 0; i < children.size(); ++i) {
            MainMenuItemInfo info = children.get(i);
            KDTreeNode node = new KDTreeNode((Object)info);
            root.add((MutableTreeNode)node);
            if (info.isIsLeaf()) continue;
            RoleAccreditUI.buildRoot(node, parentMap);
        }
    }

    private void loadConfigurationInfo() throws EASBizException, BOSException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        this.configurationInfo = iPermission.getConfigurationInfo();
    }

    public void onShow() throws Exception {
        super.onShow();
        IUIWindow win = this.getUIWindow();
        ((Frame)win).setSize(700, 630);
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 700, 354));
    }

    private void showRulePanel(boolean isVisible) {
        this.btnShowRule.setVisible(!this.isShowRule);
        this.btnHideRule.setVisible(this.isShowRule);
        IUIWindow win = this.getUIWindow();
        this.rulePanel.setVisible(isVisible);
        if (isVisible) {
            if (win instanceof UIModelDialog) {
                ((UIModelDialog)win).setSize(700, 630);
            } else if (win instanceof Frame) {
                ((Frame)win).setSize(700, 630);
                this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 700, 500));
                this.add((Component)((Object)this.rulePanel), new KDLayout.Constraints(0, 335, 700, 170, 294));
                ((Frame)win).repaint();
                ((Frame)win).validate();
            }
        } else if (win instanceof UIModelDialog) {
            ((UIModelDialog)win).setSize(700, 630);
        } else if (win instanceof Frame) {
            ((Frame)win).setSize(700, 630);
            this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 700, 354));
        }
    }

    private void initTrees() throws Exception {
        this.builder = PermissionTreeBuilderFactory.getRolePermTreeBuilder();
        this.buildTree();
        this.addPopupMenu();
    }

    private void addPopupMenu() {
        UIUtil.addStandardPopupMenu(this.treeAuthorizedPerm);
        UIUtil.addStandardPopupMenu(this.treeForbiddenPerm);
    }

    private void setTitle() {
        this.setUITitle(this.getUITitle() + " - " + this.getRoleName());
    }

    private void buildTree() throws Exception {
        this.branch = this.builder.createTreeBranch();
        this.buildSourceTree();
        this.buildTargetTree();
        this.refreshSelectCustomIco();
    }

    private void buildSourceTree() throws Exception {
        KDTreeNode root = null;
        if (!this.isBizAdmin()) {
            IRolePerm iRolePerm = RolePermFactory.getRemoteInstance();
            RolePermCollection rolePerms = iRolePerm.getSourceRolePerms();
            root = this.builder.buildTreeRoot(this.branch, (IObjectCollection)rolePerms);
        } else {
            IRolePerm iRolePerm = RolePermFactory.getRemoteInstance();
            RolePermCollection rolePerms = iRolePerm.getSourceRolePerms();
            root = this.builder.buildTreeRoot(this.branch, (IObjectCollection)rolePerms);
        }
        ((DefaultTreeModel)this.treeAuthorizedPerm.getModel()).setRoot((TreeNode)root);
    }

    private void refreshSelectCustomIco() {
        TreeModel model = this.treeAuthorizedPerm.getModel();
        if (this.tabAssign.getSelectedIndex() == 1) {
            this.addCustomIcon((DefaultKingdeeTreeNode)model.getRoot(), (DefaultKingdeeTreeNode)this.treeNormalPerm.getModel().getRoot());
        } else if (this.tabAssign.getSelectedIndex() == 2) {
            this.addCustomIcon((DefaultKingdeeTreeNode)model.getRoot(), (DefaultKingdeeTreeNode)this.treeForbiddenPerm.getModel().getRoot());
        } else if (this.tabAssign.getSelectedIndex() == 0) {
            this.addCustomIcon((DefaultKingdeeTreeNode)model.getRoot(), (DefaultKingdeeTreeNode)this.treeAuthorization.getModel().getRoot());
        } else if (this.tabAssign.getSelectedIndex() == 3) {
            model = this.treeMenu.getModel();
            this.addCustomIcon((DefaultKingdeeTreeNode)model.getRoot(), (DefaultKingdeeTreeNode)this.treeComFunction.getModel().getRoot());
        }
        try {
            this.onShow();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void addCustomIcon(DefaultKingdeeTreeNode sourceRoot, DefaultKingdeeTreeNode targetRoot) {
        if (sourceRoot == null) {
            return;
        }
        Map<String, DefaultKingdeeTreeNode> keyMapNode = this.getKeyMapNode(targetRoot);
        Enumeration enumeration = sourceRoot.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            MainMenuItemInfo mainMenuItemInfo;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)enumeration.nextElement();
            boolean flag = false;
            Object userObject = node.getUserObject();
            if (userObject instanceof RolePermInfo) {
                RolePermInfo rolePermInfo = (RolePermInfo)userObject;
                PermItemInfo permItemInfo = rolePermInfo.getPermItem();
                if (permItemInfo != null && permItemInfo.getId() != null && keyMapNode.containsKey(permItemInfo.getId().toString())) {
                    this.setAdviceIcon(node);
                    flag = true;
                }
            } else if (userObject instanceof MainMenuItemInfo && (mainMenuItemInfo = (MainMenuItemInfo)userObject) != null && mainMenuItemInfo.getId() != null && keyMapNode.containsKey(mainMenuItemInfo.getId().toString())) {
                this.setAdviceIcon(node);
                flag = true;
            }
            if (flag) continue;
            this.setNoAdviceIcon(node);
        }
    }

    private Map<String, DefaultKingdeeTreeNode> getKeyMapNode(DefaultKingdeeTreeNode rootNode) {
        HashMap<String, DefaultKingdeeTreeNode> hashMap = new HashMap<String, DefaultKingdeeTreeNode>();
        if (rootNode != null) {
            Enumeration enumeration = rootNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                MainMenuItemInfo mainMenuItemInfo;
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)enumeration.nextElement();
                Object userObject = node.getUserObject();
                if (userObject instanceof RolePermInfo) {
                    RolePermInfo rolePermInfo = (RolePermInfo)userObject;
                    PermItemInfo permItemInfo = rolePermInfo.getPermItem();
                    if (permItemInfo == null || permItemInfo.getId() == null) continue;
                    hashMap.put(permItemInfo.getId().toString(), node);
                    continue;
                }
                if (!(userObject instanceof MainMenuItemInfo) || (mainMenuItemInfo = (MainMenuItemInfo)userObject) == null || mainMenuItemInfo.getId() == null) continue;
                hashMap.put(mainMenuItemInfo.getId().toString(), node);
            }
        }
        return hashMap;
    }

    public void setAdviceIcon(DefaultKingdeeTreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        if (treeNode.isLeaf()) {
            treeNode.setCustomIcon(ICON_LEAF_ADVICE);
        } else {
            treeNode.setCustomIcon(ICON_FOLDER_OPEN_ADVICE);
        }
    }

    public void setNoAdviceIcon(DefaultKingdeeTreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        if (treeNode.isLeaf()) {
            treeNode.setCustomIcon(null);
        } else {
            treeNode.setCustomIcon(null);
        }
    }

    private void buildNormalTree(RolePermCollection rolePerms) throws Exception {
        KDTreeNode root = this.builder.buildTreeRoot(this.branch, (IObjectCollection)rolePerms);
        ((DefaultTreeModel)this.treeNormalPerm.getModel()).setRoot((TreeNode)root);
        this.builder.setDataRuleIcon(root);
    }

    private void buildForbiddenTree(RolePermCollection rolePerms) throws Exception {
        KDTreeNode root = this.builder.buildTreeRoot(this.branch, (IObjectCollection)rolePerms);
        ((DefaultTreeModel)this.treeForbiddenPerm.getModel()).setRoot((TreeNode)root);
        this.builder.setForbiddenIcon(root);
    }

    private void buildAuthorizationTree(RolePermCollection rolePerms) throws Exception {
        KDTreeNode root = this.builder.buildTreeRoot(this.branch, (IObjectCollection)rolePerms);
        ((DefaultTreeModel)this.treeAuthorization.getModel()).setRoot((TreeNode)root);
        this.builder.setDataRuleIcon(root);
    }

    public RoleInfo getTargetRole() {
        RoleInfo roleInfo = new RoleInfo();
        roleInfo.setId(BOSUuid.read((String)this.getRolePK().toString()));
        roleInfo.setNumber(this.getRoleNumber());
        roleInfo.setName(this.getRoleName());
        return roleInfo;
    }

    private IObjectPK getRolePK() {
        return new ObjectUuidPK((String)this.getUIContext().get("targetID"));
    }

    public String getRoleNumber() {
        return (String)this.getUIContext().get("number");
    }

    private String getRoleName() {
        return (String)this.getUIContext().get("name");
    }

    @Override
    public boolean isPrepareActionSubmit() {
        return false;
    }

    @Override
    public RequestContext prepareActionSubmit(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionSubmit(itemAction);
        RolePermCollection[] results = this.getUOPReuslts();
        request.put("results", (Object)results);
        request.put("LogDetail", (Object)RoleAccreditLogHelper.getLogDetail(results, this.getRoleNumber()));
        request.put("RolePK", (Object)this.getRolePK());
        return request;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.checkCurrentNodeRule();
        this.save();
        UITools.showMsg(this, EASResource.getString((String)RESOURCE, (String)"accreditPermSucceed"), false);
    }

    public IRolePerm getBizInterface() throws BOSException {
        return RolePermFactory.getRemoteInstance();
    }

    private void storeRuleTree() throws Exception {
        Object obj = null;
        obj = this.tabAssign.getSelectedIndex() == 1 ? this.treeNormalPerm.getLastSelectedPathComponent() : this.treeAuthorization.getLastSelectedPathComponent();
        if (obj != null) {
            this.storeRule((KDTreeNode)obj);
        }
    }

    private void save() throws Exception {
        this.storeRuleTree();
        RolePermCollection[] results = this.getUOPReuslts();
        if (UserRoleOrgManagerFactory.getRemoteInstance().existAssignedUser(this.getRolePK())) {
            RolePermCollection addRolePermColl = results[0];
            ArrayList<String> permItemIdList = new ArrayList<String>(results.length);
            if (addRolePermColl != null && addRolePermColl.size() > 0) {
                for (int i = 0; i < addRolePermColl.size(); ++i) {
                    if (StringUtils.isEmpty((String)addRolePermColl.get(i).getPermItemId())) continue;
                    permItemIdList.add(addRolePermColl.get(i).getPermItemId());
                }
            }
            ArrayList<String> orgIdList = new ArrayList<String>();
            orgIdList.add("all");
            PermissionHelper.alertPermNeedAuthen((Component)((Object)this), orgIdList, permItemIdList, null, null);
        }
        IRolePerm iRolePerm = this.getBizInterface();
        RoleAccreditLogHelper roleAccreditLogHelper = new RoleAccreditLogHelper();
        LogProxy logProxy = roleAccreditLogHelper.doLog(results, this.getRoleNumber());
        iRolePerm.saveRolePerms(this.getRolePK(), this.getCurrentRPs());
        roleAccreditLogHelper.doLogEnd(logProxy);
        this.saveRoleMenu();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    RoleAccreditUI.this.reloadUI();
                }
                catch (Exception e) {
                    RoleAccreditUI.this.handUIException(e);
                }
            }
        });
    }

    private void saveRoleMenu() throws Exception {
        IRoleMenuFacade iRoleMenuFacade = RoleMenuFacadeFactory.getRemoteInstance();
        HashSet<String> menuIdSet = new HashSet<String>();
        KDTreeNode accreditedRoot = (KDTreeNode)this.treeComFunction.getModel().getRoot();
        Set<MainMenuItemInfo> mainMenuItemSet = this.getSubMainMenuItemSet(accreditedRoot);
        for (MainMenuItemInfo info : mainMenuItemSet) {
            if (!info.isIsLeaf()) continue;
            menuIdSet.add(info.getId().toString());
        }
        iRoleMenuFacade.saveRoleMenu(this.getRolePK().toString(), menuIdSet);
    }

    private boolean permChanged(RolePermCollection[] results) {
        assert (results != null);
        int length = results.length;
        for (int i = 0; i < length; ++i) {
            if (results[i].size() <= 0) continue;
            return true;
        }
        return false;
    }

    private RolePermCollection[] getUOPReuslts() {
        RolePermCollection[] results = new RolePermCollection[3];
        RolePermCollection newRPs = this.getCurrentRPs();
        RolePermCollection oldRPs = this.rpsCopy;
        RolePermCollection addRPs = new RolePermCollection();
        RolePermCollection delRPs = new RolePermCollection();
        RolePermCollection updateRPs = new RolePermCollection();
        Map mapOldRP = this.createRPMap(oldRPs);
        int size = newRPs.size();
        for (int i = 0; i < size; ++i) {
            String key = PermissionCommonUtil.getKey(newRPs.get(i));
            if (mapOldRP.containsKey(key)) {
                RolePermInfo oldRP = (RolePermInfo)mapOldRP.get(key);
                RolePermInfo newRP = newRPs.get(i);
                if (!this.isRuleChanged(oldRP.getRuleStructure(), newRP.getRuleStructure())) continue;
                newRPs.get(i).setId(oldRP.getId());
                updateRPs.add(newRPs.get(i));
                continue;
            }
            addRPs.add(newRPs.get(i));
        }
        Map mapNewUOP = this.createRPMap(newRPs);
        int size2 = oldRPs.size();
        for (int i = 0; i < size2; ++i) {
            String key = PermissionCommonUtil.getKey(oldRPs.get(i));
            if (mapNewUOP.containsKey(key)) continue;
            delRPs.add(oldRPs.get(i));
        }
        results[0] = addRPs;
        results[1] = delRPs;
        results[2] = updateRPs;
        return results;
    }

    private RolePermCollection getCurrentRPs() {
        Enumeration enumForbidden;
        RolePermInfo rolePermInfo;
        KDTreeNode treeNode;
        RolePermCollection rolePerms = new RolePermCollection();
        RoleInfo roleInfo = new RoleInfo();
        roleInfo.setId(BOSUuid.read((String)this.getRolePK().toString()));
        roleInfo.setNumber(this.getRoleNumber());
        Object object = this.treeNormalPerm.getModel().getRoot();
        if (object != null) {
            KDTreeNode rootAccredit = (KDTreeNode)object;
            Enumeration enumAccredit = rootAccredit.breadthFirstEnumeration();
            while (enumAccredit.hasMoreElements()) {
                treeNode = (KDTreeNode)enumAccredit.nextElement();
                rolePermInfo = (RolePermInfo)treeNode.getUserObject();
                if (!rolePermInfo.getPermItem().isIsLeaf()) continue;
                rolePermInfo.setRole(roleInfo);
                rolePermInfo.setPermType(PermType.NORMAL);
                rolePerms.add(rolePermInfo);
            }
        }
        if ((object = this.treeForbiddenPerm.getModel().getRoot()) != null) {
            KDTreeNode rootForbidden = (KDTreeNode)object;
            enumForbidden = rootForbidden.breadthFirstEnumeration();
            while (enumForbidden.hasMoreElements()) {
                treeNode = (KDTreeNode)enumForbidden.nextElement();
                rolePermInfo = (RolePermInfo)treeNode.getUserObject();
                if (!rolePermInfo.getPermItem().isIsLeaf()) continue;
                rolePermInfo.setRole(roleInfo);
                rolePermInfo.setPermType(PermType.FORBIDDEN);
                rolePerms.add(rolePermInfo);
            }
        }
        if ((object = this.treeAuthorization.getModel().getRoot()) != null) {
            KDTreeNode authorizationNode = (KDTreeNode)object;
            enumForbidden = authorizationNode.breadthFirstEnumeration();
            while (enumForbidden.hasMoreElements()) {
                treeNode = (KDTreeNode)enumForbidden.nextElement();
                rolePermInfo = (RolePermInfo)treeNode.getUserObject();
                if (!rolePermInfo.getPermItem().isIsLeaf()) continue;
                rolePermInfo.setRole(roleInfo);
                rolePermInfo.setPermType(PermType.AUTHORIZATION);
                rolePerms.add(rolePermInfo);
            }
        }
        return rolePerms;
    }

    private boolean isRuleChanged(String ruleA, String ruleB) {
        if (StringUtils.isEmpty((String)ruleA) || StringUtils.isEmpty((String)ruleB)) {
            return !StringUtils.isEmpty((String)ruleA) || !StringUtils.isEmpty((String)ruleB);
        }
        return !ruleA.equals(ruleB);
    }

    private Map createRPMap(RolePermCollection collection) {
        HashMap<String, RolePermInfo> map = new HashMap<String, RolePermInfo>();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            map.put(PermissionCommonUtil.getKey(collection.get(i)), collection.get(i));
        }
        return map;
    }

    private void checkCurrentNodeRule() throws EASBizException, ParserException, BOSException {
        KDTreeNode node;
        Object object;
        if (this.treeNormalPerm.getSelectionPath() != null && (object = this.treeNormalPerm.getSelectionPath().getLastPathComponent()) != null && this.canBindRule(node = (KDTreeNode)object) && !this.rulePanel.verify()) {
            this.abort();
        }
    }

    @Override
    public void reloadUI() throws Exception {
        Set expendNormalNodes = this.builder.getExpendedNodes(this.treeNormalPerm);
        Set expendForbiddenNodes = this.builder.getExpendedNodes(this.treeForbiddenPerm);
        this.buildTargetTree();
        this.rebuildLeftMenuTree();
        this.loadRule(null);
        this.builder.expand(this.treeNormalPerm, expendNormalNodes);
        this.builder.expand(this.treeForbiddenPerm, expendForbiddenNodes);
        this.refreshSelectCustomIco();
    }

    private void rebuildLeftMenuTree() throws Exception {
        ((DefaultTreeModel)this.treeMenu.getModel()).setRoot(null);
        this.buildLeftMainMenuTree(this.treeMenu);
    }

    private void buildTargetTree() throws Exception {
        IRolePerm iRolePerm = RolePermFactory.getRemoteInstance();
        RolePermCollection rolePerms = iRolePerm.getTargetRolePerms(this.getRolePK());
        this.rpsCopy = (RolePermCollection)((Object)rolePerms.clone());
        ArrayList list = PermissionCommonUtil.assortPerms(rolePerms);
        this.buildNormalTree((RolePermCollection)((Object)list.get(1)));
        this.buildForbiddenTree((RolePermCollection)((Object)list.get(2)));
        this.buildAuthorizationTree((RolePermCollection)((Object)list.get(0)));
        this.buildRightMainMenuTree(this.treeComFunction);
    }

    private boolean isAccreditPerm() {
        return this.tabAuthorizedPerm.getSelectedIndex() == 0;
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        if (this.isAccreditPerm()) {
            TreePath[] treePaths = this.treeAuthorizedPerm.getSelectionPaths();
            if (treePaths != null) {
                int length = treePaths.length;
                KDTreeNode[] treeNodes = new KDTreeNode[length];
                for (int i = 0; i < length; ++i) {
                    treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
                }
                Set extendedNodes = this.builder.getExpendedNodes(this.treeAuthorizedPerm);
                if (this.tabAssign.getSelectedIndex() == 1) {
                    this.builder.addNodes(this.treeNormalPerm, treeNodes, extendedNodes);
                    this.builder.setDataRuleIcon((KDTreeNode)this.treeNormalPerm.getModel().getRoot());
                } else if (this.tabAssign.getSelectedIndex() == 2) {
                    this.builder.addNodes(this.treeForbiddenPerm, treeNodes, extendedNodes);
                    this.builder.setForbiddenIcon((KDTreeNode)this.treeForbiddenPerm.getModel().getRoot());
                } else if (this.tabAssign.getSelectedIndex() == 0) {
                    this.builder.addNodes(this.treeAuthorization, treeNodes, extendedNodes);
                    this.builder.setDataRuleIcon((KDTreeNode)this.treeAuthorization.getModel().getRoot());
                }
            }
        } else {
            this.addMenu();
        }
        this.refreshSelectCustomIco();
    }

    private void addMenu() {
        TreePath[] treePaths = this.treeMenu.getSelectionPaths();
        if (treePaths == null) {
            return;
        }
        int length = treePaths.length;
        Set extendedNodes = this.builder.getExpendedNodes(this.treeComFunction);
        KDTreeNode[] selectedTreeNodes = new KDTreeNode[length];
        for (int i = 0; i < length; ++i) {
            selectedTreeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
        }
        this.addMenu(selectedTreeNodes);
    }

    private void addMenu(KDTreeNode[] selectedTreeNodes) {
        Set<MainMenuItemInfo> selectedMainMenuItemSet = this.getSelectedMainMenuItemSet(selectedTreeNodes);
        KDTreeNode comFunRoot = (KDTreeNode)this.treeComFunction.getModel().getRoot();
        Set<MainMenuItemInfo> targetMainMenuItemSet = this.getSubMainMenuItemSet(comFunRoot);
        HashSet<MainMenuItemInfo> allMenuSet = new HashSet<MainMenuItemInfo>();
        allMenuSet.addAll(selectedMainMenuItemSet);
        allMenuSet.addAll(targetMainMenuItemSet);
        RoleAccreditUI.buildMenuTree(this.treeComFunction, allMenuSet);
    }

    private Set<MainMenuItemInfo> getSelectedMainMenuItemSet(KDTreeNode[] selectedTreeNodes) {
        HashSet<MainMenuItemInfo> ret = new HashSet<MainMenuItemInfo>();
        for (KDTreeNode node : selectedTreeNodes) {
            ret.addAll(this.getSuperMainMenuItemSet(node));
            ret.addAll(this.getSubMainMenuItemSet(node));
        }
        return ret;
    }

    private Set<MainMenuItemInfo> getSuperMainMenuItemSet(KDTreeNode node) {
        HashSet<MainMenuItemInfo> ret = new HashSet<MainMenuItemInfo>();
        if (node == null) {
            return ret;
        }
        for (KDTreeNode parent = (KDTreeNode)node.getParent(); parent != null; parent = (KDTreeNode)parent.getParent()) {
            Object userObj = parent.getUserObject();
            if (!(userObj instanceof MainMenuItemInfo)) continue;
            ret.add((MainMenuItemInfo)userObj);
        }
        return ret;
    }

    private Set<MainMenuItemInfo> getSubMainMenuItemSet(KDTreeNode node) {
        if (node == null) {
            return new HashSet<MainMenuItemInfo>();
        }
        HashSet<MainMenuItemInfo> ret = new HashSet<MainMenuItemInfo>();
        Object userObj = node.getUserObject();
        if (userObj instanceof MainMenuItemInfo) {
            MainMenuItemInfo info = (MainMenuItemInfo)userObj;
            ret.add(info);
        }
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            KDTreeNode child = (KDTreeNode)node.getChildAt(i);
            ret.addAll(this.getSubMainMenuItemSet(child));
        }
        return ret;
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.isAccreditPerm()) {
            Object object = this.treeAuthorizedPerm.getModel().getRoot();
            if (object != null && object instanceof KDTreeNode) {
                Set extendedNodes = this.builder.getExpendedNodes(this.treeAuthorizedPerm);
                if (this.tabAssign.getSelectedIndex() == 1) {
                    this.builder.addNodes(this.treeNormalPerm, new KDTreeNode[]{(KDTreeNode)object}, extendedNodes);
                    this.builder.setDataRuleIcon((KDTreeNode)this.treeNormalPerm.getModel().getRoot());
                } else if (this.tabAssign.getSelectedIndex() == 2) {
                    this.builder.addNodes(this.treeForbiddenPerm, new KDTreeNode[]{(KDTreeNode)object}, extendedNodes);
                    this.builder.setForbiddenIcon((KDTreeNode)this.treeForbiddenPerm.getModel().getRoot());
                } else if (this.tabAssign.getSelectedIndex() == 0) {
                    this.builder.addNodes(this.treeAuthorization, new KDTreeNode[]{(KDTreeNode)object}, extendedNodes);
                    this.builder.setDataRuleIcon((KDTreeNode)this.treeAuthorization.getModel().getRoot());
                }
            }
        } else {
            this.addAllMenu();
        }
        this.refreshSelectCustomIco();
    }

    private void addAllMenu() {
        this.addMenu(new KDTreeNode[]{(KDTreeNode)this.treeMenu.getModel().getRoot()});
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        if (this.isAccreditPerm()) {
            TreePath[] treePaths = null;
            if (this.tabAssign.getSelectedIndex() == 1) {
                treePaths = this.treeNormalPerm.getSelectionPaths();
                if (treePaths != null) {
                    int length = treePaths.length;
                    KDTreeNode[] treeNodes = new KDTreeNode[length];
                    for (int i = 0; i < length; ++i) {
                        treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
                    }
                    this.builder.removeNodes(this.treeNormalPerm, treeNodes);
                    this.processRulePanel();
                }
            } else if (this.tabAssign.getSelectedIndex() == 2) {
                treePaths = this.treeForbiddenPerm.getSelectionPaths();
                if (treePaths != null) {
                    int length = treePaths.length;
                    KDTreeNode[] treeNodes = new KDTreeNode[length];
                    for (int i = 0; i < length; ++i) {
                        treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
                    }
                    this.builder.removeNodes(this.treeForbiddenPerm, treeNodes);
                }
            } else if (this.tabAssign.getSelectedIndex() == 0 && (treePaths = this.treeAuthorization.getSelectionPaths()) != null) {
                int length = treePaths.length;
                KDTreeNode[] treeNodes = new KDTreeNode[length];
                for (int i = 0; i < length; ++i) {
                    treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
                }
                this.builder.removeNodes(this.treeAuthorization, treeNodes);
            }
        } else {
            this.deleteMenu();
        }
        this.refreshSelectCustomIco();
    }

    private void deleteMenu() {
        int i;
        TreePath[] treePaths = this.treeComFunction.getSelectionPaths();
        if (treePaths == null) {
            return;
        }
        int length = treePaths.length;
        Set extendedNodes = this.builder.getExpendedNodes(this.treeComFunction);
        KDTreeNode[] selectedTreeNodes = new KDTreeNode[length];
        for (i = 0; i < length; ++i) {
            selectedTreeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
        }
        for (i = 0; i < length; ++i) {
            this.removeNode(this.treeComFunction, selectedTreeNodes[i]);
        }
    }

    private void removeNode(KDTree tree, KDTreeNode nodeToRemove) {
        KDTreeNode rootNode = (KDTreeNode)tree.getModel().getRoot();
        if (rootNode == null) {
            return;
        }
        KDTreeNode findNode = this.findMenuNode(rootNode, nodeToRemove);
        KDTreeNode parentNode = (KDTreeNode)findNode.getParent();
        if (parentNode != null) {
            ((DefaultTreeModel)tree.getModel()).removeNodeFromParent((MutableTreeNode)findNode);
            if (parentNode.getChildCount() == 0) {
                this.removeNode(tree, parentNode);
            }
        } else {
            ((DefaultTreeModel)tree.getModel()).setRoot(null);
        }
    }

    private KDTreeNode findMenuNode(KDTreeNode rootNode, KDTreeNode nodeToFind) {
        if (rootNode == null) {
            return null;
        }
        Object rootObj = rootNode.getUserObject();
        Object objToFind = nodeToFind.getUserObject();
        if (objToFind != null && objToFind.equals(rootObj)) {
            return rootNode;
        }
        int count = rootNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            KDTreeNode child = (KDTreeNode)rootNode.getChildAt(i);
            KDTreeNode findNode = this.findMenuNode(child, nodeToFind);
            if (null == findNode) continue;
            return findNode;
        }
        return null;
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.isAccreditPerm()) {
            KDTreeNode object = null;
            if (this.tabAssign.getSelectedIndex() == 1) {
                object = (KDTreeNode)this.treeNormalPerm.getModel().getRoot();
                if (object != null) {
                    this.builder.removeNodes(this.treeNormalPerm, new KDTreeNode[]{object});
                    this.processRulePanel();
                }
            } else if (this.tabAssign.getSelectedIndex() == 2) {
                object = (KDTreeNode)this.treeForbiddenPerm.getModel().getRoot();
                if (object != null) {
                    this.builder.removeNodes(this.treeForbiddenPerm, new KDTreeNode[]{object});
                }
            } else if (this.tabAssign.getSelectedIndex() == 0 && (object = (KDTreeNode)this.treeAuthorization.getModel().getRoot()) != null) {
                this.builder.removeNodes(this.treeAuthorization, new KDTreeNode[]{object});
            }
        } else {
            this.deleteAllMenu();
        }
        this.refreshSelectCustomIco();
    }

    private void deleteAllMenu() {
        ((DefaultTreeModel)this.treeComFunction.getModel()).setRoot(null);
    }

    private void processRulePanel() {
        if (this.treeNormalPerm == null || this.treeNormalPerm.getLastSelectedPathComponent() == null) {
            this.rulePanel.reset();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setText(null);
        Icon addIcon = EASResource.getIcon((String)"imgTbtn_move_right");
        this.btnAdd.setIcon(addIcon);
        Icon addAllIcon = EASResource.getIcon((String)"imgTbtn_moveall_right");
        this.btnAddAll.setIcon(addAllIcon);
        Icon deleteIcon = EASResource.getIcon((String)"imgTbtn_move_left");
        this.btnDelete.setIcon(deleteIcon);
        Icon deleteAllIcon = EASResource.getIcon((String)"imgTbtn_moveall_left");
        this.btnDeleteAll.setIcon(deleteAllIcon);
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.setButtonDefaultStyl(this.btnSubmit);
        this.btnShowRule.setIcon(EASResource.getIcon((String)"imgTbtn_dataaccredit"));
        this.btnHideRule.setIcon(EASResource.getIcon((String)"imgTbtn_hiderule"));
        this.btnDiscretePerm.setIcon(EASResource.getIcon((String)"imgTbtn_scatterpurview"));
        this.btnFieldAccessAccredit.setIcon(EASResource.getIcon((String)"imgTbtn_fieldpurview"));
    }

    @Override
    public void actionHideRule_actionPerformed(ActionEvent e) throws Exception {
        super.actionHideRule_actionPerformed(e);
        this.isShowRule = false;
        this.btnShowRule.setVisible(!this.isShowRule);
        this.btnHideRule.setVisible(this.isShowRule);
        this.showRulePanel(this.isShowRule);
        this.rulePanel.refresh();
    }

    @Override
    public void actionShowRule_actionPerformed(ActionEvent e) throws Exception {
        super.actionShowRule_actionPerformed(e);
        this.isShowRule = true;
        this.btnShowRule.setVisible(!this.isShowRule);
        this.btnHideRule.setVisible(this.isShowRule);
        this.showRulePanel(this.isShowRule);
        this.rulePanel.refresh();
    }

    @Override
    protected void treeNormalPerm_valueChanged(TreeSelectionEvent e) throws Exception {
        this.dealTree(e, this.treeNormalPerm);
    }

    private void dealTree(TreeSelectionEvent e, KDTree dealTree) throws Exception {
        KDTreeNode oldNode;
        Object old;
        if (e.getOldLeadSelectionPath() != null && (old = e.getOldLeadSelectionPath().getLastPathComponent()) != null && this.canBindRule(oldNode = (KDTreeNode)old) && !this.rulePanel.verify()) {
            this.loadRule(oldNode);
            dealTree.setSelectionPath(e.getOldLeadSelectionPath());
        }
        if (e.getOldLeadSelectionPath() != null && (old = e.getOldLeadSelectionPath().getLastPathComponent()) != null) {
            this.storeRule((KDTreeNode)old);
        }
        if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() != null) {
            this.loadRule((KDTreeNode)e.getNewLeadSelectionPath().getLastPathComponent());
        }
        this.setDiscreteButtonStatus(e);
        this.setRulePanelStatus();
        this.addPopMenuExtendFunc(e, dealTree);
    }

    @Override
    protected void treeAuthorization_valueChanged(TreeSelectionEvent e) throws Exception {
        this.dealTree(e, this.treeAuthorization);
    }

    private void addPopMenuExtendFunc(TreeSelectionEvent e, KDTree sourcetree) {
        if (this.popMenuHelper == null) {
            this.popMenuHelper = new PopMenuHelper(this, sourcetree);
        }
        PopMenuPerformContext ctx = new PopMenuPerformContext();
        ctx.setTreeSelectEvent(e);
        ctx.setUiObject((IUIObject)this);
        ctx.setTargetRole(this.getTargetRole());
        ctx.setTargetIsUser(false);
        this.popMenuHelper.dealPopMenu(ctx);
    }

    private void setDiscreteButtonStatus(TreeSelectionEvent e) {
        BOSObjectType objectType;
        KDTreeNode node;
        Object old;
        if (e.getNewLeadSelectionPath() != null && (old = e.getNewLeadSelectionPath().getLastPathComponent()) != null && this.enableDataPermission(node = (KDTreeNode)old) && (objectType = this.getRuleObjectType(node)) != null) {
            this.btnDiscretePerm.setVisible(this.configurationInfo.getDiscretEntityTables().containsKey(objectType.toString()));
            return;
        }
        this.btnDiscretePerm.setVisible(false);
    }

    private boolean enableDataPermission(KDTreeNode node) {
        if (node.isLeaf()) {
            RolePermInfo info = (RolePermInfo)node.getUserObject();
            String objectType = info.getPermItem().getObjectType();
            if (!StringUtils.isEmpty((String)objectType) && info.getPermItem().isEnableDataPermission()) {
                return true;
            }
        } else {
            int size = node.getChildCount();
            for (int i = 0; i < size; ++i) {
                RolePermInfo info;
                String objectType;
                KDTreeNode child = (KDTreeNode)node.getChildAt(i);
                if (!child.isLeaf() || StringUtils.isEmpty((String)(objectType = (info = (RolePermInfo)child.getUserObject()).getPermItem().getObjectType())) || !info.getPermItem().isEnableDataPermission()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void actionDiscretePerm_actionPerformed(ActionEvent e) throws Exception {
        BOSObjectType objectType;
        super.actionDiscretePerm_actionPerformed(e);
        Object obj = this.treeNormalPerm.getLastSelectedPathComponent();
        if (obj != null && (objectType = this.getRuleObjectType((KDTreeNode)obj)) != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"bosObjectType", (Object)objectType);
            uiContext.put((Object)"targetRolePK", (Object)this.getRolePK());
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RoleDiscretePermViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            window.show();
        }
    }

    private void setRulePanelStatus() {
        this.rulePanel.setButtonStatus(this.needRule());
    }

    private boolean needRule() {
        return this.rulePanel.getBizObjectType() != null;
    }

    private String getRuleStructure() throws EASBizException, ParserException, BOSException {
        return this.getRulePanel().getRuleStructure();
    }

    private void storeRule(KDTreeNode node) throws Exception {
        BOSObjectType objectType;
        RolePermInfo info = (RolePermInfo)node.getUserObject();
        if (info.getPermItem().isIsLeaf()) {
            if (!StringUtils.isEmpty((String)info.getPermItem().getObjectType()) && info.getPermItem().isEnableDataPermission()) {
                String ruleStructure = this.getRuleStructure();
                info.setRuleStructure(ruleStructure);
                EntityObjectInfo entity = this.getEntity(BOSObjectType.create((String)info.getPermItem().getObjectType()));
                RuleParser ruleParser = new RuleParser(entity);
                ruleParser.setRuleStructure(ruleStructure);
                info.setRuleExpr(ruleParser.buildExpr());
            }
        } else if (this.enableDataPermission(node) && (objectType = this.getRuleObjectType(node)) != null) {
            int size = node.getChildCount();
            for (int i = 0; i < size; ++i) {
                String ruleStructure;
                KDTreeNode child = (KDTreeNode)node.getChildAt(i);
                if (!child.isLeaf()) continue;
                RolePermInfo infoChild = (RolePermInfo)child.getUserObject();
                if (!objectType.toString().equals(infoChild.getPermItem().getObjectType()) || StringUtils.isEmpty((String)(ruleStructure = this.getRuleStructure()))) continue;
                infoChild.setRuleStructure(ruleStructure);
                EntityObjectInfo entity = this.getEntity(objectType);
                RuleParser ruleParser = new RuleParser(entity);
                ruleParser.setRuleStructure(ruleStructure);
                infoChild.setRuleExpr(ruleParser.buildExpr());
            }
        }
    }

    private EntityObjectInfo getEntity(BOSObjectType objectType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getEntity(objectType);
    }

    private void loadRuleTree(KDTree tree) throws EASBizException, ParserException, BOSException {
        if (tree == null) {
            return;
        }
        Object obj = tree.getLastSelectedPathComponent();
        if (obj == null) {
            this.loadRule(null);
        }
        if (obj instanceof KDTreeNode) {
            this.loadRule((KDTreeNode)obj);
        } else {
            this.loadRule(null);
        }
    }

    private void loadRule(KDTreeNode node) throws EASBizException, ParserException, BOSException {
        if (node == null) {
            this.rulePanel.reset();
        } else {
            RolePermInfo info = (RolePermInfo)node.getUserObject();
            if (info.getPermItem().isIsLeaf() && !StringUtils.isEmpty((String)info.getPermItem().getObjectType()) && info.getPermItem().isEnableDataPermission()) {
                this.rulePanel.setBizObjectType(BOSObjectType.create((String)info.getPermItem().getObjectType()));
                String ruleStructure = info.getRuleStructure();
                this.rulePanel.setRuleStructure(ruleStructure);
                this.rulePanel.refresh();
            } else if (this.canBindRule(node)) {
                this.rulePanel.reset();
                this.rulePanel.setBizObjectType(this.getRuleObjectType(node));
            } else {
                this.rulePanel.reset();
            }
        }
    }

    private boolean canBindRule(KDTreeNode node) {
        if (node.isLeaf()) {
            RolePermInfo info = (RolePermInfo)node.getUserObject();
            return !StringUtils.isEmpty((String)info.getPermItem().getObjectType()) && info.getPermItem().isEnableDataPermission();
        }
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            KDTreeNode child = (KDTreeNode)node.getChildAt(i);
            if (child.isLeaf()) {
                RolePermInfo info = (RolePermInfo)child.getUserObject();
                if (StringUtils.isEmpty((String)info.getPermItem().getObjectType()) || !info.getPermItem().isEnableDataPermission()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private BOSObjectType getRuleObjectType(KDTreeNode node) {
        if (node.isLeaf()) {
            RolePermInfo info = (RolePermInfo)node.getUserObject();
            String objectType = info.getPermItem().getObjectType();
            if (!StringUtils.isEmpty((String)objectType)) {
                return BOSObjectType.create((String)objectType);
            }
        } else {
            int size = node.getChildCount();
            for (int i = 0; i < size; ++i) {
                RolePermInfo info;
                String objectType;
                KDTreeNode child = (KDTreeNode)node.getChildAt(i);
                if (!child.isLeaf() || StringUtils.isEmpty((String)(objectType = (info = (RolePermInfo)child.getUserObject()).getPermItem().getObjectType()))) continue;
                return BOSObjectType.create((String)objectType);
            }
        }
        return null;
    }

    @Override
    protected void tabAssign_stateChanged(ChangeEvent e) throws Exception {
        super.tabAssign_stateChanged(e);
        if (this.rulePanel != null) {
            if (this.tabAssign.getSelectedIndex() == 1 || this.tabAssign.getSelectedIndex() == 0) {
                this.btnShowRule.setVisible(!this.isShowRule);
                this.btnHideRule.setVisible(this.isShowRule);
                if (this.isShowRule) {
                    this.showRulePanel(this.isShowRule);
                }
                if (this.tabAssign.getSelectedIndex() == 1) {
                    this.loadRuleTree(this.treeNormalPerm);
                } else {
                    this.loadRuleTree(this.treeAuthorization);
                }
            } else if (this.tabAssign.getSelectedIndex() == 2) {
                this.showRulePanel(false);
                this.btnShowRule.setVisible(false);
                this.btnHideRule.setVisible(false);
            }
        }
        if (this.isTabbedPaneInited()) {
            if (this.tabAssign.getSelectedIndex() == 3) {
                this.tabAuthorizedPerm.setSelectedIndex(1);
                this.menuTipLbl.setVisible(true);
            } else {
                this.tabAuthorizedPerm.setSelectedIndex(0);
                this.menuTipLbl.setVisible(false);
            }
        }
        this.refreshSelectCustomIco();
    }

    private boolean isTabbedPaneInited() {
        return this.tabAuthorizedPerm.getTabCount() == 2 && this.tabAssign.getTabCount() == 4;
    }

    @Override
    protected void tabAuthorizedPerm_stateChanged(ChangeEvent e) throws Exception {
        if (!this.isTabbedPaneInited()) {
            return;
        }
        if (this.tabAuthorizedPerm.getSelectedIndex() == 0) {
            if (this.tabAssign.getSelectedIndex() == 3) {
                this.tabAssign.setSelectedIndex(1);
            }
            this.menuTipLbl.setVisible(false);
        } else {
            this.tabAssign.setSelectedIndex(3);
            this.buildLeftMainMenuTree(this.treeMenu);
            this.buildRightMainMenuTree(this.treeComFunction);
            this.menuTipLbl.setVisible(true);
        }
        this.refreshSelectCustomIco();
    }

    @Override
    public RulePanel getRulePanel() {
        return this.rulePanel;
    }

    @Override
    public void actionFieldAccessAccredit_actionPerformed(ActionEvent e) throws Exception {
        super.actionFieldAccessAccredit_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"rolePK", (Object)this.getRolePK());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RoleFieldAccessAccreditUI.class.getName(), (Map)uiContext, null, null);
        window.show();
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        if (this.permChanged(this.getUOPReuslts())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"alertSave"));
        }
    }

    public boolean checkBeforeWindowClosing() {
        if (this.permChanged(this.getUOPReuslts())) {
            int isYes = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"alertSave"));
            if (MsgBox.isYes((int)isYes)) {
                try {
                    this.save();
                    return true;
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    return false;
                }
            }
            return !MsgBox.isCancel((int)isYes);
        }
        return true;
    }

    private class EndLogThread
    implements Runnable {
        private LogProxy logProxy;

        public EndLogThread(LogProxy logProxy) {
            this.logProxy = logProxy;
        }

        @Override
        public void run() {
            while (true) {
                if (this.logProxy != null && this.logProxy.getLogPK() != null && !StringUtils.isEmpty((String)this.logProxy.getLogPK().toString())) {
                    this.logProxy.end();
                    return;
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.error((Object)e);
                    continue;
                }
                break;
            }
        }
    }

    private class BeginLogThread
    implements Runnable {
        private LogProxy logProxy;
        private RolePermCollection[] results;
        private String number;

        public BeginLogThread(LogProxy logProxy, RolePermCollection[] results, String number) {
            this.logProxy = logProxy;
            this.results = results;
            this.number = number;
        }

        @Override
        public void run() {
            try {
                this.logProxy.beginLog(null, "saveRolePerms", RolePermFactory.getRemoteInstance().getType(), null, RoleAccreditLogHelper.getLogDetail(this.results, this.number));
            }
            catch (BOSException e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
    }
}

