/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.AbstractOwnerExceptPermitemInfo;
import com.kingdee.eas.base.permission.AbstractSpecialDataPermEntryInfo;
import com.kingdee.eas.base.permission.AbstractSpecialDirectorPermitemInfo;
import com.kingdee.eas.base.permission.ISpecialDataPerm;
import com.kingdee.eas.base.permission.OperationType;
import com.kingdee.eas.base.permission.OwnerExceptPermitemCollection;
import com.kingdee.eas.base.permission.OwnerExceptPermitemInfo;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.SpecialDataPermCollection;
import com.kingdee.eas.base.permission.SpecialDataPermEntryCollection;
import com.kingdee.eas.base.permission.SpecialDataPermEntryInfo;
import com.kingdee.eas.base.permission.SpecialDataPermFactory;
import com.kingdee.eas.base.permission.SpecialDataPermInfo;
import com.kingdee.eas.base.permission.SpecialDataPermType;
import com.kingdee.eas.base.permission.SpecialDirectorPermitemCollection;
import com.kingdee.eas.base.permission.SpecialDirectorPermitemInfo;
import com.kingdee.eas.base.permission.SpecialPermLogicTag;
import com.kingdee.eas.base.permission.SpecialPermTypeEnum;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserUtils;
import com.kingdee.eas.base.permission.client.AbstractSpecialDataPermEditUI;
import com.kingdee.eas.base.permission.client.OtherOwnerF7UI;
import com.kingdee.eas.base.permission.client.OwnerPermExcepListUI;
import com.kingdee.eas.base.permission.client.SpecialDirectorListUI;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.SpecialDataF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewCtrlF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class SpecialDataPermEditUI
extends AbstractSpecialDataPermEditUI {
    private static final String ID_CELLNAME = "id";
    private static final String BOS_OBJECT_TYPE_CELLNAME = "bizObjectType";
    private static final String ENABLE_CREATOR_CELLNAME = "enableCreatorPerm";
    private static final String OTHER_OWNER_CELLNAME = "otherOwner";
    private static final String ENABLE_DIRECTOR_CELLNAME = "enableDirectorPerm";
    private static final String DIRECTOR_ENTRY_ID = "directorPermitemId";
    private static final String OWNER_EXCEPT_ENTRY_ID = "ownerExceptPermitemId";
    private static final String PERMITEM_CELLNAME = "permItem";
    private static final String PERMTYPE_CELLNAME = "permType";
    private static final String OWNER_EXCEPT_PERMTYPE = "ownerExceptPermType";
    private static final String DIRECTOR_PERMTYPE = "directorPermType";
    private static final String LOGIC_TAG = "logicTag";
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private Set changed = new HashSet();
    private Map perms = new HashMap();
    private Map otherOwners = new HashMap();
    private UserInfo currentUser = null;
    OtherOwnerF7UI propertyF7 = new OtherOwnerF7UI();
    private Logger logger = Logger.getLogger(SpecialDataPermEditUI.class);

    public SpecialDataPermEditUI() throws Exception {
        this.init();
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman hander = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("curOrgId", (Object)this.getCurrentCU().getId().toString());
        hander.setRequestContext((Serializable)request);
        return hander;
    }

    private void init() throws Exception {
        this.btnDirector.setEnabled(true);
        this.initTable();
        this.initPmtCU();
        this.currentUser = SysContext.getSysContext().getCurrentUserInfo();
    }

    protected void pmtCU_dataChanged(DataChangeEvent e) throws Exception {
        this.initData();
        this.setDefaultFilter();
        this.initOtherOwnerF7();
        this.tblMain.repaint();
        this.tblMain.removeRows();
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0, 2);
        }
    }

    private void initPmtCU() {
        this.pmtCU.setQueryInfo("com.kingdee.eas.basedata.framework.app.CtrlUnitQuery");
        this.pmtCU.setCommitFormat("$number$");
        this.pmtCU.setDisplayFormat("$name$");
        this.pmtCU.setEditFormat("$number$");
        this.pmtCU.setData((Object)this.getCurrentCU());
        this.pmtCU.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SpecialDataPermEditUI.this.pmtCU_dataChanged(e);
                }
                catch (Exception exc) {
                    SpecialDataPermEditUI.this.handUIException(exc);
                }
            }
        });
        this.currentUser = SysContext.getSysContext().getCurrentUserInfo();
        List orgRange = UserUtils.getCurrentUserOrgRangeListByAdmin(this.currentUser);
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = null;
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(ID_CELLNAME, (Object)("select forgid from t_pm_orgrange where fuserid = '" + this.currentUser.getId().toString() + "' and ftype = " + 10), CompareType.INNER));
        entityView.setFilter(filter);
        this.pmtCU.setEntityViewInfo(entityView);
        NewCtrlF7 ctrlF7 = new NewCtrlF7((IUIObject)this);
        ctrlF7.setMultiSelect(false);
        this.pmtCU.setSelector((KDPromptSelector)ctrlF7);
    }

    private void initData() throws Exception {
        String ctrlUnitID = this.getCurrentCU().getId().toString();
        ((ISpecialDataPerm)this.getBizInterface()).initData((IObjectPK)new ObjectUuidPK(ctrlUnitID));
    }

    private CtrlUnitInfo getCurrentCU() {
        Object cu = this.pmtCU.getData();
        if (cu != null) {
            return (CtrlUnitInfo)cu;
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private void initTable() {
        this.tblEntry.checkParsed();
        KDBizPromptBox pmtPermItem = new KDBizPromptBox();
        pmtPermItem.setQueryInfo("com.kingdee.eas.base.permission.app.PermItemQuery");
        pmtPermItem.setDisplayFormat("$alias$");
        pmtPermItem.setEditFormat("$name$");
        pmtPermItem.setCommitFormat("$name$");
        pmtPermItem.setEditable(false);
        pmtPermItem.setEnabledMultiSelection(false);
        KDTDefaultCellEditor defaultCellEditor = new KDTDefaultCellEditor((IKDEditor)pmtPermItem);
        this.tblEntry.getColumn(PERMITEM_CELLNAME).setEditor((ICellEditor)defaultCellEditor);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$alias$"));
        this.tblEntry.getColumn(PERMITEM_CELLNAME).setRenderer((IBasicRender)avr);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initData();
        this.setDefaultFilter();
        this.initOtherOwnerF7();
    }

    private void setDefaultFilter() throws Exception {
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
        }
        this.mainQuery.setFilter(this.getDefaultFilter());
        SorterItemCollection sortCol = new SorterItemCollection();
        sortCol.add(new SorterItemInfo("bizObject"));
        this.mainQuery.setSorter(sortCol);
    }

    private FilterInfo getDefaultFilter() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.getCurrentCU().getId().toString()));
        return filterInfo;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getColumn(ENABLE_CREATOR_CELLNAME).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(ENABLE_DIRECTOR_CELLNAME).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(OTHER_OWNER_CELLNAME).getStyleAttributes().setLocked(false);
    }

    private void initOtherOwnerF7() throws Exception {
        KDBizPromptBox otherOwnerF7 = new KDBizPromptBox();
        this.propertyF7.setParentWindow((Object)this);
        otherOwnerF7.setSelector((KDPromptSelector)this.propertyF7);
        otherOwnerF7.setEditable(false);
        this.tblMain.getColumn(OTHER_OWNER_CELLNAME).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)otherOwnerF7));
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SpecialDataPermFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.appToMultiOrg.setIcon(EASResource.getIcon((String)"imgTbtn_allotmultipopedom"));
        this.btnOwnerExcept.setIcon(EASResource.getIcon((String)"imgTbtn_putin"));
        this.btnOwnerExcept.setEnabled(true);
        this.btnDirector.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnDirector.setEnabled(true);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        SpecialDataPermCollection collection = new SpecialDataPermCollection();
        for (BOSUuid uuid : this.changed) {
            collection.add(this.getPerm(uuid));
        }
        ISpecialDataPerm iSpecialDataPerm = SpecialDataPermFactory.getRemoteInstance();
        iSpecialDataPerm.save(collection);
        this.clear();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"saveSucceed"));
    }

    private void clear() {
        this.changed.clear();
        this.perms.clear();
        this.otherOwners.clear();
    }

    private SpecialDataPermInfo getCurrentPerm(KDTEditEvent e) {
        ArrayList idList = this.getSelectedIdValues();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        assert (rowIndex >= 0);
        IRow row = this.tblMain.getRow(rowIndex);
        BOSUuid currentPermID = BOSUuid.read((String)row.getCell(ID_CELLNAME).getValue().toString());
        SpecialDataPermInfo specialDataPermInfo = this.getPerm(currentPermID);
        if (specialDataPermInfo == null) {
            specialDataPermInfo = new SpecialDataPermInfo();
            specialDataPermInfo.setId(currentPermID);
        }
        if (e.getSource().equals(this.tblMain)) {
            if (e.getColIndex() == this.getColIndex(this.tblMain, ENABLE_CREATOR_CELLNAME)) {
                specialDataPermInfo.setEnableCreatorPerm((Boolean)e.getValue());
            }
            if (e.getColIndex() == this.getColIndex(this.tblMain, ENABLE_DIRECTOR_CELLNAME)) {
                specialDataPermInfo.setEnableDirectorPerm((Boolean)e.getValue());
            }
        }
        specialDataPermInfo.getEntries().clear();
        SpecialDataPermEntryCollection col = this.getEntries();
        for (int i = 0; i < col.size(); ++i) {
            specialDataPermInfo.getEntries().add(col.get(i));
        }
        specialDataPermInfo.setSpecialDirectorPermitemCol(this.getDirectorEntries());
        specialDataPermInfo.setOwnerExceptPermitemCol(this.getOwnerExceptEntries());
        return specialDataPermInfo;
    }

    private SpecialDataPermEntryCollection getEntries() {
        SpecialDataPermEntryCollection col = new SpecialDataPermEntryCollection();
        int size = this.tblEntry.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow rowEntry = this.tblEntry.getRow(i);
            PermItemInfo permItemInfo = (PermItemInfo)rowEntry.getCell(PERMITEM_CELLNAME).getValue();
            SpecialDataPermType permType = (SpecialDataPermType)((Object)rowEntry.getCell(PERMTYPE_CELLNAME).getValue());
            if (permItemInfo == null || permType == null) continue;
            SpecialPermLogicTag logicTag = (SpecialPermLogicTag)((Object)rowEntry.getCell(LOGIC_TAG).getValue());
            SpecialDataPermEntryInfo entryInfo = new SpecialDataPermEntryInfo();
            entryInfo.setPermItem(permItemInfo);
            entryInfo.setPermType(permType);
            entryInfo.setLogicTag(logicTag);
            col.add(entryInfo);
        }
        return col;
    }

    private SpecialDirectorPermitemCollection getDirectorEntries() {
        SpecialDirectorPermitemCollection col = new SpecialDirectorPermitemCollection();
        int size = this.tblEntry.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow rowEntry = this.tblEntry.getRow(i);
            PermItemInfo permItemInfo = (PermItemInfo)rowEntry.getCell(PERMITEM_CELLNAME).getValue();
            SpecialPermTypeEnum permType = (SpecialPermTypeEnum)((Object)rowEntry.getCell(DIRECTOR_PERMTYPE).getValue());
            String directorEntryId = StringUtils.cnulls((Object)rowEntry.getCell(DIRECTOR_ENTRY_ID).getValue());
            if (permItemInfo == null || permType == null) continue;
            SpecialDirectorPermitemInfo entryInfo = new SpecialDirectorPermitemInfo();
            entryInfo.setPermItem(permItemInfo);
            entryInfo.setPermType(permType);
            if (!StringUtils.isEmpty((String)directorEntryId)) {
                entryInfo.setId(BOSUuid.read((String)directorEntryId));
            }
            col.add(entryInfo);
        }
        return col;
    }

    private OwnerExceptPermitemCollection getOwnerExceptEntries() {
        OwnerExceptPermitemCollection col = new OwnerExceptPermitemCollection();
        int size = this.tblEntry.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow rowEntry = this.tblEntry.getRow(i);
            PermItemInfo permItemInfo = (PermItemInfo)rowEntry.getCell(PERMITEM_CELLNAME).getValue();
            SpecialPermTypeEnum permType = (SpecialPermTypeEnum)((Object)rowEntry.getCell(OWNER_EXCEPT_PERMTYPE).getValue());
            String ownerExceptEntryId = StringUtils.cnulls((Object)rowEntry.getCell(OWNER_EXCEPT_ENTRY_ID).getValue());
            if (permItemInfo == null || permType == null) continue;
            OwnerExceptPermitemInfo entryInfo = new OwnerExceptPermitemInfo();
            entryInfo.setPermItem(permItemInfo);
            entryInfo.setPermType(permType);
            if (!StringUtils.isEmpty((String)ownerExceptEntryId)) {
                entryInfo.setId(BOSUuid.read((String)ownerExceptEntryId));
            }
            col.add(entryInfo);
        }
        return col;
    }

    private int getColIndex(KDTable table, String colName) {
        return table.getColumn(colName).getColumnIndex();
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        this.storePerms(this.getCurrentPerm(e));
    }

    private void enableAndLockViewPermItem(boolean index) {
        int size = this.tblEntry.getRowCount();
        for (int i = 0; i < size; ++i) {
            PermItemInfo permItemInfo = (PermItemInfo)this.tblEntry.getRow(i).getCell(PERMITEM_CELLNAME).getValue();
            if (!OperationType.READ.equals((Object)permItemInfo.getOperationType()) || !index) continue;
            this.tblEntry.getRow(i).getCell(PERMTYPE_CELLNAME).setValue((Object)SpecialDataPermType.CREATEOR_NORMAL_PERM);
        }
    }

    @Override
    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        super.tblMain_editValueChanged(e);
        int colIndex = e.getColIndex();
        Object object = e.getValue();
        boolean isCreator = false;
        boolean flag = false;
        if (object != null && object instanceof Boolean) {
            flag = (Boolean)object;
        }
        if (colIndex == this.getColIndex(this.tblMain, ENABLE_CREATOR_CELLNAME)) {
            this.setCreatorEntryStatus(flag);
            if (flag) {
                isCreator = true;
            }
        } else if (colIndex == this.getColIndex(this.tblMain, ENABLE_DIRECTOR_CELLNAME)) {
            this.setDirectorEntryStatus(flag);
        }
        this.enableAndLockViewPermItem(isCreator);
    }

    private void setCreatorEntryStatus(boolean flag) {
        this.tblEntry.getColumn(PERMTYPE_CELLNAME).getStyleAttributes().setLocked(!flag);
        this.tblEntry.getColumn(OWNER_EXCEPT_PERMTYPE).getStyleAttributes().setLocked(!flag);
        this.tblEntry.getColumn(PERMTYPE_CELLNAME).getStyleAttributes().setBackground(flag ? Color.WHITE : this.getBackground());
        this.tblEntry.getColumn(OWNER_EXCEPT_PERMTYPE).getStyleAttributes().setBackground(flag ? Color.WHITE : this.getBackground());
    }

    private void setDirectorEntryStatus(boolean flag) {
        this.tblEntry.getColumn(DIRECTOR_PERMTYPE).getStyleAttributes().setLocked(!flag);
        this.tblEntry.getColumn(DIRECTOR_PERMTYPE).getStyleAttributes().setBackground(flag ? Color.WHITE : this.getBackground());
    }

    @Override
    protected void tblEntry_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex;
        Object obj;
        super.tblEntry_editStopped(e);
        int colIndex = e.getColIndex();
        if (colIndex == this.tblEntry.getColumn(PERMITEM_CELLNAME).getColumnIndex() && (obj = this.tblEntry.getRow(rowIndex = e.getRowIndex()).getCell(PERMTYPE_CELLNAME).getValue()) == null) {
            this.tblEntry.getRow(rowIndex).getCell(PERMTYPE_CELLNAME).setValue((Object)SpecialDataPermType.DEFAULT);
        }
        if (!this.equals(e.getValue(), e.getOldValue())) {
            this.storePerms(this.getCurrentPerm(e));
        }
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    @Override
    protected void tblMain_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        super.tblMain_activeCellChanged(e);
        int rowIndex = e.getRowIndex();
        if (this.tblMain.getRowCount() < 1 || this.tblMain.getRow(rowIndex) == null) {
            return;
        }
        IRow row = this.tblMain.getRow(rowIndex);
        Object creatorEnable = row.getCell(ENABLE_CREATOR_CELLNAME).getValue();
        boolean creatorFlag = false;
        if (creatorEnable != null && creatorEnable instanceof Boolean) {
            creatorFlag = (Boolean)creatorEnable;
        }
        this.setCreatorEntryStatus(creatorFlag);
        Object directorEnable = row.getCell(ENABLE_DIRECTOR_CELLNAME).getValue();
        boolean directorFlag = false;
        if (directorEnable != null && directorEnable instanceof Boolean) {
            directorFlag = (Boolean)directorEnable;
        }
        this.setDirectorEntryStatus(directorFlag);
        String strID = row.getCell(ID_CELLNAME).getValue().toString();
        SpecialDataPermInfo info = this.getPerm(BOSUuid.read((String)strID));
        this.loadPermDetails(info);
        String boType = row.getCell(BOS_OBJECT_TYPE_CELLNAME).getValue().toString();
        this.propertyF7.setBotype(boType);
        this.propertyF7.setPermInfo(this.getPerm(BOSUuid.read((String)row.getCell(ID_CELLNAME).getValue().toString())));
    }

    private SpecialDataPermInfo getPerm(BOSUuid permID) {
        if (!this.perms.containsKey(permID)) {
            this.perms.put(permID, this.getSpecialDataPermInfo((IObjectPK)new ObjectUuidPK(permID)));
        }
        return (SpecialDataPermInfo)this.perms.get(permID);
    }

    private void storePerms(SpecialDataPermInfo info) {
        this.changed.add(info.getId());
        this.perms.put(info.getId(), info);
    }

    private List sortEntryList(SpecialDataPermEntryCollection collection) {
        ArrayList<SpecialDataPermEntryInfo> entries = new ArrayList<SpecialDataPermEntryInfo>();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            SpecialDataPermEntryInfo entryInfo = collection.get(i);
            entries.add(entryInfo);
        }
        Collections.sort(entries, new Comparator(){

            public int compare(Object o1, Object o2) {
                SpecialDataPermEntryInfo entry1 = (SpecialDataPermEntryInfo)o1;
                SpecialDataPermEntryInfo entry2 = (SpecialDataPermEntryInfo)o2;
                return entry1.getPermItem().getName().compareTo(entry2.getPermItem().getName());
            }
        });
        return entries;
    }

    private void loadPermDetails(SpecialDataPermInfo specialDataPermInfo) {
        this.tblEntry.setRefresh(false);
        this.tblEntry.removeRows();
        this.loadPermEntries(specialDataPermInfo);
        this.loadDirectorPermEntries(specialDataPermInfo);
        this.loadOwnerExceptPermEntries(specialDataPermInfo);
        this.loadPermitemLogicEntries(specialDataPermInfo);
        this.tblEntry.setRefresh(true);
        this.tblEntry.repaint();
    }

    private void loadPermEntries(SpecialDataPermInfo specialDataPermInfo) {
        SpecialDataPermEntryCollection collection = specialDataPermInfo.getEntries();
        List entries = this.sortEntryList(collection);
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            KDTDefaultCellEditor permTypeEditor;
            KDComboBox combSpecialDataPerm;
            SpecialDataPermEntryInfo info = (SpecialDataPermEntryInfo)entries.get(i);
            IRow row = this.tblEntry.addRow();
            row.getCell(ID_CELLNAME).setValue((Object)info.getId());
            row.getCell(PERMITEM_CELLNAME).setValue((Object)info.getPermItem());
            row.getCell(PERMTYPE_CELLNAME).setValue((Object)info.getPermType());
            if (OperationType.READ.equals((Object)info.getPermItem().getOperationType())) {
                combSpecialDataPerm = new KDComboBox(SpecialDataPermType.getEnumList().toArray());
                combSpecialDataPerm.removeItem((Object)SpecialDataPermType.CREATEOR_FORBIDDEN_PERM);
                permTypeEditor = new KDTDefaultCellEditor((JComboBox)combSpecialDataPerm);
                row.getCell(PERMTYPE_CELLNAME).setEditor((ICellEditor)permTypeEditor);
                continue;
            }
            combSpecialDataPerm = new KDComboBox(SpecialDataPermType.getEnumList().toArray());
            permTypeEditor = new KDTDefaultCellEditor((JComboBox)combSpecialDataPerm);
            row.getCell(PERMTYPE_CELLNAME).setEditor((ICellEditor)permTypeEditor);
        }
    }

    private void loadDirectorPermEntries(SpecialDataPermInfo info) {
        SpecialDirectorPermitemCollection collection = info.getSpecialDirectorPermitemCol();
        int rowCount = this.tblEntry.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblEntry.getRow(i);
            ICell directorEntryCell = row.getCell(DIRECTOR_PERMTYPE);
            ICell directorEntryIdCell = row.getCell(DIRECTOR_ENTRY_ID);
            KDComboBox directorCombox = new KDComboBox(SpecialPermTypeEnum.getEnumList().toArray());
            KDTDefaultCellEditor directorEntryEditor = new KDTDefaultCellEditor((JComboBox)directorCombox);
            directorEntryCell.setEditor((ICellEditor)directorEntryEditor);
            PermItemInfo perm = (PermItemInfo)row.getCell(PERMITEM_CELLNAME).getValue();
            if (collection == null) continue;
            AbstractSpecialDirectorPermitemInfo directorPermInfo = null;
            for (int j = 0; j < collection.size(); ++j) {
                if (!perm.getId().toString().equals(collection.get(j).getPermItem().getId().toString())) continue;
                directorPermInfo = collection.get(j);
                break;
            }
            if (directorPermInfo != null) {
                directorEntryCell.setValue((Object)directorPermInfo.getPermType());
                directorEntryIdCell.setValue((Object)(directorPermInfo.getId() == null ? "" : directorPermInfo.getId().toString()));
                continue;
            }
            directorEntryCell.setValue((Object)SpecialPermTypeEnum.ON);
        }
    }

    private void loadOwnerExceptPermEntries(SpecialDataPermInfo info) {
        OwnerExceptPermitemCollection collection = info.getOwnerExceptPermitemCol();
        int rowCount = this.tblEntry.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblEntry.getRow(i);
            ICell ownerExceptEntryCell = row.getCell(OWNER_EXCEPT_PERMTYPE);
            ICell ownerExceptEntryIdCell = row.getCell(OWNER_EXCEPT_ENTRY_ID);
            KDComboBox directorCombox = new KDComboBox(SpecialPermTypeEnum.getEnumList().toArray());
            KDTDefaultCellEditor ownerExceptEntryEditor = new KDTDefaultCellEditor((JComboBox)directorCombox);
            ownerExceptEntryCell.setEditor((ICellEditor)ownerExceptEntryEditor);
            PermItemInfo perm = (PermItemInfo)row.getCell(PERMITEM_CELLNAME).getValue();
            if (collection == null) continue;
            AbstractOwnerExceptPermitemInfo ownerExceptPermInfo = null;
            for (int j = 0; j < collection.size(); ++j) {
                if (!perm.getId().toString().equals(collection.get(j).getPermItem().getId().toString())) continue;
                ownerExceptPermInfo = collection.get(j);
                break;
            }
            if (ownerExceptPermInfo != null) {
                ownerExceptEntryCell.setValue((Object)ownerExceptPermInfo.getPermType());
                ownerExceptEntryIdCell.setValue(ownerExceptPermInfo.getId() == null ? null : ownerExceptPermInfo.getId().toString());
                continue;
            }
            ownerExceptEntryCell.setValue((Object)SpecialPermTypeEnum.ON);
        }
    }

    private void loadPermitemLogicEntries(SpecialDataPermInfo specialDataPermInfo) {
        SpecialDataPermEntryCollection collection = specialDataPermInfo.getEntries();
        int rowCount = this.tblEntry.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblEntry.getRow(i);
            ICell permLogicEntryCell = row.getCell(LOGIC_TAG);
            KDComboBox permitemLogicCombox = new KDComboBox(SpecialPermLogicTag.getEnumList().toArray());
            KDTDefaultCellEditor permitemLogicEntryEditor = new KDTDefaultCellEditor((JComboBox)permitemLogicCombox);
            permLogicEntryCell.setEditor((ICellEditor)permitemLogicEntryEditor);
            PermItemInfo perm = (PermItemInfo)row.getCell(PERMITEM_CELLNAME).getValue();
            if (collection == null) continue;
            AbstractSpecialDataPermEntryInfo entryx = null;
            for (int j = 0; j < collection.size(); ++j) {
                if (!perm.getId().toString().equals(collection.get(j).getPermItem().getId().toString())) continue;
                entryx = collection.get(j);
                break;
            }
            if (entryx == null) continue;
            permLogicEntryCell.setValue(SpecialPermLogicTag.getEnumMap().get(entryx.getLogicTag().getName()));
        }
    }

    private SpecialDataPermInfo getSpecialDataPermInfo(IObjectPK objectPK) {
        assert (objectPK != null);
        try {
            ISpecialDataPerm iSpecialDataPerm = SpecialDataPermFactory.getRemoteInstance();
            return iSpecialDataPerm.getSpecialDataPermDetailInfo(objectPK);
        }
        catch (EASBizException e) {
            this.handUIException(e);
            return null;
        }
        catch (BOSException e) {
            this.handUIException(e);
            return null;
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    @Override
    public void actionOwnerExcept_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        List objTypeList = UIUtil.getUserIdList(this.tblMain, 2);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ObjTypeList", (Object)objTypeList);
        uiContext.put((Object)"cu_id", (Object)this.getCurrentCU().getId().toString());
        UITools.showUI((Object)this, OwnerPermExcepListUI.class.getName(), uiContext);
    }

    @Override
    public void actionDirector_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        List objTypeList = UIUtil.getUserIdList(this.tblMain, 2);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ObjTypeList", (Object)objTypeList);
        uiContext.put((Object)"cu_id", (Object)this.getCurrentCU().getId().toString());
        UITools.showUI((Object)this, SpecialDirectorListUI.class.getName(), uiContext);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionAppToMultiOrg_actionPerformed(ActionEvent e) throws Exception {
        if (this.changed.size() != 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"DO_SAVE_BEFORE_APPLY_MULTIORG"));
            return;
        }
        List orgList = this.getSelectedOrgList();
        if (orgList == null || orgList.size() == 0) {
            return;
        }
        ArrayList dataPermIdList = this.getSelectedIdValues();
        SpecialDataPermCollection dataPermCollection = new SpecialDataPermCollection();
        for (int i = 0; i < dataPermIdList.size(); ++i) {
            String dataPermId = (String)dataPermIdList.get(i);
            dataPermCollection.add(this.getPerm(BOSUuid.read((String)dataPermId)));
        }
        ISpecialDataPerm iSpecialDataPerm = SpecialDataPermFactory.getRemoteInstance();
        iSpecialDataPerm.appToMultiOrg(orgList, dataPermCollection);
        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"MULTI_ORG_APPLY_SUCCESS"));
        for (int i = 0; i < dataPermIdList.size(); ++i) {
            String dataPermId = (String)dataPermIdList.get(i);
            this.perms.remove(dataPermId);
        }
    }

    private List getSelectedOrgList() throws EASBizException, BOSException {
        ArrayList<String> selectOrgList = new ArrayList<String>();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        SpecialDataF7PromptDialog orgF7 = new SpecialDataF7PromptDialog((IUIObject)this, userInfo, true);
        orgF7.setIsCUFilter(true);
        orgF7.show();
        if (!orgF7.isCanceled() && orgF7.getData() != null) {
            Object obj = orgF7.getData();
            OrgUnitInfo[] orgUnitInfoAry = (OrgUnitInfo[])obj;
            for (int i = 0; i < orgUnitInfoAry.length; ++i) {
                selectOrgList.add(orgUnitInfoAry[i].getId().toString());
            }
        }
        return selectOrgList;
    }
}

