/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.cellformatter.ICellFormatter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.DiscretePermissionFactory;
import com.kingdee.eas.base.permission.IDiscretePermission;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractUserDiscretePermViewListUI;
import com.kingdee.eas.base.permission.client.DiscreteAccreditManager;
import com.kingdee.eas.base.permission.client.IDiscreteAccreditCommonProvider;
import com.kingdee.eas.base.permission.client.IDiscreteAccreditProvider;
import com.kingdee.eas.base.permission.client.QueryHelperInfo;
import com.kingdee.eas.base.permission.client.helper.OrgHelper;
import com.kingdee.eas.base.permission.client.helper.RoleHelper;
import com.kingdee.eas.base.permission.client.helper.TableColDisplayFormatter;
import com.kingdee.eas.base.permission.client.util.QueryUtils;
import com.kingdee.eas.base.permission.client.util.TableHelper;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.service.OrgCommonCilentUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class UserDiscretePermViewListUI
extends AbstractUserDiscretePermViewListUI {
    private static final Logger logger = CoreUIObject.getLogger(UserDiscretePermViewListUI.class);
    private BOSObjectType bizObjType = null;
    private IObjectPK userPK;
    private IObjectPK orgPK;
    private IObjectPK rolePK;
    private IObjectPK bizDataPK;
    private String conditionStr = null;
    private String commonQueryConditionStr = null;
    private boolean curIsUserTable = true;
    private boolean initPrmtBizOK = false;
    CommonQueryDialog commonQuerydialog = null;
    private IDiscreteAccreditProvider discreteAccreditProvider = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.bizObjType = (BOSObjectType)this.getUIContext().get(BOSObjectType.class.getName());
        this.discreteAccreditProvider = DiscreteAccreditManager.getInstace().getProvider(this.bizObjType);
        this.initUI();
        this.initOrgF7();
        this.initUserF7();
        this.initRoleF7();
        this.initBizObjF7();
        this.initTable();
        this.getUIWindow();
        super.getUIWindow();
    }

    private void initUI() {
        this.btnGoQuery.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnfreshData.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.lblBizData.setBoundLabelText(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"selectName"), this.getEntityName()));
    }

    private void initTable() {
        this.initTableHeader();
        this.initTableListener();
    }

    private void initTableHeader() {
        QueryHelperInfo queryHelperInfo = new QueryHelperInfo();
        queryHelperInfo.setIMetaDataPK(this.getQueryMetaDataPK());
        TableHelper tableHelper = new TableHelper(queryHelperInfo, this.tblUserMain);
        tableHelper.fillTableHeaderDiscrete();
        this.tblUserMain.removeRows();
        this.tblUserMain.getGroupManager().setGroup(true);
        this.tblUserMain.setCellCustomFormatter((ICellFormatter)new TableColDisplayFormatter());
        TableHelper userHelper = new TableHelper(queryHelperInfo, this.tblRoleTable);
        userHelper.fillTableHeaderDiscreteRole();
        this.tblRoleTable.removeRows();
        this.tblRoleTable.setCellCustomFormatter((ICellFormatter)new TableColDisplayFormatter());
    }

    private void initBizObjF7() {
        boolean isNewInterface = false;
        this.prmtBizDataF7.setQueryInfo(StringUtils.replaceIgnoreCase((String)this.discreteAccreditProvider.getQueryPK().toString(), (String)"\\", (String)"."));
        if (this.discreteAccreditProvider instanceof IDiscreteAccreditCommonProvider) {
            isNewInterface = true;
        }
        if (isNewInterface && ((IDiscreteAccreditCommonProvider)this.discreteAccreditProvider).getSelectorCollection() != null) {
            this.prmtBizDataF7.setSelectorCollection(((IDiscreteAccreditCommonProvider)this.discreteAccreditProvider).getSelectorCollection());
        }
        this.prmtBizDataF7.setEditable(false);
        this.prmtBizDataF7.setEditFormat("$number$");
        if (isNewInterface && ((IDiscreteAccreditCommonProvider)this.discreteAccreditProvider).getDisplayName() != null) {
            this.prmtBizDataF7.setDisplayFormat(((IDiscreteAccreditCommonProvider)this.discreteAccreditProvider).getDisplayName());
        } else {
            this.prmtBizDataF7.setDisplayFormat("$name$");
        }
        this.prmtBizDataF7.setCommitFormat("$number$");
    }

    private void setBizF7EntityViewInfo(EntityViewInfo bizEntityViewInfo) {
        this.prmtBizDataF7.setEntityViewInfo(bizEntityViewInfo);
    }

    private EntityViewInfo getBizEntityViewInfo() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String filterString = "";
        filterString = this.curIsUserTable ? this.getUserFilterString() : this.getRoleFilterString();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select fbizdataid from T_PM_DiscretePermPortlet where " + filterString), CompareType.INNER));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private String getUserFilterString() {
        String userId = null;
        String orgId = null;
        Object userData = this.prmtUserF7.getData();
        Object orgData = this.prmtOrgF7.getData();
        if (userData != null && userData instanceof UserInfo) {
            userId = ((UserInfo)userData).getId().toString();
        }
        if (orgData != null && orgData instanceof OrgUnitInfo) {
            orgId = ((OrgUnitInfo)orgData).getId().toString();
        }
        String filterString = "";
        if (userId != null && orgId != null) {
            filterString = " fuserid='" + userId + "' and forgid='" + orgId + "' ";
        } else if (userId != null && orgId == null) {
            filterString = " fuserid='" + userId + "'";
        } else if (userId == null && orgId != null) {
            filterString = "forgid = '" + orgId + "'";
        }
        return filterString;
    }

    private String getRoleFilterString() {
        String roleId = null;
        Object roleData = this.prmtRoleF7.getData();
        if (roleData != null && roleData instanceof RoleInfo) {
            roleId = ((RoleInfo)roleData).getId().toString();
        }
        String filterString = "";
        if (roleId != null) {
            filterString = "froleid='" + roleId + "'";
        }
        return filterString;
    }

    private void initRoleF7() throws EASBizException, BOSException {
        this.prmtRoleF7.setQueryInfo("com.kingdee.eas.base.permission.app.RoleQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.ID in (" + RoleHelper.getCUOrgRangeSQL() + ")"));
        viewInfo.setFilter(filterInfo);
        this.prmtRoleF7.setEntityViewInfo(viewInfo);
        this.prmtRoleF7.setEditFormat("$number$");
        this.prmtRoleF7.setDisplayFormat("$name$");
        this.prmtRoleF7.setCommitFormat("$number$");
        this.prmtRoleF7.setEditable(true);
    }

    private void initUserF7() throws EASBizException, BOSException {
        this.prmtUserF7.setQueryInfo("com.kingdee.eas.base.permission.app.F7AllUserQuery");
        EntityViewInfo viewInfo = this.getUserEntityViewInfo();
        this.prmtUserF7.setEntityViewInfo(viewInfo);
        this.prmtUserF7.setEditFormat("$number$");
        this.prmtUserF7.setDisplayFormat("$name$");
        this.prmtUserF7.setCommitFormat("$number$");
        this.prmtUserF7.setEditable(true);
    }

    private void setUserF7EntityViewInfo(EntityViewInfo userEntityViewInfo) {
        this.prmtUserF7.setEntityViewInfo(userEntityViewInfo);
    }

    private EntityViewInfo getUserEntityViewInfo() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String curOrgId = this.getCurrentOrgID();
        if (curOrgId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)("select distinct fUserid from t_pm_orgrange where forgid = '" + curOrgId + "'"), CompareType.INNER));
        }
        try {
            filterInfo.mergeFilter(Administrator.getNotAdminUserFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handleException((Exception)((Object)e));
        }
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    private String getCurrentOrgID() {
        Object data = this.prmtOrgF7.getData();
        if (data != null && data instanceof OrgUnitInfo) {
            return ((OrgUnitInfo)data).getId().toString();
        }
        return null;
    }

    private OrgUnitInfo getCurrentOrgUnitByBizOrgType(OrgType orgType) {
        if (orgType == null || orgType.equals((Object)OrgType.NONE)) {
            return SysContext.getSysContext().getCurrentOrgUnit();
        }
        return SysContext.getSysContext().getCurrentOrgUnit(orgType);
    }

    private void initOrgF7() throws Exception {
        OrgType orgType = OrgHelper.getBizObjectOrgType(this.bizObjType);
        NewOrgViewF7PromptDialog orgF7 = OrgCommonCilentUtils.createNewF7((OrgType)orgType);
        String orgRangeSQL = PermissionRangeHelper.getBizUserCUOrgRangeSQL(null, ToolUtils.getCurrentUserPK());
        orgF7.setMultiRootUnitsSQL(orgRangeSQL);
        this.prmtOrgF7.setSelector((KDPromptSelector)orgF7);
        this.prmtOrgF7.setData((Object)this.getCurrentOrgUnitByBizOrgType(orgType));
        this.prmtOrgF7.setEditable(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private void initTableListener() {
        this.tblUserMain.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                UserDiscretePermViewListUI.this.tblMain_doRequestRowSet(e, UserDiscretePermViewListUI.this.tblUserMain);
            }
        });
        this.tblRoleTable.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                UserDiscretePermViewListUI.this.tblMain_doRequestRowSet(e, UserDiscretePermViewListUI.this.tblRoleTable);
            }
        });
    }

    private void tblMain_doRequestRowSet(RequestRowSetEvent e, KDTable tblMain) {
        int start = (Integer)e.getParam1();
        int length = (Integer)e.getParam2() - start + 1;
        try {
            String retConditionStr = StringUtil.mergerStrByLogicStr((String)this.commonQueryConditionStr, (String)this.conditionStr, (String)"and");
            IDiscretePermission iDiscretePerm = DiscretePermissionFactory.getRemoteInstance();
            IRowSet rowSet = iDiscretePerm.getUserDiscretePermByQuery(this.getQueryMetaDataPK(), this.bizObjType, this.userPK, this.orgPK, this.rolePK, null, this.bizDataPK, start, length, retConditionStr, this.curIsUserTable);
            e.setRowSet(rowSet);
            this.onGetRowSet(rowSet);
        }
        catch (Exception ee) {
            e.setRowSet(null);
            tblMain.setRowCount(0);
            logger.error((Object)ee);
            this.abort();
        }
    }

    private IMetaDataPK getQueryMetaDataPK() {
        return this.discreteAccreditProvider.getQueryPK();
    }

    @Override
    protected void prmtBizDataF7_dataChanged(DataChangeEvent e) throws Exception {
        Object obj = this.prmtBizDataF7.getData();
        if (obj != null) {
            this.bizDataPK = new ObjectStringPK(obj.toString());
        }
        this.getCurTable().refresh();
    }

    private KDTable getCurTable() {
        if (this.curIsUserTable) {
            return this.tblUserMain;
        }
        return this.tblRoleTable;
    }

    @Override
    protected void prmtOrgF7_dataChanged(DataChangeEvent e) throws Exception {
        Object obj = this.prmtOrgF7.getData();
        if (obj != null) {
            this.orgPK = new ObjectStringPK(obj.toString());
        }
        this.setUserF7EntityViewInfo(this.getUserEntityViewInfo());
        this.setBizF7EntityViewInfo(this.getBizEntityViewInfo());
        this.getCurTable().refresh();
    }

    @Override
    protected void prmtRoleF7_dataChanged(DataChangeEvent e) throws Exception {
        Object obj = this.prmtRoleF7.getData();
        if (obj != null) {
            this.rolePK = new ObjectStringPK(obj.toString());
        }
        this.setBizF7EntityViewInfo(this.getBizEntityViewInfo());
        this.getCurTable().refresh();
    }

    @Override
    protected void prmtUserF7_dataChanged(DataChangeEvent e) throws Exception {
        Object obj = this.prmtUserF7.getData();
        if (obj != null) {
            this.userPK = new ObjectStringPK(obj.toString());
        }
        this.setBizF7EntityViewInfo(this.getBizEntityViewInfo());
        this.getCurTable().refresh();
    }

    @Override
    protected void tabpaneMain_stateChanged(ChangeEvent e) throws Exception {
        this.curIsUserTable = this.tabpaneMain.getSelectedIndex() == 0;
        this.stateChange();
    }

    private void stateChange() {
        if (this.curIsUserTable) {
            this.prmtRoleF7.setEnabled(false);
            this.prmtOrgF7.setEnabled(true);
            this.prmtUserF7.setEnabled(true);
            this.conditionStr = " fRoleid is null ";
        } else {
            this.prmtRoleF7.setEnabled(true);
            this.prmtOrgF7.setEnabled(false);
            this.prmtUserF7.setEnabled(false);
            this.conditionStr = " fRoleid is not null ";
        }
        this.setBizF7EntityViewInfo(this.getBizEntityViewInfo());
    }

    private void loadData() {
        this.orgPK = null;
        this.userPK = null;
        this.rolePK = null;
        this.bizDataPK = null;
        if (!StringUtils.isEmpty((String)StringUtils.cnulls((Object)this.prmtBizDataF7.getData()))) {
            IObjectValue objectValue = (IObjectValue)this.prmtBizDataF7.getData();
            this.bizDataPK = new ObjectStringPK(objectValue.get("ID").toString());
        }
        if (!StringUtils.isEmpty((String)StringUtils.cnulls((Object)this.prmtOrgF7.getData()))) {
            this.orgPK = new ObjectStringPK(StringUtils.cnulls((String)((OrgUnitInfo)this.prmtOrgF7.getData()).getId().toString()));
        }
        if (!StringUtils.isEmpty((String)StringUtils.cnulls((Object)this.prmtUserF7.getData()))) {
            this.userPK = new ObjectStringPK(StringUtils.cnulls((String)((UserInfo)this.prmtUserF7.getData()).getId().toString()));
        }
        if (!StringUtils.isEmpty((String)StringUtils.cnulls((Object)this.prmtRoleF7.getData()))) {
            this.rolePK = new ObjectStringPK(StringUtils.cnulls((String)((RoleInfo)this.prmtRoleF7.getData()).getId().toString()));
        }
    }

    @Override
    public void actionGoQuery_actionPerformed(ActionEvent e) throws Exception {
        this.loadData();
        if (this.curIsUserTable) {
            this.rolePK = null;
        } else {
            this.userPK = null;
            this.orgPK = null;
        }
        this.getCurTable().refresh();
    }

    @Override
    public void actionFreshData_actionPerformed(ActionEvent e) throws Exception {
        this.getCurTable().refresh();
    }

    private List queryBizData(IMetaDataPK queryPK, EntityViewInfo entityView) throws BOSException {
        IRowSet rowSet = QueryUtils.getDataByQuery(queryPK, entityView);
        return this.transRowSet2List(rowSet);
    }

    private List transRowSet2List(IRowSet rowSet) throws BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        try {
            String idFieldStr = this.getKeyFieldName();
            while (rowSet.next()) {
                String value = rowSet.getString(idFieldStr);
                if (StringUtils.isEmpty((String)value)) continue;
                idList.add(value);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return idList;
    }

    protected String getKeyFieldName() {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        QueryInfo queryInfo = loader.getQuery(this.discreteAccreditProvider.getQueryPK());
        return queryInfo.getQueryPK().getKeyPropertys().get(0).toString();
    }

    protected String getEntityName() {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entityInfo = loader.getEntity(this.bizObjType);
        return entityInfo.getAlias();
    }

    protected void selectFirstRow() {
    }

    @Override
    public void actionUserQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.commonQuerydialog == null) {
            this.commonQuerydialog = this.initCommonQueryDialog();
        }
        this.commonQuerydialog.setQueryObjectPK(this.discreteAccreditProvider.getQueryPK());
        if (this.commonQuerydialog.show()) {
            EntityViewInfo entityView;
            List bizIdList = new ArrayList();
            if (this.commonQuerydialog != null && (entityView = this.commonQuerydialog.getEntityViewInfoResult()) != null) {
                bizIdList = this.queryBizData(this.discreteAccreditProvider.getQueryPK(), entityView);
            }
            this.commonQueryConditionStr = bizIdList == null ? null : " fbizDataid in (" + ToolUtils.aryToStr(bizIdList, true) + ")";
            this.actionGoQuery_actionPerformed(null);
        }
    }

    private CommonQueryDialog initCommonQueryDialog() {
        this.commonQuerydialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            this.commonQuerydialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            this.commonQuerydialog.setOwner((Component)((Object)this));
        }
        this.commonQuerydialog.setUiObject((IUIObject)this);
        this.commonQuerydialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        this.commonQuerydialog.setQueryObjectPK(this.discreteAccreditProvider.getQueryPK());
        this.commonQuerydialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        this.commonQuerydialog.setUiObject(null);
        this.commonQuerydialog.setShowSorter(false);
        return this.commonQuerydialog;
    }
}

