/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.util.ParamHelper;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserGroupFactory;
import com.kingdee.eas.base.permission.UserGroupInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.client.AbstractUserF7UI;
import com.kingdee.eas.base.permission.client.UserGroupEditUI;
import com.kingdee.eas.base.permission.client.UserListUIHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class UserF7UI
extends AbstractUserF7UI {
    private static final Logger logger = CoreUIObject.getLogger(UserF7UI.class);
    protected boolean isSingleSelect = false;
    private UserInfo userInfo = null;
    private UserCollection userCol = null;
    private boolean isCanceled = true;
    private EntityViewInfo f7EVI = null;
    private static final String USER_ID_CELLNAME = "id";
    private static final String GROUP_ID_CELLNAME = "group.id";
    private static final String GROUP_NAME_CELLNAME = "group.name";
    private UserListUIHelper helper = null;
    private FilterInfo userRangeFilter = null;
    private boolean mergeUserRangeFilter = true;
    private boolean isCapitalSensitiveQuery = false;

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.helper = new UserListUIHelper();
        this.userRangeFilter = this.helper.getCurrentRangeUser();
        this.userRangeFilter.mergeFilter(Administrator.getNotAdminUserFilter(), "and");
        this.initCapitalSensitiveQuery();
        HashMap map = (HashMap)this.getUIContext();
        if (map.get("F7_EVI") != null) {
            this.f7EVI = (EntityViewInfo)map.get("F7_EVI");
        }
        if (map.get("mergeUserRangeFilter") != null) {
            this.mergeUserRangeFilter = Boolean.parseBoolean("mergeUserRangeFilter");
        }
        this.mergeF7Filter();
        this.chkLike.setSelected(true);
        this.tblMain.removeRows();
        KDTable currentTable = this.getMainTable();
        this.tblMain.getGroupManager().setGroup(true);
        this.setMergeColumn(true);
        this.tblMain.refresh();
        this.btnMoveTree.setVisible(false);
        this.btnGroupAddNew.setVisible(false);
        this.btnGroupEdit.setVisible(false);
        this.btnGroupRemove.setVisible(false);
        this.btnGroupMoveTree.setVisible(false);
        this.tblMain.getColumn("adminDisplayName").getStyleAttributes().setHided(true);
    }

    private void setMergeColumn(boolean merge) {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(merge);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(merge);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(merge);
            }
        }
        this.tblMain.getColumn(GROUP_ID_CELLNAME).setMergeable(false);
        this.tblMain.getColumn(GROUP_NAME_CELLNAME).setMergeable(false);
    }

    public String[] getMergeColumnKeys() {
        String[] columnKeys = new String[]{"number", "type", "name", "CU.name", "security.alias", "adminName", "adminDisplayName", "bizAdmin", "effectiveDate", "invalidationDate", "PWEffectiveDate", "isForbidden", "isLocked", "description", "defOrgUnit.name", "isSynToCloud", "cell", "email"};
        return columnKeys;
    }

    protected String[] getNotOrderColumns() {
        String[] columnKeys = new String[]{GROUP_NAME_CELLNAME};
        return columnKeys;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return UserGroupFactory.getRemoteInstance();
    }

    protected ICoreBase getBizInterface() throws BOSException {
        return UserFactory.getRemoteInstance();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initTree() throws Exception {
        super.initTree();
    }

    protected String getKeyFieldName() {
        return USER_ID_CELLNAME;
    }

    protected String getRootName() {
        return PermissionResUtil.getResource("res_111");
    }

    protected String getLongNumberFieldName() {
        return "";
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int[] rowID;
        KDTSelectBlock block;
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            super.tblMain_tableClicked(e);
            return;
        }
        if (this.tblMain.getSelectManager().size() > 0 && (block = this.tblMain.getSelectManager().get(0)).getMode() == 8 && (rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain)).length == 1) {
            return;
        }
        if (e.getClickCount() == 2) {
            this.storeData();
            this.close(false);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.storeData();
        this.close(false);
    }

    private void storeData() throws Exception {
        int i;
        int[] rowIDs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        KDTSelectManager manager = this.tblMain.getSelectManager();
        if (this.tblMain.getRowCount() > 0 && manager.size() > 0 && manager.get(0).getMode() == 8) {
            rowIDs = new int[this.tblMain.getRowCount()];
            for (i = 0; i < rowIDs.length; ++i) {
                rowIDs[i] = i;
            }
        }
        if (this.isSingleSelect) {
            if (rowIDs.length > 0) {
                String strID = this.tblMain.getRow(rowIDs[0]).getCell(USER_ID_CELLNAME).getValue().toString();
                IUser iUser = UserFactory.getRemoteInstance();
                this.userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)strID)));
                this.isCanceled = false;
                this.getUIWindow().close();
            }
        } else {
            if (this.userCol == null) {
                this.userCol = new UserCollection();
            }
            for (i = 0; i < rowIDs.length; ++i) {
                if (rowIDs[i] == -1) continue;
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)this.tblMain.getRow(rowIDs[i]).getCell(USER_ID_CELLNAME).getValue().toString()));
                if (this.tblMain.getRow(rowIDs[i]).getCell("name").getValue() != null) {
                    userInfo.setName(this.tblMain.getRow(rowIDs[i]).getCell("name").getValue().toString());
                }
                userInfo.setNumber(this.tblMain.getRow(rowIDs[i]).getCell("number").getValue().toString());
                userInfo.setType(UserType.getEnum(((BizEnumValueDTO)this.tblMain.getRow(rowIDs[i]).getCell("type").getValue()).getInt()));
                this.userCol.add(userInfo);
            }
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterinfo = null;
        if (this.f7EVI != null && (filterinfo = this.f7EVI.getFilter()) != null && this.mergeUserRangeFilter) {
            try {
                filterinfo = (FilterInfo)filterinfo.clone();
                filterinfo.mergeFilter(this.userRangeFilter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)"Permission.UserF7UI.getDefaultFilterForQuery:", (Throwable)e);
            }
        }
        return filterinfo != null ? filterinfo : this.userRangeFilter;
    }

    private void close(boolean isCanceled) {
        this.isCanceled = isCanceled;
        this.getUIWindow().close();
    }

    @Override
    public void actionQuit_actionPerformed(ActionEvent e) throws Exception {
        this.close(true);
    }

    public void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        TreePath path = this.treeMain.getSelectionPath();
        if (path == null) {
            FilterInfo nofilter = new FilterInfo();
            nofilter.getFilterItems().add(new FilterItemInfo(USER_ID_CELLNAME, (Object)"nodata"));
            this.mainQuery.setFilter(nofilter);
            this.mergeF7Filter();
            this.tblMain.removeRows();
            return;
        }
        DefaultKingdeeTreeNode treenode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (treenode.getUserObject() != null && treenode.getUserObject() instanceof UserGroupInfo) {
            UserGroupInfo groupInfo = (UserGroupInfo)treenode.getUserObject();
            this.mainQuery = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(GROUP_ID_CELLNAME, (Object)groupInfo.getId().toString()));
            this.mainQuery.setFilter(filter);
        } else if (treenode.getUserObject() != null && treenode.isRoot()) {
            FilterInfo filter = new FilterInfo();
            this.mainQuery.setFilter(filter);
        } else {
            FilterInfo nofilter = new FilterInfo();
            nofilter.getFilterItems().add(new FilterItemInfo(USER_ID_CELLNAME, (Object)"nodata"));
            this.mainQuery.setFilter(nofilter);
        }
        this.mergeF7Filter();
        this.tblMain.removeRows();
        this.tblMain.requestFocusInWindow();
        this.selectFirstRow();
        super.treeMain_valueChanged(e);
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public UserCollection getUserCollection() {
        return this.userCol;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    @Override
    public void actionFastQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionFastQuery_actionPerformed(e);
        String theValue = this.txtValue.getText().trim();
        if (theValue.length() != 0) {
            String theCompareString = "=";
            String fieldName = "name";
            if (this.cboKey.getSelectedIndex() == 0) {
                fieldName = "name";
            } else if (this.cboKey.getSelectedIndex() == 1) {
                fieldName = "number";
            }
            if (this.chkLike.isSelected()) {
                theCompareString = "like";
                theValue = ParamHelper.getMatchString((String)fieldName, (String)theValue, (String)"");
            }
            theValue = "'" + theValue + "'";
            String oql = "where ";
            oql = this.isCapitalSensitiveQuery ? oql + fieldName + " " + theCompareString + " " + theValue : oql + "upper(" + fieldName + ") " + theCompareString + " " + theValue.toUpperCase();
            try {
                this.mainQuery = new EntityViewInfo(oql.toString());
            }
            catch (Exception ex) {
                this.mainQuery = new EntityViewInfo();
            }
        } else {
            this.mainQuery = new EntityViewInfo();
        }
        this.mergeF7Filter();
        this.tblMain.removeRows();
        this.tblMain.requestFocusInWindow();
        this.selectFirstRow();
    }

    private void initCapitalSensitiveQuery() {
        String capitalSensitiveQuery = ParamHelper.getCapitalSensitiveQuery();
        if (capitalSensitiveQuery != null && capitalSensitiveQuery.equalsIgnoreCase("true")) {
            this.isCapitalSensitiveQuery = true;
        }
    }

    private void mergeF7Filter() throws Exception {
        if (this.f7EVI != null && this.f7EVI.getFilter() != null && this.f7EVI.getFilter().getFilterItems().size() > 0) {
            EntityViewInfo cloneFilter = (EntityViewInfo)this.f7EVI.clone();
            if (this.mainQuery.getFilter() != null && this.mainQuery.getFilter().getFilterItems().size() > 0) {
                this.mainQuery.getFilter().mergeFilter(cloneFilter.getFilter(), "and");
            } else {
                this.mainQuery.setFilter(cloneFilter.getFilter());
            }
        }
        if (this.mergeUserRangeFilter) {
            FilterInfo userFilter = this.mainQuery.getFilter();
            if (userFilter == null) {
                this.mainQuery.setFilter(this.userRangeFilter);
            } else {
                this.mainQuery.getFilter().mergeFilter(this.userRangeFilter, "and");
            }
        }
    }

    protected String getEditUIName() {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.actionConfirm_actionPerformed(null);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected String getGroupEditUIName() {
        return UserGroupEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return GROUP_ID_CELLNAME;
    }

    @Override
    protected void chkShowAdminDisPlayName_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getColumn("adminName").getStyleAttributes().setHided(this.chkShowAdminDisPlayName.isSelected());
        this.tblMain.getColumn("adminDisplayName").getStyleAttributes().setHided(!this.chkShowAdminDisPlayName.isSelected());
    }
}

