/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.FieldAccessCollection;
import com.kingdee.eas.base.permission.FieldAccessFactory;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermFacadeFactory;
import com.kingdee.eas.base.permission.GrantUserFieldFactory;
import com.kingdee.eas.base.permission.IFieldAccess;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractUserFieldAccessAccreditUI;
import com.kingdee.eas.base.permission.client.util.FieldAccessUtil;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.LogNamesHelper;
import com.kingdee.eas.base.permission.util.LogProxy;
import com.kingdee.eas.base.permission.util.MyEntityInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.AccreditPermF7PromptDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class UserFieldAccessAccreditUI
extends AbstractUserFieldAccessAccreditUI {
    private static final int FIELD_NAME_INDEX = 0;
    private static final int VIEWABLE_INDEX = 1;
    private static final int EDITABLE_INDEX = 2;
    private static final int GRANT_INDEX = 3;
    public static final String TARGET_ORG_PK = "orgPK";
    public static final String TARGET_USER_PK = "userPK";
    public static final String TARGET_USER_INFO = "targetUserInfo";
    private static final String GRANTABLE = "grantable";
    private Map loadedData = null;
    private FieldAccessCollection oldData = null;
    private Set oldGrantFields = null;
    private BOSObjectType currentBOSObjectType = null;
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman hander = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("targetUserPK", (Object)this.getTargetUserPK());
        request.put("targetOrgPK", (Object)this.getTargetOrgPK());
        hander.setRequestContext((Serializable)request);
        return hander;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.setStatus();
        this.selectDefOrg();
    }

    private void setStatus() {
        this.pmtOrg.setEnabled(false);
    }

    private void initUI() throws EASBizException, BOSException {
        this.initTable();
    }

    private void initTable() {
        this.tblMain.checkParsed(true);
        if (this.isTargetBizAdmin()) {
            this.tblMain.getColumn(GRANTABLE).getStyleAttributes().setHided(false);
        }
    }

    private String getSelectedOrgNumber() {
        if (this.pmtOrg.getData() == null) {
            return "";
        }
        FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)this.pmtOrg.getData();
        return fullOrgUnitInfo.getNumber();
    }

    private IObjectPK getSelectedOrgPK() {
        if (this.pmtOrg.getData() == null) {
            return null;
        }
        FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)this.pmtOrg.getData();
        return new ObjectUuidPK(fullOrgUnitInfo.getId());
    }

    private void initOrgF7() throws EASBizException, BOSException {
        UserInfo targetUser = UserFactory.getRemoteInstance().getUserByID(this.getTargetUserPK());
        AccreditPermF7PromptDialog orgF7 = new AccreditPermF7PromptDialog((IUIObject)this, targetUser, false);
        orgF7.setMultiSelect(false);
        this.pmtOrg.setSelector((KDPromptSelector)orgF7);
        this.selectDefOrg();
    }

    private void selectDefOrg() throws EASBizException, BOSException {
        IObjectPK orgPK = this.getTargetOrgPK();
        if (orgPK != null) {
            FullOrgUnitInfo defOrgUnit = this.getOrg(this.getTargetOrgPK());
            this.pmtOrg.setData((Object)defOrgUnit);
        }
    }

    private FullOrgUnitInfo getOrg(IObjectPK orgPK) throws EASBizException, BOSException {
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        return iFullOrgUnit.getFullOrgUnitInfo(orgPK);
    }

    private void buildTree() throws EASBizException, BOSException {
        DefaultKingdeeTreeNode root = this.createNode();
        FieldAccessUtil.filterUserFieldAccessTreeNode(this.getTargetUserPK(), this.getTargetOrgPK(), root);
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        this.tree.setModel((TreeModel)model);
        UIUtil.addStandardPopupMenu(this.tree);
    }

    private void clearTree() {
        ((DefaultTreeModel)this.tree.getModel()).setRoot(null);
    }

    private DefaultKingdeeTreeNode createNode() {
        return SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_fieldpermission")));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnSubmit);
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.setButtonDefaultStyl(this.btnSelectAll);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.setButtonDefaultStyl(this.btnClearAll);
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    private IObjectPK getTargetOrgPK() {
        if (this.getUIContext().get(TARGET_ORG_PK) != null) {
            return (IObjectPK)this.getUIContext().get(TARGET_ORG_PK);
        }
        return null;
    }

    private IObjectPK getAccreditOrgPK() {
        IObjectPK orgPK = this.getSelectedOrgPK();
        if (orgPK != null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo entity = loader.getEntity(this.currentBOSObjectType);
            if (OrgType.NONE.equals((Object)PermissionCommonUtil.getMainBizOrgType(entity))) {
                return new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4");
            }
            return orgPK;
        }
        return null;
    }

    private IObjectPK getTargetUserPK() {
        if (this.getUIContext().get(TARGET_USER_PK) != null) {
            return (IObjectPK)this.getUIContext().get(TARGET_USER_PK);
        }
        return null;
    }

    private UserInfo getTargetUserInfo() {
        if (this.getUIContext().get(TARGET_USER_INFO) != null) {
            return (UserInfo)this.getUIContext().get(TARGET_USER_INFO);
        }
        return null;
    }

    private boolean isTargetBizAdmin() {
        if (this.getTargetUserInfo() != null) {
            return this.getTargetUserInfo().isBizAdmin();
        }
        return false;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.save();
    }

    @Override
    protected void pmtOrg_dataChanged(DataChangeEvent e) throws Exception {
        super.pmtOrg_dataChanged(e);
        IObjectPK orgPK = this.getSelectedOrgPK();
        if (orgPK != null) {
            this.buildTree();
        } else {
            this.clearTree();
        }
    }

    private String getLogFieldStr(FieldAccessCollection currentResult, Set grantFields) {
        Locale locale = SysContext.getSysContext().getLocale();
        if (currentResult == null || currentResult.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(LogNamesHelper.getLogName("orgNumber4Log", locale)).append(":").append(this.getSelectedOrgNumber());
        sb.append(" \n ").append(LogNamesHelper.getLogName("operObj", locale)).append(":").append(MyEntityInfo.getBOSEntity(null, BOSObjectType.create((String)currentResult.get(0).getBizObjectType()), true).getName());
        List retStrList = ToolUtils.transCol2ListByPeroperty((IObjectCollection)currentResult, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                FieldAccessInfo fieldInfo = (FieldAccessInfo)obj;
                return fieldInfo.getFieldName();
            }
        });
        sb.append("  \n ").append(LogNamesHelper.getLogName("fieldName", locale)).append(":").append(ToolUtils.aryToStr(retStrList, false));
        String grantFieldStr = ToolUtils.aryToStr(grantFields, false);
        sb.append(" \n ").append(LogNamesHelper.getLogName("grantFieldName", locale)).append(":").append(grantFieldStr);
        return sb.toString();
    }

    private void save() throws Exception {
        if (this.currentBOSObjectType != null) {
            FieldAccessCollection currentResult = this.getCurrentResult();
            IFieldAccess iFieldAccess = FieldAccessFactory.getRemoteInstance();
            Set currentGrantFields = this.getCurrentGrantFields();
            if (currentResult.size() == 0) {
                this.deleteFieldAccess(this.currentBOSObjectType);
            } else {
                LogProxy logProxy = new LogProxy();
                String logString = this.getLogFieldStr(currentResult, currentGrantFields);
                logProxy.beginLog(null, MyEntityInfo.getMethodAlias(null, iFieldAccess.getType(), "save"), iFieldAccess.getType(), null, logString, "bs_permission_user_fieldAccessStrategyAccredit");
                FieldPermFacadeFactory.getRemoteInstance().saveUserFieldPerm(this.getTargetUserPK(), this.getAccreditOrgPK(), currentGrantFields, this.currentBOSObjectType, currentResult);
                logProxy.end();
            }
            this.refreshList();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"accreditPermSucceed"));
        }
    }

    private void deleteFieldAccess(BOSObjectType objectType) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bizObjectType", (Object)objectType.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)this.getTargetUserPK().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("org.id", (Object)this.getAccreditOrgPK().toString()));
        IFieldAccess iFieldAccess = FieldAccessFactory.getRemoteInstance();
        iFieldAccess.delete(filterInfo);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.setValue(Boolean.TRUE);
        super.actionSelectAll_actionPerformed(e);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.setValue(Boolean.FALSE);
        super.actionClearAll_actionPerformed(e);
    }

    private void setValue(Boolean value) {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                int endCol = selectBlock.getRight();
                for (int beginCol = selectBlock.getLeft(); beginCol <= endCol; ++beginCol) {
                    if (beginCol == 1 || beginCol == 2) {
                        this.tblMain.getRow(j).getCell(beginCol).setValue((Object)value);
                        if (beginCol == 2 && value.booleanValue()) {
                            this.tblMain.getRow(j).getCell(1).setValue((Object)value);
                        }
                        if (beginCol == 1 && !value.booleanValue()) {
                            this.tblMain.getRow(j).getCell(2).setValue((Object)value);
                        }
                    }
                    if (beginCol != 3) continue;
                    this.tblMain.getRow(j).getCell(GRANTABLE).setValue((Object)value);
                }
            }
        }
    }

    @Override
    protected void tree_valueChanged(TreeSelectionEvent e) throws Exception {
        super.tree_valueChanged(e);
        this.alertSave();
        this.refreshList();
    }

    private void setCurrentEntityType() {
        MetaDataBriefInfo mdbInfo;
        DefaultKingdeeTreeNode node;
        Object userObject;
        Object object = this.tree.getLastSelectedPathComponent();
        if (object != null && object instanceof DefaultKingdeeTreeNode && (userObject = (node = (DefaultKingdeeTreeNode)object).getUserObject()) instanceof MetaDataBriefInfo && (mdbInfo = (MetaDataBriefInfo)userObject).getMetaDataType().equals((Object)MetaDataTypeList.ENTITY)) {
            this.currentBOSObjectType = mdbInfo.getBOType();
            return;
        }
        this.currentBOSObjectType = null;
    }

    private void alertSave() throws Exception {
        if (this.currentBOSObjectType != null && this.isModify()) {
            int isYes = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"fieldAccessIsChange"));
            if (MsgBox.isYes((int)isYes)) {
                this.save();
                this.abort();
            } else if (MsgBox.isCancel((int)isYes)) {
                this.abort();
            }
        }
    }

    private boolean isModify() {
        return this.isFieldAccessModify() || this.isGrantFieldModify();
    }

    private boolean isFieldAccessModify() {
        FieldAccessCollection currentResult = this.getCurrentResult();
        int size = currentResult.size();
        int oldSize = this.oldData.size();
        if (currentResult.size() == this.oldData.size()) {
            int i;
            HashMap<String, FieldAccessInfo> oldDataMap = new HashMap<String, FieldAccessInfo>();
            for (i = 0; i < oldSize; ++i) {
                oldDataMap.put(this.oldData.get(i).getFieldName(), this.oldData.get(i));
            }
            for (i = 0; i < size; ++i) {
                FieldAccessInfo fieldAccessInfo = currentResult.get(i);
                String fieldName = fieldAccessInfo.getFieldName();
                if (oldDataMap.containsKey(fieldName)) {
                    FieldAccessInfo oldFieldAccessInfo = (FieldAccessInfo)oldDataMap.get(fieldName);
                    if (fieldAccessInfo.getAccessValue() == oldFieldAccessInfo.getAccessValue()) continue;
                    return true;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isGrantFieldModify() {
        Set currentGrantFields = this.getCurrentGrantFields();
        return !this.oldGrantFields.containsAll(currentGrantFields) || !currentGrantFields.containsAll(this.oldGrantFields);
    }

    private FieldAccessCollection getCurrentResult() {
        FieldAccessCollection result = new FieldAccessCollection();
        UserInfo userInfo = new UserInfo();
        FullOrgUnitInfo org = new FullOrgUnitInfo();
        RoleInfo roleInfo = new RoleInfo();
        userInfo.setId(BOSUuid.read((String)this.getTargetUserPK().toString()));
        org.setId(BOSUuid.read((String)this.getAccreditOrgPK().toString()));
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            boolean isViewable = (Boolean)row.getCell(1).getValue();
            boolean isEditable = (Boolean)row.getCell(2).getValue();
            String fieldName = (String)row.getCell(0).getUserObject();
            FieldAccessInfo info = new FieldAccessInfo();
            info.setBizObjectType(this.currentBOSObjectType.toString());
            info.setFieldName(fieldName);
            info.setViewable(isViewable);
            info.setEditable(isEditable);
            info.setCU(this.getCurrentCU());
            info.setUser(userInfo);
            info.setOrg(org);
            info.setRole(roleInfo);
            result.add(info);
        }
        return result;
    }

    private Set getCurrentGrantFields() {
        HashSet<String> ret = new HashSet<String>();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            boolean isGrant = (Boolean)row.getCell(GRANTABLE).getValue();
            if (!isGrant) continue;
            ret.add(row.getCell(0).getUserObject().toString());
        }
        return ret;
    }

    private void refreshList() throws Exception {
        this.setCurrentEntityType();
        if (this.currentBOSObjectType != null) {
            this.loadCurrentFieldAccess(this.currentBOSObjectType);
            this.loadRowData(this.currentBOSObjectType);
            this.oldData = this.getCurrentResult();
            this.oldGrantFields = this.getCurrentGrantFields();
        } else {
            this.loadedData = null;
            this.tblMain.removeRows();
            this.oldData = null;
            this.oldGrantFields = null;
        }
    }

    private Map loadCurrentFieldAccess(BOSObjectType objectType) throws BOSException {
        this.loadedData = new HashMap();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bizObjectType", (Object)objectType.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)this.getTargetUserPK().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("org.id", (Object)this.getAccreditOrgPK().toString()));
        entityViewInfo.setFilter(filterInfo);
        IFieldAccess iFieldAccess = FieldAccessFactory.getRemoteInstance();
        FieldAccessCollection collection = iFieldAccess.getFieldAccessCollection(entityViewInfo);
        if (collection != null) {
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                FieldAccessInfo info = collection.get(i);
                this.loadedData.put(info.getFieldName(), info);
            }
        }
        return this.loadedData;
    }

    private Set getGrantedUserFields(BOSObjectType objectType) throws Exception {
        return GrantUserFieldFactory.getRemoteInstance().getGrantedFields(this.getTargetUserPK(), this.getAccreditOrgPK(), objectType);
    }

    private void loadRowData(BOSObjectType objectType) throws Exception {
        this.tblMain.setRefresh(false);
        this.tblMain.removeRows();
        Set result = FieldAccessUtil.getFieldAccessStrategy(objectType, this.getCUPK(this.getAccreditOrgPK()));
        Set fieldInfos = FieldAccessUtil.getEntityFieldInfos(objectType);
        if (this.isCurrentUserBizAdmin()) {
            Set grantedFields = GrantUserFieldFactory.getRemoteInstance().getUserAndRoleGrantedFields((IObjectPK)new ObjectUuidPK(this.getCurrentUserInfo().getId()), this.getTargetOrgPK(), objectType);
            fieldInfos = FieldAccessUtil.getGrantedFieldInfos(fieldInfos, grantedFields);
        }
        Set grantedUserFields = this.getGrantedUserFields(objectType);
        for (String[] fieldInfo : fieldInfos) {
            if (!result.contains(fieldInfo[1])) continue;
            IRow row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)fieldInfo[0]);
            row.getCell(0).setUserObject((Object)fieldInfo[1]);
            if (this.loadedData.containsKey(fieldInfo[1])) {
                FieldAccessInfo info = (FieldAccessInfo)this.loadedData.get(fieldInfo[1]);
                row.getCell(1).setValue((Object)info.isViewable());
                row.getCell(2).setValue((Object)info.isEditable());
            } else {
                row.getCell(1).setValue((Object)Boolean.TRUE);
                row.getCell(2).setValue((Object)Boolean.TRUE);
            }
            if (grantedUserFields.contains(fieldInfo[1])) {
                row.getCell(GRANTABLE).setValue((Object)Boolean.TRUE);
                continue;
            }
            row.getCell(GRANTABLE).setValue((Object)Boolean.FALSE);
        }
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
    }

    private IObjectPK getCUPK(IObjectPK orgPK) throws EASBizException, BOSException {
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        FullOrgUnitInfo fullOrgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo(orgPK);
        return new ObjectUuidPK(fullOrgUnitInfo.getCU().getId());
    }

    private UserInfo getCurrentUserInfo() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    private boolean isCurrentUserBizAdmin() {
        return this.getCurrentUserInfo().isBizAdmin();
    }

    private CtrlUnitInfo getCurrentCU() {
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    @Override
    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        super.tblMain_editValueChanged(e);
        boolean flag = e.getValue() == null ? false : (Boolean)e.getValue();
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        this.tblMain.getCell(rowIndex, colIndex).setValue(e.getValue());
        if (colIndex == 1) {
            if (!flag) {
                this.tblMain.getRow(rowIndex).getCell(2).setValue((Object)Boolean.FALSE);
            }
        } else if (colIndex == 2 && flag) {
            this.tblMain.getRow(rowIndex).getCell(1).setValue((Object)Boolean.TRUE);
        }
    }
}

