/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgCollection;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.UserEditUI;
import com.kingdee.eas.base.permission.client.helper.PermissionUIHelper;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.BizOrgRangeF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.CtrlF7;
import com.kingdee.eas.common.EASBizException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserOrgRangeHelper {
    private UserEditUI userEditUI;
    private static Logger logger = Logger.getLogger((String)UserOrgRangeHelper.class.getName());

    private UserOrgRangeHelper(UserEditUI userEditUI) {
        this.userEditUI = userEditUI;
    }

    public static UserOrgRangeHelper getHelper(UserEditUI userEditUI) {
        return new UserOrgRangeHelper(userEditUI);
    }

    public static FullOrgUnitInfo[] selectCURangeOrgs(Set selectedOrgs, UserInfo editUserInfo) {
        FullOrgUnitInfo[] fullOrgUnitInfos = null;
        CtrlF7 ctrlF7 = new CtrlF7();
        ctrlF7.setRootUnitID(editUserInfo.getCU().getId().toString());
        ctrlF7.setMultiSelect(true);
        ctrlF7.setCheckedOrgIDs(selectedOrgs);
        ctrlF7.setUnChangeableOrgIDs(selectedOrgs);
        ctrlF7.setIsShowContainSealUp(true);
        if (editUserInfo.getId() != null && Administrator.isSuperAdmin((IObjectPK)new ObjectUuidPK(editUserInfo.getId()))) {
            ctrlF7.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
            ctrlF7.disablePerm();
        }
        ctrlF7.setShowNameandNumber(true);
        ctrlF7.show();
        if (!ctrlF7.isCanceled()) {
            fullOrgUnitInfos = PermissionUIHelper.getOrgs(ctrlF7.getData());
        }
        return fullOrgUnitInfos;
    }

    public static FullOrgUnitInfo[] selectBizOrg(Set selectedOrgs, UserInfo editUserInfo) throws EASBizException, BOSException {
        return UserOrgRangeHelper.selectBizOrg(null, selectedOrgs, editUserInfo);
    }

    public static FullOrgUnitInfo[] selectBizOrg(IUIObject uiObject, Set selectedOrgs, UserInfo editUserInfo) throws EASBizException, BOSException {
        BizOrgRangeF7PromptDialog orgF7 = new BizOrgRangeF7PromptDialog(uiObject, editUserInfo);
        HashSet tmp = new HashSet();
        tmp.addAll(selectedOrgs);
        orgF7.setSelectedOrgIds(tmp);
        orgF7.show();
        FullOrgUnitInfo[] orgs = PermissionUIHelper.getOrgs(orgF7.getData());
        return orgs;
    }

    public static OrgRangeCollection orgRangeCast(OrgRangeIncludeSubOrgCollection orgRange) {
        OrgRangeCollection commonOrgRangeCol = new OrgRangeCollection();
        int size = orgRange.size();
        for (int index = 0; index < size; ++index) {
            OrgRangeInfo oInfo = new OrgRangeInfo();
            oInfo.setOrg(orgRange.get(index).getOrg());
            oInfo.setUser(orgRange.get(index).getUser());
            oInfo.setType(orgRange.get(index).getType());
            commonOrgRangeCol.add(oInfo);
        }
        return commonOrgRangeCol;
    }
}

