/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.GroupLicModeUserCheckStrategy;
import com.kingdee.eas.base.permission.util.IUserInfoCheckStrategy;
import com.kingdee.eas.base.permission.util.RegistLicModeUserCheckStrategy;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserHelper {
    private static Logger logger = Logger.getLogger((String)UserHelper.class.getName());
    CoreUI editUI;
    IUserInfoCheckStrategy checkStragey;

    public void setEditUI(CoreUI editUI) {
        this.editUI = editUI;
        boolean isRegister = false;
        try {
            isRegister = FrameWorkClientUtils.getLicenseController().isRegister();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        this.checkStragey = isRegister ? new RegistLicModeUserCheckStrategy() : new GroupLicModeUserCheckStrategy();
    }

    public void checkUserInfo(UserInfo user) throws UserException {
        this.checkStragey.check(user);
    }

    public void suspendProcessInst(Set set) throws UserException {
        if (set == null || set.isEmpty()) {
            return;
        }
        try {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                EnactmentServiceFactory.createRemoteEnactService().suspendProcessInst(iter.next().toString());
            }
        }
        catch (WfException e) {
            logger.error((Object)"", (Throwable)e);
            throw new UserException(UserException.SUSPEND_WORKFLOW_ERROR);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new UserException(UserException.SUSPEND_WORKFLOW_ERROR);
        }
    }

    public Set findWf(IObjectPK userId) throws UserException {
        HashSet<String> set = new HashSet<String>();
        try {
            if (userId == null) {
                return set;
            }
            AssignmentInfo[] assignInfos = EnactmentServiceFactory.createRemoteEnactService().checkAssignmentInfos(userId.toString());
            if (assignInfos == null || assignInfos.length == 0) {
                return set;
            }
            int n = assignInfos.length;
            for (int i = 0; i < n; ++i) {
                String procInstId = assignInfos[i].getProcInstId();
                if (set.contains(procInstId)) continue;
                set.add(procInstId);
            }
        }
        catch (WfException e) {
            logger.error((Object)"", (Throwable)e);
            throw new UserException(UserException.SUSPEND_WORKFLOW_ERROR);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new UserException(UserException.SUSPEND_WORKFLOW_ERROR);
        }
        return set;
    }

    public void deleteUserWorkflow(IObjectPK userId) throws UserException {
        try {
            if (userId == null) {
                return;
            }
            AssignmentInfo[] assignInfos = EnactmentServiceFactory.createRemoteEnactService().checkAssignmentInfos(userId.toString());
            if (assignInfos == null || assignInfos.length == 0) {
                return;
            }
            HashSet<String> set = new HashSet<String>();
            int n = assignInfos.length;
            for (int i = 0; i < n; ++i) {
                String procInstId = assignInfos[i].getProcInstId();
                if (set.contains(procInstId)) continue;
                set.add(procInstId);
            }
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                EnactmentServiceFactory.createRemoteEnactService().suspendProcessInst(iter.next().toString());
            }
        }
        catch (WfException e) {
            logger.error((Object)"", (Throwable)e);
            throw new UserException(UserException.SUSPEND_WORKFLOW_ERROR);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new UserException(UserException.SUSPEND_WORKFLOW_ERROR);
        }
    }

    public void deleteUserWorkflow(List userIdList) throws UserException {
        if (userIdList == null || userIdList.isEmpty()) {
            return;
        }
        int size = userIdList.size();
        for (int i = 0; i < size; ++i) {
            this.deleteUserWorkflow((IObjectPK)userIdList.get(i));
        }
    }

    public boolean hasUserWorkflow(List userIdList) throws UserException {
        if (userIdList == null || userIdList.isEmpty()) {
            return false;
        }
        int size = userIdList.size();
        for (int i = 0; i < size; ++i) {
            Set set = this.findWf((IObjectPK)userIdList.get(i));
            if (set == null || set.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

