/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.quickperm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IUserOrgPerm;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.RuleInfo;
import com.kingdee.eas.base.permission.UserOrgPermFactory;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.client.quickperm.PopMenuConfigInfo;
import com.kingdee.eas.base.permission.client.quickperm.RuleProxy;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class UserPermProxy {
    private static String PREFIX = " WHERE ";
    private static Logger logger = Logger.getLogger(UserPermProxy.class);

    public void saveUserPermRule(UserOrgPermInfo userOrgPermInfo, RuleInfo ruleInfo) throws EASBizException, BOSException, ParserException {
        userOrgPermInfo.setRuleStructure(PREFIX + ruleInfo.getId().toString());
        userOrgPermInfo.setRuleExpr(PREFIX + "(" + RuleProxy.buildRuleExpr(ruleInfo.getBizObject(), ruleInfo.getScript()) + ")");
        userOrgPermInfo.setCtrlUnit(ToolUtils.getCurrentCU());
        userOrgPermInfo.setPermType(PermType.NORMAL);
        String permId = userOrgPermInfo.getPermItem().getId().toString();
        if (!PopMenuConfigInfo.getInstance().getAllKey4Batch().contains(permId)) {
            IUserOrgPerm iUserOrgPerm = UserOrgPermFactory.getRemoteInstance();
            if (userOrgPermInfo.getId() == null) {
                iUserOrgPerm.addnew(userOrgPermInfo);
            } else {
                iUserOrgPerm.update((IObjectPK)new ObjectStringPK(userOrgPermInfo.getId().toString()), userOrgPermInfo);
            }
        } else {
            this.saveBatchSubNode(userOrgPermInfo, ruleInfo);
        }
    }

    private void saveBatchSubNode(UserOrgPermInfo userOrgPermInfo, RuleInfo ruleInfo) throws EASBizException, BOSException {
        String permId = userOrgPermInfo.getPermItem().getId().toString();
        String subPermId = PopMenuConfigInfo.getInstance().getValueBatch(permId);
        if (StringUtils.isEmpty((String)subPermId)) {
            return;
        }
        String[] subPermIdAry = StringUtils.split((String)subPermId, (String)",");
        if (subPermIdAry == null || subPermIdAry.length == 0) {
            return;
        }
        int size = subPermIdAry.length;
        for (int i = 0; i < size; ++i) {
            this.saveBatchPerm(userOrgPermInfo, subPermIdAry[i]);
        }
    }

    private void saveBatchPerm(UserOrgPermInfo userOrgPermInfo, String newPermIdStr) throws EASBizException, BOSException {
        UserOrgPermInfo tempOrgPermInfo = null;
        try {
            tempOrgPermInfo = (UserOrgPermInfo)ObjectUtils.createCopy((Object)userOrgPermInfo);
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException("CloneNotSupportedException is fail!", (Throwable)e);
        }
        this.deletePermInfo(tempOrgPermInfo.getOwner().getId().toString(), newPermIdStr, tempOrgPermInfo.getOrg().getId().toString());
        PermItemInfo permItemInfo = tempOrgPermInfo.getPermItem();
        permItemInfo.setId(BOSUuid.read((String)newPermIdStr));
        tempOrgPermInfo.setId(BOSUuid.create((BOSObjectType)tempOrgPermInfo.getBOSType()));
        this.savePermInfo(tempOrgPermInfo);
    }

    public PermItemInfo getPermItemInfo(String permItemId) throws EASBizException, BOSException {
        IPermItem iPermItem = PermItemFactory.getRemoteInstance();
        return iPermItem.getPermItemInfo((IObjectPK)new ObjectStringPK(permItemId));
    }

    private void savePermInfo(UserOrgPermInfo userOrgPermInfo) throws BOSException, EASBizException {
        IUserOrgPerm iUserOrgPerm = UserOrgPermFactory.getRemoteInstance();
        iUserOrgPerm.saveSimplePerm(userOrgPermInfo);
    }

    private void deletePermInfo(String userId, String permIdStr, String orgId) throws BOSException, EASBizException {
        IUserOrgPerm iUserOrgPerm = UserOrgPermFactory.getRemoteInstance();
        iUserOrgPerm.deleteSimplePerm(userId, orgId, permIdStr);
    }
}

