/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.util;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public class InheritFatherUserRoleUtil {
    private static Logger logger = Logger.getLogger(InheritFatherUserRoleUtil.class);

    public static void showInheritFatherUserAndRole(IObjectPK orgPK) throws Exception {
        if (!InheritFatherUserRoleUtil.needInheritParentUserAndRole()) {
            return;
        }
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo(orgPK);
        if (!OrgCommonUtils.isCanBeDefOrg((FullOrgUnitInfo)orgInfo)) {
            return;
        }
        String uiName = "com.kingdee.eas.base.permission.client.OrgInheritFatherUserRoleUI";
        if (InheritFatherUserRoleUtil.getParentOrgInfo(orgPK) != null) {
            UIContext uiContext = new UIContext();
            uiContext.put((Object)"orgId", (Object)orgPK);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
    }

    private static FullOrgUnitInfo getParentOrgInfo(IObjectPK orgPK) throws Exception {
        return FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo(orgPK).getParent();
    }

    public static void changeSubOrgsRole(IObjectPK userPK, IObjectPK orgPK, Collection addedRoleCol, Collection deletedRoleCol, Collection addedGrantRoleCol, Collection deletedGrantRoleCol) throws Exception {
        if (!InheritFatherUserRoleUtil.needInheritParentUserAndRole()) {
            return;
        }
        String uiName = "com.kingdee.eas.base.permission.client.SubOrgUI";
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"USERPK", (Object)userPK);
        uiContext.put((Object)"ORGPK", (Object)orgPK);
        uiContext.put((Object)"ADDEDROLECOL", (Object)addedRoleCol);
        uiContext.put((Object)"DELETEDROLECOL", (Object)deletedRoleCol);
        uiContext.put((Object)"ADDEDGRANTROLECOL", (Object)addedGrantRoleCol);
        uiContext.put((Object)"DELETEDGRANTROLECOL", (Object)deletedGrantRoleCol);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    public static boolean needInheritParentUserAndRole() {
        try {
            String needInherit = ParamManager.getParamValue(null, null, (String)"IsOrgInheritFatherUserAndRole");
            if (needInherit != null && "true".equalsIgnoreCase(needInherit)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"needInheritParentUserAndRole", (Throwable)e);
        }
        return false;
    }

    public static void addUserSubOrgRole(Object[] users, IObjectPK rolePK, IObjectPK orgPK) throws Exception {
        if (!InheritFatherUserRoleUtil.needInheritParentUserAndRole()) {
            return;
        }
        String uiName = "com.kingdee.eas.base.permission.client.UserSubOrgUI";
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"USERS", (Object)users);
        uiContext.put((Object)"ORGPK", (Object)orgPK);
        uiContext.put((Object)"ROLEPK", (Object)rolePK);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    public static void addUserSubOrgRole(Object[] users, IObjectPK rolePK, IObjectPK orgPK, String permChangeId) throws Exception {
        if (!InheritFatherUserRoleUtil.needInheritParentUserAndRole()) {
            return;
        }
        String uiName = "com.kingdee.eas.base.permission.client.UserSubOrgUI";
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"USERS", (Object)users);
        uiContext.put((Object)"ORGPK", (Object)orgPK);
        uiContext.put((Object)"ROLEPK", (Object)rolePK);
        uiContext.put((Object)"permChangeId", (Object)permChangeId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    public static void deleteUserSubOrgRole(Map userOrgsMap, IObjectPK rolePK) throws Exception {
        if (!InheritFatherUserRoleUtil.needInheritParentUserAndRole()) {
            return;
        }
        String uiName = "com.kingdee.eas.base.permission.client.DeleteUserSubOrgUI";
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"USER_ORGS_MAP", (Object)userOrgsMap);
        uiContext.put((Object)"ROLEPK", (Object)rolePK);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    public static void deleteUserSubOrgRole(Map userOrgsMap, IObjectPK rolePK, String permChangeId) throws Exception {
        if (!InheritFatherUserRoleUtil.needInheritParentUserAndRole()) {
            return;
        }
        String uiName = "com.kingdee.eas.base.permission.client.DeleteUserSubOrgUI";
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"USER_ORGS_MAP", (Object)userOrgsMap);
        uiContext.put((Object)"ROLEPK", (Object)rolePK);
        uiContext.put((Object)"permChangeId", (Object)permChangeId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }
}

