/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.EnumUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class QueryUtils {
    private static final Logger logger = Logger.getLogger((String)QueryUtils.class.getName());

    public static IQueryExecutor getQueryExecutor(IMetaDataPK queryPK) {
        IQueryExecutor queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExecutor.option().isAutoTranslateEnum = true;
        queryExecutor.option().isAutoTranslateBoolean = true;
        queryExecutor.option().isAutoIgnoreZero = true;
        return queryExecutor;
    }

    public static IRowSet getDataByQuery(IMetaDataPK queryPK, EntityViewInfo entityViewInfo) throws BOSException {
        IQueryExecutor queryExecutor = QueryUtils.getQueryExecutor(queryPK);
        queryExecutor.setObjectView(entityViewInfo);
        return queryExecutor.executeQuery();
    }

    public static DataType getDataType(QueryInfo bizQuery, String field) {
        QueryFieldInfo queryFieldInfo = bizQuery.getUnits().getQueryFields().get(field);
        assert (queryFieldInfo.getPropertyRefs().size() == 1);
        SubEntityInfo subEntityInfo = queryFieldInfo.getPropertyRefs().get(0).getSubEntity();
        String propertyName = (String)queryFieldInfo.getPropertyRefs().get(0).getRefProperty().get("name");
        EntityObjectInfo entity = subEntityInfo.getEntityRef();
        PropertyCollection collection = entity.getInheritedDuplicatedProperties();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            OwnPropertyInfo ownPropertyInfo;
            PropertyInfo propertyInfo = collection.get(i);
            if (!(propertyInfo instanceof OwnPropertyInfo) || !propertyName.equals((ownPropertyInfo = (OwnPropertyInfo)propertyInfo).getName())) continue;
            return ownPropertyInfo.getDataType();
        }
        throw new IllegalArgumentException("propertyName:" + propertyName + " not found in entity:" + entity.getFullName());
    }

    public static Map getDataTypeMap(QueryInfo queryInfo) {
        HashMap<String, DataType> retMap = new HashMap<String, DataType>();
        QueryFieldCollection queryFieldCol = queryInfo.getUnits().getQueryFields();
        block0: for (int queryFieldColIndex = 0; queryFieldColIndex < queryFieldCol.size(); ++queryFieldColIndex) {
            String filedName = queryFieldCol.get(queryFieldColIndex).getName();
            QueryFieldInfo queryFieldInfo = queryInfo.getUnits().getQueryFields().get(filedName);
            SubEntityInfo subEntityInfo = queryFieldInfo.getPropertyRefs().get(0).getSubEntity();
            String propertyName = (String)queryFieldInfo.getPropertyRefs().get(0).getRefProperty().get("name");
            EntityObjectInfo entity = subEntityInfo.getEntityRef();
            PropertyCollection collection = entity.getInheritedDuplicatedProperties();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                OwnPropertyInfo ownPropertyInfo;
                PropertyInfo propertyInfo = collection.get(i);
                if (!(propertyInfo instanceof OwnPropertyInfo) || !propertyName.equals((ownPropertyInfo = (OwnPropertyInfo)propertyInfo).getName())) continue;
                retMap.put(filedName, ownPropertyInfo.getDataType());
                continue block0;
            }
        }
        return retMap;
    }

    public static Map getEntityFieldMap(QueryInfo queryInfo) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        QueryFieldCollection queryFieldCol = queryInfo.getUnits().getQueryFields();
        for (int queryFieldColIndex = 0; queryFieldColIndex < queryFieldCol.size(); ++queryFieldColIndex) {
            String refPropertyName;
            String filedName;
            block3: {
                filedName = queryFieldCol.get(queryFieldColIndex).getName();
                QueryFieldInfo queryFieldInfo = queryInfo.getUnits().getQueryFields().get(filedName);
                PropertyRefInfo propertRefInfo = queryFieldInfo.getPropertyRefs().get(0);
                refPropertyName = queryFieldInfo.getPropertyRefs().get(0).getRefProperty().getName();
                try {
                    if (queryInfo.getMainObject().getName().equals(propertRefInfo.getSubEntity().getName())) break block3;
                    refPropertyName = propertRefInfo.getSubEntity().getName() + "." + refPropertyName;
                }
                catch (BOSException e) {
                    logger.info((Object)"error!", (Throwable)e);
                    continue;
                }
            }
            retMap.put(filedName, refPropertyName);
        }
        return retMap;
    }

    public static String getEnumClassName(QueryInfo bizQuery, String field) {
        QueryFieldInfo queryFieldInfo = bizQuery.getUnits().getQueryFields().get(field);
        assert (queryFieldInfo.getPropertyRefs().size() == 1);
        SubEntityInfo subEntityInfo = queryFieldInfo.getPropertyRefs().get(0).getSubEntity();
        String propertyName = (String)queryFieldInfo.getPropertyRefs().get(0).getRefProperty().get("name");
        EntityObjectInfo entity = subEntityInfo.getEntityRef();
        PropertyCollection collection = entity.getInheritedDuplicatedProperties();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            OwnPropertyInfo ownPropertyInfo;
            PropertyInfo propertyInfo = collection.get(i);
            if (!(propertyInfo instanceof OwnPropertyInfo) || !propertyName.equals((ownPropertyInfo = (OwnPropertyInfo)propertyInfo).getName()) || !DataType.ENUM.equals((Object)ownPropertyInfo.getDataType())) continue;
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            MetaDataPK enumPK = new MetaDataPK(ownPropertyInfo.getMetaDataRef());
            BizEnumInfo bizEnumInfo = loader.getEnum((IMetaDataPK)enumPK);
            return bizEnumInfo.getClassName();
        }
        throw new IllegalArgumentException("propertyName:" + propertyName + " not found in entity:" + entity.getFullName());
    }

    public static Object getEnumValue(QueryInfo queryInfo, String field, Object fieldData) {
        try {
            DataType dataType = QueryUtils.getDataType(queryInfo, field);
            if (DataType.ENUM.equals((Object)dataType) && fieldData != null) {
                Class<?> enumClass = Class.forName(QueryUtils.getEnumClassName(queryInfo, field));
                if (fieldData instanceof String) {
                    fieldData = EnumUtils.getEnum(enumClass, (String)((String)fieldData)).getAlias();
                } else if (fieldData instanceof Integer) {
                    fieldData = EnumUtils.getEnum(enumClass, (int)((Integer)fieldData)).getAlias();
                }
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return fieldData;
    }

    public static Object getEnumValue(String enumClassName, Object fieldData) {
        try {
            if (fieldData != null) {
                Class<?> enumClass = Class.forName(enumClassName);
                if (fieldData instanceof String) {
                    fieldData = EnumUtils.getEnum(enumClass, (String)((String)fieldData)).getAlias();
                } else if (fieldData instanceof Integer) {
                    fieldData = EnumUtils.getEnum(enumClass, (int)((Integer)fieldData)).getAlias();
                }
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return fieldData;
    }
}

