/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.util;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.client.tree.IAccreditTreeBuilder;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import java.util.Enumeration;
import java.util.Set;
import javax.swing.tree.TreePath;

public class TreeOperator {
    private IAccreditTreeBuilder builder = null;

    public void actionAdd(KDTree treeSourcePerm, KDTree treeTargetPerm) throws Exception {
        TreePath[] treePaths = treeSourcePerm.getSelectionPaths();
        if (treePaths != null) {
            int length = treePaths.length;
            KDTreeNode[] treeNodes = new KDTreeNode[length];
            for (int i = 0; i < length; ++i) {
                treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
            }
            Set extendedNodes = this.builder.getExpendedNodes(treeSourcePerm);
            this.builder.addNodes(treeTargetPerm, treeNodes, extendedNodes);
        }
    }

    public void actionAddAll(KDTree treeSourcePerm, KDTree treeTargetPerm) throws Exception {
        Object object = treeSourcePerm.getModel().getRoot();
        if (object != null && object instanceof KDTreeNode) {
            Set extendedNodes = this.builder.getExpendedNodes(treeSourcePerm);
            this.builder.addNodes(treeTargetPerm, new KDTreeNode[]{(KDTreeNode)object}, extendedNodes);
        }
    }

    public void actionDelete(KDTree treeTargetPerm) throws Exception {
        TreePath[] treePaths = treeTargetPerm.getSelectionPaths();
        if (treePaths != null) {
            int length = treePaths.length;
            KDTreeNode[] treeNodes = new KDTreeNode[length];
            for (int i = 0; i < length; ++i) {
                treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
            }
            this.builder.removeNodes(treeTargetPerm, treeNodes);
        }
    }

    public void actionDeleteAll(KDTree treeTargetPerm) throws Exception {
        KDTreeNode object = null;
        object = (KDTreeNode)treeTargetPerm.getModel().getRoot();
        if (object != null) {
            KDTreeNode[] treeNodes = new KDTreeNode[]{object};
            this.builder.removeNodes(treeTargetPerm, treeNodes);
        }
    }

    public TreeOperator(IAccreditTreeBuilder builder) {
        this.builder = builder;
    }

    public static UserOrgPermCollection getUserOrgPermInTree(KDTree treeAuthorizedPerm, IObjectPK targetPK, IObjectPK targetOrgPK, PermType permType) {
        Object object;
        UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)targetPK.toString()));
        FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
        if (targetOrgPK != null) {
            fullOrgUnitInfo.setId(BOSUuid.read((String)targetOrgPK.toString()));
        }
        if ((object = treeAuthorizedPerm.getModel().getRoot()) != null) {
            KDTreeNode rootAuthorization = (KDTreeNode)object;
            Enumeration enumAuthorization = rootAuthorization.breadthFirstEnumeration();
            while (enumAuthorization.hasMoreElements()) {
                KDTreeNode treeNode = (KDTreeNode)enumAuthorization.nextElement();
                UserOrgPermInfo userOrgPermInfo = (UserOrgPermInfo)treeNode.getUserObject();
                if (!userOrgPermInfo.getPermItem().isIsLeaf()) continue;
                userOrgPermInfo.setOwner(userInfo);
                userOrgPermInfo.setPermType(permType);
                userOrgPermInfo.setOrg(fullOrgUnitInfo);
                userOrgPermInfo.setCtrlUnit(ToolUtils.getCurrentCU());
                userOrgPerms.add(userOrgPermInfo);
            }
        }
        return userOrgPerms;
    }
}

