/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.numbersign.imp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.INumberSign;
import com.kingdee.eas.base.permission.NumberSignFactory;
import com.kingdee.eas.base.permission.NumberSignInfo;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.numbersign.BatchSignInfo;
import com.kingdee.eas.base.permission.numbersign.imp.SignBrowerVirutalProxy;
import com.kingdee.eas.base.permission.numbersign.imp.SignParamHelper;
import com.kingdee.eas.base.permission.numbersign.imp.SignProtectData;
import com.kingdee.eas.base.permission.numbersign.imp.SignProtectDataInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;

public class BrowerVirutalSocket {
    Logger logger = Logger.getLogger((String)BrowerVirutalSocket.class.getName());
    private SignBrowerVirutalProxy browser;
    private static String DATA = "browser_data";
    private boolean isRunComplete = false;
    private String retValue = null;
    private String protectedStr = null;
    SignProtectDataInfo protectData = null;
    private String documentId = null;
    private String operatorType = null;
    public static final String OPERATORTYPE_SIGN = "OPERATORTYPE_SIGN";
    public static final String OPERATORTYPE_BATCHSIGN = "OPERATORTYPE_BATCHSIGN";
    public static final String OPERATORTYPE_VERIFY = "OPERATORTYPE_VERIFY";
    public static final String OPERATORTYPE_GETCERT = "OPERATORTYPE_GETCERT";
    public static final String OPERATORTYPE_BATCH_SIGN = "OPERATORTYPE_BATCH_SIGN";
    private String htmlStr = "";
    private String batchSignError = "";
    BASE64Decoder base = new BASE64Decoder();
    private List batchSignInfoList = null;
    private Map batchSignInfoMap = new HashMap();
    private Context ctx = null;

    public BrowerVirutalSocket(Context ctx, String protectedStr, String documentId) {
        this.ctx = ctx;
        this.protectedStr = protectedStr;
        this.documentId = documentId;
        this.browser = new SignBrowerVirutalProxy(ctx, protectedStr, documentId);
    }

    public BrowerVirutalSocket(Context ctx, SignProtectDataInfo protectData, List documentIdList) {
        this.ctx = ctx;
        this.protectData = protectData;
        this.batchSignInfoList = documentIdList;
        this.protectedStr = this.protectData.getBatchSignXmlInfo();
        this.browser = new SignBrowerVirutalProxy(ctx, protectData, documentIdList);
    }

    public byte[] sign() throws Exception {
        this.operatorType = OPERATORTYPE_SIGN;
        this.factSign();
        this.logger.info((Object)("last res is:" + this.retValue));
        try {
            return this.base.decodeBuffer(this.retValue);
        }
        catch (IOException e) {
            this.logger.error((Object)"decode error!", (Throwable)e);
            throw new Exception(e);
        }
    }

    public Map batchSign() throws Exception {
        this.operatorType = OPERATORTYPE_BATCHSIGN;
        this.factBatchSign();
        this.logger.info((Object)("last res is:" + this.retValue));
        return this.batchSignInfoMap;
    }

    public boolean verify() throws Exception {
        this.operatorType = OPERATORTYPE_VERIFY;
        this.factVerify();
        return Boolean.valueOf(this.retValue);
    }

    private void getCertByUsbkey() throws Exception {
        boolean result = this.browser.execute("GetGaCertificate()");
        this.logger.info((Object)("GetGaCertificate()" + result));
        if (!result) {
            this.logger.info((Object)PermissionResUtil.getResource("res_114"));
            return;
        }
        String re = this.browser.getData(DATA);
        this.logger.info((Object)("GetGaCertificate() res:" + re));
        this.retValue = re;
    }

    private void factVerify() throws Exception {
        this.SetFieldXml();
        this.logger.info((Object)("begin. ShowSignature('" + this.documentId + "')"));
        boolean result = this.browser.execute("ShowSignature('" + this.documentId + "')");
        this.logger.info((Object)("result is:" + result));
        if (!result) {
            this.logger.info((Object)PermissionResUtil.getResource("res_115"));
            return;
        }
        this.logger.info((Object)"begin. CheckSignature()");
        result = this.browser.execute("CheckSignature()");
        if (!result) {
            this.logger.info((Object)PermissionResUtil.getResource("res_116"));
            return;
        }
        this.logger.info((Object)PermissionResUtil.getResource("res_117"));
        String res = this.browser.getData(DATA);
        this.logger.info((Object)("check res:" + res));
        this.retValue = res;
    }

    private void SetDocumentID() throws Exception {
        this.logger.info((Object)"begin. SetDocumentID");
        boolean result = this.browser.execute("SetDocumentID('" + this.documentId + "')");
        this.logger.info((Object)("SetDocumentID('" + this.documentId + "') is:" + result));
        if (!result) {
            this.logger.info((Object)(PermissionResUtil.getResource("res_118") + "DocumentID" + PermissionResUtil.getResource("res_119")));
            return;
        }
    }

    private void factSign() throws Exception {
        this.SetFieldXml();
        this.SetDocumentID();
        this.logger.info((Object)"begin. browser.execute(RunSignature())");
        boolean falg = this.browser.execute("RunSignature()");
        this.logger.info((Object)("RunSignature:" + falg));
        if (!falg) {
            this.logger.error((Object)("RunSignature() operator fail! return value is:" + falg));
            throw new IllegalArgumentException("RunSignature fail!");
        }
        String signRes = this.browser.getData(DATA);
        this.logger.info((Object)("RunSignature() res:" + signRes));
        if (!"true".equalsIgnoreCase(signRes)) {
            this.logger.error((Object)("RunSignature() operator fail! return value is:" + signRes));
            throw new IllegalArgumentException("RunSignature fail!");
        }
        this.SetFieldXml();
        this.SetDocumentID();
        boolean result = this.browser.execute("ShowSignature('" + this.documentId + "')");
        this.logger.info((Object)("ShowSignature()" + result));
        if (!result) {
            this.logger.info((Object)PermissionResUtil.getResource("res_115"));
            return;
        }
        result = this.browser.execute("GetSignatureImg()");
        this.logger.info((Object)("GetSignatureImg()" + result));
        if (!result) {
            this.logger.info((Object)PermissionResUtil.getResource("res_120"));
            return;
        }
        String re = this.browser.getData(DATA);
        this.logger.info((Object)("GetSignatureImg() res:" + re));
        this.retValue = re;
    }

    private void factBatchTest() throws Exception {
        boolean falg = false;
        SignProtectData signData = new SignProtectData();
        for (int i = 0; i < this.batchSignInfoList.size(); ++i) {
            BatchSignInfo batchSignInfo = (BatchSignInfo)this.batchSignInfoList.get(i);
            NumberSignInfo signInfo = batchSignInfo.getNumberSignInfo();
            try {
                this.protectedStr = signData.getProtectInfo(null, batchSignInfo.getIVo());
            }
            catch (EASBizException e) {
                this.logger.error((Object)"error!", (Throwable)e);
            }
            catch (BOSException e) {
                this.logger.error((Object)"error!", (Throwable)e);
            }
            this.SetFieldXml();
            this.documentId = signInfo.getId().toString();
            this.SetDocumentID();
            this.logger.info((Object)"begin. browser.execute(RunSignature())");
            falg = this.browser.execute("RunSignature()");
            this.logger.info((Object)("RunSignature:" + falg));
        }
    }

    private void factBatchReal() throws Exception {
        this.logger.info((Object)"!!!!!!!!!!!!! NUMBER_SIGN_ENALBE_BATCH_TEST set false ,it's run factBatchReal");
        boolean falg = false;
        this.logger.info((Object)"begin. browser.execute(RunBatchSignature())");
        falg = this.browser.execute("RunBatchSignature(\"" + this.protectedStr + "\")");
        this.logger.info((Object)("RunBatchSignature:" + falg));
        if (!falg) {
            this.batchSignError = this.browser.getData(DATA);
            this.logger.error((Object)(PermissionResUtil.getResource("res_121") + "ID" + PermissionResUtil.getResource("res_122") + this.batchSignError));
            return;
        }
        String signRes = this.browser.getData(DATA);
        if (!"true".equalsIgnoreCase(signRes)) {
            this.logger.error((Object)("RunBatchSignature() factBatchReal fail! return value is:" + signRes));
            throw new IllegalArgumentException("RunSignature fail!");
        }
    }

    private void factBatchSign() throws Exception {
        SignParamHelper signParam = new SignParamHelper(null);
        if (signParam.isTrue4Param("NUMBER_SIGN_ENALBE_BATCH_TEST")) {
            this.logger.warn((Object)"!!!!!!!!!!!!! NUMBER_SIGN_ENALBE_BATCH_TEST set true ,it's very dangerous!!!!!!!!!!! ");
            this.factBatchTest();
        } else {
            this.factBatchReal();
        }
        if (!StringUtils.isEmpty((String)this.batchSignError)) {
            this.logger.error((Object)"batch sign occur error,cancel this batch sign");
            return;
        }
        for (int i = 0; i < this.batchSignInfoList.size(); ++i) {
            BatchSignInfo batchSignInfo = (BatchSignInfo)this.batchSignInfoList.get(i);
            NumberSignInfo signInfo = batchSignInfo.getNumberSignInfo();
            String docId = signInfo.getId().toString();
            this.SetFieldXml(this.protectData.getSignProtectedData(docId));
            boolean result = this.browser.execute("ShowSignature('" + docId + "')");
            this.logger.info((Object)("ShowSignature()" + result));
            if (!result) {
                this.logger.info((Object)PermissionResUtil.getResource("res_115"));
                return;
            }
            result = this.browser.execute("GetSignatureImg()");
            this.logger.info((Object)("GetSignatureImg()" + result));
            if (!result) {
                this.logger.info((Object)PermissionResUtil.getResource("res_120"));
                return;
            }
            String re = this.browser.getData(DATA);
            this.logger.info((Object)("GetSignatureImg() res:" + re));
            byte[] imageInfoByte = null;
            try {
                imageInfoByte = this.base.decodeBuffer(re);
            }
            catch (IOException e) {
                this.logger.error((Object)"error!", (Throwable)e);
            }
            if (imageInfoByte == null) {
                this.logger.error((Object)"imageInfoByte info not get,may run again!!!");
            }
            if (this.batchSignInfoMap == null) {
                this.batchSignInfoMap = new HashMap();
            }
            this.batchSignInfoMap.put(docId, imageInfoByte);
        }
    }

    private String getHtmlStr() {
        if (StringUtils.isEmpty((String)this.htmlStr)) {
            this.htmlStr = this.createHtml();
        }
        return this.htmlStr;
    }

    private String createHtml() {
        this.logger.info((Object)"........ begin read file from server");
        try {
            INumberSign iNumberSign = NumberSignFactory.getRemoteInstance();
            String retStr = iNumberSign.getHtmlStr();
            if (StringUtils.isEmpty((String)retStr)) {
                this.logger.error((Object)"retStr is null");
                return null;
            }
            return retStr;
        }
        catch (Exception e) {
            this.logger.error((Object)"readfile erro!", (Throwable)e);
            this.logger.info((Object)"........ begin read file over!!!");
            return null;
        }
    }

    public String getCertStr() throws Exception {
        this.operatorType = OPERATORTYPE_GETCERT;
        this.getCertByUsbkey();
        this.logger.info((Object)("last res is:" + this.retValue));
        return this.retValue;
    }

    private void SetFieldXml() throws Exception {
        this.SetFieldXml(this.protectedStr);
    }

    private void SetFieldXml(String singleProtectedData) throws Exception {
        String setFieldXml = "SetFieldXml(\"" + singleProtectedData + "\")";
        this.logger.info((Object)"begin. SetFieldXml");
        boolean result = this.browser.execute(setFieldXml);
        this.logger.info((Object)("result is:" + result + " : setFieldXml is :" + setFieldXml));
        if (!result) {
            this.logger.info((Object)(PermissionResUtil.getResource("res_123") + "XML" + PermissionResUtil.getResource("res_124")));
            return;
        }
    }
}

