/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.service.helper.usbkeyimpl;

import com.kingdee.eas.base.permission.UsbKeyException;
import com.kingdee.eas.base.permission.service.helper.IUsbKeyControl;
import ikeycom.CoiKey;
import ikeycom.ComFailException;
import ikeycom.IiKey;
import ikeycom.SFileInfo;
import org.apache.log4j.Logger;

public class UsbKeyOperatorImpl
implements IUsbKeyControl {
    private static Logger logger;
    private static int WRITE_FILEID;
    IiKey iKey = null;

    @Override
    public void write(String contentStr) throws UsbKeyException {
        try {
            this.init();
            byte[] content = contentStr.getBytes();
            int fileSize = content.length;
            this.ensureFileExist(fileSize);
            SFileInfo fi = new SFileInfo();
            this.iKey.OpenDevice(1, null);
            this.iKey.OpenFile(16, WRITE_FILEID, fi);
            int[] pBytesRead = new int[content.length];
            this.iKey.Write(0, 0, content, fileSize, pBytesRead);
            logger.info((Object)("write str right over! str is:" + contentStr));
        }
        catch (ComFailException ue) {
            logger.error((Object)"ComFailException error!", (Throwable)ue);
            throw new UsbKeyException(UsbKeyException.USB_WRITE_ERROR);
        }
        finally {
            if (this.iKey != null) {
                this.iKey.CloseDevice();
            }
        }
    }

    private void ensureFileExist(int fileSize) throws UsbKeyException {
        try {
            this.iKey.OpenDevice(1, null);
            try {
                this.iKey.DeleteFile(0, WRITE_FILEID);
            }
            catch (ComFailException e) {
                logger.error((Object)"del file error !", (Throwable)e);
            }
            try {
                SFileInfo fi = new SFileInfo();
                fi.lId = WRITE_FILEID;
                fi.lFlags = 0;
                fi.lFileSize = fileSize + 10;
                fi.chFileType = (byte)2;
                fi.chReadAccess = 0;
                fi.chWriteAccess = 0;
                fi.chCryptAccess = 0;
                this.iKey.CreateFile(0, fi);
            }
            catch (ComFailException e) {
                logger.error((Object)"create file error!", (Throwable)e);
                throw new UsbKeyException(UsbKeyException.USB_WRITE_ERROR);
            }
        }
        catch (ComFailException ue) {
            logger.error((Object)"ensureFileExist error!", (Throwable)ue);
            throw new UsbKeyException(UsbKeyException.USB_INIT_ERROR);
        }
        finally {
            if (this.iKey != null) {
                this.iKey.CloseDevice();
            }
        }
    }

    private void init() throws UsbKeyException {
        try {
            this.iKey = new CoiKey();
            this.iKey.CreateContext(0, 512);
            logger.info((Object)"CreateContext succeeded\n");
        }
        catch (Throwable e) {
            logger.error((Object)"init error!please install driver!", e);
            throw new UsbKeyException(UsbKeyException.USB_INIT_ERROR);
        }
    }

    @Override
    public String read(int length) throws UsbKeyException {
        try {
            this.init();
            this.iKey.OpenDevice(1, null);
            logger.info((Object)"OpenDevice succeeded, found first iKey\n");
            SFileInfo fi = new SFileInfo();
            this.iKey.OpenFile(16, WRITE_FILEID, fi);
            byte[] buffer = new byte[length];
            int[] factSize = new int[length];
            this.iKey.Read(0, 0, buffer, length, factSize);
            String string = new String(buffer);
            return string;
        }
        catch (ComFailException ue) {
            logger.error((Object)"ComFailException fail!", (Throwable)ue);
            throw new UsbKeyException(UsbKeyException.USB_INIT_ERROR);
        }
        finally {
            if (this.iKey != null) {
                this.iKey.CloseDevice();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        UsbKeyOperatorImpl usbKeyProxy = new UsbKeyOperatorImpl();
        String testStr = "wangdch";
        try {
            usbKeyProxy.write(testStr);
            String targetStr = usbKeyProxy.read(testStr.length());
            if (!testStr.equals(targetStr)) return;
        }
        catch (UsbKeyException usbKeyException) {
            // empty catch block
        }
    }

    static {
        WRITE_FILEID = 8;
        logger = Logger.getLogger((String)UsbKeyOperatorImpl.class.getName());
    }
}

