/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.eas.base.permission.util.ITreeFilterComp;
import com.kingdee.eas.base.permission.util.ITreeFilterExt;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import java.util.Enumeration;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;

public class TreeFilter {
    private Logger logger = Logger.getLogger(TreeFilter.class);
    private Set holdSet = null;
    private boolean sameHold;
    private ITreeFilterComp filterComp = null;
    private ITreeFilterExt iTreeFilterExt = null;
    private KDTree tree = null;
    private int index = 0;

    public TreeFilter(Set holdSet, boolean sameHold, ITreeFilterComp filterComp) {
        this.holdSet = holdSet;
        this.sameHold = sameHold;
        this.filterComp = filterComp;
    }

    public void filterTree(KDTree tree) {
        if (tree == null) {
            return;
        }
        this.tree = tree;
        this.filterNode((KDTreeNode)tree.getModel().getRoot());
    }

    private void filterNode(KDTreeNode root) {
        KDTreeNode treeNode;
        ++this.index;
        if (root != null && root.children() != null) {
            Enumeration enu = root.children();
            while (enu.hasMoreElements()) {
                KDTreeNode oldNode = (KDTreeNode)enu.nextElement();
                this.filterNode(oldNode);
            }
        }
        if (root.getParent() != null && root.isLeaf() && (this.mayDel(root) || !this.filterComp.isLeaf(root.getUserObject())) && (treeNode = (KDTreeNode)root.getParent()) != null) {
            this.tree.removeNodeFromParent((MutableTreeNode)root);
            this.filterNode(treeNode);
        }
    }

    private boolean mayDel(KDTreeNode root) {
        String keyStr = this.filterComp.getKeyString(root.getUserObject());
        if (this.iTreeFilterExt != null) {
            keyStr = this.iTreeFilterExt.getKeyString(root.getUserObject(), keyStr);
        }
        if (this.sameHold) {
            return !this.holdSet.contains(keyStr);
        }
        return this.holdSet.contains(keyStr);
    }

    public ITreeFilterExt getITreeFilterExt() {
        return this.iTreeFilterExt;
    }

    public void setITreeFilterExt(ITreeFilterExt treeFilterExt) {
        this.iTreeFilterExt = treeFilterExt;
    }
}

