/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.cloud;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.permission.CloudUserFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.apache.log4j.Logger;

public class EasCloud {
    private static Logger logger = Logger.getLogger(EasCloud.class);
    private static final String ENCODE = "utf-8";
    public static final String CALLBACK_URL = "kderp/page/callback";
    private static String CLOUD_URL = null;
    private static String BINDQUERY_URL = null;
    private static String BINDINGPAGE_URL = null;
    private static String ACCESSTOKEN_URL = null;
    private static String CLIENT_ID = null;
    private static String CLIENT_SECRET = null;
    private static String ACTIVECODE_URL = null;
    private static String VERIFYCODE_URL = null;
    private static String LICENSE_URL = null;

    private static void initConfig() throws BOSException, EASBizException {
        Map config = (Map)CloudUserFacadeFactory.getRemoteInstance().getConfig();
        CLOUD_URL = (String)config.get("cloud.server.url");
        CLIENT_ID = (String)config.get("cloud.client.id");
        CLIENT_SECRET = (String)config.get("cloud.client.secret");
        BINDQUERY_URL = CLOUD_URL + "/kderp/binding";
        BINDINGPAGE_URL = CLOUD_URL + "/kderp/binding/page";
        ACCESSTOKEN_URL = CLOUD_URL + "/kderp/access_token";
        ACTIVECODE_URL = CLOUD_URL + "/clouderp/account/vcode";
        VERIFYCODE_URL = CLOUD_URL + "/clouderp/account/vcode/verifying";
        LICENSE_URL = CLOUD_URL + "/kdproduct/prod_instance/licence/download";
    }

    public static void main(String[] args) {
        String prod_inst_code = "1433496679bdb1ff08c4ef043bdd8f3e";
        try {
            File file = File.createTempFile(System.currentTimeMillis() + "", ".zip");
            System.out.println("path=" + file.getPath());
            EasCloud.downloadLicense(prod_inst_code, file.getPath());
            System.out.println("******download over***");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONObject getActiveCode(String uid, String prod_inst_code, String phone) throws Exception {
        long timestamp = System.currentTimeMillis();
        StringBuffer sha1Param = new StringBuffer();
        sha1Param.append(CLIENT_ID);
        sha1Param.append(CLIENT_SECRET);
        sha1Param.append(uid);
        sha1Param.append(prod_inst_code);
        sha1Param.append(phone);
        sha1Param.append(timestamp);
        String signiture = EasCloud.sha1(sha1Param.toString());
        StringBuffer paramSB = new StringBuffer();
        paramSB.append("client_id=" + CLIENT_ID);
        paramSB.append("&uid=" + uid);
        paramSB.append("&prod_inst_code=" + prod_inst_code);
        paramSB.append("&phone=" + phone);
        paramSB.append("&timestamp=" + timestamp);
        paramSB.append("&signiture=" + signiture);
        return EasCloud.doGet(ACTIVECODE_URL, paramSB.toString());
    }

    public static JSONObject verifyCode(String uid, String prod_inst_code, String phone, String vcode) throws Exception {
        long timestamp = System.currentTimeMillis();
        StringBuffer sha1Param = new StringBuffer();
        sha1Param.append(CLIENT_ID);
        sha1Param.append(CLIENT_SECRET);
        sha1Param.append(uid);
        sha1Param.append(prod_inst_code);
        sha1Param.append(phone);
        sha1Param.append(vcode);
        sha1Param.append(timestamp);
        String signiture = EasCloud.sha1(sha1Param.toString());
        StringBuffer paramSB = new StringBuffer();
        paramSB.append("client_id=" + CLIENT_ID);
        paramSB.append("&uid=" + uid);
        paramSB.append("&prod_inst_code=" + prod_inst_code);
        paramSB.append("&phone=" + phone);
        paramSB.append("&vcode=" + vcode);
        paramSB.append("&timestamp=" + timestamp);
        paramSB.append("&signiture=" + signiture);
        return EasCloud.doGet(VERIFYCODE_URL, paramSB.toString());
    }

    public static JSONObject bindQuery(String userId, String userNumber, String product_code, String software_code) throws Exception {
        try {
            String param = EasCloud.string2Param(userId, userNumber, product_code, software_code);
            return EasCloud.doGet(BINDQUERY_URL, param);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
    }

    public static String bindingPage(String userId, String userNumber, String product_code, String software_code) throws Exception {
        String param = EasCloud.string2Param(userId, userNumber, product_code, software_code);
        return BINDINGPAGE_URL + "?" + param;
    }

    public static JSONObject accessToken(String userId, String userNumber, String product_code, String software_code) throws Exception {
        try {
            String param = EasCloud.string2Param(userId, userNumber, product_code, software_code);
            return EasCloud.doGet(ACCESSTOKEN_URL, param);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
    }

    private static String string2Param(String userId, String userNumber, String product_code, String software_code) throws Exception {
        long timestamp = System.currentTimeMillis();
        StringBuffer sha1Param = new StringBuffer();
        sha1Param.append(CLIENT_ID);
        sha1Param.append(CLIENT_SECRET);
        sha1Param.append(userId);
        sha1Param.append(userNumber);
        if (product_code != null) {
            sha1Param.append(product_code);
        }
        sha1Param.append(software_code);
        sha1Param.append(timestamp);
        String signiture = EasCloud.sha1(sha1Param.toString());
        StringBuffer paramSB = new StringBuffer();
        paramSB.append("client_id=" + CLIENT_ID);
        paramSB.append("&euid=" + URLEncoder.encode(userId, ENCODE));
        paramSB.append("&ename=" + URLEncoder.encode(userNumber, ENCODE));
        if (product_code != null) {
            paramSB.append("&product_code=" + URLEncoder.encode(product_code, ENCODE));
        }
        paramSB.append("&software_code=" + URLEncoder.encode(software_code, ENCODE));
        paramSB.append("&timestamp=" + timestamp);
        paramSB.append("&signiture=" + signiture);
        return paramSB.toString();
    }

    public static void downloadLicense(String prod_inst_code, String filePath) throws Exception {
        String url = LICENSE_URL + "?is_zip=1&prod_inst_code=" + prod_inst_code + "&client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET;
        EasCloud.downloadFile(url, filePath);
    }

    private static void downloadFile(String url, String filePath) throws Exception {
        FileOutputStream out = null;
        InputStream in = null;
        HttpURLConnection conn = null;
        try {
            out = new FileOutputStream(filePath);
            logger.debug((Object)("download license url: " + url));
            URL realUrl = new URL(url);
            conn = (HttpURLConnection)realUrl.openConnection();
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3600000);
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("Accept-Charset", ENCODE);
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.connect();
            in = conn.getInputStream();
            if (conn.getContentType().indexOf("text") > -1) {
                throw new Exception("download fail");
            }
            byte[] b = new byte[8096];
            int i = 0;
            while ((i = in.read(b)) != -1) {
                ((OutputStream)out).write(b, 0, i);
                out.flush();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (conn != null) {
                    conn.disconnect();
                }
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private static JSONObject doGet(String url, String param) throws Exception {
        StringBuffer result = new StringBuffer();
        BufferedReader in = null;
        HttpURLConnection conn = null;
        try {
            String line;
            String urlName = url + "?" + param;
            URL realUrl = new URL(urlName);
            conn = (HttpURLConnection)realUrl.openConnection();
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(60000);
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("Accept-Charset", ENCODE);
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.connect();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), ENCODE));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
        finally {
            try {
                if (conn != null) {
                    conn.disconnect();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return JSONObject.parseObject((String)new String(result.toString().getBytes(ENCODE), ENCODE));
    }

    private static JSONObject doPost(String url, String jsonBody) throws Exception {
        FilterOutputStream ds = null;
        InputStream in = null;
        BufferedReader reader = null;
        try {
            URL sendUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)sendUrl.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("Charsert", "UTF-8");
            conn.setRequestProperty("content-type", "application/x-www-form-urlencoded");
            conn.setInstanceFollowRedirects(false);
            conn.connect();
            ds = new DataOutputStream(conn.getOutputStream());
            String content = "";
            JSONObject jsonObject = JSONObject.parseObject((String)jsonBody);
            for (Map.Entry entry : jsonObject.entrySet()) {
                content = content + (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8") + "&";
            }
            content = content + "1=1";
            ((DataOutputStream)ds).writeBytes(content);
            ((DataOutputStream)ds).flush();
            ds.close();
            in = conn.getInputStream();
            StringBuffer sb = new StringBuffer();
            reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            conn.disconnect();
            JSONObject jSONObject = JSONObject.parseObject((String)new String(sb.toString().getBytes("UTF-8"), "UTF-8"));
            return jSONObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (ds != null) {
                try {
                    ds.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String sha1(String data) throws Exception {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(data.getBytes(ENCODE));
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e);
            throw e;
        }
    }

    static {
        try {
            EasCloud.initConfig();
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

