/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.cloud.activiation;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ICloudRegistSrv;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.service.IValidateCommunicationService;
import com.kingdee.eas.base.permission.service.ValidateCommunicationFactory;
import com.kingdee.eas.base.permission.service.comstrategy.CommunicationInfo;
import com.kingdee.eas.base.permission.util.cloud.SynShrUserToCloudUtils;
import com.kingdee.eas.base.uiframe.EasCloud;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class UserNoActiviationHelper {
    private static final Logger logger = Logger.getLogger(UserNoActiviationHelper.class);

    private static ICloudRegistSrv getCloudRegistSrv(Context ctx) throws LicenseException {
        ICloudRegistSrv iCloudRegistSrv = null;
        iCloudRegistSrv = ctx == null ? CloudRegistSrvAgentFactory.getRemoteInstance() : CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx);
        return iCloudRegistSrv;
    }

    public static List<String> getNoActiviationUsersIgnoreCase(Context ctx) {
        List<String> noActiviationUsers = UserNoActiviationHelper.getNoActiviationUsers(ctx);
        return UserNoActiviationHelper.toLowerCase(noActiviationUsers);
    }

    public static List<String> getNoActiviationUsers(Context ctx) {
        ArrayList<String> list = new ArrayList<String>();
        ICloudRegistSrv iCloudRegistSrv = null;
        try {
            iCloudRegistSrv = UserNoActiviationHelper.getCloudRegistSrv(ctx);
            return iCloudRegistSrv.getNoActivationUsers();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return list;
        }
    }

    public static List<String> getCloudNoActiviationUsers(Context ctx) {
        ArrayList<String> list = new ArrayList<String>();
        ICloudRegistSrv iCloudRegistSrv = null;
        try {
            iCloudRegistSrv = UserNoActiviationHelper.getCloudRegistSrv(ctx);
            return iCloudRegistSrv.getCloudNoActivationUsers();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return list;
        }
    }

    public static List<String> getCloudUnNoActiviationUsers(Context ctx) {
        ArrayList<String> list = new ArrayList<String>();
        ICloudRegistSrv iCloudRegistSrv = null;
        try {
            iCloudRegistSrv = UserNoActiviationHelper.getCloudRegistSrv(ctx);
            return iCloudRegistSrv.getCloudUnNoActivationUsers();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return list;
        }
    }

    public static List<String> getNotCanAddNoActiviationUsers(Context ctx) {
        List<String> list = new ArrayList<String>();
        list.addAll(UserNoActiviationHelper.getNoActiviationUsers(ctx));
        list.addAll(UserNoActiviationHelper.getCloudUnNoActiviationUsers(ctx));
        list = UserNoActiviationHelper.toLowerCase(list);
        return list;
    }

    public static List<String> getNotValidNoActiviationUsers(Context ctx) {
        ArrayList<String> list = new ArrayList<String>();
        ICloudRegistSrv iCloudRegistSrv = null;
        try {
            iCloudRegistSrv = UserNoActiviationHelper.getCloudRegistSrv(ctx);
            List noActivationUsers = iCloudRegistSrv.getNoActivationUsers();
            List cloudNoActivationUsers = iCloudRegistSrv.getCloudNoActivationUsers();
            noActivationUsers.removeAll(cloudNoActivationUsers);
            return noActivationUsers;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return list;
        }
    }

    public static void addNoActivedErpUser(Context ctx, String[] erpNumbers) throws BOSException {
        ICloudRegistSrv iCloudRegistSrv = null;
        try {
            iCloudRegistSrv = UserNoActiviationHelper.getCloudRegistSrv(ctx);
        }
        catch (LicenseException e) {
            throw new BOSException((Throwable)e);
        }
        iCloudRegistSrv.addNoActivedErpUser(UserNoActiviationHelper.toLowerCase(erpNumbers));
    }

    public static void tryAutoAddNoActivedErpUser(Context ctx, String erpNumber) {
        try {
            if (UserNoActiviationHelper.isAutoAddNoActivedErpUser(ctx)) {
                UserNoActiviationHelper.addNoActivedErpUser(ctx, new String[]{erpNumber});
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static boolean isAutoAddNoActivedErpUser(Context ctx) {
        try {
            String isAutoAddNoActivedErpUser = ParamManager.getParamValue((Context)ctx, null, (String)"NewUserAutoToPreventActivate");
            return "true".equals(isAutoAddNoActivedErpUser);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
    }

    public static void removeNoActivedErpUser(Context ctx, String[] erpNumbers) throws BOSException {
        ICloudRegistSrv iCloudRegistSrv = null;
        try {
            iCloudRegistSrv = UserNoActiviationHelper.getCloudRegistSrv(ctx);
        }
        catch (LicenseException e) {
            throw new BOSException((Throwable)e);
        }
        iCloudRegistSrv.removeNoActivedErpUser(UserNoActiviationHelper.toLowerCase(erpNumbers));
    }

    public static boolean isSupportNoActiviation(Context ctx) throws BOSException {
        CommunicationInfo cloudCommunicationStategy = SynShrUserToCloudUtils.getCommunicationInfo(ctx);
        return cloudCommunicationStategy.getExc_limit() > 0;
    }

    public static CommunicationInfo getCloudCommunicationStategy(Context ctx) throws BOSException {
        return SynShrUserToCloudUtils.getCommunicationInfo(ctx);
    }

    public static void doCloudCommunicationStategy(Context ctx) {
        try {
            ILicenseSrvAgent agent = null;
            IValidateCommunicationService iValidateCommunicationService = null;
            if (ctx == null) {
                agent = LicenseSrvAgentFactory.getRemoteInstance();
                iValidateCommunicationService = ValidateCommunicationFactory.getRemoteInstance();
            } else {
                agent = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
                iValidateCommunicationService = ValidateCommunicationFactory.getLocalInstance(ctx);
            }
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            String prod_inst_code = baseInfo.getProductInstanceID();
            JSONObject o = EasCloud.getComnnicationStrategy((String)prod_inst_code);
            if (o != null) {
                if (o.getInteger("errcode") == 0) {
                    JSONObject data = JSONObject.parseObject((String)o.getString("data"));
                    CommunicationInfo info = new CommunicationInfo();
                    info.setNeedEmail(data.getInteger("need_email"));
                    info.setNeedPhone(data.getInteger("need_phone"));
                    info.setExc_count(data.getInteger("exc_count"));
                    info.setExc_limit(data.getInteger("exc_limit"));
                    info.setCountry_id(data.getInteger("country_id") == null ? 0 : data.getInteger("country_id"));
                    info.setEname(data.getString("ename"));
                    iValidateCommunicationService.doCloudCommunicationStategy(info);
                } else {
                    logger.error((Object)o.getString("description"));
                }
            }
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            return;
        }
    }

    private static String[] toLowerCase(String[] erpNumbers) {
        String[] lowerCaseErpNumbers = new String[erpNumbers.length];
        for (int i = 0; i < erpNumbers.length; ++i) {
            lowerCaseErpNumbers[i] = erpNumbers[i].toLowerCase();
        }
        return lowerCaseErpNumbers;
    }

    private static List<String> toLowerCase(List<String> erpNumbers) {
        ArrayList<String> erpNumbersList = new ArrayList<String>();
        for (int i = 0; i < erpNumbers.size(); ++i) {
            erpNumbersList.add(erpNumbers.get(i).toLowerCase());
        }
        return erpNumbersList;
    }
}

