/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.xt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.util.xt.PrepareBizData;
import com.kingdee.eas.base.permission.util.xt.RSAUtils;
import com.kingdee.eas.base.permission.util.xt.XunTongSynUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.security.Key;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;

public class SynchManager {
    private static Key key = null;
    private static String mid = null;
    private static String sn = null;
    private static String dataCenter = null;
    private static int queryCount = 1000;
    private static String rootUrl = "http://do.kdweibo.com";
    private HashMap<String, HashMap<String, String>> adminMap = new HashMap();
    private HashMap<String, String> fullPathMap = new HashMap();
    private Context ctx = null;
    Logger logger = Logger.getLogger(SynchManager.class);

    public SynchManager() {
    }

    public SynchManager(Context ctx) {
        this.ctx = ctx;
        this.logger.error((Object)("SynchManager==" + ctx));
    }

    public void loginMCloud() throws BOSException {
        String data = null;
        try {
            data = RSAUtils.encryptString(mid, key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String url = rootUrl + "/openadmin/ums/erplogin.do?eid=" + mid + "&sn=" + sn + "&token=" + data;
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"chrome,firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void synchData() throws BOSException {
        this.init();
        this.logger.error((Object)("mid==" + mid));
        Timestamp lastUpdateTime = XunTongSynUtils.getLastUpdateTime(this.ctx);
        this.logger.error((Object)("lastUpdateTime==" + lastUpdateTime));
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        this.adminMap = PrepareBizData.prepareAdminMap(this.ctx);
        boolean isSuccess = true;
        boolean isPostSuccess = false;
        isPostSuccess = this.processOrg(lastUpdateTime);
        if (!isPostSuccess) {
            isSuccess = false;
        }
        if (!(isPostSuccess = this.processPerson(lastUpdateTime))) {
            isSuccess = false;
        }
        if (isSuccess) {
            XunTongSynUtils.saveLastUpdateTime(this.ctx, currentTime);
        }
    }

    public void mappingData() throws BOSException {
        this.init();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("type", new Integer(0));
        this.getImportData("person/getall", param, 0, queryCount);
    }

    private boolean processOrg(Timestamp lastUpdateTime) throws BOSException {
        HashMap param = new HashMap();
        try {
            Class<?> facadeClass = Class.forName("com.kingdee.shr.base.syssetting.IMSFServiceFacade");
            IBOSObject bosObject = this.getOSFBosObject(facadeClass);
            Method method = facadeClass.getMethod("processService", String.class, Map.class);
            Object object = method.invoke((Object)bosObject, "integrationInitOrg", param);
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)"integrationInitOrg_ClassNotFoundException");
            e.printStackTrace();
        }
        catch (SecurityException e) {
            this.logger.error((Object)"integrationInitOrg_SecurityException");
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            this.logger.error((Object)"integrationInitOrg_NoSuchMethodException");
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            this.logger.error((Object)"integrationInitOrg_IllegalArgumentException");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            this.logger.error((Object)"integrationInitOrg_IllegalAccessException");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            this.logger.error((Object)"integrationInitOrg_InvocationTargetException");
            e.printStackTrace();
        }
        List addOrgList = null;
        List deleteOrg = null;
        this.logger.error((Object)("lastUpdateTime=" + lastUpdateTime));
        Map<String, Object> orgIdMap = PrepareBizData.prepareOrgIds(this.ctx, lastUpdateTime);
        addOrgList = (List)orgIdMap.get("addnew");
        ArrayList updateOrgList = (ArrayList)orgIdMap.get("update");
        deleteOrg = (List)orgIdMap.get("delete");
        boolean isSuccess = true;
        boolean isPostSuccess = false;
        this.logger.error((Object)("addOrgList==" + addOrgList));
        if (addOrgList != null && addOrgList.size() > 0) {
            isPostSuccess = this.postImportData(addOrgList, "dept/add", "departments", null);
            if (!isPostSuccess) {
                isSuccess = false;
            }
            addOrgList = null;
        }
        this.logger.error((Object)("updateOrgList==" + updateOrgList));
        if (updateOrgList != null && updateOrgList.size() > 0) {
            isPostSuccess = this.postImportData(updateOrgList, "dept/update", "departments", null);
            if (!isPostSuccess) {
                isSuccess = false;
            }
            updateOrgList = null;
        }
        this.logger.error((Object)("deleteOrg==" + deleteOrg));
        if (deleteOrg != null && deleteOrg.size() > 0) {
            isPostSuccess = this.postImportData(deleteOrg, "dept/delete", "departments", null);
            if (!isPostSuccess) {
                isSuccess = false;
            }
            deleteOrg = null;
        }
        return isSuccess;
    }

    private IBOSObject getOSFBosObject(Class facadeClass) throws BOSException {
        IBOSObject bosObject = null;
        bosObject = this.ctx != null ? BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)new BOSObjectType("95925689")) : BOSObjectFactory.createRemoteBOSObject((BOSObjectType)new BOSObjectType("95925689"), (Class)facadeClass);
        return bosObject;
    }

    private boolean processPerson(Timestamp lastUpdateTime) throws BOSException {
        Map each;
        List<Map<String, Object>> addPerList = null;
        List<Map<Object, Object>> updatePerList = new ArrayList<Map>();
        List deleteEmp = null;
        Set<String> addNewEmp = null;
        if (lastUpdateTime == null) {
            addNewEmp = new HashSet<String>();
            addPerList = PrepareBizData.getPersonList(this.ctx, addNewEmp, this.adminMap, this.fullPathMap);
        } else {
            Map<String, Object> perIdMap = PrepareBizData.preparePersonIDs(this.ctx, lastUpdateTime);
            addNewEmp = (Set)perIdMap.get("addnew");
            this.logger.error((Object)("addNewEmp==" + addNewEmp));
            deleteEmp = (List)perIdMap.get("delete");
            this.logger.error((Object)("deleteEmp==" + deleteEmp));
            Set updateEmp = (Set)perIdMap.get("update");
            this.logger.error((Object)("updateEmp==" + updateEmp));
            if (addNewEmp != null && addNewEmp.size() > 0) {
                addPerList = PrepareBizData.getPersonList(this.ctx, addNewEmp, this.adminMap, this.fullPathMap);
            }
            if (updateEmp != null && updateEmp.size() > 0) {
                updatePerList = PrepareBizData.getPersonList(this.ctx, updateEmp, this.adminMap, this.fullPathMap);
            }
        }
        if (addPerList != null && addPerList.size() > 0) {
            for (int i = addPerList.size() - 1; i >= 0; --i) {
                each = addPerList.get(i);
                if (each.get("openId") != null && !StringUtils.isEmpty((String)each.get("openId").toString())) {
                    updatePerList.add(each);
                    addPerList.remove(i);
                    continue;
                }
                each.remove("openId");
            }
        }
        if (updatePerList != null && updatePerList.size() > 0) {
            for (int i = 0; i < updatePerList.size(); ++i) {
                each = (Map)updatePerList.get(i);
                each.remove("regSource");
            }
        }
        boolean isSuccess = true;
        boolean isPostSuccess = false;
        if (addPerList != null && addPerList.size() > 0) {
            isPostSuccess = this.postImportData(addPerList, "person/add", "persons", null);
            if (!isPostSuccess) {
                isSuccess = false;
            }
            addPerList = null;
        }
        this.logger.error((Object)("updatePerList==" + updatePerList));
        if (updatePerList != null && updatePerList.size() > 0) {
            isPostSuccess = this.postImportData(updatePerList, "person/updateInfo", "persons", null);
            isPostSuccess = this.postImportData(updatePerList, "person/updateDept", "persons", null);
            if (isPostSuccess) {
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date nowDateTime = new Date();
                long dateL = nowDateTime.getTime() - 3600000L;
                nowDateTime.setTime(dateL);
                String dateStr = sf.format(nowDateTime);
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("time", dateStr);
                this.getImportData("person/getAtTime", param, 0, queryCount);
            }
            if (!isPostSuccess) {
                isSuccess = false;
            }
            updatePerList = null;
        }
        if (deleteEmp != null && deleteEmp.size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("type", new Integer(1));
            isPostSuccess = this.postImportData(deleteEmp, "person/delete", "openIds", param);
            if (!isPostSuccess) {
                isSuccess = false;
            }
            deleteEmp = null;
        }
        return isSuccess;
    }

    private boolean postImportData(Object bizData, String action, String dataKey, Map<String, Object> postParam) throws BOSException {
        List list;
        int size;
        boolean isSuccess = false;
        if (bizData == null || StringUtils.isEmpty((String)mid) || key == null) {
            return isSuccess;
        }
        if (bizData instanceof List && (size = (list = (List)bizData).size()) > 300) {
            isSuccess = this.postImportData(list.subList(0, 300), action, dataKey, postParam);
            isSuccess = this.postImportData(list.subList(300, size), action, dataKey, postParam);
            return isSuccess;
        }
        String url = rootUrl + "/openaccess/input/" + action;
        HttpClient http = new HttpClient();
        UTF8PostMethod post = new UTF8PostMethod(url);
        HashMap<Object, Object> result = postParam == null ? new HashMap(4) : new HashMap<String, Object>(postParam);
        result.put("eid", mid);
        result.put("sn", sn);
        result.put("dataCenterId", dataCenter);
        result.put(dataKey, bizData);
        String responseBody = null;
        String dataStr = XunTongSynUtils.convertObjectToJson(result);
        try {
            String encryData = RSAUtils.encryptString(dataStr, key);
            NameValuePair dataParam = new NameValuePair("nonce", UUID.randomUUID().toString());
            NameValuePair midParam = new NameValuePair("eid", mid);
            NameValuePair nonceParam = new NameValuePair("data", encryData);
            post.setRequestBody(new NameValuePair[]{dataParam, midParam, nonceParam});
            int statusCode = http.executeMethod((HttpMethod)post);
            if (statusCode == 200) {
                // empty if block
            }
            responseBody = post.getResponseBodyAsString();
            this.logger.error((Object)(statusCode + ":" + statusCode));
            this.logger.error((Object)(url + ":" + responseBody));
            System.out.println(responseBody);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        finally {
            post.releaseConnection();
        }
        this.logger.error((Object)("action=" + action + " datastr=" + dataStr));
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("response", URLEncoder.encode(responseBody, "utf-8"));
            param.put("action", action);
            Class<?> facadeClass = Class.forName("com.kingdee.shr.base.syssetting.IMSFServiceFacade");
            IBOSObject bosObject = this.getOSFBosObject(facadeClass);
            Method method = facadeClass.getMethod("processService", String.class, Map.class);
            Object rObj = method.invoke((Object)bosObject, "IntergrationMCloudService", param);
            isSuccess = (Boolean)rObj;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.processAddPerson(action, responseBody, bizData);
        return isSuccess;
    }

    private boolean getImportData(String action, Map<String, Object> postParam, int start, int count) throws BOSException {
        boolean isSuccess = false;
        String url = rootUrl + "/openaccess/input/" + action;
        HttpClient http = new HttpClient();
        UTF8PostMethod post = new UTF8PostMethod(url);
        HashMap<Object, Object> result = postParam == null ? new HashMap(4) : new HashMap<String, Object>(postParam);
        result.put("eid", mid);
        result.put("sn", sn);
        result.put("dataCenterId", dataCenter);
        result.put("begin", start);
        result.put("count", queryCount);
        String responseBody = null;
        String dataStr = XunTongSynUtils.convertObjectToJson(result);
        try {
            String encryData = RSAUtils.encryptString(dataStr, key);
            NameValuePair dataParam = new NameValuePair("nonce", UUID.randomUUID().toString());
            NameValuePair midParam = new NameValuePair("eid", mid);
            NameValuePair nonceParam = new NameValuePair("data", encryData);
            post.setRequestBody(new NameValuePair[]{dataParam, midParam, nonceParam});
            int statusCode = http.executeMethod((HttpMethod)post);
            if (statusCode == 200) {
                // empty if block
            }
            responseBody = post.getResponseBodyAsString();
            this.logger.error((Object)(statusCode + ":" + statusCode));
            this.logger.error((Object)(url + ":" + responseBody));
            System.out.println(responseBody);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        finally {
            post.releaseConnection();
        }
        this.logger.error((Object)("action=" + action + " datastr=" + dataStr));
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("response", URLEncoder.encode(responseBody, "utf-8"));
            param.put("action", action);
            Class<?> facadeClass = Class.forName("com.kingdee.shr.base.syssetting.IMSFServiceFacade");
            IBOSObject bosObject = this.getOSFBosObject(facadeClass);
            Method method = facadeClass.getMethod("processService", String.class, Map.class);
            Object rObj = method.invoke((Object)bosObject, "IntergrationMCloudService", param);
            isSuccess = (Boolean)rObj;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap responseMap = null;
        try {
            responseMap = XunTongSynUtils.convertJsonToObject(responseBody);
        }
        catch (Exception e) {
            this.logger.error((Object)(action + " reseponse error" + responseBody));
        }
        if (null != responseMap) {
            Object data = responseMap.get("data");
            List listData = null;
            if (data instanceof Map) {
                listData = (List)((Map)data).get("orgList");
            } else if (data instanceof List) {
                listData = (List)data;
            }
            this.logger.error((Object)(action + ":" + listData.size()));
            if (listData != null && listData.size() == queryCount) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("type", new Integer(0));
                isSuccess = this.getImportData("person/getall", param, start += queryCount, queryCount);
            }
        }
        return isSuccess;
    }

    private void processAddPerson(String action, String responseBody, Object bizData) throws BOSException {
        if ("person/add".equals(action)) {
            ArrayList<String> phones = new ArrayList<String>();
            HashMap responseMap = null;
            try {
                responseMap = XunTongSynUtils.convertJsonToObject(responseBody);
            }
            catch (Exception e) {
                this.logger.error((Object)(action + " reseponse error" + responseBody));
            }
            Object data = responseMap.get("data");
            List listData = null;
            if (data instanceof Map) {
                listData = (List)((Map)data).get("orgList");
            } else if (data instanceof List) {
                listData = (List)data;
            }
            List list = null;
            if (bizData instanceof List) {
                list = (List)bizData;
            }
            if (list != null) {
                for (int k = 0; k < list.size(); ++k) {
                    Map map = (Map)list.get(k);
                    String phone = (String)map.get("phone");
                    phones.add(phone);
                }
            }
            if (phones.size() > 0) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("type", new Integer(0));
                this.postImportData(phones, "person/get", "array", param);
            }
        }
    }

    private HashMap<String, Object> prepareMIDParam() throws BOSException {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
        mid = this.getMid();
        sn = this.getSN();
        if (!StringUtils.isEmpty((String)mid)) {
            dataMap.put("eid", mid);
        } else {
            dataMap.put("sn", sn);
        }
        if (StringUtils.isEmpty((String)sn) && StringUtils.isEmpty((String)mid)) {
            throw new BOSException("mid or sn is null!");
        }
        return dataMap;
    }

    private void init() throws BOSException {
        dataCenter = this.ctx == null ? SysContext.getSysContext().getDCNumber() : this.ctx.getAIS();
        String host = this.getRootUrl();
        if (null != host) {
            rootUrl = host;
        }
        mid = this.getMid();
        sn = this.getSN();
        key = this.getPrivateKey();
    }

    private String getRootUrl() {
        String host = null;
        try {
            HashMap param = new HashMap();
            Class<?> facadeClass = Class.forName("com.kingdee.shr.base.syssetting.IMSFServiceFacade");
            IBOSObject bosObject = this.getOSFBosObject(facadeClass);
            Method method = facadeClass.getMethod("processService", String.class, Map.class);
            Object returnVal = method.invoke((Object)bosObject, "GetMCloudHostService", param);
            if (null != returnVal) {
                host = returnVal.toString();
            } else {
                this.logger.error((Object)"getHostConfig is null!");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"getHostConfig fail!");
            e.printStackTrace();
        }
        return host;
    }

    private String getMid() throws BOSException {
        if (StringUtils.isEmpty((String)mid)) {
            mid = XunTongSynUtils.getCust3gNO(this.ctx);
        }
        if (StringUtils.isEmpty((String)mid)) {
            throw new BOSException("mid is null");
        }
        return mid;
    }

    private String getSN() throws BOSException {
        if (StringUtils.isEmpty((String)sn)) {
            sn = XunTongSynUtils.getProductSN(this.ctx);
        }
        if (StringUtils.isEmpty((String)sn)) {
            sn = "8065000018";
        }
        return sn;
    }

    private Key getPrivateKey() throws BOSException {
        this.logger.error((Object)("getPrivateKey==" + this.ctx));
        this.logger.error((Object)("keys==" + key));
        if (key == null) {
            key = XunTongSynUtils.getServerPrivateKey(this.ctx, mid);
        }
        if (key != null) {
            return key;
        }
        this.logger.error((Object)("keyend==" + key));
        return key;
    }

    class UTF8GetMethod
    extends GetMethod {
        public UTF8GetMethod(String url) {
            super(url);
        }

        public String getRequestCharSet() {
            return "UTF-8";
        }

        public String getResponseCharSet() {
            return "UTF-8";
        }

        protected String getContentCharSet(Header contentheader) {
            return "UTF-8";
        }
    }

    class UTF8PostMethod
    extends PostMethod {
        public UTF8PostMethod(String url) {
            super(url);
        }

        public String getRequestCharSet() {
            return "UTF-8";
        }
    }
}

