/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.shrssc.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.shrssc.ShrTaskOperation;
import com.kingdee.eas.base.ssc.BillTypeCfgFactory;
import com.kingdee.eas.base.ssc.BillTypeCfgInfo;
import com.kingdee.eas.base.ssc.BillTypeInfo;
import com.kingdee.eas.base.ssc.BussinessAttributeInfo;
import com.kingdee.eas.base.ssc.JobClassificationEnum;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShrTaskOperation_SHRBUSSATTR
implements ShrTaskOperation {
    private static final Logger logger = LoggerFactory.getLogger(ShrTaskOperation_SHRBUSSATTR.class);

    @Override
    public Object operation(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        try {
            String userId = null;
            String shareCenterId = null;
            String roleType = null;
            if (params != null) {
                userId = (String)params.get("userId");
                shareCenterId = (String)params.get("shareCenterId");
                roleType = (String)params.get("roleType");
            }
            if (userId == null || "".equals(userId)) {
                return "\u672a\u77e5\u4e1a\u52a1\u5458\uff01";
            }
            if (shareCenterId == null || "".equals(shareCenterId)) {
                return "\u672a\u83b7\u53d6\u5171\u4eab\u4e2d\u5fc3\uff01";
            }
            ArrayList<BussinessAttributeInfo> bussAttrList = new ArrayList<BussinessAttributeInfo>();
            String shareCenterFilter = ShareCenterUtils.getShareCenterParentIDs((Context)ctx, (StringBuffer)new StringBuffer(), (String)shareCenterId);
            StringBuffer sql = new StringBuffer();
            sql.append(" select distinct role.froletypeidid roletypeid, bussattr.fid bussattrid, bussattr.fname_" + ctx.getLocale().toString() + " bussattrname,");
            sql.append(" bussattr.fnumber bussattrnumber, bussattr.furl url, billtype.fid billtypeid, billtype.fnumber billtypenumber, ");
            sql.append(" billtype.fname_l2 billtypename, billtype.fbillSourceidid billtypesourceid, bussattr.FJobClassification jobClassification, ");
            sql.append(" isnull(lac.FISINTELLIGENTPULL,0) pullType ");
            sql.append(" from t_ssc_roleuser roleuser ");
            sql.append(" left outer join t_ssc_role role on role.fid = roleuser.froleidid ");
            sql.append(" left outer join t_ssc_rolebussattr rentry on rentry.fparentid = role.fid ");
            sql.append(" left outer join t_ssc_bussinessattribute bussattr on bussattr.fid = rentry.fbussnameid ");
            sql.append(" left outer join t_ssc_billtype billtype on billtype.fid = bussattr.fbilltypeid ");
            sql.append(" left join t_ssc_IntelligentAuditCfg lac on lac.FBUSSATTRID = bussattr.FID ");
            sql.append(" where roleuser.fuseridid = ? ");
            sql.append(" and billtype.fid in (select fid from t_ssc_billtype where fsysattrid in ");
            sql.append(" (select fsystemattributeid from t_ssc_sysattrorgscmap where fsharecenterid = ?)) ");
            sql.append(" and bussattr.fsharecenterid in (");
            sql.append(shareCenterFilter);
            sql.append(")");
            sql.append(" order by bussattrnumber asc");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{userId, shareCenterId});
                while (rs.next()) {
                    String roleTypeId = rs.getString("roletypeid");
                    if (roleTypeId == null || !roleType.equals(roleTypeId)) continue;
                    String bussAttrId = rs.getString("bussattrid");
                    String bussAttName = rs.getString("bussattrname");
                    String bussAttrNumber = rs.getString("bussattrnumber");
                    String url = rs.getString("url");
                    String billTypeId = rs.getString("billtypeid");
                    String billTypeNumber = rs.getString("billtypenumber");
                    String billTypeName = rs.getString("billtypename");
                    String billTypeSourceId = rs.getString("billtypesourceid");
                    int jobClassification = rs.getInt("jobClassification");
                    BussinessAttributeInfo newAttr = new BussinessAttributeInfo();
                    newAttr.setId(BOSUuid.read((String)bussAttrId));
                    newAttr.setName(bussAttName);
                    newAttr.setNumber(bussAttrNumber);
                    newAttr.setUrl(url);
                    BillTypeInfo billTypeInfo = new BillTypeInfo();
                    billTypeInfo.setId(BOSUuid.read((String)billTypeId));
                    billTypeInfo.setName(billTypeName);
                    billTypeInfo.setNumber(billTypeNumber);
                    BillTypeCfgInfo info = (BillTypeCfgInfo)BillTypeCfgFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(billTypeSourceId));
                    billTypeInfo.setBillSourceId(info);
                    newAttr.setBillType(billTypeInfo);
                    newAttr.setJobClassification(JobClassificationEnum.getEnum((int)jobClassification));
                    newAttr.setString("roleTypeBIZ", roleTypeId);
                    newAttr.setString("pullType", rs.getString("pullType"));
                    bussAttrList.add(newAttr);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            return bussAttrList;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return e.getMessage();
        }
    }
}

